/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class SouQuoSubmitValidator
extends AbstractValidator {
    public String getEntityKey() {
        return this.entityKey;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.entityKey = "sou_quote";
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            QFilter qFilter;
            DynamicObject[] inquiries;
            DynamicObject model = rowDataEntity.getDataEntity();
            long supplierId = model.getLong("supplier_id");
            if (supplierId != 0L && (inquiries = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)"billno,isautofillprice,turns,supscope,entryentity.supplier,entryentity.supentrystatus,entryentity.supplierbizstatus,entryentity.canshow,entryentity.entryturns,entryentity.deadline", (QFilter[])new QFilter[]{qFilter = new QFilter("billno", "=", (Object)model.getString("inquiryno"))})) != null && inquiries.length > 0) {
                ArrayList<Long> supplierIds = new ArrayList<Long>();
                supplierIds.add(supplierId);
                Map<String, Object> result = this.validateQuoteInfo(inquiries[0].getPkValue(), supplierIds);
                if ("false".equals(result.get("succed"))) {
                    this.addErrorMessage(rowDataEntity, result.get("message").toString());
                    return;
                }
            }
            this.beforeSubmit(model, rowDataEntity);
        }
    }

    private Map<String, Object> validateQuoteInfo(Object pkValue, List<Long> supplierIds) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"verifyQuote", (Object[])new Object[]{pkValue, supplierIds});
    }

    private void beforeSubmit(DynamicObject quoteBill, ExtendedDataEntity rowDataEntity) {
        boolean totalInquiry = quoteBill.getBoolean("totalinquiry");
        DynamicObjectCollection coll = quoteBill.getDynamicObjectCollection("materialentry");
        StringBuilder errorInfo = new StringBuilder();
        int quoCount = this.checkQuo(coll, errorInfo);
        String content = this.fitNullValue(quoteBill, coll);
        if (coll.size() > quoCount && totalInquiry && StringUtils.isBlank((CharSequence)errorInfo.toString())) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u662f\u6574\u5355\u8be2\u4ef7\uff0c\u5fc5\u987b\u5bf9\u5168\u90e8\u5546\u54c1\u8fdb\u884c\u62a5\u4ef7\u3002", (String)"SouQuoSubmitValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
        } else if (content.length() > 0 || StringUtils.isNotBlank((CharSequence)errorInfo.toString())) {
            if (StringUtils.isNotBlank((CharSequence)errorInfo.toString())) {
                this.addErrorMessage(rowDataEntity, errorInfo.toString());
                return;
            }
            if (quoCount == 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5bf9\u4e00\u4e2a\u5546\u54c1\u8fdb\u884c\u6709\u6548\u62a5\u4ef7\u3002", (String)"SouQuoSubmitValidator_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                return;
            }
            this.addWarningMessage(rowDataEntity, content);
        }
    }

    private int checkQuo(DynamicObjectCollection dynamicObjectsParam, StringBuilder errorInfo) {
        int quoCount = 0;
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjectsParam) {
            ++i;
            BigDecimal taxPrice = dynamicObject.getBigDecimal("taxprice");
            DynamicObject quoteCurr = dynamicObject.getDynamicObject("quotecurr");
            BigDecimal rate = dynamicObject.getBigDecimal("exrate");
            if (taxPrice == null || BigDecimal.ZERO.compareTo(taxPrice) >= 0) continue;
            if (rate == null || rate.compareTo(BigDecimal.ZERO) <= 0) {
                errorInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6c47\u7387\u4e3a\u7a7a,\u8bf7\u4e0e\u91c7\u8d2d\u5546\u8054\u7cfb\u7ef4\u62a4\u6c47\u7387\u5173\u7cfb\u3002", (String)"SouQuoSubmitValidator_12", (String)"scm-sou-opplugin", (Object[])new Object[0]), i));
                errorInfo.append('\n');
            }
            ++quoCount;
        }
        return quoCount;
    }

    public String fitNullValue(DynamicObject quoteBill, DynamicObjectCollection coll) {
        Object taxType = quoteBill.get("taxtype");
        int rowCount = 1;
        boolean isShowWarning = false;
        StringBuilder content = new StringBuilder(ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u5206\u5f55\u6709\u5546\u54c1\u672a\u586b\u7a0e\u7387(\u7a0e\u7387\u4e3a0)\u6216\u62a5\u4ef7\uff1a", (String)"SouQuoSubmitValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
        StringBuilder contentRow = new StringBuilder();
        for (DynamicObject dynamicObject : coll) {
            BigDecimal taxRate;
            BigDecimal price;
            BigDecimal taxPrice;
            contentRow.setLength(0);
            boolean isLineWarning = false;
            if (("1".equals(taxType) || "3".equals(taxType)) && ((taxPrice = dynamicObject.getBigDecimal("taxprice")) == null || BigDecimal.ZERO.compareTo(taxPrice) >= 0)) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a\u3002", (String)"SouQuoSubmitValidator_9", (String)"scm-quo-opplugin", (Object[])new Object[0]), rowCount));
                isShowWarning = true;
                isLineWarning = true;
            }
            if ("2".equals(taxType) && ((price = dynamicObject.getBigDecimal("price")) == null || BigDecimal.ZERO.compareTo(price) >= 0)) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5355\u4ef7\u4e3a\u7a7a\uff1b", (String)"SouQuoSubmitValidator_14", (String)"scm-quo-opplugin", (Object[])new Object[0]), rowCount));
                isShowWarning = true;
                isLineWarning = true;
            }
            if ((taxRate = dynamicObject.getBigDecimal("taxrate")) == null || BigDecimal.ZERO.compareTo(taxRate) >= 0) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7a0e\u7387\u4e3a\u7a7a(\u7a0e\u7387\u4e3a0)\uff1b", (String)"SouQuoSubmitValidator_11", (String)"scm-quo-opplugin", (Object[])new Object[0]), rowCount));
                isShowWarning = true;
                isLineWarning = true;
            }
            if (isLineWarning && contentRow.length() > 5) {
                content.append((CharSequence)contentRow.replace(contentRow.length() - 1, contentRow.length(), "\n"));
            }
            ++rowCount;
        }
        String mobTaxRateParam = (String)this.getOption().getVariables().get("mobopvartaxrate");
        if (!isShowWarning || StringUtils.isNotEmpty((CharSequence)mobTaxRateParam)) {
            content.setLength(0);
        }
        return content.toString();
    }
}

