/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SouSubmitTaxrateValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("materialentry.taxrateid");
        preparePropertys.add("materialentry.taxrate");
        preparePropertys.add("materialentry.seq");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            String name = dynamicObject.getDataEntityType().getName();
            String preMessage = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6", (String)"SouSubmitTaxrateValidator_0", (String)"scm-sou-opplugin", (Object[])new Object[0]);
            if ("sou_compare".equals(name)) {
                preMessage = ResManager.loadKDString((String)"\u62a5\u4ef7\u8be6\u60c5\u4fe1\u606f", (String)"SouSubmitTaxrateValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]);
            }
            for (DynamicObject entry : materialentry) {
                DynamicObject taxrateid = entry.getDynamicObject("taxrateid");
                if (taxrateid == null) continue;
                BigDecimal taxrateValue = taxrateid.getBigDecimal("taxrate");
                BigDecimal taxrate = entry.getBigDecimal("taxrate");
                if (BigDecimal.ZERO.compareTo(taxrateValue) == 0 || BigDecimal.ZERO.compareTo(taxrate) != 0) continue;
                Object seq = entry.get("seq");
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff0c\u7a0e\u7387\u503c\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u7a0e\u7387\u3002", (String)"SouSubmitTaxrateValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]), preMessage, seq));
            }
        }
    }
}

