/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;

public class BuildUrlToQuoInquiry
implements IEventServicePlugin {
    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityEvent entityEvent = (EntityEvent)evt;
        String domainContextUrl = UrlService.getDomainContextUrl();
        String accountId = RequestContext.get().getAccountId();
        List businessKeys = entityEvent.getBusinesskeys();
        List pkids = businessKeys.stream().map(Long::parseLong).collect(Collectors.toList());
        DynamicObjectCollection souQuoteDyns = QueryServiceHelper.query((String)"sou_quote", (String)"id,inquiryno", (QFilter[])new QFilter[]{new QFilter("id", "in", pkids)});
        HashMap<String, String> billNoMaps = new HashMap<String, String>(8);
        for (DynamicObject souQuoteDyn : souQuoteDyns) {
            Long pkid = souQuoteDyn.getLong("id");
            String billno = souQuoteDyn.getString("inquiryno");
            billNoMaps.put(billno, pkid.toString());
        }
        if (!CollectionUtils.isEmpty(billNoMaps)) {
            ArrayList billNoList = new ArrayList(8);
            billNoList.addAll(billNoMaps.keySet());
            DynamicObjectCollection quoInquiryDyns = QueryServiceHelper.query((String)"quo_inquiry", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoList)});
            for (DynamicObject quoInquiryDyn : quoInquiryDyns) {
                Long pkid = quoInquiryDyn.getLong("id");
                String billno = quoInquiryDyn.getString("billno");
                StringBuilder url = new StringBuilder();
                url.append(domainContextUrl).append("?accountId=").append(accountId).append("&formId=").append("quo_inquiry").append("&pkId=").append(pkid);
                map.put((String)billNoMaps.get(billno), url.toString());
            }
        }
        return map;
    }
}

