/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.sdk.scm.sou.extpoint.ISouBidBillToEasXKOrder;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;

public class SouBidCfmBillUtil {
    public static String getBotpRule(DynamicObject[] objs, String entryKey, String targetBillType) {
        Map<String, Object> billInfoMap = SouBidCfmBillUtil.getBillIdInfo(objs, entryKey);
        String rules = "";
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            billInfoMap.put("targetBillType", targetBillType);
            billInfoMap.put("srctype", "request");
            param.put("data", billInfoMap);
            param.put("code", "200");
            rules = ApiUtil.botpQuery(param);
            if (StringUtils.isEmpty((String)rules) || "[]".equals(rules)) {
                return null;
            }
        }
        return rules;
    }

    public static Map<String, Object> getBillIdInfo(DynamicObject[] objs, String entryKey) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entryCol) {
                Object sb = null;
                Object sbei = null;
                sb = entry.get("srcbillid");
                sbei = entry.get("srcentryid");
                if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
                String srcBillId = sb.toString();
                String srcBillEntryId = sbei.toString();
                entryIdSet.add(srcBillEntryId);
                billIdSet.add(srcBillId);
            }
        }
        dataMap.put("billId", billIdSet);
        dataMap.put("entryId", entryIdSet);
        return dataMap;
    }

    public static boolean isValideData(DynamicObject[] objs, String entryKey) {
        Set entryIdSet;
        Map<String, Object> dataMap = SouBidCfmBillUtil.getBillIdInfo(objs, entryKey);
        Object entryId = dataMap.get("entryId");
        boolean isValide = false;
        if (null != entryId && entryId instanceof Set && (entryIdSet = (Set)entryId).size() > 0) {
            isValide = true;
        }
        return isValide;
    }

    public static void toOrder(DynamicObject[] objs, String entryKey, String botpNumber, IFormView view) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("code", "200");
        param.put("action", "souBidToOrder");
        param.put("botpnumber", botpNumber);
        param.put("data", SouBidCfmBillUtil.getBillInfo(objs, entryKey));
        String msg = ApiUtil.souBidBillToOrder(param);
        StringBuilder msgSB = new StringBuilder();
        StringBuilder successMsg = new StringBuilder();
        boolean hasSuccess = false;
        if (!(msg == null || msg.isEmpty() || "null".equals(msg) || "{}".equals(msg))) {
            Map returnDataMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            for (DynamicObject obj : objs) {
                String billno = obj.getString("billno");
                successMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u7ade\u4ef7\u5355\u53f7\uff1a{0}\u751f\u6210\u7684\u91c7\u8d2d\u8ba2\u5355\u5355\u636e\u7f16\u53f7\uff1a", (String)"SouBidCfmBillUtil_0", (String)"scm-sou-common", (Object[])new Object[0]), billno));
                DynamicObjectCollection cols = obj.getDynamicObjectCollection(entryKey);
                DynamicObject col = null;
                StringBuilder billNoSb = new StringBuilder();
                for (int i = 0; i < cols.size(); ++i) {
                    col = (DynamicObject)cols.get(i);
                    Object detail = returnDataMap.get(col.getPkValue().toString());
                    if (detail instanceof Map) {
                        Map detailMap = (Map)returnDataMap.get(col.getPkValue().toString());
                        Object error = detailMap.get("error");
                        if (error == null || error.toString().isEmpty()) {
                            String poBillNo = (String)detailMap.get("billno");
                            col.set("pobillno", (Object)poBillNo);
                            col.set("pobillid", detailMap.get("billid"));
                            col.set("poentryid", detailMap.get("entryid"));
                            if (!billNoSb.toString().contains(poBillNo)) {
                                successMsg.append(poBillNo).append(" ");
                                billNoSb.append(poBillNo);
                            }
                            obj.set("bidstatus", (Object)"F");
                            hasSuccess = true;
                            continue;
                        }
                        msgSB.append(error).append(";\n");
                        continue;
                    }
                    msgSB.append(MessageFormat.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\uff1a{0}", (String)"SouBidCfmBillUtil_1", (String)"scm-sou-common", (Object[])new Object[0]), detail)).append(";\n");
                }
                successMsg.append(";\n");
            }
        } else {
            msgSB.append(ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u6570\u636e\u3002", (String)"SouBidCfmBillUtil_2", (String)"scm-sou-common", (Object[])new Object[0]));
        }
        if (msgSB.length() == 0 || hasSuccess) {
            view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"SouBidCfmBillUtil_3", (String)"scm-sou-common", (Object[])new Object[0]), successMsg.toString(), MessageTypes.Default);
            SaveServiceHelper.save((DynamicObject[])objs);
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u5355\u636e\u751f\u6210\u5931\u8d25\u3002", (String)"SouBidCfmBillUtil_4", (String)"scm-sou-common", (Object[])new Object[0]), msgSB.toString(), MessageTypes.Default);
        }
        view.updateView();
    }

    public static List<Map<String, Object>> getBillInfo(DynamicObject[] objs, String entryKey) {
        ArrayList<Map<String, Object>> billList = new ArrayList<Map<String, Object>>(objs.length);
        PluginProxy<ISouBidBillToEasXKOrder> pluginProxy = SouBidCfmBillUtil.getWrapInfoExtPlugin();
        for (DynamicObject obj : objs) {
            Map<String, List<Map<String, Object>>> resultMap = SouBidCfmBillUtil.getRowInfo(obj, entryKey);
            Set<Map.Entry<String, List<Map<String, Object>>>> entries = resultMap.entrySet();
            for (Map.Entry<String, List<Map<String, Object>>> entry : entries) {
                String key = entry.getKey();
                List<Map<String, Object>> value = entry.getValue();
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                if (StringUtils.isBlank((String)key)) continue;
                detailMap.put("entry", value);
                detailMap.put("billid", String.valueOf(obj.getPkValue()));
                detailMap.put("billno", obj.get("billno").toString());
                detailMap.put("supplier", key);
                DynamicObject purOrg = obj.getDynamicObject("org");
                detailMap.put("org", purOrg == null ? "" : purOrg.getString("number"));
                DynamicObject person = obj.getDynamicObject("person");
                detailMap.put("person", person == null ? "" : person.getString("number"));
                if (null != person) {
                    DynamicObject group = person.getDynamicObject("group");
                    detailMap.put("group", group == null ? "" : group.getString("number"));
                } else {
                    detailMap.put("group", "");
                }
                DynamicObject settletype = obj.getDynamicObject("settletype");
                detailMap.put("settletype", settletype == null ? "" : settletype.getString("number"));
                DynamicObject paycond = obj.getDynamicObject("paycond");
                detailMap.put("paycond", paycond == null ? "" : paycond.getString("number"));
                String taxtype = obj.getString("taxtype");
                detailMap.put("taxtype", taxtype);
                detailMap.put("curr", obj.getDynamicObject("curr").getString("number"));
                pluginProxy.callReplaceIfPresent(p -> {
                    p.dealHead(detailMap, obj);
                    return null;
                });
                billList.add(detailMap);
            }
        }
        return billList;
    }

    public static Map<String, Object> getInfo(DynamicObject bill, String entryKey) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entryCol) {
            Map<String, Object> entryDetailMap = SouBidCfmBillUtil.wrapDetailMap(bill, entry);
            entryList.add(entryDetailMap);
        }
        detailMap.put("entry", entryList);
        return detailMap;
    }

    public static Map<String, List<Map<String, Object>>> getRowInfo(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection(entryKey);
        PluginProxy<ISouBidBillToEasXKOrder> pluginProxy = SouBidCfmBillUtil.getWrapInfoExtPlugin();
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>();
        for (DynamicObject entry : entryCol) {
            String winsupplier = entry.getString("winsupplier.number");
            BigDecimal winprice = entry.getBigDecimal("winprice");
            if (StringUtils.isBlank((String)winsupplier) || BigDecimal.ZERO.compareTo(winprice) >= 0) continue;
            ArrayList<Map<String, Object>> entryList = (ArrayList<Map<String, Object>>)resultMap.get(winsupplier);
            if (entryList == null) {
                entryList = new ArrayList<Map<String, Object>>();
                resultMap.put(winsupplier, entryList);
            }
            Map<String, Object> entryDetailMap = SouBidCfmBillUtil.wrapDetailMap(bill, entry);
            pluginProxy.callReplaceIfPresent(p -> {
                p.dealEntry(entry, bill, entryDetailMap);
                return null;
            });
            entryList.add(entryDetailMap);
        }
        return resultMap;
    }

    private static PluginProxy<ISouBidBillToEasXKOrder> getWrapInfoExtPlugin() {
        ISouBidBillToEasXKOrder plugin = new ISouBidBillToEasXKOrder(){};
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouBidBillToEasXKOrder.class, (String)"SCM_SOU_BIDBILL_TOORDER", null);
        return pluginProxy;
    }

    private static Map<String, Object> wrapDetailMap(DynamicObject bill, DynamicObject entry) {
        String srcBillEntryId;
        String srcBillId;
        String srcbilltype = "pur_apply";
        Object sb = entry.get("srcbillid");
        Object sbei = entry.get("srcentryid");
        if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) {
            srcBillId = "";
            srcBillEntryId = "";
        } else {
            srcBillId = sb.toString();
            srcBillEntryId = sbei.toString();
        }
        HashMap<String, Object> entryDetailMap = new HashMap<String, Object>(8);
        entryDetailMap.put("entryid", entry.getPkValue().toString());
        entryDetailMap.put("srcbilltype", srcbilltype);
        entryDetailMap.put("srcbillid", srcBillId);
        entryDetailMap.put("srcentryid", srcBillEntryId);
        entryDetailMap.put("taxrate", CommonUtil.getBigDecimalPro((Object)entry.get("taxrate")));
        entryDetailMap.put("price", CommonUtil.getBigDecimalPro((Object)entry.get("winprice")));
        entryDetailMap.put("taxprice", CommonUtil.getBigDecimalPro((Object)entry.get("wintaxprice")));
        entryDetailMap.put("taxamount", CommonUtil.getBigDecimalPro((Object)entry.get("taxamount")));
        DynamicObject material = entry.getDynamicObject("material");
        entryDetailMap.put("material", material == null ? "" : material.getString("number"));
        entryDetailMap.put("materialdesc", entry.get("materialdesc"));
        DynamicObject unit = entry.getDynamicObject("unit");
        entryDetailMap.put("unit", unit == null ? "" : unit.getString("number"));
        entryDetailMap.put("dctamount", entry.get("dctamount"));
        entryDetailMap.put("dctrate", entry.get("dctrate"));
        entryDetailMap.put("amount", entry.get("amount"));
        entryDetailMap.put("tax", entry.get("tax"));
        entryDetailMap.put("qty", entry.get("qty"));
        entryDetailMap.put("seq", entry.get("seq"));
        entryDetailMap.put("delidate", bill.get("delidate1"));
        entryDetailMap.put("deliaddr", bill.get("deliaddress"));
        DynamicObject entryrcvorg = entry.getDynamicObject("entryrcvorg");
        entryDetailMap.put("entryrcvorg", entryrcvorg == null ? "" : entryrcvorg.getString("number"));
        return entryDetailMap;
    }

    public static Map<String, Object> verifyEASOrder(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        StringBuilder msgSb = new StringBuilder();
        StringBuilder EASOrderCheck = new StringBuilder();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String bidStatus = dynamicObjects[i].getString("bidstatus");
            if (!bidStatus.equals(BidStatusEnum.CONFIRMED.getVal())) {
                msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a{0}\u4e0d\u662f\u5df2\u5b9a\u6807\u72b6\u6001\u3002", (String)"SouBidCfmBillUtil_5", (String)"scm-sou-common", (Object[])new Object[0]), dynamicObjects[i].get("billno"))).append('\n');
            }
            DynamicObjectCollection entryentity = dynamicObjects[i].getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryentity) {
                String pobillno = entryRow.getString("pobillno");
                if (pobillno == null || EASOrderCheck.toString().contains(pobillno)) continue;
                EASOrderCheck.append(MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\u8ba2\u5355{0}", (String)"SouBidCfmBillUtil_6", (String)"scm-sou-common", (Object[])new Object[0]), pobillno)).append('\u3001');
            }
        }
        if (EASOrderCheck.length() > 0) {
            msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\u65e0\u9700\u518d\u6b21\u751f\u6210\u3002", (String)"SouBidCfmBillUtil_7", (String)"scm-sou-common", (Object[])new Object[0]), EASOrderCheck));
        }
        if (msgSb.length() > 0) {
            returnMap.put("title", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"SouBidCfmBillUtil_8", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            returnMap.put("message", msgSb);
            return returnMap;
        }
        if (!SouBidCfmBillUtil.isValideData(dynamicObjects, "entryentity") && ApiConfigUtil.hasXKScmConfig()) {
            returnMap.put("title", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"SouBidCfmBillUtil_8", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6765\u6e90\u4e8e\u661f\u7a7a, \u4e0d\u80fd\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"SouBidCfmBillUtil_9", (String)"scm-sou-common", (Object[])new Object[0]));
            return returnMap;
        }
        if (SouBidCfmBillUtil.isValideData(dynamicObjects, "entryentity")) {
            String inwareRules = SouBidCfmBillUtil.getBotpRule(dynamicObjects, "entryentity", "order");
            if (StringUtils.isEmpty((String)inwareRules)) {
                returnMap.put("title", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"SouBidCfmBillUtil_8", (String)"scm-sou-common", (Object[])new Object[0]));
                returnMap.put("succed", "false");
                returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouBidCfmBillUtil_10", (String)"scm-sou-common", (Object[])new Object[0]));
                return returnMap;
            }
            JSONArray orderRuleList = JSONArray.fromObject((Object)inwareRules);
            if (orderRuleList.size() > 0 && orderRuleList.size() != 0) {
                returnMap.put("succed", "true");
                returnMap.put("botp", orderRuleList);
            }
        } else {
            returnMap.put("succed", "true");
            returnMap.put("botp", "");
        }
        return returnMap;
    }
}

