/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.sou.common.SouPermUtil;

public class SouCommonUtil {
    private static Log log = LogFactory.getLog((String)SouCommonUtil.class.getName());

    public static final String getMaterialName(long materialId) {
        StringBuilder content = new StringBuilder();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"name");
        if (obj == null) {
            return "";
        }
        content.append(obj.getString("name"));
        return content.toString();
    }

    public static final String getModelnum(long materialId) {
        StringBuilder content = new StringBuilder();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"modelnum");
        if (obj == null) {
            return "";
        }
        content.append(obj.getString("modelnum"));
        return content.toString();
    }

    public static final String getUnitName(long unitId) {
        StringBuilder content = new StringBuilder();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits", (String)"name");
        if (obj == null) {
            return "";
        }
        content.append(obj.getString("name"));
        return content.toString();
    }

    public static Map<String, Object> getUnitInfo(long unitId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject unitDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits", (String)"name");
        String unitName = "";
        int precision = 2;
        RoundingMode rm = RoundingMode.HALF_UP;
        if (unitDyn != null) {
            unitName = unitDyn.getString("name");
            precision = unitDyn.getInt("precision");
            int precisionaccount = unitDyn.getInt("precisionaccount");
            switch (precisionaccount) {
                case 1: {
                    rm = RoundingMode.HALF_UP;
                    break;
                }
                case 2: {
                    rm = RoundingMode.FLOOR;
                    break;
                }
                case 3: {
                    rm = RoundingMode.CEILING;
                    break;
                }
                default: {
                    rm = RoundingMode.HALF_UP;
                }
            }
            resultMap.put("roundingMode", (Object)rm);
            resultMap.put("name", unitName);
            resultMap.put("precision", precision);
        }
        return resultMap;
    }

    public static QFilter validSupFilter() {
        ArrayList<Long> validStatusId = new ArrayList<Long>(2);
        validStatusId.add(BillAssistConstant.SUPPLIER_STATUS_LATENT);
        validStatusId.add(BillAssistConstant.SUPPLIER_STATUS_FORMAL);
        return new QFilter("supplier_status", "in", validStatusId);
    }

    public static void updatePmStatus(DynamicObjectCollection entryentity) {
        if (ApiConfigUtil.hasCQScmConfig()) {
            ArrayList<String> pmApplyPkIds = new ArrayList<String>();
            for (DynamicObject row : entryentity) {
                Object srcBillId;
                String srcType = row.getString("srcbilltype");
                if (srcType.isEmpty() || !"pm_purapplybill".equals(srcType) || (srcBillId = row.getString("srcbillid")) == null || ((String)srcBillId).isEmpty() || pmApplyPkIds.contains(srcBillId)) continue;
                pmApplyPkIds.add((String)srcBillId);
            }
            ArrayList<String> havedoneStatusList = new ArrayList<String>();
            havedoneStatusList.add(BidStatusEnum.CONFIRMED.getVal());
            havedoneStatusList.add(BidStatusEnum.EXECUTED.getVal());
            havedoneStatusList.add(BidStatusEnum.END.getVal());
            QFilter statusFilter = new QFilter("bidstatus", "not in", havedoneStatusList);
            statusFilter.and(new QFilter("materialentry.prbillid", "in", pmApplyPkIds));
            DynamicObjectCollection doingBills = QueryServiceHelper.query((String)"sou_bidbill", (String)"materialentry.prbillid prbillid", (QFilter[])statusFilter.toArray());
            if (doingBills != null && !doingBills.isEmpty()) {
                for (DynamicObject doingBill : doingBills) {
                    String prbillid = doingBill.getString("prbillid");
                    if (prbillid.isEmpty()) continue;
                    pmApplyPkIds.remove(prbillid);
                }
            }
            if (!pmApplyPkIds.isEmpty()) {
                HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
                confirmMap.put("ids", pmApplyPkIds.stream().map(Long::valueOf).collect(Collectors.toList()));
                confirmMap.put("status", "B");
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upApplyBidStatus", (Object[])new Object[]{confirmMap});
            }
        }
    }

    public static void validateTraceDown(Object[] ids, IFormView view) {
        if ((ids == null || ids.length <= 0) && view != null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SouInquiryList_16", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
    }

    public static Map<String, HashSet<Long>> wrapTraceDownCustomParams(String sourceBill, Long[] ids, List<String> errMsgList, String ... targetBills) {
        Map trackerMap = BFTrackerServiceHelper.findTargetBills((String)sourceBill, (Long[])ids);
        HashMap<String, String> targetMap = new HashMap<String, String>(targetBills.length);
        for (String targetBill : targetBills) {
            if (StringUtils.isBlank((CharSequence)targetBill)) continue;
            targetMap.put(targetBill, "1");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetBill);
            if (SouPermUtil.hasBillViewRightForOrg(ids[0], sourceBill, targetBill, mainEntityType.getAppId())) continue;
            trackerMap.remove(targetBill);
            errMsgList.add(String.format(ResManager.loadKDString((String)"\u641c\u7d22\u5230\u4e86\u5173\u8054\u7684\u201c%s\u201d\uff0c\u4f46\u672a\u88ab\u6388\u4e88\u67e5\u770b\u6743\u3002", (String)"SouPermUtil_2", (String)"scm-sou-common", (Object[])new Object[0]), mainEntityType.getDisplayName().getLocaleValue()));
        }
        Map<String, HashSet<Long>> resultMap = trackerMap.entrySet().stream().filter(map -> targetMap.containsKey(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return resultMap;
    }

    public static void showTraceForm(List<String> errMsgList, IFormView view, Map<String, HashSet<Long>> ... result) {
        if (view != null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>(1);
            for (Map<String, HashSet<Long>> map : result) {
                resultMap.putAll(map);
            }
            if (resultMap.size() == 0 && errMsgList != null && errMsgList.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"SouPermUtil_1", (String)"scm-sou-common", (Object[])new Object[0]));
                return;
            }
            customParams.put("param", resultMap);
            String errMsg = null;
            if (errMsgList != null && !errMsgList.isEmpty()) {
                errMsg = String.join((CharSequence)"\uff0c", errMsgList);
                customParams.put("permMsg", errMsg);
            }
            if (resultMap.size() == 0) {
                view.showTipNotification(errMsg);
                return;
            }
            FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
            view.showForm(formParam);
        }
    }

    public static void traceDowOrder(Object[] objects, IFormView view) {
        SouCommonUtil.validateTraceDown(objects, view);
        Long[] ids = new Long[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ids[i] = (Long)objects[i];
        }
        ArrayList<String> errMsgList = new ArrayList<String>(1);
        Map<String, HashSet<Long>> result = SouCommonUtil.wrapTraceDownCustomParams("sou_compare", ids, errMsgList, "pm_purorderbill");
        QFilter qFilter = new QFilter("id", "in", (Object)objects);
        qFilter.and("materialentry.prbillid", "!=", (Object)" ");
        ArrayList<Long> pids = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"d", (String)"sou_compare", (String)"id,materialentry.prbillid", (QFilter[])new QFilter[]{qFilter}, null);){
            try {
                for (Row row : dataSet) {
                    pids.add(row.getLong("materialentry.prbillid"));
                }
            }
            catch (NumberFormatException e) {
                log.error("SouCommonUtil prbillid NumberFormatException!", (Throwable)e);
            }
        }
        if (pids.size() > 0) {
            SouCommonUtil.validateTraceDown(pids.toArray(), view);
            Map<String, HashSet<Long>> setMap = SouCommonUtil.wrapTraceDownCustomParams("pm_purapplybill", pids.toArray(new Long[0]), errMsgList, "pm_purorderbill");
            for (Map.Entry<String, HashSet<Long>> next : setMap.entrySet()) {
                HashSet<Long> targetIds = result.get(next.getKey());
                if (targetIds != null) {
                    targetIds.addAll((Collection<Long>)next.getValue());
                    continue;
                }
                result.put(next.getKey(), next.getValue());
            }
        }
        SouCommonUtil.showTraceForm(errMsgList, view, result);
    }

    public static Map<String, DynamicObject> dealQuoteSupplier(DynamicObject inquiryBill, List<DynamicObject> entrysupplier, String turns, int maxTurns) {
        HashMap<String, DynamicObject> selectSupplierMap = new HashMap<String, DynamicObject>((int)((double)entrysupplier.size() / 0.75));
        if (inquiryBill == null) {
            return selectSupplierMap;
        }
        DynamicObjectCollection entryDyoCol = inquiryBill.getDynamicObjectCollection("entryentity");
        entrysupplier.forEach(info -> {
            long supplierId = info.getLong("suppliernumber_id");
            if (supplierId != 0L) {
                selectSupplierMap.put(info.getString("suppliernumber_id"), (DynamicObject)info);
            }
        });
        Date endDate = inquiryBill.getDate("enddate");
        HashMap entryTurnsCount = new HashMap();
        if (null != entryDyoCol && entryDyoCol.size() > 0) {
            DynamicObject info2 = null;
            for (DynamicObject dyo : entryDyoCol) {
                info2 = (DynamicObject)selectSupplierMap.get(dyo.getString("supplier_id"));
                InquirySupParticipateUtils.calMaxTurnsMap(entryTurnsCount, (DynamicObject)dyo);
                if (info2 == null && (StringUtils.isBlank((CharSequence)dyo.getString("supentrystatus")) || "B".equals(dyo.getString("supplierbizstatus"))) && InquirySupParticipateUtils.isShowSelect((DynamicObject)dyo)) continue;
                InquirySupParticipateUtils.setSupEntryShowSelect((DynamicObject)dyo, (Boolean)Boolean.FALSE);
            }
        }
        entrysupplier.forEach(obj -> {
            if (obj.getLong("suppliernumber_id") != 0L) {
                DynamicObject newObj = entryDyoCol.addNew();
                newObj.set("supplier", obj.get("suppliernumber"));
                newObj.set("supentrystatus", (Object)"");
                newObj.set("supplierbizstatus", (Object)"");
                InquirySupParticipateUtils.setSupEntryDeadLine((DynamicObject)newObj, (Date)endDate);
                Integer countNum = (Integer)entryTurnsCount.get(obj.getString("suppliernumber_id"));
                newObj.set("entryturns", (Object)turns);
                int count = countNum == null ? 1 : countNum + 1;
                newObj.set("entrycount", (Object)(count > maxTurns ? maxTurns : count));
                InquirySupParticipateUtils.setSupEntryShowSelect((DynamicObject)newObj, (Boolean)Boolean.TRUE);
            }
        });
        return selectSupplierMap;
    }

    public static boolean existBelowOrders(Object[] objects, String entityId) {
        Long[] ids = new Long[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ids[i] = (Long)objects[i];
        }
        QFilter qFilter = new QFilter("id", "in", (Object)objects);
        String selectFields = "id,materialentry.prbillid";
        String prFieldName = "materialentry.prbillid";
        if ("sou_compare".equals(entityId)) {
            qFilter.and("materialentry.prbillid", "!=", (Object)" ");
        } else {
            qFilter.and("entryentity.prbillid", "!=", (Object)" ");
            selectFields = "id,entryentity.prbillid";
            prFieldName = "entryentity.prbillid";
        }
        ArrayList<Long> pids = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SouCommonUtil", (String)entityId, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);){
            try {
                for (Row row : dataSet) {
                    pids.add(row.getLong(prFieldName));
                }
            }
            catch (NumberFormatException e) {
                log.error("SouCommonUtil prbillid NumberFormatException!", (Throwable)e);
            }
        }
        boolean flag = false;
        if (pids.size() > 0) {
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"pm_purapplybill", (Long[])pids.toArray(new Long[0]));
            Map<String, HashSet> resultMap = targetBills.entrySet().stream().filter(map -> targetBills.containsKey("pm_purorderbill")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashSet orderids = new HashSet(pids.size());
            for (Map.Entry<String, HashSet> entry : resultMap.entrySet()) {
                HashSet orderIdSet = entry.getValue();
                if (!"pm_purorderbill".equals(entry.getKey())) continue;
                orderids.addAll(orderIdSet);
            }
            QFilter filter = new QFilter("id", "in", orderids);
            DynamicObjectCollection pm_purorderbill = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billentry.soubillentity soubillentity", (QFilter[])filter.toArray());
            for (DynamicObject dynamicObject : pm_purorderbill) {
                String soubillentity = dynamicObject.getString("soubillentity");
                if (!entityId.equals(soubillentity)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

