/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.sdk.scm.sou.extpoint.ISouCompareToEasXKOrder;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;

public class SouCompareBillUtil {
    private static final Log log = LogFactory.getLog(SouCompareBillUtil.class);

    public static void setIsEasBill(Boolean value) {
        IAppCache easBillCache = AppCache.get((String)"SouCompareBillUtil");
        easBillCache.put("isEasBill" + RequestContext.get().getTraceId(), (Object)value);
    }

    public static String getBotpRule(DynamicObject[] invoiceObjs, String targetBillType) {
        Map<String, Object> billInfoMap = SouCompareBillUtil.getBillIdInfo(invoiceObjs);
        String rules = "";
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            billInfoMap.put("targetBillType", targetBillType);
            billInfoMap.put("srctype", "request");
            param.put("data", billInfoMap);
            param.put("code", "200");
            rules = ApiUtil.botpQuery(param);
            if (StringUtils.isEmpty((String)rules) || "[]".equals(rules)) {
                return null;
            }
        }
        return rules;
    }

    public static Map<String, Object> getBillIdInfo(DynamicObject[] compareObjs) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject compare : compareObjs) {
            DynamicObjectCollection entryCol = compare.getDynamicObjectCollection("materialentry");
            DynamicObject[] srcBillObjects = SouCompareBillUtil.querySrcBillInfo(entryCol, "materialentry");
            for (DynamicObject entry : entryCol) {
                Object sb = null;
                Object sbei = null;
                sb = entry.get("srcbillid");
                DynamicObject srcBillEntry = SouCompareBillUtil.getSrcBillEntry(srcBillObjects, sb, sbei = entry.get("srcentryid"));
                if (srcBillEntry != null) {
                    sb = srcBillEntry.get("srcbillid");
                    sbei = srcBillEntry.get("srcentryid");
                } else {
                    sb = null;
                    sbei = null;
                }
                if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
                String srcBillId = String.valueOf(sb);
                String srcBillEntryId = String.valueOf(sbei);
                if (!ApiConfigUtil.hasXKScmConfig()) {
                    boolean isMatch = Pattern.matches("^-?\\d+(\\.\\d+)?$", srcBillId);
                    if (StringUtils.isBlank((String)String.valueOf(srcBillId)) || isMatch) {
                        continue;
                    }
                } else {
                    String prbillid = srcBillEntry.getString("prbillid");
                    if (StringUtils.isBlank((String)String.valueOf(prbillid))) continue;
                }
                entryIdSet.add(srcBillEntryId);
                billIdSet.add(srcBillId);
            }
        }
        if (entryIdSet.size() > 0) {
            dataMap.put("billId", billIdSet);
            dataMap.put("entryId", entryIdSet);
            SouCompareBillUtil.setIsEasBill(Boolean.TRUE);
        } else {
            SouCompareBillUtil.setIsEasBill(Boolean.FALSE);
        }
        return dataMap;
    }

    public static Map<String, Object> toOrder(DynamicObject[] objs, String botpNumber) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String msg = null;
        Map<String, Map<String, Object>> billInfoMap = SouCompareBillUtil.getBillParam(objs);
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            HashMap<String, String> botpParam = new HashMap<String, String>(1);
            botpParam.put("botpNumber", botpNumber);
            billInfoMap.put("botpNumber", botpParam);
            param.put("data", billInfoMap);
            msg = SouCompareBillUtil.sendData(param, "sou_compare");
            if (!"500".equals(msg)) {
                returnMap.putAll(SouCompareBillUtil.handResult(objs, msg));
            }
        }
        return returnMap;
    }

    public static Map<String, Object> toMultOrder(DynamicObject[] objs, String botpNumber) {
        ArrayList<Map<String, Object>> multiResultMapList = new ArrayList<Map<String, Object>>();
        String msg = null;
        List<Map<String, Map<String, Object>>> billInfoMapList = SouCompareBillUtil.getMultBillParam(objs);
        if (billInfoMapList != null && billInfoMapList.size() > 0) {
            for (Map<String, Map<String, Object>> billInfoMap : billInfoMapList) {
                if (billInfoMap == null || billInfoMap.size() <= 0) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(1);
                HashMap<String, String> botpParam = new HashMap<String, String>(1);
                botpParam.put("botpNumber", botpNumber);
                billInfoMap.put("botpNumber", botpParam);
                param.put("data", billInfoMap);
                msg = SouCompareBillUtil.sendData(param, "sou_compare");
                if ("500".equals(msg)) continue;
                multiResultMapList.add(SouCompareBillUtil.handMultResult(objs, msg));
            }
        }
        return SouCompareBillUtil.dealResult(multiResultMapList, objs);
    }

    private static Map<String, Object> dealResult(List<Map<String, Object>> multiResultMapList, DynamicObject[] objs) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        boolean flag = false;
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        StringBuilder errorCheck = new StringBuilder();
        for (Map<String, Object> info : multiResultMapList) {
            if (info == null) continue;
            Object isUpdate = info.get("isUpdate");
            if (isUpdate instanceof Boolean && ((Boolean)isUpdate).booleanValue()) {
                flag = true;
            }
            if ("true".equals(info.get("succed"))) {
                message.append(info.get("message"));
                ++successNum;
                continue;
            }
            errorCheck.append(info.get("message"));
            ++failNum;
        }
        if (flag) {
            SaveServiceHelper.save((DynamicObject[])objs);
        }
        if (message.length() > 0 && errorCheck.length() > 0) {
            returnMap.put("succed", "true");
            returnMap.put("title", String.format(ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\uff1a%1$s\uff0c\u5931\u8d25\uff1a%2$s", (String)"SouCompareBillUtil_11", (String)"scm-sou-common", (Object[])new Object[0]), successNum, failNum));
            SouCompareBillUtil.updateInquiryData(objs);
        } else if (message.length() > 0) {
            returnMap.put("succed", "true");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"SouCompareBillUtil_3", (String)"scm-sou-common", (Object[])new Object[0]));
            SouCompareBillUtil.updateInquiryData(objs);
        } else {
            returnMap.put("succed", "false");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25", (String)"SouCompareBillUtil_4", (String)"scm-sou-common", (Object[])new Object[0]));
        }
        returnMap.put("message", message.append((CharSequence)errorCheck).toString());
        return returnMap;
    }

    public static Map<String, Object> handResult(DynamicObject[] objs, String msg) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        StringBuffer EASNoResult = new StringBuffer();
        StringBuffer errorCheck = new StringBuffer();
        boolean isUpdate = SouCompareBillUtil.dealEasMsgInfo(objs, EASNoResult, errorCheck, msg);
        if (isUpdate) {
            SaveServiceHelper.save((DynamicObject[])objs);
        }
        if (EASNoResult.length() > 0) {
            returnMap.put("succed", "true");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"SouCompareBillUtil_3", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("message", EASNoResult);
            SouCompareBillUtil.updateInquiryData(objs);
        }
        if (errorCheck.length() > 0) {
            returnMap.put("succed", "false");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25", (String)"SouCompareBillUtil_4", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("message", errorCheck);
        }
        return returnMap;
    }

    public static Map<String, Object> handMultResult(DynamicObject[] objs, String msg) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        StringBuffer EASNoResult = new StringBuffer();
        StringBuffer errorCheck = new StringBuffer();
        boolean isUpdate = SouCompareBillUtil.dealEasMsgInfo(objs, EASNoResult, errorCheck, msg);
        if (isUpdate) {
            returnMap.put("isUpdate", isUpdate);
        }
        if (EASNoResult.length() > 0 && errorCheck.length() > 0) {
            returnMap.put("succed", "true");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"SouCompareBillUtil_3", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("message", EASNoResult.append(errorCheck).toString());
        } else if (EASNoResult.length() > 0) {
            returnMap.put("succed", "true");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"SouCompareBillUtil_3", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("message", EASNoResult);
        } else if (errorCheck.length() > 0) {
            returnMap.put("succed", "false");
            returnMap.put("title", ResManager.loadKDString((String)"\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25", (String)"SouCompareBillUtil_4", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("message", errorCheck);
        }
        return returnMap;
    }

    private static boolean dealEasMsgInfo(DynamicObject[] objs, StringBuffer easNoResult, StringBuffer errorCheck, String msg) {
        boolean isUpdate = false;
        for (DynamicObject bill : objs) {
            String billId = bill.getString("id");
            String billNo = bill.getString("billno");
            if (msg != null && !msg.isEmpty()) {
                Map resultMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
                if (resultMap != null) {
                    String code = (String)resultMap.get("code");
                    if ("404".equals(code)) {
                        String error = (String)resultMap.get("error");
                        errorCheck.append(MessageFormat.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002{0}", (String)"SouCompareBillUtil_0", (String)"scm-sou-common", (Object[])new Object[0]), error)).append('\n');
                        return isUpdate;
                    }
                    Map entryMap = (Map)resultMap.get(billId);
                    if (entryMap == null) continue;
                    DynamicObjectCollection entrs = bill.getDynamicObjectCollection("materialentry");
                    StringBuilder EASNoCheck = new StringBuilder();
                    for (DynamicObject entry : entrs) {
                        String entryId = entry.getString("id");
                        Map entryDetailMap = (Map)entryMap.get(entryId);
                        if (entryDetailMap == null) continue;
                        Object error = entryDetailMap.get("error");
                        if (error != null && error.toString().length() > 0 && !errorCheck.toString().contains(error.toString())) {
                            errorCheck.append(MessageFormat.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002{0}", (String)"SouCompareBillUtil_0", (String)"scm-sou-common", (Object[])new Object[0]), error)).append('\n');
                            continue;
                        }
                        isUpdate = true;
                        Object bn = entryDetailMap.get("billnumber");
                        Object xkBillEntryId = entryDetailMap.get("XKBillEntryId");
                        Object xkBillId = entryDetailMap.get("XKBillId");
                        entry.set("pobillno", bn);
                        entry.set("pobillid", xkBillId);
                        entry.set("poentryid", xkBillEntryId);
                        if (EASNoCheck.toString().contains(bn.toString())) continue;
                        EASNoCheck.append(bn).append('\u3001');
                    }
                    if (EASNoCheck.length() <= 0) continue;
                    easNoResult.append(MessageFormat.format(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\uff1a{0},\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u5982\u4e0b{1}", (String)"SouCompareBillUtil_1", (String)"scm-sou-common", (Object[])new Object[0]), billNo, EASNoCheck.substring(0, EASNoCheck.length() - 1))).append('\n');
                    continue;
                }
                errorCheck.append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SouCompareBillUtil_2", (String)"scm-sou-common", (Object[])new Object[0]));
                continue;
            }
            errorCheck.append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SouCompareBillUtil_2", (String)"scm-sou-common", (Object[])new Object[0]));
        }
        return isUpdate;
    }

    public static String sendData(Map<String, Object> param, String entityType) {
        String msg = null;
        if (param.isEmpty()) {
            return null;
        }
        param.put("billtype", entityType);
        param.put("action", "toOrder");
        param.put("code", "200");
        if (entityType.equals("sou_compare")) {
            try {
                msg = ApiUtil.souCompareToOrder(param);
                if (msg.isEmpty() || msg.equals("{}")) {
                    msg = "500";
                }
            }
            catch (KDException e) {
                msg = "500";
                log.error("\u4e0b\u63a8\u5931\u8d25", (Throwable)e);
            }
        }
        return msg;
    }

    private static Map<String, Map<String, Object>> getBillParam(DynamicObject[] objs) {
        HashMap<String, Map<String, Object>> billMap = new HashMap<String, Map<String, Object>>();
        Map<Object, Object> detailMap = new HashMap();
        for (DynamicObject obj : objs) {
            detailMap = SouCompareBillUtil.getParam(obj);
            if (detailMap.size() == 0) continue;
            String billIdStr = String.valueOf(obj.getPkValue());
            billMap.put(billIdStr, detailMap);
        }
        return billMap;
    }

    private static List<Map<String, Map<String, Object>>> getMultBillParam(DynamicObject[] objs) {
        ArrayList<Map<String, Map<String, Object>>> billMap = new ArrayList<Map<String, Map<String, Object>>>();
        List<Map<String, Object>> detailMapList = null;
        HashMap<String, Map<String, Object>> detailMap = null;
        for (DynamicObject obj : objs) {
            detailMapList = SouCompareBillUtil.getMultParam(obj);
            if (detailMapList.size() == 0) continue;
            String billIdStr = String.valueOf(obj.getPkValue());
            for (Map<String, Object> objectMap : detailMapList) {
                if (objectMap == null) continue;
                detailMap = new HashMap<String, Map<String, Object>>();
                detailMap.put(billIdStr, objectMap);
                billMap.add(detailMap);
            }
        }
        return billMap;
    }

    private static Map<String, Object> getParam(DynamicObject bill) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection("materialentry");
        DynamicObject[] srcBillObjs = SouCompareBillUtil.querySrcBillInfo(entryCols, "materialentry");
        if (srcBillObjs.length == 0) {
            return paramMap;
        }
        SouCompareBillUtil.setHeadParam(paramMap, bill);
        Map<String, Object> billMap = SouCompareBillUtil.wrapEntry((List<DynamicObject>)entryCols, srcBillObjs, bill);
        paramMap.put("entry", billMap);
        return paramMap;
    }

    private static List<Map<String, Object>> getMultParam(DynamicObject bill) {
        ArrayList<Map<String, Object>> paramMapList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection("materialentry");
        DynamicObject[] srcBillObjs = SouCompareBillUtil.querySrcBillInfo(entryCols, "materialentry");
        if (srcBillObjs.length == 0) {
            return paramMapList;
        }
        HashMap<Long, ArrayList<DynamicObject>> currEntryMap = new HashMap<Long, ArrayList<DynamicObject>>();
        ArrayList<DynamicObject> list = null;
        Long quotecurrId = null;
        for (DynamicObject entry : entryCols) {
            quotecurrId = entry.getLong("quotecurr_id");
            if (quotecurrId == null || quotecurrId == 0L) continue;
            list = (ArrayList<DynamicObject>)currEntryMap.get(entry.getLong("quotecurr_id"));
            if (list != null) {
                list.add(entry);
                continue;
            }
            list = new ArrayList<DynamicObject>();
            list.add(entry);
            currEntryMap.put(entry.getLong("quotecurr_id"), list);
        }
        if (currEntryMap.size() > 0) {
            Set entries = currEntryMap.entrySet();
            Iterator iterator = entries.iterator();
            HashMap<String, Object> paramMap = null;
            while (iterator.hasNext()) {
                paramMap = new HashMap<String, Object>();
                Map.Entry next = iterator.next();
                if (next.getValue() == null || ((List)next.getValue()).size() <= 0) continue;
                DynamicObject head = (DynamicObject)((List)next.getValue()).get(0);
                bill.set("curr", (Object)head.getDynamicObject("quotecurr"));
                BigDecimal exrate = head.getBigDecimal("exrate");
                if (exrate != null && exrate.compareTo(BigDecimal.ZERO) > 0) {
                    bill.set("exchrate", (Object)head.getBigDecimal("exrate"));
                }
                SouCompareBillUtil.setHeadParam(paramMap, bill);
                Map<String, Object> billMap = SouCompareBillUtil.wrapEntry((List)next.getValue(), srcBillObjs, bill);
                paramMap.put("entry", billMap);
                paramMapList.add(paramMap);
            }
        }
        return paramMapList;
    }

    private static Map<String, Object> wrapEntry(List<DynamicObject> entryCols, DynamicObject[] srcBillObjs, DynamicObject bill) {
        HashMap<String, Object> billMap = new HashMap<String, Object>(entryCols.size());
        PluginProxy<ISouCompareToEasXKOrder> pluginProxy = SouCompareBillUtil.getWrapInfoExtPlugin();
        for (DynamicObject entryCol : entryCols) {
            DynamicObject material;
            String entryIdStr = String.valueOf(entryCol.getPkValue());
            HashMap<String, Object> entryMap = new HashMap<String, Object>(28);
            String srcBillEntryId = entryCol.getString("srcentryid");
            String srcBillId = entryCol.getString("srcbillid");
            DynamicObject supplier = entryCol.getDynamicObject("supplier");
            entryMap.put("supplier", supplier == null ? "" : supplier.getString("number"));
            entryMap.put("confirmqty", entryCol.get("qty"));
            entryMap.put("price", entryCol.get("price"));
            entryMap.put("confirmtaxprice", entryCol.get("taxprice"));
            entryMap.put("taxrate", entryCol.get("taxrate"));
            if (supplier != null) {
                // empty if block
            }
            if (null == srcBillEntryId) continue;
            DynamicObject srcObjEntry = SouCompareBillUtil.getSrcBillEntry(srcBillObjs, srcBillId, srcBillEntryId);
            if (srcObjEntry != null) {
                String srcBid = srcObjEntry.getString("srcbillid");
                String srcBeid = srcObjEntry.getString("srcentryid");
                entryMap.put("srcbillid", srcBid);
                entryMap.put("srcbillentryid", srcBeid);
                entryMap.put("delidate", DateUtil.date2str((Date)srcObjEntry.getDate("entrydelidate"), (String)"yyyy-MM-dd"));
            }
            entryMap.put("material", (material = entryCol.getDynamicObject("material")) == null ? "" : material.getString("number"));
            entryMap.put("materialdesc", entryCol.get("materialdesc"));
            DynamicObject unit = entryCol.getDynamicObject("unit");
            entryMap.put("unit", unit == null ? "" : unit.getString("number"));
            entryMap.put("dctrate", entryCol.get("dctrate"));
            entryMap.put("dctamount", entryCol.get("dctamount"));
            entryMap.put("amount", entryCol.get("amount"));
            entryMap.put("tax", entryCol.get("tax"));
            entryMap.put("taxamount", entryCol.get("taxamount"));
            entryMap.put("seq", entryCol.get("seq"));
            entryMap.put("entrydelidat", bill.get("delidate"));
            entryMap.put("entrydeliaddr", bill.get("deliaddress"));
            DynamicObject entryrcvorg = entryCol.getDynamicObject("entryrcvorg");
            entryMap.put("entryrcvorg", entryrcvorg == null ? "" : entryrcvorg.getString("number"));
            pluginProxy.callReplaceIfPresent(p -> {
                p.dealEntry(entryCol, bill, entryMap);
                return null;
            });
            billMap.put(entryIdStr, entryMap);
        }
        return billMap;
    }

    private static PluginProxy<ISouCompareToEasXKOrder> getWrapInfoExtPlugin() {
        ISouCompareToEasXKOrder plugin = new ISouCompareToEasXKOrder(){};
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouCompareToEasXKOrder.class, (String)"SCM_SOU_COMPARE_TOORDER", null);
        return pluginProxy;
    }

    private static void setHeadParam(Map<String, Object> headMap, DynamicObject bill) {
        PluginProxy<ISouCompareToEasXKOrder> pluginProxy = SouCompareBillUtil.getWrapInfoExtPlugin();
        DynamicObject org = bill.getDynamicObject("org");
        headMap.put("purorg", org == null ? "" : org.getString("number"));
        DynamicObject curr = bill.getDynamicObject("curr");
        headMap.put("settlecurr", curr == null ? "" : curr.getString("number"));
        DynamicObject loccurr = bill.getDynamicObject("loccurr");
        headMap.put("localcurr", loccurr == null ? "" : loccurr.getString("number"));
        DynamicObject payCond = bill.getDynamicObject("paycond");
        headMap.put("paycond", payCond == null ? "" : payCond.getString("number"));
        DynamicObject person = bill.getDynamicObject("person");
        headMap.put("purperson", person == null ? "" : person.getString("number"));
        if (null != person) {
            DynamicObject group = person.getDynamicObject("group");
            headMap.put("group", group == null ? "" : group.getString("number"));
        } else {
            headMap.put("group", "");
        }
        String taxType = bill.getString("taxtype");
        headMap.put("taxtype", taxType);
        DynamicObject settleType = bill.getDynamicObject("settletype");
        headMap.put("settletype", settleType == null ? "" : settleType.getString("number"));
        headMap.put("exchrate", bill.get("exchrate"));
        pluginProxy.callReplaceIfPresent(p -> {
            p.dealHead(headMap, bill);
            return null;
        });
    }

    private static DynamicObject[] querySrcBillInfo(DynamicObjectCollection entryCol, String entryEntity) {
        DynamicObject[] dynamicObjects = null;
        String selectFields = "id,billno,materialentry.id,materialentry.srcbillid,materialentry.prbillid,materialentry.srcentryid,materialentry.entrydelidate,supplier";
        HashMap paramMap = new HashMap();
        HashMap<String, Set<Object>> idMap = new HashMap<String, Set<Object>>();
        idMap.put("in", SouCompareBillUtil.getIdList(entryCol, entryEntity));
        paramMap.put("id", idMap);
        dynamicObjects = ORMUtil.load((String)"sou_quote", (String)selectFields, paramMap);
        return dynamicObjects;
    }

    private static Set<Object> getIdList(DynamicObjectCollection entryCol, String entryEntity) {
        HashSet<Object> idList = new HashSet<Object>();
        for (DynamicObject entry : entryCol) {
            Object sb = null;
            Object sbi = null;
            sb = entry.get("srcbillid");
            sbi = entry.get("srcentryid");
            if (sbi == null || sbi.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            Long srcBillId = Long.valueOf(sb.toString());
            idList.add(srcBillId);
        }
        return idList;
    }

    private static DynamicObject getSrcBillEntry(DynamicObject[] srcBillObjs, Object srcBillId, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String billId = String.valueOf(srcBill.getPkValue());
            if (!srcBillId.equals(billId)) continue;
            DynamicObjectCollection entryCols = srcBill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryCol : entryCols) {
                String billEntryId = String.valueOf(entryCol.getPkValue());
                if (!srcBillEntryId.equals(billEntryId)) continue;
                return entryCol;
            }
        }
        return entry;
    }

    public static void updateInquiryData(DynamicObject[] objs) {
        ArrayList<String> billNoList = new ArrayList<String>();
        for (int i = 0; i < objs.length; ++i) {
            String billno = objs[i].getString("inquiryno");
            if (null == billno) continue;
            billNoList.add(billno);
        }
        String selectFields = "id,billno,bizstatus";
        QFilter fitler = new QFilter("billno", "in", billNoList);
        DynamicObject[] inquiryDataMap = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)selectFields, (QFilter[])new QFilter[]{fitler});
        ArrayList<DynamicObject> inquiryList = new ArrayList<DynamicObject>(inquiryDataMap.length);
        for (DynamicObject bill : inquiryDataMap) {
            bill.set("bizstatus", (Object)BizStatusEnum.EXECUTED.getVal());
            inquiryList.add(bill);
        }
        if (inquiryList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])inquiryList.toArray(new DynamicObject[0]));
        }
    }

    public static Map<String, Object> verifyEASOrder(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        StringBuilder msgSb = new StringBuilder();
        StringBuilder billNoCheck = new StringBuilder();
        for (DynamicObject bill : dynamicObjects) {
            String billNo = bill.getString("billno");
            DynamicObjectCollection entrs = bill.getDynamicObjectCollection("materialentry");
            StringBuilder EASOrderCheck = new StringBuilder();
            for (DynamicObject entry : entrs) {
                String poBillno = entry.getString("pobillno");
                if (poBillno == null || poBillno.trim().length() <= 0 || EASOrderCheck.toString().contains(poBillno)) continue;
                EASOrderCheck.append(poBillno).append('\u3001');
            }
            if (EASOrderCheck.length() <= 0) continue;
            billNoCheck.append(MessageFormat.format(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\uff1a{0}\uff0c\u5df2\u7ecf\u751f\u6210\u8ba2\u5355\uff1a{1}\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210", (String)"SouCompareBillUtil_5", (String)"scm-sou-common", (Object[])new Object[0]), billNo, EASOrderCheck.subSequence(0, EASOrderCheck.length() - 1))).append('\n');
        }
        if (billNoCheck.toString().length() > 0) {
            msgSb.append((CharSequence)billNoCheck);
        }
        if (msgSb.length() > 0) {
            returnMap.put("title", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"SouCompareBillUtil_6", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            returnMap.put("message", msgSb);
            return returnMap;
        }
        String inwareRules = null;
        try {
            inwareRules = SouCompareBillUtil.getBotpRule(dynamicObjects, "order");
        }
        catch (Exception e) {
            returnMap.put("title", ResManager.loadKDString((String)"\u83b7\u53d6\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"SouCompareBillUtil_7", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouCompareBillUtil_8", (String)"scm-sou-common", (Object[])new Object[0]));
            log.error("\u83b7\u53d6\u8f6c\u6362\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return returnMap;
        }
        if (!SouCompareBillUtil.isEasBill() && ApiConfigUtil.hasXKScmConfig()) {
            returnMap.put("title", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"SouCompareBillUtil_6", (String)"scm-sou-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            if (ApiConfigUtil.hasXKScmConfig()) {
                returnMap.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6765\u6e90\u4e8e\u661f\u7a7a\uff0c\u4e0d\u80fd\u751f\u6210\u661f\u7a7a\u8ba2\u5355\u3002", (String)"SouCompareBillUtil_10", (String)"scm-sou-common", (Object[])new Object[0]));
            } else {
                returnMap.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6765\u6e90\u4e8eEAS\uff0c\u4e0d\u80fd\u751f\u6210EAS\u8ba2\u5355\u3002", (String)"SouCompareBillUtil_9", (String)"scm-sou-common", (Object[])new Object[0]));
            }
            return returnMap;
        }
        if (SouCompareBillUtil.isEasBill()) {
            if (StringUtils.isEmpty((String)inwareRules)) {
                returnMap.put("title", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"SouCompareBillUtil_6", (String)"scm-sou-common", (Object[])new Object[0]));
                returnMap.put("succed", "false");
                returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouCompareBillUtil_8", (String)"scm-sou-common", (Object[])new Object[0]));
                return returnMap;
            }
            JSONArray orderRuleList = JSONArray.fromObject((Object)inwareRules);
            if (orderRuleList.size() > 0 && orderRuleList.size() != 0) {
                returnMap.put("succed", "true");
                returnMap.put("botp", orderRuleList);
            }
        } else {
            returnMap.put("succed", "true");
            returnMap.put("botp", "");
        }
        return returnMap;
    }

    public static void setAdoptInfo(DynamicObjectCollection entrs, DynamicObjectCollection quoentrs, DynamicObject bill) {
        if (quoentrs != null) {
            Object curr;
            int scale = 0;
            if (bill != null && (curr = bill.get("curr")) instanceof DynamicObject) {
                scale = ((DynamicObject)curr).getInt("amtprecision");
            }
            for (DynamicObject obj : quoentrs) {
                Object entrySupplier = obj.get("entrysupplier");
                String supplier = "supplier";
                String entrysupplierId = "entrysupplier";
                boolean flag = true;
                if (entrySupplier == null) continue;
                if (entrySupplier instanceof Long) {
                    flag = false;
                }
                Long quosupid = null;
                if (flag) {
                    supplier = "supplier_id";
                    entrysupplierId = "entrysupplier_id";
                }
                quosupid = obj.getLong(entrysupplierId);
                obj.set("adoptamount", (Object)BigDecimal.ZERO);
                BigDecimal cnsum = obj.getBigDecimal("adoptamount");
                for (DynamicObject entry : entrs) {
                    Long sup = entry.getLong(supplier);
                    if (sup == null || !sup.equals(quosupid)) continue;
                    BigDecimal exrate = entry.getBigDecimal("exrate");
                    String entryquotation = entry.getString("entryquotation");
                    exrate = exrate == null ? BigDecimal.ONE : exrate;
                    BigDecimal taxamount = entry.getBigDecimal("taxamount");
                    DynamicObject quotecurr = entry.getDynamicObject("quotecurr");
                    if (scale == 0) {
                        scale = quotecurr == null ? 6 : quotecurr.getInt("amtprecision");
                    }
                    cnsum = cnsum.add(taxamount == null ? BigDecimal.ZERO : MultCurrencyCalImpl.convertByExrate((BigDecimal)taxamount, (BigDecimal)exrate, (int)scale, (String)entryquotation));
                }
                obj.set("adoptamount", (Object)cnsum);
                if (obj.getBigDecimal("adoptamount").compareTo(BigDecimal.ZERO) > 0) {
                    obj.set("isadopt", (Object)"1");
                    continue;
                }
                obj.set("isadopt", (Object)"2");
            }
        }
    }

    public static void setAdoptInfo(DynamicObjectCollection entrs, DynamicObjectCollection quoentrs) {
        SouCompareBillUtil.setAdoptInfo(entrs, quoentrs, null);
    }

    public static boolean isEasBill() {
        IAppCache easBillCache = AppCache.get((String)"SouCompareBillUtil");
        Boolean isEas = (Boolean)easBillCache.get("isEasBill" + RequestContext.get().getTraceId(), Boolean.class);
        return isEas == null ? false : isEas;
    }

    public static void showBillForm(Object val, String entityKey, Object value, IFormView view) {
        if (val == null || entityKey == null || entityKey.isEmpty() || view == null) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        String idValue = String.valueOf(value);
        if ("null".equals(idValue) || "0".equals(value)) {
            param.put("billno", val);
        } else {
            param.put("id", value);
        }
        DynamicObject dynaObject = ORMUtil.queryOneByPro((String)entityKey, (String)"id,billno", param);
        if (dynaObject != null) {
            view.showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)dynaObject.getPkValue()), new HashMap(), null));
        }
    }
}

