/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.common;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ORMUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;

public class WriteBackUtil {
    private static Log log = LogFactory.getLog(WriteBackUtil.class);
    private static final String HEAD = "head";

    public static void writeBackBill(String entityKey, Map<String, List<String>> proListMap, List<Long> entryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        StringBuilder selectFields = new StringBuilder();
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        log.info("entryIdList" + entryIdList);
        if (!entryIdList.isEmpty()) {
            HashMap<String, List<Long>> entryParam = new HashMap<String, List<Long>>(1);
            entryParam.put("in", entryIdList);
            params.put("materialentry.id", entryParam);
            WriteBackUtil.assembleSelectFieldsAndParams(proListMap, selectFields, params, operation);
            log.info("###WriteBackUtil params:" + params);
            if (!params.isEmpty()) {
                DynamicObject[] dynamicObjectSave;
                for (DynamicObject bill : dynamicObjectSave = ORMUtil.load((String)entityKey, (String)selectFields.toString(), params)) {
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
                    for (DynamicObject entry : entrys) {
                        Long entryId = (Long)entry.getPkValue();
                        if (!entryIdList.contains(entryId)) continue;
                        WriteBackUtil.writeBackProVal(entry, proListMap, (long)entryId, srcEntryId_qtyMap, operation);
                    }
                }
                if (dynamicObjectSave.length > 0) {
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjectSave);
                }
            }
        } else {
            log.info("entryIdList" + entryIdList);
            log.info("srcEntryId_qtyMap" + srcEntryId_qtyMap);
        }
    }

    private static void assembleSelectFieldsAndParams(Map<String, List<String>> proListMap, StringBuilder selectFields, Map<String, Map<String, Object>> params, String operation) {
        selectFields.append("id,billno,billstatus");
        for (Map.Entry<String, List<String>> entry : proListMap.entrySet()) {
            List<String> proList = entry.getValue();
            String entryKey = entry.getKey();
            if (null == proList || proList.size() <= 0) continue;
            switch (entryKey) {
                case "head": {
                    WriteBackUtil.assemblePro(proList, selectFields);
                    break;
                }
                case "materialentry": 
                case "2": {
                    selectFields.append(',').append(entryKey);
                    WriteBackUtil.assembleEntryPro(entryKey, proList, selectFields);
                    WriteBackUtil.assembleParams(entryKey, proList, operation, params);
                    break;
                }
            }
        }
    }

    private static void assemblePro(List<String> proList, StringBuilder selectFields) {
        for (String pro : proList) {
            selectFields.append(',').append(pro);
        }
    }

    private static void assembleEntryPro(String entryKey, List<String> proList, StringBuilder selectFields) {
        for (String pro : proList) {
            if (null == pro || pro.isEmpty()) continue;
            selectFields.append(',').append(entryKey).append('.').append(pro);
        }
    }

    private static void assembleParams(String entryKey, List<String> proList, String operation, Map<String, Map<String, Object>> params) {
        for (String pro : proList) {
            if (null == pro || pro.isEmpty() || !"audit".equals(operation)) continue;
            HashMap<String, String> qtyParam = new HashMap<String, String>();
            qtyParam.put("of", entryKey + ".qty>" + entryKey + "." + pro);
            params.put(entryKey + ".qty", qtyParam);
        }
    }

    private static void writeBackProVal(DynamicObject entry, Map<String, List<String>> proListMap, long entryId, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        List<String> proList = proListMap.get("materialentry");
        for (String pro : proList) {
            WriteBackUtil.writeBackProVal(entry, pro, entryId, srcEntryId_qtyMap, operation);
        }
    }

    private static void writeBackProVal(DynamicObject entry, String pro, long entryId, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)srcEntryId_qtyMap.get(String.valueOf(entryId)));
        BigDecimal wirtBackQtyPro = CommonUtil.getBigDecimalPro((Object)entry.get(pro));
        if (qty.compareTo(BigDecimal.ZERO) > 0) {
            switch (operation) {
                case "audit": {
                    entry.set(pro, (Object)qty.add(wirtBackQtyPro));
                    break;
                }
                case "delete": {
                    if (wirtBackQtyPro.compareTo(BigDecimal.ZERO) <= 0) break;
                    entry.set(pro, (Object)wirtBackQtyPro.subtract(qty));
                    break;
                }
            }
        }
    }
}

