/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.common.util.cal.Cal4MultCurrencyObj;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import org.apache.poi.util.StringUtil;

public abstract class AbstractSouCompareBatchPlugin
extends AbstractFormPlugin {
    protected void allotDynamicData(String billNoPar) {
        Map<String, Object> parameters = this.buildQuoCondition();
        List<String> inquiryNosList = this.getEffectiveInquiryNos(parameters, billNoPar);
        if (inquiryNosList == null || inquiryNosList.isEmpty()) {
            return;
        }
        this.deleteViewEntry();
        Map<String, Object> dataMap = this.getQuoteByInquiry(inquiryNosList.get(0));
        this.buildViewData(dataMap, inquiryNosList.get(0));
    }

    protected void buildViewData(Map<String, Object> dataMap, String inquiryNo) {
        DynamicObjectCollection quoteCollections = this.buildInquiryAndQuote(dataMap, inquiryNo);
        if (quoteCollections != null) {
            this.buildHisMinPriceData();
            this.buildLastComparePriceData();
            this.buildRecentCompareAndOrder(quoteCollections);
            this.setAdoptRuleItem();
            this.getView().updateView("inquiry_entry");
        }
    }

    protected abstract List<String> getEffectiveInquiryNos(Map<String, Object> var1, String var2);

    protected abstract Map<String, Object> buildQuoCondition();

    protected abstract void buildRecentCompareAndOrder(DynamicObjectCollection var1);

    protected abstract DynamicObjectCollection buildInquiryAndQuote(Map<String, Object> var1, String var2);

    protected abstract void buildLastComparePriceData();

    protected abstract void buildHisMinPriceData();

    protected abstract void deleteViewEntry();

    protected abstract Map<String, Object> getQuoteByInquiry(String var1);

    protected abstract List<String> getInquiryNoByQuoInfo(Map<String, Object> var1);

    protected abstract void setAdoptRuleItem();

    public Map<String, Character> getInquiryEntryBlackMap() {
        HashMap<String, Character> entryBlackMap = new HashMap<String, Character>(17);
        entryBlackMap.put("materialnumber1", Character.valueOf('1'));
        entryBlackMap.put("material1", Character.valueOf('1'));
        entryBlackMap.put("material1_id", Character.valueOf('1'));
        entryBlackMap.put("materialmodel1", Character.valueOf('1'));
        entryBlackMap.put("srcentryid1", Character.valueOf('1'));
        entryBlackMap.put("supprice1", Character.valueOf('1'));
        entryBlackMap.put("supprice2", Character.valueOf('1'));
        entryBlackMap.put("supprice3", Character.valueOf('1'));
        entryBlackMap.put("supprice4", Character.valueOf('1'));
        entryBlackMap.put("supprice5", Character.valueOf('1'));
        entryBlackMap.put("supprice6", Character.valueOf('1'));
        entryBlackMap.put("supprice7", Character.valueOf('1'));
        entryBlackMap.put("supprice8", Character.valueOf('1'));
        entryBlackMap.put("cfmqty1", Character.valueOf('1'));
        entryBlackMap.put("cfmprice1", Character.valueOf('1'));
        entryBlackMap.put("cfmtaxprice1", Character.valueOf('1'));
        entryBlackMap.put("cfmtaxrate1", Character.valueOf('1'));
        entryBlackMap.put("supplier1", Character.valueOf('1'));
        entryBlackMap.put("id", Character.valueOf('1'));
        entryBlackMap.put("seq", Character.valueOf('1'));
        entryBlackMap.put("supplier1_id", Character.valueOf('1'));
        return entryBlackMap;
    }

    public Map<String, String> getInquiryEntryWhiteMap() {
        HashMap<String, String> entryMap = new HashMap<String, String>(1);
        entryMap.put("qty1", "inquiryqty");
        return entryMap;
    }

    public Map<String, Character> getCompareQuoteBlackMap() {
        HashMap<String, Character> entryMap = new HashMap<String, Character>(17);
        entryMap.put("turns2", Character.valueOf('1'));
        entryMap.put("turnscount2", Character.valueOf('1'));
        entryMap.put("price2", Character.valueOf('1'));
        entryMap.put("taxprice2", Character.valueOf('1'));
        entryMap.put("taxrateid2", Character.valueOf('1'));
        entryMap.put("taxrateid2_id", Character.valueOf('1'));
        entryMap.put("taxrate2", Character.valueOf('1'));
        entryMap.put("result2", Character.valueOf('1'));
        entryMap.put("cfmamount2", Character.valueOf('1'));
        entryMap.put("cfmtaxamount2", Character.valueOf('1'));
        entryMap.put("tax2", Character.valueOf('1'));
        entryMap.put("qty2", Character.valueOf('1'));
        entryMap.put("supname2", Character.valueOf('1'));
        entryMap.put("billno2", Character.valueOf('1'));
        entryMap.put("billdate2", Character.valueOf('1'));
        entryMap.put("id", Character.valueOf('1'));
        entryMap.put("seq", Character.valueOf('1'));
        return entryMap;
    }

    public Map<String, String> getCompareQuoteWhiteMap() {
        HashMap<String, String> entryMap = new HashMap<String, String>(7);
        entryMap.put("cfmqty2", "qty");
        entryMap.put("cfmbaseqty2", "basicqty");
        entryMap.put("cfmprice2", "price");
        entryMap.put("cfmtaxprice2", "taxprice");
        entryMap.put("cfmtaxrateid2", "taxrateid");
        entryMap.put("cfmtaxrate2", "taxrate");
        entryMap.put("billid2", "srcbillid");
        entryMap.put("entryid2", "srcentryid");
        entryMap.put("entrydelidate2", "entrydelidat");
        return entryMap;
    }

    public void createCompareQuoEntry(DynamicObject billObj, String entryKey, Object inquiryNo, int source) {
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection(entryKey);
        HashSet<String> idset = new HashSet<String>();
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        HashMap<String, Date> maxmap = new HashMap<String, Date>();
        HashSet<String> selectList = new HashSet<String>(64);
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("quobillno", "billno");
        extMap.put("quotebillid", "id");
        extMap.put("entrysupplier", "supplier");
        extMap.put("rate", "taxrate");
        extMap.put("qoutaxamount", "sumtaxamount");
        extMap.put("qouamount", "sumamount");
        extMap.put("paycondition", "paycond");
        extMap.put("deliverdate", "delidate");
        extMap.put("remarks", "remark");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"quo_quote");
        IDataEntityType dataEntityType1 = (IDataEntityType)dataEntityType.getAllEntities().get("materialentry");
        MainEntityType compareType = EntityMetadataCache.getDataEntityType((String)"sou_compare");
        IDataEntityType comapreQuote = (IDataEntityType)compareType.getAllEntities().get(entryKey);
        DataEntityPropertyCollection compareQuotePro = comapreQuote.getProperties();
        HashMap blackListMap = new HashMap();
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)compareQuotePro, selectList, extMap, blackListMap, (DataEntityPropertyCollection)dataEntityType.getProperties(), (String)"");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)compareQuotePro, selectList, extMap, blackListMap, (DataEntityPropertyCollection)dataEntityType1.getProperties(), (String)"");
        selectList.add("materialentry.taxprice taxprice");
        selectList.add("id");
        String selects = StringUtil.join((Object[])selectList.toArray(), (String)",");
        DynamicObjectCollection quoteCollections = QueryServiceHelper.query((String)"quo_quote", (String)selects, (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", inquiryNo).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("materialentry.entrystatus", "=", (Object)"A"))});
        if (quoteCollections != null) {
            for (DynamicObject obj : quoteCollections) {
                String quoid = obj.getString("id");
                Date delidate = obj.getDate("deliverdate");
                if (delidate == null) continue;
                if (maxmap.get(quoid) == null) {
                    maxmap.put(quoid, delidate);
                    continue;
                }
                if (!((Date)maxmap.get(quoid)).before(delidate)) continue;
                maxmap.put(quoid, delidate);
            }
            DataEntityPropertyCollection properties = quoteCollections.getDynamicObjectType().getProperties();
            int index = 1;
            for (DynamicObject obj : quoteCollections) {
                if (obj.getBigDecimal("taxprice").compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject entry = ORMUtil.newDynamicObject((String)("sou_compare." + entryKey));
                if (!idset.add(obj.getString("id"))) continue;
                entryList.add(entry);
                entry.set("seq", (Object)index);
                ++index;
                for (IDataEntityProperty property : compareQuotePro) {
                    if ("id".equals(property.getName()) || !properties.containsKey((Object)property.getName())) continue;
                    if ("deliverdate".equals(property.getName())) {
                        entry.set("deliverdate", maxmap.get(obj.getString("id")));
                        continue;
                    }
                    if (property instanceof BasedataProp) {
                        if (source == 0) {
                            entry.set(property.getName() + "_id", obj.get(property.getName()));
                            continue;
                        }
                        property.setValueFast((Object)entry, (Object)obj.getLong(property.getName()));
                        continue;
                    }
                    entry.set(property.getName(), obj.get(property.getName()));
                }
            }
        }
        if (entryList.size() > 0) {
            entrys.addAll(entryList);
        }
    }

    public void createCompareQuoEntry(DynamicObject billObj, String entryKey) {
    }

    public DynamicObject createCompareBillHead(DynamicObject inquiry, DynamicObject billObj) {
        if (billObj == null) {
            billObj = BusinessDataServiceHelper.newDynamicObject((String)"sou_compare");
        }
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)billObj.getDataEntityType());
        Map inquiryMap = DynamicObjectUtil.plainObject2Map((DynamicObject)inquiry);
        for (String pro : properties) {
            Object val = inquiryMap.get(pro);
            if (null == val || "remark".equals(pro) || "id".equals(pro)) continue;
            billObj.set(pro, val);
        }
        billObj.set("inquiryno", (Object)inquiry.getString("billno"));
        Date curDate = new Date();
        billObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        billObj.set("cfmstatus", (Object)ConfirmStatusEnum.UNCONFIRM.getVal());
        billObj.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        billObj.set("createtime", (Object)curDate);
        billObj.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        billObj.set("modifytime", (Object)curDate);
        billObj.set("lastupdateuser", (Object)RequestContext.get().getCurrUserId());
        billObj.set("lastupdatetime", (Object)curDate);
        billObj.set("auditor", (Object)0);
        billObj.set("auditdate", null);
        billObj.set("billdate", (Object)curDate);
        billObj.set("billno", null);
        String billno = billObj.getString("billno");
        if (StringUtils.isEmpty((String)billno)) {
            billObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"sou_compare", (DynamicObject)billObj, (String)billObj.getString("org")));
        }
        return billObj;
    }

    public void setQuoEntry(DynamicObject billObj, int source) {
        String curr = "curr_id";
        String entrySupp = "entrysupplier_id";
        if (source == 1) {
            curr = "curr";
            entrySupp = "entrysupplier";
        }
        DynamicObjectCollection entrs = billObj.getDynamicObjectCollection("materialentry");
        DynamicObjectCollection quoentrs = billObj.getDynamicObjectCollection("quoentry");
        if (quoentrs != null) {
            Cal4MultCurrencyObj cul = new Cal4MultCurrencyObj();
            long currId = billObj.getLong(curr);
            DynamicObject currency = cul.getCurrency(Long.valueOf(currId));
            int scale = currency == null ? 6 : currency.getInt("amtprecision");
            for (DynamicObject obj : quoentrs) {
                long quosupid = 0L;
                Object value = obj.get(entrySupp);
                if (value instanceof BasedataProp) {
                    quosupid = obj.getLong("entrysupplier_id");
                } else if (value instanceof Long) {
                    quosupid = (Long)value;
                }
                if (quosupid == 0L) continue;
                obj.set("adoptamount", (Object)BigDecimal.ZERO);
                BigDecimal cnsum = obj.getBigDecimal("adoptamount");
                for (DynamicObject entry : entrs) {
                    long sup = entry.getLong("supplier_id");
                    if (sup != quosupid) continue;
                    BigDecimal exrate = entry.getBigDecimal("exrate");
                    String entryquotation = entry.getString("entryquotation");
                    BigDecimal taxamount = entry.getBigDecimal("taxamount");
                    cnsum = cnsum.add(taxamount == null ? BigDecimal.ZERO : MultCurrencyCalImpl.convertByExrate((BigDecimal)taxamount, (BigDecimal)exrate, (int)scale, (String)entryquotation));
                }
                obj.set("adoptamount", (Object)cnsum);
                if (obj.getBigDecimal("adoptamount").compareTo(BigDecimal.ZERO) > 0) {
                    obj.set("isadopt", (Object)"1");
                    continue;
                }
                obj.set("isadopt", (Object)"2");
            }
        }
    }

    public void wrapSelectsByContainer(Container inquiryquopanel, Set<String> selectList, DataEntityPropertyCollection properties) {
        if (inquiryquopanel != null) {
            List items = inquiryquopanel.getItems();
            for (Control item : items) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)item.getKey());
                if (property == null) continue;
                if (property instanceof BasedataProp || property instanceof CurrencyProp || property instanceof OrgProp) {
                    selectList.add(item.getKey() + ".id " + item.getKey());
                    continue;
                }
                if ("purorg".equals(item.getKey()) || "inquiryno".equals(item.getKey())) continue;
                selectList.add(item.getKey());
            }
        }
    }

    public Map<String, Character> getQuoteInfoBlackMap() {
        HashMap<String, Character> blackListMap = new HashMap<String, Character>(1);
        blackListMap.put("note", Character.valueOf('1'));
        blackListMap.put("supplier_id", Character.valueOf('1'));
        blackListMap.put("cfmprice", Character.valueOf('1'));
        blackListMap.put("cfmqty", Character.valueOf('1'));
        blackListMap.put("cfmtaxprice", Character.valueOf('1'));
        blackListMap.put("cfmtaxrate", Character.valueOf('1'));
        blackListMap.put("material_id", Character.valueOf('1'));
        blackListMap.put("unit_id", Character.valueOf('1'));
        blackListMap.put("entryrcvorg_id", Character.valueOf('1'));
        blackListMap.put("entryreqorg_id", Character.valueOf('1'));
        blackListMap.put("supname", Character.valueOf('1'));
        blackListMap.put("curr_id", Character.valueOf('1'));
        blackListMap.put("result", Character.valueOf('1'));
        blackListMap.put("cfmtaxrateid", Character.valueOf('1'));
        blackListMap.put("tax", Character.valueOf('1'));
        blackListMap.put("basicunit_id", Character.valueOf('1'));
        blackListMap.put("cfmtaxrateid_id", Character.valueOf('1'));
        blackListMap.put("taxrateid_id", Character.valueOf('1'));
        blackListMap.put("quotecurr_id", Character.valueOf('1'));
        return blackListMap;
    }

    public void createCompareBillEntry(DynamicObject billObj, String entryKey) {
    }

    public void createCompareBillEntry(DynamicObject billObj, String entryKey, int source) {
    }
}

