/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.sou.common.SouCompareToolUtil;

public class SouAllBillAdoptPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener {
    private static final String INQUIRY_NO = "inquiryno";
    private static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object inquiryNo = param.get(INQUIRY_NO);
        if (inquiryNo != null) {
            String billno = inquiryNo.toString();
            Map<String, Object> quomap = this.getQuoteByInquiry(billno);
            DynamicObjectCollection quoteCollections = null;
            if (null != quomap.get("quote")) {
                quoteCollections = (DynamicObjectCollection)quomap.get("quote");
            }
            this.getModel().setValue("billno", (Object)billno);
            this.getModel().setValue("inquirytitle", param.get("inquirytitle"));
            this.getModel().setValue("billdate", param.get("billDate"));
            if (quoteCollections != null) {
                this.setSupEntryByNo(quoteCollections);
            }
        }
    }

    protected Map<String, Object> getQuoteByInquiry(String inquiryNo) {
        Map<String, Map<String, Object>> quoParams = this.buildCondition();
        HashMap<String, String> inquiryNoMap = new HashMap<String, String>(1);
        inquiryNoMap.put("=", inquiryNo);
        quoParams.put(INQUIRY_NO, inquiryNoMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", "A");
        quoParams.put("materialentry.entrystatus", statusMap);
        String orderBys = "sumtaxamount,billdate";
        return SouCompareToolUtil.getQuoteByInquiry((String)"sou_quote", quoParams, (String)orderBys);
    }

    private Map<String, Map<String, Object>> buildCondition() {
        HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>();
        IPageCache cache = this.getPageCache();
        String org = cache.get("org");
        if (null != org) {
            HashMap<String, Long> orgMap = new HashMap<String, Long>(1);
            orgMap.put("=", Long.valueOf(org));
            paramMap.put("org", orgMap);
        }
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        paramMap.put("billstatus", statusMap);
        return paramMap;
    }

    protected void setSupEntryByNo(DynamicObjectCollection quoteCollections) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        HashSet<Object> idset = new HashSet<Object>();
        if (quoteCollections.size() > 0) {
            int i = 0;
            TableValueSetter ts = new TableValueSetter(new String[0]);
            for (DynamicObject obj : quoteCollections) {
                Object id = obj.get(0);
                if (!idset.add(id)) continue;
                ts.set("number", obj.get("supplier"), i);
                ts.set("quobillno", obj.get("billno"), i);
                ts.set("quodate", obj.get("billdate"), i);
                ts.set("sumamount", obj.get("sumtaxamount"), i);
                ++i;
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, ts);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IFormView view = this.getView();
        if ("confirm".equals(operateKey)) {
            String inquiryNo;
            Map<String, Object> quomap;
            EntryGrid grid = (EntryGrid)view.getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            if (selectRows == null || selectRows.length != 1) {
                view.showMessage(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u4f9b\u5e94\u5546\u3002", (String)"SouAllBillAdoptPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection scorerRowObjs = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            Object supid = ((DynamicObject)scorerRowObjs.get(index)).getDynamicObject("number").getPkValue();
            Map param = view.getFormShowParameter().getCustomParams();
            Map srcEntryIdMap = (Map)param.get("srcentryid");
            ArrayList<Integer> errorSeqs = new ArrayList<Integer>(selectRows.length);
            if (srcEntryIdMap != null && !srcEntryIdMap.isEmpty() && supid != null && null != (quomap = this.getQuoteByInquiry(inquiryNo = (String)param.get(INQUIRY_NO))).get("quote")) {
                DynamicObjectCollection quoteCollections = (DynamicObjectCollection)quomap.get("quote");
                for (DynamicObject quoteObj : quoteCollections) {
                    if (!srcEntryIdMap.containsKey(quoteObj.getString("srcentryid")) || !supid.toString().equals(quoteObj.getString("supplier")) || quoteObj.getBigDecimal("price") != null && quoteObj.getBigDecimal("price").compareTo(BigDecimal.ZERO) != 0) continue;
                    errorSeqs.add((Integer)srcEntryIdMap.get(quoteObj.getString("srcentryid")) + 1);
                }
                if (errorSeqs.size() != 0) {
                    this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6b64\u4f9b\u5e94\u5546\u65e0\u62a5\u4ef7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SouAllBillAdoptPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]), CommonUtil.integerList2str(errorSeqs)));
                    return;
                }
            }
            if (supid != null) {
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("suppid", supid);
                view.returnDataToParent(returnData);
                view.close();
            }
        }
    }
}

