/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;

public class SouBidAlertDatePlugin
extends AbstractFormPlugin {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Map param = parameter.getCustomParams();
        this.log.info("\u7ade\u4ef7\u65f6\u95f4\u53d8\u66f4\u65f6\u95f4\u53c2\u6570param\uff1a" + param);
        model.setValue("oldenrolldate", param.get("enrolldate"));
        model.setValue("enrolldate", param.get("enrolldate"));
        model.setValue("oldopendate", param.get("opendate"));
        model.setValue("opendate", param.get("opendate"));
        model.setValue("oldresultdate", param.get("resultdate"));
        model.setValue("resultdate", param.get("resultdate"));
        model.setValue("olddelidate1", param.get("delidate1"));
        model.setValue("delidate1", param.get("delidate1"));
        String bidStatus = (String)param.get("bidstatus");
        if (BidStatusEnum.BEENEXAMINED.getVal().equals(bidStatus) || BidStatusEnum.BIDDING.getVal().equals(bidStatus) || BidStatusEnum.EVALUATING.getVal().equals(bidStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"enrolldate", "opendate"});
        } else if (BidStatusEnum.CONFIRMED.getVal().equals(bidStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"enrolldate", "opendate", "resultdate"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        super.afterDoOperation(event);
        if (!event.getOperationResult().isSuccess()) {
            return;
        }
        if (this.validateDate() && "confirm".equals(operateKey = ((AbstractOperate)event.getSource()).getOperateKey())) {
            this.confirmAlert();
        }
    }

    private void confirmAlert() {
        IFormView view = this.getView();
        DynamicObject bidBill = this.getBidBill();
        if (null == bidBill) {
            view.showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7ade\u4ef7\u5355\u3002", (String)"SouBidAlertDatePlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        Object enrollDate = model.getValue("enrolldate");
        Object openDate = model.getValue("opendate");
        Object resultDate = model.getValue("resultdate");
        Object deliDate1 = model.getValue("delidate1");
        bidBill.set("enrolldate", enrollDate);
        bidBill.set("opendate", openDate);
        bidBill.set("resultdate", resultDate);
        bidBill.set("delidate1", deliDate1);
        if (null != enrollDate && TimeServiceHelper.now().before((Date)enrollDate) && BidStatusEnum.DEADLINE.getVal().equals(bidBill.getString("bidstatus"))) {
            bidBill.set("bidstatus", (Object)BidStatusEnum.ENROLMENT.getVal());
        } else if (null != enrollDate && TimeServiceHelper.now().after((Date)enrollDate) && BidStatusEnum.ENROLMENT.getVal().equals(bidBill.getString("bidstatus"))) {
            bidBill.set("bidstatus", (Object)BidStatusEnum.DEADLINE.getVal());
        }
        Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidBill});
        if (objs.length > 0) {
            this.updateNoticeDate((Long)bidBill.getPkValue());
            view.showMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u65f6\u95f4\u6210\u529f\u3002", (String)"SouAlertDatePlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            view.close();
        }
    }

    private void updateNoticeDate(Long inquiryId) {
        Map targetDataMap = BFTrackerServiceHelper.findTargetBills((String)"sou_bidbill", (Long[])new Long[]{inquiryId});
        Set noticeSet = (Set)targetDataMap.get("sou_notice");
        if (null != noticeSet) {
            Object enrollDate = this.getModel().getValue("enrolldate");
            String selectProperties = "id,duedate";
            QFilter filter = new QFilter("id", "in", (Object)noticeSet);
            DynamicObject[] noticeObjs = BusinessDataServiceHelper.load((String)"sou_notice", (String)selectProperties, (QFilter[])new QFilter[]{filter});
            for (int i = 0; i < noticeObjs.length; ++i) {
                DynamicObject noticeObj = noticeObjs[i];
                noticeObj.set("duedate", enrollDate);
            }
            SaveServiceHelper.save((DynamicObject[])noticeObjs);
        }
    }

    private DynamicObject getBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        Object bidBillIdObj = params.get("billid");
        if (bidBillIdObj == null) {
            return null;
        }
        String selectFields = "id,billno,bizstatus,enrolldate,opendate,resultdate,delidate1,bidstatus";
        return BusinessDataServiceHelper.loadSingle(bidBillIdObj, (String)"sou_bidbill", (String)selectFields);
    }

    public boolean validateDate() {
        Date now = TimeServiceHelper.now();
        Date enrolldate = (Date)this.getModel().getValue("enrolldate");
        Date opendate = (Date)this.getModel().getValue("opendate");
        Date resultdate = (Date)this.getModel().getValue("resultdate");
        Object delidate1 = this.getModel().getValue("delidate1");
        if (null == enrolldate || opendate == null || resultdate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d8\u66f4\u540e\u65f6\u95f4\u3002", (String)"SouBidAlertDatePlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date oldEnrollDate = (Date)this.getModel().getValue("oldenrolldate");
        Date oldOpenDate = (Date)this.getModel().getValue("oldopendate");
        Date oldResultDate = (Date)this.getModel().getValue("oldresultdate");
        Object oldDeliDate1 = this.getModel().getValue("olddelidate1");
        if (!enrolldate.equals(oldEnrollDate) && enrolldate.compareTo(now) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (opendate.compareTo(enrolldate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u62a5\u540d\u622a\u6b62\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!opendate.equals(oldOpenDate) && opendate.compareTo(now) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (resultdate.compareTo(opendate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u516c\u5e03\u7ed3\u679c\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!resultdate.equals(oldResultDate) && resultdate.compareTo(now) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u516c\u5e03\u7ed3\u679c\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null != delidate1 && ((Date)delidate1).compareTo(resultdate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u8d27\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u9884\u8ba1\u516c\u5e03\u7ed3\u679c\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null != delidate1 && !delidate1.equals(oldDeliDate1) && ((Date)delidate1).compareTo(now) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u8d27\u7684\u53d8\u66f4\u540e\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouBidAlertDatePlugin_7", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

