/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.sou.common.SouCommonUtil;

public class SouBidConfirmPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CONFIRM = "confirm";
    private static final String CONFIRMCALLBACK = "CONFIRMCALLBACK";

    public void afterCreateNewData(EventObject e) {
        this.bindData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar tb = (Toolbar)this.getControl("toolbarap");
        tb.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (CONFIRM.equals(itemKey) && this.hasQZGYS()) {
            evt.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e2d\u6807\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u4e0d\u662f\u6b63\u5f0f\u4f9b\u5e94\u5546\uff0c\u540e\u7eed\u65e0\u6cd5\u4e0b\u63a8\u5355\u636e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"SouBidConfirmPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK));
        }
    }

    public boolean hasQZGYS() {
        DynamicObject supplierDyn = (DynamicObject)this.getModel().getValue("supplier");
        return null != supplierDyn && "QZGYS".equals(supplierDyn.getString("supplier_status.number"));
    }

    public void bindData() {
        DynamicObjectCollection quoBidBills = this.getSouBidBillForView();
        if (quoBidBills == null || quoBidBills.isEmpty()) {
            return;
        }
        this.cacheSupplierAndAmount(quoBidBills);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object curr = param.get("curr");
        DynamicObject data = (DynamicObject)quoBidBills.get(0);
        IDataModel model = this.getModel();
        model.setValue("bidtitle", data.get("name"));
        model.setValue("amount", (Object)this.getPageCache().get("minAmount"));
        model.setValue("supplier", (Object)this.getPageCache().get("minSupplier"));
        model.setValue("curr", curr);
    }

    public void cacheSupplierAndAmount(DynamicObjectCollection quoBidBills) {
        if (quoBidBills.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>((int)((double)quoBidBills.size() / 0.75));
        for (int i = 0; i <= quoBidBills.size() - 1; ++i) {
            DynamicObject quoBidBill = (DynamicObject)quoBidBills.get(i);
            BigDecimal quoAmount = quoBidBill.getBigDecimal("quoteamount");
            if (tempMap.containsKey(quoBidBill.getString("quotesupplier"))) continue;
            tempMap.put(quoBidBill.getString("quotesupplier"), quoAmount.toString());
        }
        this.getPageCache().put(tempMap);
        BigDecimal minAmount = BigDecimal.ZERO;
        String minSupplier = "";
        for (Map.Entry entry : tempMap.entrySet()) {
            BigDecimal quoAmount = new BigDecimal((String)entry.getValue());
            if (BigDecimal.ZERO.compareTo(minAmount) == 0) {
                minAmount = quoAmount;
            }
            if (StringUtils.isEmpty((CharSequence)minSupplier)) {
                minSupplier = (String)entry.getKey();
            }
            if (minAmount.compareTo(quoAmount) < 0) continue;
            minAmount = quoAmount;
            minSupplier = (String)entry.getKey();
        }
        this.getPageCache().put("minAmount", minAmount.toString());
        this.getPageCache().put("minSupplier", minSupplier);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey()) {
            case "confirm": {
                OperationResult result = afterDoOperationEventArgs.getOperationResult();
                if (!result.isSuccess()) break;
                this.confirmBid();
                break;
            }
        }
    }

    public void confirmBid() {
        boolean bidForShowWinAmount;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        if (null == supplier) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546\u3002", (String)"SouBidConfirmPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        DynamicObject bidCfm = BusinessDataServiceHelper.loadSingle(bidBillIdObj, (String)"sou_bidbillcfm");
        BigDecimal amount = CommonUtil.getBigDecimalPro((Object)model.getValue("amount"));
        BigDecimal sumTaxAmount = CommonUtil.getBigDecimalPro((Object)bidCfm.get("sumtaxamount"));
        DynamicObject curr = BusinessDataServiceHelper.loadSingleFromCache((Object)bidCfm.getLong("curr_id"), (String)"bd_currency");
        int priceprecision = curr.getInt("priceprecision");
        bidCfm.set("bidamount", (Object)amount);
        bidCfm.set("supplier", supplier.getPkValue());
        bidCfm.set("bidprofit", (Object)sumTaxAmount.subtract(amount));
        bidCfm.set("decider", (Object)RequestContext.get().getUserId());
        bidCfm.set("decidedate", (Object)new Date());
        bidCfm.set("bidstatus", (Object)BidStatusEnum.CONFIRMED);
        bidCfm.set("audit", model.getValue("audit"));
        boolean bidForShowWinCompany = bidCfm.getBoolean("open3");
        if (bidForShowWinCompany) {
            bidCfm.set("supplier1", supplier.getPkValue());
        }
        if (bidForShowWinAmount = bidCfm.getBoolean("open4")) {
            bidCfm.set("amount1", (Object)amount);
        }
        DynamicObjectCollection supQuoEntrys = bidCfm.getDynamicObjectCollection("entryentity1");
        Set<String> quoSupIdSet = this.getQuoSupIdSet();
        for (DynamicObject supQuoEntry : supQuoEntrys) {
            DynamicObject quoSup = supQuoEntry.getDynamicObject("entrysupplier");
            if (null == quoSup) continue;
            String quoSupId = quoSup.getPkValue().toString();
            if (supplier.getPkValue().toString().equals(quoSupId)) {
                supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.WINTHEBID);
                continue;
            }
            if (!quoSupIdSet.contains(quoSupId)) continue;
            supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.FAILTHEBID);
        }
        DynamicObjectCollection materialEntrys = bidCfm.getDynamicObjectCollection("entryentity");
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal winPrice = BigDecimal.ZERO;
        BigDecimal winTaxPrice = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        String taxType = bidCfm.getString("taxtype");
        int scale = bidCfm.getInt("curr.priceprecision");
        for (int maxIndex = materialEntrys.size() - 1; maxIndex >= 0; --maxIndex) {
            DynamicObject materialEntry = (DynamicObject)materialEntrys.get(maxIndex);
            curTaxAmount = materialEntry.getBigDecimal("taxamount");
            qty = materialEntry.getBigDecimal("qty");
            taxRate = materialEntry.getBigDecimal("taxrate");
            BigDecimal dctrate = materialEntry.getBigDecimal("dctrate");
            if (maxIndex == 0) {
                curTaxAmount = amount.subtract(totalAmount);
            } else {
                curTaxAmount = curTaxAmount.multiply(amount).divide(sumTaxAmount, 10, RoundingMode.CEILING);
                totalAmount = totalAmount.add(curTaxAmount);
            }
            winTaxPrice = CalculateUtils.calTaxPrice((BigDecimal)curTaxAmount, (BigDecimal)qty, (BigDecimal)dctrate, (int)scale);
            winPrice = TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType) ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)winTaxPrice, (int)scale) : CalculateUtils.calPrice((BigDecimal)winTaxPrice, (BigDecimal)taxRate, (int)scale);
            materialEntry.set("wintaxprice", (Object)winTaxPrice);
            materialEntry.set("winprice", (Object)winPrice);
            materialEntry.set("winamount", (Object)curTaxAmount);
            materialEntry.set("winsupplier", supplier.getPkValue());
        }
        SaveServiceHelper.save((IDataEntityType)bidCfm.getDynamicObjectType(), (Object[])new Object[]{bidCfm});
        DynamicObjectCollection entryentity = bidCfm.getDynamicObjectCollection("entryentity");
        SouCommonUtil.updatePmStatus((DynamicObjectCollection)entryentity);
        HashMap<String, Boolean> returnData = new HashMap<String, Boolean>();
        returnData.put("isConfirmed", true);
        view.returnDataToParent(returnData);
        view.close();
    }

    public DynamicObjectCollection getSouBidBillForView() {
        Map<String, Map<String, Object>> params = this.getParams();
        String selectFields = "name,entryentity2.quotesupplier.id quotesupplier,entryentity2.quotedate quotedate,entryentity2.quoteamount quoteamount";
        String orderBys = "entryentity2.quotedate desc,entryentity2.quoteamount";
        return ORMUtil.queryDynamicObjectCollection((String)"sou_bidbillcfm", (String)selectFields, params, (String)orderBys);
    }

    public Map<String, Map<String, Object>> getParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        return params;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "supplier": {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Object bidBillId = parameter.getCustomParam("bidBillId");
                if (bidBillId != null) {
                    ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    Set<String> quoSupIdSet = this.getQuoSupIdSet();
                    HashSet quoSupIds = new HashSet();
                    quoSupIdSet.forEach(s -> quoSupIds.add(Long.valueOf(s)));
                    formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", quoSupIds));
                    formShowParameter.setMultiSelect(false);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        super.confirmCallBack(messageBoxClosedEvent);
        if (CONFIRMCALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().invokeOperation(CONFIRM);
        }
    }

    public Set<String> getQuoSupIdSet() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object bidBillId = parameter.getCustomParam("bidBillId");
        HashSet<String> idSet = new HashSet<String>();
        if (bidBillId != null) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"sou_bidbillcfm", (String)"entryentity2.quotesupplier quotesupplier", (QFilter[])new QFilter[]{new QFilter("id", "in", bidBillId)}, (String)"id");){
                dataSet.forEach(row -> idSet.add(row.getString("quotesupplier")));
            }
        }
        return idSet;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        if ("supplier".equals(e.getProperty().getName()) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.getModel().setValue("amount", (Object)this.getPageCache().get(String.valueOf(newValue.getPkValue())));
        }
    }
}

