/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.util.StringUtils;
import kd.scm.common.service.IExcelDataEntityService;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.sou.formplugin.service.impl.SouCompareExcelServiceImp;

public class SouCompareBatchExportPlugin
extends AbstractFormPlugin
implements UploadListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        toolBar.addUploadListener((UploadListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        if ("quoexport".equals(afterDoOperationEventArgs.getOperateKey())) {
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u51fa\u4e2d", (String)"QuoToolBatchImportPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0])));
                DynamicObjectCollection rows = this.getModel().getEntryEntity("inquiry_entry");
                ExcelDataEntity entity = this.export(rows);
                if (entity == null) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002%1$s", (String)"QuoToolBatchImportPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]), ""));
                    return;
                }
                ExcelUtil.exportExcel((IFormView)this.getView(), (ExcelDataEntity)entity);
            }
            catch (Exception e) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002%1$s", (String)"QuoToolBatchImportPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    public ExcelDataEntity export(DynamicObjectCollection rows) throws Exception {
        HashMap<String, String> mustInputPro = new HashMap<String, String>();
        mustInputPro.put("result2", "");
        mustInputPro.put("cfmqty2", "");
        mustInputPro.put("cfmtaxprice2", "");
        mustInputPro.put("cfmprice2", "");
        ExcelDataEntity excelDataEntity = null;
        if (rows == null || rows.size() < 1) {
            return null;
        }
        String taxType = (String)this.getModel().getValue("taxtype");
        DynamicObject curr1 = (DynamicObject)this.getModel().getDataEntity(true).get("curr");
        int settleScale = 6;
        if (curr1 != null && curr1.getDynamicObjectType().getProperty("priceprecision") != null) {
            settleScale = curr1.getInt("priceprecision");
        }
        DynamicObjectCollection quoteRntry = ((DynamicObject)rows.get(0)).getDynamicObjectCollection("quote_entry");
        DynamicObjectCollection infos = new DynamicObjectCollection(quoteRntry.getDynamicObjectType(), quoteRntry.getParent(), (List)quoteRntry);
        for (int i = 1; i < rows.size(); ++i) {
            infos.addAll((Collection)((DynamicObject)rows.get(i)).getDynamicObjectCollection("quote_entry"));
        }
        Set<String> noNeedExportProps = this.getNoNeedExportProps();
        if ("1".equals(taxType) || "3".equals(taxType)) {
            noNeedExportProps.add("cfmprice2");
        }
        if ("2".equals(taxType)) {
            noNeedExportProps.add("cfmtaxprice2");
        }
        IExcelDataEntityService service = this.getExcelDataEntityService(taxType, settleScale);
        excelDataEntity = service.wrapExcelDataEntity(infos, items -> {
            Iterator iterator = items.iterator();
            ControlAp[] endList = new ControlAp[1];
            while (iterator.hasNext()) {
                boolean isNotNeed;
                ControlAp item = (ControlAp)iterator.next();
                if (StringUtils.isBlank((String)item.getVisible()) && "material2".equals(item.getKey())) {
                    iterator.remove();
                    continue;
                }
                boolean bl = isNotNeed = noNeedExportProps.contains(item.getKey()) || item.getKey() == null || item.getKey().split("_").length > 1 && "id".equals(item.getKey().split("_")[1]);
                if (isNotNeed) {
                    if ("entryid2".equals(item.getKey())) {
                        endList[0] = item;
                        endList[0].setName(new LocaleString(MessageFormat.format("{0}{1}#{2}", item.getName().getLocaleValue(), ResManager.loadKDString((String)"(\u4e0d\u5141\u8bb8\u4fee\u6539)", (String)"QuoToolBatchImportPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]), item.getKey())));
                    }
                    iterator.remove();
                    continue;
                }
                if ("cfmtaxrate2".equals(item.getKey()) || "taxrate2".equals(item.getKey()) || "note2".equals(item.getKey())) {
                    Field field = ((EntryFieldAp)item).getField();
                    field.setMustInput(true);
                }
                if (mustInputPro.containsKey(item.getKey())) {
                    item.setName(new LocaleString(MessageFormat.format("*{0}{1}#{2}", item.getName().getLocaleValue(), "", item.getKey())));
                    continue;
                }
                item.setName(new LocaleString(MessageFormat.format("{0}{1}#{2}", item.getName().getLocaleValue(), "", item.getKey())));
            }
            for (ControlAp entityItem : endList) {
                if (entityItem == null) continue;
                items.add(entityItem);
            }
            return null;
        });
        excelDataEntity.setFileName(ResManager.loadKDString((String)"\u6211\u8981\u6bd4\u4ef7.xlsx", (String)"QuoToolBatchImportPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        return excelDataEntity;
    }

    private Set<String> getNoNeedExportProps() {
        HashSet<String> noNeedExportProps = new HashSet<String>(32);
        noNeedExportProps.add("prbillid2");
        noNeedExportProps.add("prentryid2");
        noNeedExportProps.add("billid2");
        noNeedExportProps.add("curr2");
        noNeedExportProps.add("supname2");
        noNeedExportProps.add("purleadday2");
        noNeedExportProps.add("minorderqty2");
        noNeedExportProps.add("basicunit2");
        noNeedExportProps.add("basicqty2");
        noNeedExportProps.add("cfmtaxrateid2");
        noNeedExportProps.add("entryid2");
        noNeedExportProps.add("tax");
        return noNeedExportProps;
    }

    private IExcelDataEntityService getExcelDataEntityService(String taxType, int settleScale) {
        return new SouCompareExcelServiceImp(taxType, settleScale);
    }
}

