/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.sou.formplugin.SouToolBatchDataSheetHandler;
import org.apache.commons.lang3.StringUtils;

public class SouCompareBatchImportPlugin {
    private static final Log log = LogFactory.getLog(SouCompareBatchImportPlugin.class);
    private Map<Integer, Map<Integer, String>> rows;
    private Map<BigDecimal, Object> taxMap = new HashMap<BigDecimal, Object>();
    private Map<String, Map<String, Object>> dealMap = new HashMap<String, Map<String, Object>>();
    private String importInquiryNo = "";
    private static final String PARTITION = "#";
    private Map<String, String> mustInputPropMap = new HashMap<String, String>();
    private Map<String, String> mayInputPropMap = new HashMap<String, String>();
    private Map<String, Map<String, Object>> comboItemMap = new HashMap<String, Map<String, Object>>();
    private EntityMetadata entitymeta;

    public SouCompareBatchImportPlugin(SouToolBatchDataSheetHandler handler) {
        this.mustInputPropMap.put("cfmprice2", "");
        this.mustInputPropMap.put("cfmtaxprice2", "");
        this.mustInputPropMap.put("cfmqty2", "");
        this.mustInputPropMap.put("entryid2", "");
        this.mustInputPropMap.put("inquiryno2", "");
        this.mustInputPropMap.put("result2", "");
        this.mayInputPropMap.put("note2", "");
        this.mayInputPropMap.put("cfmtaxrate2", "");
        String entityName = "sou_comparetool";
        String entryEntity = "quote_entry";
        String entityId = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        this.entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List items = MetaDataUtil.getControlAps((FormMetadata)formmeta, (EntityMetadata)this.entitymeta, (String)entryEntity);
        if (items != null) {
            for (ControlAp item : items) {
                Map<String, Object> itemMap;
                List items1;
                Field info = ((EntryFieldAp)item).getField();
                if (!(info instanceof ComboField) || null == (items1 = ((ComboField)info).getItems()) || items1.size() <= 0 || (itemMap = this.comboItemMap.get(info.getKey())) != null) continue;
                itemMap = new HashMap<String, Object>(items1.size());
                for (ComboItem comboItem : items1) {
                    itemMap.put(comboItem.getCaption().getLocaleValue(), comboItem.getValue());
                }
                this.comboItemMap.put(info.getKey(), itemMap);
            }
        }
        if (handler != null) {
            this.rows = handler.getRows();
        }
    }

    public String getImportInquiryNo() {
        return this.importInquiryNo;
    }

    public String validateImportInfo(Function<String, String> fresh) {
        StringBuilder errorInfos = new StringBuilder();
        if (this.rows.size() > 1) {
            HashMap<String, Integer> propIndexMap = new HashMap<String, Integer>();
            int inquirynoInx = -1;
            int resultInx = -1;
            int entryidInx = -1;
            Map<Integer, String> titleRow = this.rows.get(0);
            for (Map.Entry<Integer, String> entry : titleRow.entrySet()) {
                String colName;
                if (entry.getValue() == null || entry.getValue().split(PARTITION).length <= 1 || !this.mustInputPropMap.containsKey(colName = entry.getValue().split(PARTITION)[1]) && !this.mayInputPropMap.containsKey(colName)) continue;
                propIndexMap.put(colName, entry.getKey());
                if ("inquiryno2".equals(colName)) {
                    inquirynoInx = entry.getKey();
                    continue;
                }
                if ("result2".equals(colName)) {
                    resultInx = entry.getKey();
                    continue;
                }
                if (!"entryid2".equals(colName)) continue;
                entryidInx = entry.getKey();
            }
            if (inquirynoInx == -1) {
                return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be2\u4ef7\u5355\u7f16\u53f7\u3002", (String)"SouCompareBatchImportPlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]);
            }
            Map<Integer, String> integerStringMap = this.rows.get(1);
            String inquiryno = integerStringMap.get(inquirynoInx);
            if (StringUtils.isNotBlank((CharSequence)inquiryno)) {
                this.importInquiryNo = inquiryno;
                String taxType = fresh.apply(inquiryno);
                if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                    this.mustInputPropMap.remove("cfmtaxprice2");
                } else {
                    this.mustInputPropMap.remove("cfmprice2");
                }
                if (this.validateMustInputProperty(propIndexMap, errorInfos)) {
                    StringBuilder rowErrorInfo = null;
                    for (int i = 1; i < this.rows.size(); ++i) {
                        Map<Integer, String> valueMap = this.rows.get(i);
                        rowErrorInfo = new StringBuilder();
                        if (!StringUtils.equals((CharSequence)valueMap.get(inquirynoInx), (CharSequence)inquiryno)) {
                            return ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u76f8\u540c\u8be2\u4ef7\u5355\u62a5\u4ef7\u4fe1\u606f\u3002", (String)"SouCompareBatchImportPlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0]);
                        }
                        String result = valueMap.get(resultInx);
                        if (StringUtils.isNotBlank((CharSequence)result)) {
                            Map<String, Object> itemMap = this.comboItemMap.get("result2");
                            if (itemMap != null) {
                                Object resultValue = itemMap.get(result);
                                HashMap<String, Object> row = new HashMap<String, Object>(3);
                                this.dealMap.put(valueMap.get(entryidInx), row);
                                if ("1".equals(resultValue)) {
                                    String error = this.parseRowInfo(propIndexMap, row, valueMap);
                                    if (StringUtils.isNotBlank((CharSequence)error)) {
                                        rowErrorInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"SouCompareBatchImportPlugin_6", (String)"scm-sou-formplugin", (Object[])new Object[0]), i)).append(error).append("\n");
                                    }
                                } else if ("2".equals(resultValue)) {
                                    row.put("result2", "2");
                                } else {
                                    rowErrorInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c{1}\u201d\u4e3a\u975e\u6cd5\u6570\u636e\u3002", (String)"SouCompareBatchImportPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]), i, this.entitymeta.getFieldByKey("result2").getName().getLocaleValue())).append("\n");
                                }
                            }
                        } else {
                            rowErrorInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c{1}\u201d\u4e3a\u975e\u6cd5\u6570\u636e\u3002", (String)"SouCompareBatchImportPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]), i, this.entitymeta.getFieldByKey("result2").getName().getLocaleValue())).append("\n");
                        }
                        errorInfos.append((CharSequence)rowErrorInfo);
                    }
                }
                return errorInfos.toString();
            }
        }
        return ResManager.loadKDString((String)"\u5f15\u5165\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"SouCompareBatchImportPlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]);
    }

    private boolean validateMustInputProperty(Map<String, Integer> propIndexMap, StringBuilder error) {
        Set<Map.Entry<String, String>> mustInputEntry = this.mustInputPropMap.entrySet();
        for (Map.Entry<String, String> map : mustInputEntry) {
            Integer index = propIndexMap.get(map.getKey());
            if (index != null) continue;
            error.append(String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u5f55\u5c5e\u6027:%1$s", (String)"SouCompareBatchImportPlugin_10", (String)"scm-sou-formplugin", (Object[])new Object[0]), this.entitymeta.getFieldByKey(map.getKey()).getName().getLocaleValue())).append("\n");
        }
        return !StringUtils.isNotBlank((CharSequence)error.toString());
    }

    private String parseRowInfo(Map<String, Integer> propIndexMap, Map<String, Object> row, Map<Integer, String> valueMap) {
        Set<Map.Entry<String, Integer>> map = propIndexMap.entrySet();
        StringBuilder error = new StringBuilder();
        for (Map.Entry<String, Integer> entry : map) {
            String value;
            String importValue;
            if (this.mustInputPropMap.containsKey(entry.getKey()) && StringUtils.isBlank((CharSequence)(importValue = valueMap.get(entry.getValue())))) {
                error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u8bf7\u586b\u8be5\u6570\u636e\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"SouCompareBatchImportPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("entryid2".equals(entry.getKey())) continue;
            if ("cfmtaxrate2".equals(entry.getKey())) {
                String inputValue = valueMap.get(entry.getValue());
                DynamicObject taxItem = (DynamicObject)this.getTaxItem(inputValue);
                if (taxItem == null) {
                    if (StringUtils.isNotBlank((CharSequence)inputValue)) {
                        error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u6307\u5b9a\u7a0e\u7387\u503c\u3002", (String)"SouCompareBatchImportPlugin_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    value = valueMap.get(entry.getValue());
                    row.put(entry.getKey(), value == null ? BigDecimal.ZERO : new BigDecimal(value));
                    row.put("cfmtaxrateid2", null);
                    continue;
                }
                value = valueMap.get(entry.getValue());
                row.put(entry.getKey(), value == null ? BigDecimal.ZERO : new BigDecimal(value));
                row.put("cfmtaxrateid2", taxItem);
                row.put("cfmtaxrate2", taxItem.getBigDecimal("taxrate"));
                continue;
            }
            Field fieldByKey = this.entitymeta.getFieldByKey(entry.getKey());
            if (fieldByKey instanceof DecimalField) {
                try {
                    DecimalField field = (DecimalField)fieldByKey;
                    Map editor = field.createEditor();
                    BigDecimal bigDecimal = new BigDecimal(valueMap.get(entry.getValue()));
                    if (editor != null) {
                        Object max = editor.get("max");
                        Object min = editor.get("min");
                        Object maxm = editor.get("maxm");
                        Object minm = editor.get("minm");
                        BigDecimal begin = this.getBigDecimal(min);
                        BigDecimal end = this.getBigDecimal(max);
                        this.validateBigDecimal(bigDecimal, begin, String.valueOf(minm));
                        if (this.validateBigDecimal(bigDecimal, begin, String.valueOf(minm)) || this.validateBigDecimal(bigDecimal, end, String.valueOf(maxm))) {
                            error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u8d85\u8fc7\u6307\u5b9a\u7cbe\u5ea6", (String)"SouCompareBatchImportPlugin_7", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        }
                    }
                    if (bigDecimal.precision() > field.getPrecision() || bigDecimal.scale() > field.getScale()) {
                        error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u8d85\u8fc7\u6307\u5b9a\u7cbe\u5ea6", (String)"SouCompareBatchImportPlugin_7", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"SouCompareBatchImportPlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    row.put(entry.getKey(), bigDecimal);
                }
                catch (Exception e) {
                    error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e3a\u975e\u6570\u503c\u7c7b\u6570\u636e\u3002", (String)"SouCompareBatchImportPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    log.error("\u4e0d\u5141\u8bb8\u4e3a\u975e\u6570\u503c\u7c7b\u6570\u636e\u3002", (Throwable)e);
                }
                continue;
            }
            if ("result2".equals(entry.getKey())) {
                row.put(entry.getKey(), "1");
                continue;
            }
            if ("note2".equals(entry.getKey())) {
                TextField note = (TextField)fieldByKey;
                value = valueMap.get(entry.getValue());
                if (value != null && value.length() > note.getMaxLength()) {
                    error.append(this.entitymeta.getFieldByKey(entry.getKey()).getName().getLocaleValue()).append(ResManager.loadKDString((String)"\u8d85\u8fc7\u6307\u5b9a\u957f\u5ea6", (String)"SouCompareBatchImportPlugin_11", (String)"scm-sou-formplugin", (Object[])new Object[0])).append(note.getMaxLength());
                    continue;
                }
            }
            row.put(entry.getKey(), valueMap.get(entry.getValue()));
        }
        return error.toString();
    }

    private boolean validateBigDecimal(BigDecimal bigDecimal, BigDecimal value, String tag) {
        if ("[".equals(tag)) {
            return bigDecimal.compareTo(value) < 0;
        }
        if ("(".equals(tag)) {
            return bigDecimal.compareTo(value) <= 0;
        }
        if ("]".equals(tag)) {
            return bigDecimal.compareTo(value) > 0;
        }
        return bigDecimal.compareTo(value) >= 0;
    }

    private BigDecimal getBigDecimal(Object o) {
        if (o instanceof Integer) {
            return new BigDecimal((Integer)o);
        }
        if (o instanceof Long) {
            return new BigDecimal((Long)o);
        }
        if (o == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(o.toString());
    }

    public Map<String, Map<String, Object>> getDealMap() {
        return this.dealMap;
    }

    private Object getTaxItem(Object value) {
        BigDecimal val;
        try {
            val = new BigDecimal(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            log.error("\u7a0e\u7387\u7c7b\u578b\u9519\u8bef!", (Throwable)e);
            return null;
        }
        Object tax = this.taxMap.get(val);
        if (tax != null) {
            return tax;
        }
        QFilter filter = new QFilter("taxrate", "=", (Object)val);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bd_taxrate", (String)"id,taxrate", (QFilter[])new QFilter[]{filter});
        if (null != obj) {
            this.taxMap.put(val, obj);
            tax = obj;
        }
        return tax;
    }
}

