/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.helper.pmapply.InquiryFactory;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.sou.common.SouSendMessageUtil;

public class SouInquiryEndPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u7ec8\u6b62\uff1f", (String)"SouInquiryEndPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmend"));
                break;
            }
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.getSouInquiryBillForSave();
        if (inquiryBill != null) {
            String bizStatus = inquiryBill.getString("bizstatus");
            Object result = model.getValue("result");
            if (result != null && "A".equals(result.toString())) {
                if (bizStatus.equals(BizStatusEnum.END.getVal())) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"SouInquiryEndPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    return;
                }
                inquiryBill.set("bizstatus", (Object)BizStatusEnum.END);
                this.setEntryEntityStatus(inquiryBill);
            }
            Date currDate = TimeServiceHelper.getCurrentSystemTime();
            inquiryBill.set("terminate", model.getValue("suggestion"));
            inquiryBill.set("decider", (Object)RequestContext.get().getUserId());
            inquiryBill.set("decidedate", (Object)currDate);
            SaveServiceHelper.save((IDataEntityType)inquiryBill.getDynamicObjectType(), (Object[])new Object[]{inquiryBill});
            this.deleteEASInfo(inquiryBill);
            view.close();
            this.beforeSendMessage(inquiryBill);
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"sendmsgforend", (String)"sou_inquiry", (DynamicObject[])new DynamicObject[]{inquiryBill}, (OperateOption)option);
            if (ApiConfigUtil.hasInvCloudConfig()) {
                InquiryFactory pmApplyStatusUpdateFactory = new InquiryFactory();
                PmApplyStatusUpdate pmApplyStatusUpdate = pmApplyStatusUpdateFactory.create("sou_inquiry", "terminate", "", new DynamicObject[]{inquiryBill});
                pmApplyStatusUpdate.execute();
            }
        }
    }

    protected void deleteEASInfo(DynamicObject bidBill) {
        if (ApiConfigUtil.hasEASConfig()) {
            DynamicObject inquiryEntry = null;
            HashSet<String> srcBillidSet = new HashSet<String>(1024);
            HashSet<String> srcBillEntryidSet = new HashSet<String>(1024);
            DynamicObjectCollection inquiryCol = bidBill.getDynamicObjectCollection("materialentry");
            for (int j = 0; j < inquiryCol.size(); ++j) {
                inquiryEntry = (DynamicObject)inquiryCol.get(j);
                srcBillidSet.add(inquiryEntry.getString("srcbillid"));
                srcBillEntryidSet.add(inquiryEntry.getString("srcentryid"));
            }
            HashMap<String, Serializable> param = new HashMap<String, Serializable>();
            HashMap<String, HashSet<String>> dataMap = new HashMap<String, HashSet<String>>();
            dataMap.put("inquiry", srcBillidSet);
            dataMap.put("inquirysrcentry", srcBillEntryidSet);
            param.put("data", dataMap);
            param.put("code", Integer.valueOf(200));
            ApiUtil.souBillDeleteEAS(param);
        }
    }

    private void beforeSendMessage(DynamicObject inquiryBill) {
        String billNo = inquiryBill.getString("billno");
        DynamicObjectCollection quoteBills = QueryServiceHelper.query((String)"quo_quote", (String)"id,billno,creator,modifier,auditor,bizpartner", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)billNo).and("materialentry.entrystatus", "=", (Object)"A").and("billstatus", "=", (Object)"C")});
        HashSet<String> handledQuoteBillNos = new HashSet<String>(quoteBills.size());
        HashSet<Long> userPkId = new HashSet<Long>(quoteBills.size() * 3);
        HashSet<Long> bizpartnerIds = new HashSet<Long>(quoteBills.size());
        String supscope = inquiryBill.getString("supscope");
        if ("2".equals(supscope)) {
            Iterator entryCol = inquiryBill.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                if (row.getDynamicObject("supplier") == null) continue;
                bizpartnerIds.add(row.getDynamicObject("supplier").getLong("bizpartner_id"));
            }
            List adminPks = BizPartnerUtil.getAdminSupUserIdsByBizPartner(bizpartnerIds);
            userPkId.addAll(adminPks);
        }
        for (DynamicObject quoteBill : quoteBills) {
            String quoteBillNo = quoteBill.getString("billno");
            if (!handledQuoteBillNos.add(quoteBillNo)) continue;
            Long bizpartnerId = quoteBill.getLong("bizpartner");
            bizpartnerIds.add(bizpartnerId);
            Long creator = quoteBill.getLong("creator");
            Long modifier = quoteBill.getLong("modifier");
            Long auditor = quoteBill.getLong("auditor");
            userPkId.add(creator);
            userPkId.add(modifier);
            userPkId.add(auditor);
        }
        if (!bizpartnerIds.isEmpty() && !userPkId.isEmpty()) {
            String content = MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u7684\u8be2\u4ef7\u5355{0}\u5df2\u7531\u91c7\u8d2d\u65b9\u7ec8\u6b62\uff0c\u8bf7\u77e5\u6089\u3002", (String)"SouInquiryEndPlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]), billNo);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            DynamicObject person = inquiryBill.getDynamicObject("person");
            if (person != null) {
                msgParams.put("senderId", String.valueOf(person.getPkValue()));
                msgParams.put("senderName", person.getString("name"));
            } else {
                DynamicObject inquiryCreator = inquiryBill.getDynamicObject("creator");
                msgParams.put("senderId", String.valueOf(inquiryCreator.getPkValue()));
                msgParams.put("senderName", inquiryCreator.getString("name"));
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u8be2\u4ef7\u7ec8\u6b62\u901a\u77e5", (String)"SouInquiryEndPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            msgParams.put("content", content);
            msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_inquiry" + "&pkId=" + inquiryBill.getLong("id"));
            msgParams.put("toMob", "true");
            StringBuilder mobUrl = new StringBuilder();
            String domainContextUrl = UrlService.getDomainContextUrl();
            mobUrl.append(domainContextUrl);
            mobUrl.append("/index.html?formId=quo_inquiry&pkId=").append(inquiryBill.getPkValue()).append("&type=report");
            String accountId = RequestContext.get().getAccountId();
            if (accountId != null) {
                mobUrl.append('&').append("accountId=").append(accountId);
            }
            msgParams.put("mobContentUrl", mobUrl.toString());
            msgParams.put("hasBizDataId", "false");
            SouSendMessageUtil.sendMessage(bizpartnerIds, new ArrayList(userPkId), msgParams);
        }
    }

    private void setEntryEntityStatus(DynamicObject inquiryBill) {
        DynamicObjectCollection supplierInfo = inquiryBill.getDynamicObjectCollection("entryentity");
        HashMap midSupplierInfoMap = new HashMap();
        if (supplierInfo != null) {
            supplierInfo.forEach(info -> {
                DynamicObject dynamicObject = (DynamicObject)midSupplierInfoMap.get(info.getString("supplier_id"));
                if (dynamicObject == null) {
                    midSupplierInfoMap.put(info.getString("supplier_id"), info);
                } else if (dynamicObject.getInt("entrycount") < info.getInt("entrycount")) {
                    midSupplierInfoMap.put(info.getString("supplier_id"), info);
                }
            });
        }
        midSupplierInfoMap.values().forEach(info -> {
            if (info != null) {
                info.set("supplierbizstatus", (Object)BizStatusEnum.END);
            }
        });
    }

    private DynamicObject getSouInquiryBillForSave() {
        Map<String, Map<String, Object>> params = this.getParams();
        StringBuilder stringBuilder = new StringBuilder(DynamicObjectUtil.getSelectfields((String)"sou_inquiry", (boolean)false));
        stringBuilder.append(",entryentity.supplier,entryentity.canshow,entryentity.supplierbizstatus,entryentity.entrycount,materialentry.srcbillid,materialentry.srcentryid");
        DynamicObject[] objs = ORMUtil.load((String)"sou_inquiry", (String)stringBuilder.toString(), params);
        return objs.length == 0 ? null : objs[0];
    }

    private Map<String, Map<String, Object>> getParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("inquiryBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        return params;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmend".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirm();
        }
    }
}

