/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.sou.service.ISouGroupParamerterService;
import kd.scm.sou.service.SouGroupParamerterServiceImp;

public class SouSelectBidBillPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        EntryGrid checkSumGrid = (EntryGrid)view.getControl("entryentity");
        checkSumGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] bidBillObjs = this.getBidBillData();
        this.setBidBillInfo(bidBillObjs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "refresh": {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData("entryentity");
                DynamicObject[] bidBillObjs = this.getBidBillData();
                this.setBidBillInfo(bidBillObjs);
                break;
            }
        }
    }

    private DynamicObject[] getBidBillData() {
        HashMap params = new HashMap(8);
        List permissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"sou_bidhall", (String)"47150e89000000ac");
        HashMap<String, List> orgsMap = new HashMap<String, List>(2);
        orgsMap.put("in", permissionOrgs);
        params.put("org", orgsMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(2);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        params.put("billstatus", statusMap);
        ISouGroupParamerterService service = this.getSouGroupService();
        QFilter filter = service.getCurrUserGroupFilter();
        if (filter != null) {
            HashMap<String, QFilter> groupMaps = new HashMap<String, QFilter>(1);
            groupMaps.put("qfilter", filter);
            params.put("person.group", groupMaps);
        }
        HashMap<String, Object> bidStatusMap = new HashMap<String, Object>(4);
        String[] bidStatusArray = new String[]{BidStatusEnum.ENROLMENT.getVal()};
        bidStatusMap.put("not in", bidStatusArray);
        bidStatusMap.put("!=", " ");
        params.put("bidstatus", bidStatusMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"sou_bidbill", (String)selectFields, params, (String)" opendate desc");
        return objs;
    }

    protected ISouGroupParamerterService getSouGroupService() {
        return new SouGroupParamerterServiceImp();
    }

    private void setBidBillInfo(DynamicObject[] bidBillObjs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        model.deleteEntryData("entryentity");
        if (bidBillObjs.length == 0) {
            return;
        }
        IDataEntityProperty billNoProperty = (IDataEntityProperty)bidBillObjs[0].getDynamicObjectType().getProperties().get((Object)"billno");
        IDataEntityProperty bidBillNameProperty = (IDataEntityProperty)bidBillObjs[0].getDynamicObjectType().getProperties().get((Object)"name");
        IDataEntityProperty openDateProperty = (IDataEntityProperty)bidBillObjs[0].getDynamicObjectType().getProperties().get((Object)"opendate");
        IDataEntityProperty bidStatusProperty = (IDataEntityProperty)bidBillObjs[0].getDynamicObjectType().getProperties().get((Object)"bidstatus");
        IDataEntityProperty personProperty = (IDataEntityProperty)bidBillObjs[0].getDynamicObjectType().getProperties().get((Object)"person_id");
        for (DynamicObject bidBillObj : bidBillObjs) {
            Object bidStatus = bidStatusProperty.getValueFast((Object)bidBillObj);
            BidStatusEnum bidStatusEnum = BidStatusEnum.fromVal((String)bidStatus.toString());
            ts.set("billno", billNoProperty.getValueFast((Object)bidBillObj), i);
            ts.set("billname", bidBillNameProperty.getValueFast((Object)bidBillObj), i);
            ts.set("opendate", openDateProperty.getValueFast((Object)bidBillObj), i);
            ts.set("bidstatus", (Object)bidStatusEnum.getVal(), i);
            ts.set("bidbillid", bidBillObj.getPkValue(), i);
            ts.set("person_id", personProperty.getValueFast((Object)bidBillObj), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        StringBuilder stringBuilder;
        String billBidId;
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String gridKey = grid.getKey();
        DynamicObject selectedObj = grid.getModel().getEntryRowEntity(gridKey, heperLinkEvent.getRowIndex());
        IFormView view = this.getView();
        if (selectedObj != null && this.checkBidStatus(billBidId = selectedObj.getString("bidbillid"), stringBuilder = new StringBuilder())) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("bidBillId", billBidId);
            if (stringBuilder.toString().equals("2")) {
                view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_bidhallbyentry", paramMap, null, (ShowType)ShowType.MainNewTabPage));
            } else {
                view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_bidhall", paramMap, null, (ShowType)ShowType.MainNewTabPage));
            }
        }
    }

    private boolean checkBidStatus(String billBidId, StringBuilder stringBuilder) {
        IFormView view = this.getView();
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)"supquoentry", (boolean)false);
        DynamicObject souBidHallDO = QueryServiceHelper.queryOne((String)"sou_bidbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(billBidId))});
        String bidStatus = souBidHallDO.getString("bidstatus");
        if (BidStatusEnum.ENROLMENT.getVal().equals(bidStatus) || BidStatusEnum.BEENEXAMINED.getVal().equals(bidStatus) || BidStatusEnum.DEADLINE.getVal().equals(bidStatus)) {
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u62a5\u540d\u4e2d\uff0c\u62a5\u540d\u622a\u6b62\u6216\u5df2\u8d44\u5ba1\u7684\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouSelectBidBillPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        String autoConfirm = souBidHallDO.getString("autoconfirm");
        if ("true".equals(autoConfirm) && !BidStatusEnum.CONFIRMED.getVal().equals(bidStatus) && !BidStatusEnum.EXECUTED.getVal().equals(bidStatus) && !BidStatusEnum.END.getVal().equals(bidStatus)) {
            view.showMessage(ResManager.loadKDString((String)"\u81ea\u52a8\u5b9a\u6807\u7684\u9879\u76ee\u5728\u5b9a\u6807\u524d\u4e0d\u80fd\u67e5\u770b\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouSelectBidBillPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return false;
        }
        stringBuilder.append(souBidHallDO.getString("quotemode"));
        return true;
    }
}

