/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.common.SouBidCfmBillUtil;
import kd.scm.sou.common.SouContactChangeUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import kd.scm.sou.formplugin.edit.SouCoreBillEditPlugin;

public class SouBidBillCfmEdit
extends SouCoreBillEditPlugin {
    private static final String BIDAUDIT = "bidaudit";
    private static final String RETURNCASH = "returncash";
    private static final String PUSH = "push";
    private static final String TERMINATE = "terminate";
    private static final String BIDHALL = "bidhall";
    private static final String ACTION_BOTPLIST = "botpList";
    private static final String MYTRACKUP = "mytrackup";

    public void initialize() {
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_toorder"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"eas_push"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_supplier"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_tocontract"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_toorder"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_supplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"eas_push"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_tocontract"});
        }
        if (ApiConfigUtil.hasCQScmConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        if (ApiConfigUtil.hasXKScmConfig()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_tocontract"});
        }
        SouBidBillUtil.updateBidStatus();
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        return inquiryObject.getString("bidstatus").toLowerCase();
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String bidStatus = dataEntity.getString("bidstatus");
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_supplier") && !StringUtils.equals((CharSequence)bidStatus, (CharSequence)BidStatusEnum.CONFIRMED.getVal()) && !StringUtils.equals((CharSequence)bidStatus, (CharSequence)BidStatusEnum.EXECUTED.getVal())) {
            this.getView().showMessage(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u5df2\u5b9a\u6807/\u5df2\u6267\u884c\u72b6\u6001\uff0c\u4e0d\u80fd\u751f\u6210\u4f9b\u8d27\u6e05\u5355\u3002", (String)"SouBidBillCfmEdit_4", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_tocontract") && !StringUtils.equals((CharSequence)bidStatus, (CharSequence)BidStatusEnum.CONFIRMED.getVal()) && !StringUtils.equals((CharSequence)bidStatus, (CharSequence)BidStatusEnum.EXECUTED.getVal())) {
            this.getView().showMessage(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u5df2\u5b9a\u6807/\u5df2\u6267\u884c\u72b6\u6001\uff0c\u4e0d\u80fd\u751f\u6210\u91c7\u8d2d\u5408\u540c\u3002", (String)"SouBidBillCfmEdit_16", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            evt.setCancel(true);
            return;
        }
        if ((StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_toorder") || StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_supplier") || StringUtils.equals((CharSequence)itemKey, (CharSequence)"baritemap") || StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_tocontract")) && this.hasQZGYS()) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u8ba4\u8bc1\u4e3a\u6b63\u5f0f\u4f9b\u5e94\u5546\u624d\u80fd\u5173\u8054\u4e0b\u6e38\u5355\u636e\u3002", (String)"SouBidBillCfmEdit_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public boolean hasQZGYS() {
        DynamicObjectCollection materialentryCol = this.getModel().getEntryEntity("entryentity1");
        for (DynamicObject materialDyn : materialentryCol) {
            boolean isHasQZGYS = SupBidStatusEnum.WINTHEBID.getVal().equals(materialDyn.getString("supentrystatus")) && "QZGYS".equals(materialDyn.getString("entrysupplier.supplier_status.number"));
            if (!isHasQZGYS) continue;
            return true;
        }
        return false;
    }

    protected void toOrder() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter prodfilter = new QFilter("id", "=", dataEntity.getPkValue());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbillcfm", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbillcfm", (String)"entryentity", (boolean)false);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"sou_bidbillcfm", (String)selectFields, (QFilter[])new QFilter[]{prodfilter});
        Map resultMap = SouBidCfmBillUtil.verifyEASOrder((DynamicObject[])prodArray);
        if (resultMap.get("succed").equals("true")) {
            if (resultMap.get("botp").equals("")) {
                IFormView view = this.getView();
                BillModel model = (BillModel)this.getModel();
                DynamicObject obj = model.getDataEntity(true);
                SouBidCfmBillUtil.toOrder((DynamicObject[])new DynamicObject[]{obj}, (String)"entryentity", null, (IFormView)view);
            } else {
                this.openBotpListPage(CommonUtil.objs2str((Object[])new Object[]{dataEntity.getPkValue()}), (List)resultMap.get("botp"), "order");
            }
        }
        if (resultMap.get("succed").equals("false")) {
            this.getView().showMessage(resultMap.get("title").toString(), resultMap.get("message").toString(), MessageTypes.Default);
            return;
        }
    }

    protected void openBotpListPage(String pkStr, List<Object> ruleList, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleList);
        param.put("srctype", "request");
        param.put("tobilltype", toBillType);
        param.put("pkstr", pkStr);
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
        this.getView().showForm(formParam);
    }

    private void retDeposit() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object bidStatus = model.getValue("bidstatus");
        BigDecimal cashDeposit = CommonUtil.getBigDecimalPro((Object)model.getValue("cashdeposit"));
        if (cashDeposit.compareTo(BigDecimal.ZERO) == 0) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u4e3a\u96f6\uff0c\u65e0\u987b\u9000\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillCfmEdit_0", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if (!bidStatus.toString().equals(BidStatusEnum.CONFIRMED.getVal()) && !bidStatus.equals(BidStatusEnum.EXECUTED.getVal())) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u672a\u5b9a\u6807\uff0c\u65e0\u6cd5\u9000\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillCfmEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        this.openDealPage("sou_retdeposit", "retDepositActionId", "", ShowType.Modal);
    }

    private void audit() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject newInfo = QueryServiceHelper.queryOne((String)"sou_bidbillcfm", (String)"id,bidstatus,autoconfirm", (QFilter[])new QFilter[]{new QFilter("id", "=", model.getDataEntity().getPkValue())});
        String bidStatus = newInfo.getString("bidstatus");
        boolean autoConfirm = newInfo.getBoolean("autoconfirm");
        if (!BidStatusEnum.EVALUATING.getVal().equals(bidStatus)) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u662f\u8bc4\u6807\u4e2d\uff0c\u65e0\u6cd5\u5b9a\u6807\u3002", (String)"SouBidBillCfmEdit_2", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if (autoConfirm) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5b9a\u6807\u7684\u9879\u76ee\u4e0d\u5141\u8bb8\u624b\u52a8\u5b9a\u6807\u5ba1\u6279\u3002", (String)"SouBidBillCfmEdit_13", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        Object curr = model.getDataEntity(true).getDynamicObject("curr").getPkValue();
        String quotemode = model.getDataEntity(true).getString("quotemode");
        MutexHelper.require((String)model.getDataEntityType().getName(), (Object)String.valueOf(model.getDataEntity().getPkValue()), (String)BIDAUDIT, (StringBuilder)new StringBuilder(1));
        if (StringUtils.equals((CharSequence)quotemode, (CharSequence)"1")) {
            this.openDealPage("sou_bidconfirm", "bidAuditActionId", curr, ShowType.Modal);
        } else {
            this.openDealPage("sou_bidconfirmbyentry", "bidAuditActionId", curr, ShowType.Modal);
        }
    }

    private void terninate() {
        Object bidStatus = this.getModel().getValue("bidstatus");
        if (!bidStatus.toString().equals(BidStatusEnum.END.getVal())) {
            this.openDealPage("sou_exception", "bidTerminateAtionId", "", ShowType.Modal);
        }
    }

    private void openDealPage(String pageKey, String actionId, Object obj, ShowType type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bidBillId", this.getModel().getDataEntity().getPkValue());
        paramMap.put("curr", obj);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)type));
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "bidaudit": {
                    this.audit();
                    break;
                }
                case "returncash": {
                    this.retDeposit();
                    break;
                }
                case "bidhall": {
                    SouBidBillUtil.openBidHall((String)"sou_bidbillcfm", (IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "bidHallAtionId"));
                    break;
                }
                case "terminate": {
                    this.terninate();
                    break;
                }
                case "toeasorder": {
                    this.toOrder();
                    break;
                }
                case "mytrackup": {
                    this.trackUp();
                    break;
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        Object value = dataModel.getValue(name);
        switch (name) {
            case "supcontacter": {
                if (!(value instanceof DynamicObject)) break;
                SouContactChangeUtil.ContactChange((IDataModel)dataModel, (DynamicObject)((DynamicObject)value));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "bidAuditActionId": {
                model.load(model.getPKValue());
                view.updateView();
                this.beforeSendMessage();
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                OperationServiceHelper.executeOperate((String)"sendmsgtowin", (String)"sou_bidbillcfm", (DynamicObject[])new DynamicObject[]{model.getDataEntity()}, (OperateOption)option);
                OperationServiceHelper.executeOperate((String)"sendmsgtofail", (String)"sou_bidbillcfm", (DynamicObject[])new DynamicObject[]{model.getDataEntity()}, (OperateOption)option);
                MutexHelper.release((String)model.getDataEntityType().getName(), (String)BIDAUDIT, (String)String.valueOf(model.getPKValue()));
                break;
            }
            case "bidHallAtionId": 
            case "bidTerminateAtionId": 
            case "retDepositActionId": {
                model.load(model.getPKValue());
                view.updateView();
                break;
            }
            case "botpList": {
                Object botpList_condition = closedCallBackEvent.getReturnData();
                if (botpList_condition == null) {
                    return;
                }
                Map result = (Map)botpList_condition;
                Object ruleNumber = result.get("rule");
                if (ruleNumber == null) {
                    return;
                }
                Object[] pks = CommonUtil.str2objs((String)String.valueOf(result.get("pkstr")), (String)",");
                this.pushOrder(pks, String.valueOf(ruleNumber));
                break;
            }
        }
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
        model.setDataChanged(false);
    }

    private void pushOrder(Object[] pks, String botpNumber) {
        DynamicObject[] objs = this.getSelectData(pks);
        IFormView view = this.getView();
        SouBidCfmBillUtil.toOrder((DynamicObject[])objs, (String)"entryentity", (String)botpNumber, (IFormView)view);
    }

    protected DynamicObject[] getSelectData(Object[] ids) {
        ArrayList<Object> idList = new ArrayList<Object>();
        if (ids != null) {
            Collections.addAll(idList, ids);
        } else {
            idList.add(this.getModel().getDataEntity().getPkValue());
        }
        List idLists = CommonUtil.getLongList(idList);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbillcfm", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbillcfm", (String)"entryentity", (boolean)false);
        HashMap filterMap = new HashMap(2);
        HashMap<String, List> idMap = new HashMap<String, List>(1);
        idMap.put("in", idLists);
        filterMap.put("id", idMap);
        return ORMUtil.load((String)"sou_bidbillcfm", (String)selectFields, filterMap);
    }

    private void trackUp() {
        Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbillcfm", (String)"sou_bidbill")) {
            noPermBill.add("sou_bidbill");
            errMsgList.add(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7ade\u4ef7\u53d1\u5e03\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillCfmEdit_11", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbillcfm", (String)"sou_notice")) {
            noPermBill.add("sou_notice");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u516c\u544a\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillCfmEdit_12", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Map<String, HashSet<Long>> result = this.getTrackUpBill(pkId);
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackUpBill(Long pk) {
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>();
        HashSet<Long> bidBillSet = new HashSet<Long>();
        bidBillSet.add(pk);
        resultMap.put("sou_bidbill", bidBillSet);
        Map noticeResult = BFTrackerServiceHelper.findTargetBills((String)"sou_bidbill", (Long[])new Long[]{pk});
        if (noticeResult != null && !noticeResult.isEmpty() && noticeResult.get("sou_notice") != null) {
            resultMap.put("sou_notice", (HashSet<Long>)noticeResult.get("sou_notice"));
        }
        return resultMap;
    }

    private void beforeSendMessage() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String billno = dataEntity.getString("billno");
        DynamicObjectCollection entryentity = (DynamicObjectCollection)dataEntity.get("entryentity1");
        for (DynamicObject supplierDO : entryentity) {
            String adoptStr;
            DynamicObject entrysupplier = supplierDO.getDynamicObject("entrysupplier");
            long supenroll = supplierDO.getLong("supenroll.id");
            if (entrysupplier == null) continue;
            long bizPartnerPkId = entrysupplier.getLong("bizpartner_id");
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(supenroll);
            DynamicObject quoBidBillDO = QueryServiceHelper.queryOne((String)"quo_bidbill", (String)"id,billno,name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            if ("F".equals(supplierDO.getString("supentrystatus"))) {
                adoptStr = ResManager.loadKDString((String)"\u5df2\u4e2d\u6807", (String)"SouBidBillCfmEdit_14", (String)"scm-sou-formplugin", (Object[])new Object[0]);
            } else {
                if (!"G".equals(supplierDO.getString("supentrystatus"))) continue;
                adoptStr = ResManager.loadKDString((String)"\u672a\u4e2d\u6807", (String)"SouBidBillCfmEdit_15", (String)"scm-sou-formplugin", (Object[])new Object[0]);
            }
            if (quoBidBillDO == null) continue;
            String content = MessageFormat.format(ResManager.loadKDString((String)"\u7ade\u4ef7\u67e5\u8be2\u5355\uff08\u9879\u76ee\u540d\u79f0\uff1a{0}\uff0c\u9879\u76ee\u7f16\u53f7\uff1a{1}\uff09\u7684\u7ed3\u679c\u72b6\u6001\u4e3a{2}\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SouBidBillCfmEdit_7", (String)"scm-sou-formplugin", (Object[])new Object[0]), quoBidBillDO.getString("name"), quoBidBillDO.getString("billno"), adoptStr);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            DynamicObject person = dataEntity.getDynamicObject("person");
            if (person != null) {
                msgParams.put("senderId", String.valueOf(person.getPkValue()));
                msgParams.put("senderName", person.getString("name"));
            } else {
                DynamicObject creator = dataEntity.getDynamicObject("creator");
                msgParams.put("senderId", String.valueOf(creator.getPkValue()));
                msgParams.put("senderName", creator.getString("name"));
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5", (String)"SouBidBillCfmEdit_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            msgParams.put("content", content);
            msgParams.put("failMsgTitle", ResManager.loadKDString((String)"\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u901a\u77e5\u4e1a\u52a1\u90e8\u95e8\u8ddf\u8fdb\u3002", (String)"SouBidBillCfmEdit_10", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            msgParams.put("failMsgContent", String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e3a\u53d1\u9001\u5931\u8d25\u4fe1\u606f\uff1a%1$s", (String)"SouBidBillCfmEdit_9", (String)"scm-sou-formplugin", (Object[])new Object[0]), content));
            msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_bidbill" + "&pkId=" + quoBidBillDO.getLong("id"));
            msgParams.put("toMob", "false");
            msgParams.put("hasBizDataId", "false");
            HashSet<Long> bizPartnerPkIds = new HashSet<Long>();
            bizPartnerPkIds.add(bizPartnerPkId);
            SouSendMessageUtil.sendMessage(bizPartnerPkIds, ids, msgParams);
        }
    }
}

