/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExchrateUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.cal.CalImpl;
import kd.scm.common.util.cal.CalImportImpl;
import kd.scm.common.util.cal.ICal;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.common.SouContactChangeUtil;
import kd.scm.sou.common.SouPermUtil;

public class SouBidBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BIDHALL = "bidhall";
    private static final String SUPAUDIT = "supaudit";
    private static final String BIDCASH = "bidcash";
    private static final String BIDSTART = "bidstart";
    private static final String COPY = "copy";
    private static final String BIDHALLACTIONID = "bidHallActionId";
    private static final String QUALIFYACTIONID = "qualifyActionId";
    private static final String RECDEPOSITACTIONID = "recdepositActionId";
    private static final String KEY_CHANGETAXTAPE = "key_changetaxtape";
    private static final String MYTRACKDOWN = "mytrackdown";
    private static final String BIDALERTDATE = "bidalertdate";
    private static ICal cal = new CalImpl();

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getControl("entrysupplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit unit = (BasedataEdit)this.getControl("unit");
        unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "org": {
                List permissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)this.getModel().getDataEntityType().getName());
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)permissionOrgs));
                break;
            }
            case "entrysupplier": {
                GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
                break;
            }
            case "material": {
                GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"sou");
                break;
            }
            case "unit": {
                int rowIdx = beforeF7SelectEvent.getRow();
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIdx);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"SouBidBillEditPlugin_24", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(material.getLong("baseunit_id"));
                QFilter qFilter = new QFilter("srcmuid", "in", ids);
                qFilter.or("desmuid", "in", ids);
                QFilter[] filters1 = new QFilter[]{qFilter};
                Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunitconv", (String)"srcmuid,desmuid,numerator, denominator, converttype", (QFilter[])filters1);
                result.forEach((key, info) -> {
                    ids.add(info.getLong("srcmuid_id"));
                    ids.add(info.getLong("desmuid_id"));
                });
                QFilter[] filters = new QFilter[]{new QFilter("materialid", "=", material.getPkValue())};
                String selectFields = "id,measureunitid.id";
                Map multimeasureunits = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)selectFields, (QFilter[])filters);
                multimeasureunits.forEach((key, info) -> ids.add(info.getLong("measureunitid.id")));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
                showParameter.setMultiSelect(false);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        this.resetStatus();
        this.resetTaxType();
    }

    public void afterLoadData(EventObject e) {
        this.getModel().setDataChanged(false);
        SouBidBillUtil.updateBidStatus();
        this.setExRateAndDate();
    }

    public void afterCreateNewData(EventObject eventobject) {
        this.getModel().setDataChanged(false);
        this.setBizPerson();
    }

    private void setExRateAndDate() {
        Date createTime;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            long bizOrg = org.getLong("id");
            DynamicObject exchtype = (DynamicObject)this.getModel().getValue("exchtype");
            if (null == exchtype) {
                Map map = ExchrateUtil.getCurrencyAndExRateTable((Long)bizOrg);
                if (map == null) {
                    return;
                }
                this.getModel().setValue("exchtype", map.get("exchangeRateTableID"));
            }
        }
        if ((createTime = (Date)this.getModel().getValue("createtime")) == null) {
            createTime = TimeServiceHelper.now();
        }
        this.getModel().setValue("ratedate", (Object)createTime);
    }

    private void setBizPerson() {
        QFilter statusFilter;
        QFilter enableFilter;
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("user", "=", (Object)currUserId);
        DynamicObjectCollection personDyns = QueryServiceHelper.query((String)"pur_bizperson", (String)"id,user,group,phone", (QFilter[])new QFilter[]{userFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")}, (String)"id");
        if (personDyns != null && !personDyns.isEmpty()) {
            this.getModel().setValue("person", (Object)((DynamicObject)personDyns.get(0)).getLong("id"));
            this.getModel().setValue("phone", ((DynamicObject)personDyns.get(0)).get("phone"));
        }
    }

    private void resetTaxType() {
        ComboEdit taxtypeControl = (ComboEdit)this.getView().getControl("taxtype");
        List<ComboItem> comboItems = this.getTaxTypeComboItems();
        taxtypeControl.setComboItems(comboItems);
    }

    private List<ComboItem> getTaxTypeComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem taxsExpriceIntax = this.createComboItem(TaxTypeEnum.TAXSEXPRICE_INTAX);
        ComboItem taxsExpriceExtax = this.createComboItem(TaxTypeEnum.TAXSEXPRICE_EXTAX);
        comboItems.add(taxsExpriceIntax);
        comboItems.add(taxsExpriceExtax);
        if (ApiConfigUtil.hasEASConfig()) {
            ComboItem taxsInpriceIntax = this.createComboItem(TaxTypeEnum.TAXSINPRICE_INTAX);
            comboItems.add(taxsInpriceIntax);
        }
        return comboItems;
    }

    private ComboItem createComboItem(TaxTypeEnum commondimension) {
        return new ComboItem(new LocaleString(commondimension.getName()), commondimension.getVal());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long pkId;
        DynamicObject query;
        super.beforeDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operate)) {
            if (null == this.getModel().getValue("creator")) {
                this.getModel().setValue("creator_id", (Object)RequestContext.get().getUserId());
            }
            if (null == this.getModel().getValue("createtime")) {
                this.getModel().setValue("createtime", (Object)new Date());
            }
        } else if (BIDHALL.equals(operate) && (query = QueryServiceHelper.queryOne((String)"sou_bidbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(pkId = ((Long)this.getModel().getValue("id")).longValue()))})) != null && !BillStatusEnum.AUDIT.getVal().equals(query.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u7684\u7ade\u4ef7\u53d1\u5e03\u5355\u624d\u80fd\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillEditPlugin_23", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (COPY.equals(operateKey)) {
            this.initializeData();
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "bidstart": 
                case "audit": {
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
                    break;
                }
                case "unaudit": {
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)"tab");
                    break;
                }
                case "bidalertdate": {
                    this.bidAlertDate();
                    break;
                }
                case "supaudit": {
                    this.supAudit();
                    break;
                }
                case "bidcash": {
                    this.recDeposit();
                    break;
                }
                case "bidhall": {
                    this.refreshModelAndView();
                    SouBidBillUtil.openBidHall((String)"sou_bidbill", (IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, BIDHALLACTIONID));
                    break;
                }
                case "mytrackdown": {
                    this.trackDown();
                    break;
                }
                case "copy": {
                    this.initializeData();
                    break;
                }
                case "save": {
                    this.getModel().updateCache();
                    this.getView().updateView("fs_otherinfo");
                    break;
                }
            }
        }
        switch (operateKey) {
            case "deleteentry": 
            case "insertentry": {
                cal.calSumQty(this.getModel(), "materialentry");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String opKey;
        super.itemClick(evt);
        switch (opKey = evt.getOperationKey()) {
            case "submit": {
                this.getModel().updateCache();
                this.getView().updateView("fs_otherinfo");
            }
        }
    }

    protected void bidAlertDate() {
        SouBidBillUtil.bidAlertDate((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "bidAlertDate"));
    }

    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        String bidStatus = inquiryObject.getString("bidstatus");
        return bidStatus == null ? "" : bidStatus.toLowerCase();
    }

    private void initializeData() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("supquoentry");
        dataModel.deleteEntryData("quoentry");
        dataModel.setValue("enrollnum", null);
        dataModel.setValue("bidnum", null);
        dataModel.setValue("bidamount", null);
        dataModel.setValue("bidprofit", null);
        dataModel.setValue("supplier", null);
        dataModel.setValue("pausetime", null);
        dataModel.setValue("bidrestoftime", null);
        dataModel.setValue("pausestarttime", null);
        dataModel.setValue("pauseamt", null);
        dataModel.setValue("audit", null);
        dataModel.setValue("terminate", null);
        dataModel.setValue("pushnotice", (Object)0);
        dataModel.setValue("pushresult", (Object)0);
        int rowCount = dataModel.getEntryRowCount("materialentry");
        for (int i = 0; i < rowCount; ++i) {
            dataModel.setValue("winprice", null, i);
            dataModel.setValue("wintaxprice", null, i);
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        if (properties.containsKey((Object)"businesstype")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"businesstype"});
        }
    }

    private void openDealPage(String pageKey, String actionId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("bidBillId", this.getModel().getDataEntity().getPkValue());
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)ShowType.Modal));
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
    }

    private void supAudit() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object bidStatus = model.getValue("bidstatus");
        Object checkType = model.getValue("checktype");
        DynamicObjectCollection col = model.getEntryEntity("supquoentry");
        if (checkType != null && "3".equals(checkType)) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8d44\u683c\u514d\u5ba1\uff0c\u65e0\u987b\u5ba1\u67e5\u3002", (String)"SouBidBillEditPlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if ("1".equals(checkType)) {
            this.getView().invokeOperation("refresh");
            bidStatus = model.getValue("bidstatus");
            if (!BidStatusEnum.DEADLINE.getVal().equals(bidStatus)) {
                view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u662f\u62a5\u540d\u622a\u6b62\u7684\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u8d44\u5ba1\u3002", (String)"SouBidBillEditPlugin_7", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
                return;
            }
        }
        if ("2".equals(checkType) && !BidStatusEnum.BIDDING.getVal().equals(bidStatus) && !BidStatusEnum.EVALUATING.getVal().equals(bidStatus)) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8d44\u683c\u540e\u5ba1\u53ea\u80fd\u5728\u7ade\u4ef7\u4e2d\u6216\u8bc4\u6807\u4e2d\u8fdb\u884c\u3002", (String)"SouBidBillEditPlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if (col.size() == 0) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u65e0\u4f9b\u5e94\u5546\u62a5\u540d\uff0c\u4e0d\u5141\u8bb8\u8d44\u5ba1\u3002", (String)"SouBidBillEditPlugin_9", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        int count = 0;
        for (DynamicObject bidBill : col) {
            String supentrystatus = bidBill.getString("supentrystatus");
            if (!SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus)) continue;
            ++count;
        }
        if (count == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u8d44\u5ba1\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u68c0\u67e5\u53c2\u4e0e\u4f9b\u5e94\u5546\u662f\u5426\u4e3a\u5f85\u8d44\u5ba1\u72b6\u6001\u3002", (String)"SouBidBillEditPlugin_21", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openDealPage("sou_qualify", QUALIFYACTIONID);
    }

    private void recDeposit() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection col = model.getDataEntity(true).getDynamicObjectCollection("supquoentry");
        if (col.size() == 0) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u5728\u4f9b\u5e94\u5546\u62a5\u540d\u4ee5\u540e\u518d\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillEditPlugin_10", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        Object bidStatus = model.getValue("bidstatus");
        if (!(bidStatus.equals(BidStatusEnum.ENROLMENT.getVal()) || bidStatus.equals(BidStatusEnum.DEADLINE.getVal()) || bidStatus.equals(BidStatusEnum.BEENEXAMINED.getVal()))) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u662f\u62a5\u540d\u4e2d\uff0c\u62a5\u540d\u622a\u6b62\u548c\u5df2\u8d44\u5ba1\u7684\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillEditPlugin_11", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        BigDecimal cashDeposit = CommonUtil.getBigDecimalPro((Object)model.getValue("cashdeposit"));
        if (cashDeposit.compareTo(BigDecimal.ZERO) == 0) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u4e3a\u96f6\uff0c\u65e0\u987b\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillEditPlugin_12", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        int count = 0;
        for (DynamicObject dyna : col) {
            String supentrystatus = dyna.getString("supentrystatus");
            if (!SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) continue;
            ++count;
        }
        if (count == 0) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u8d44\u5ba1\u901a\u8fc7\uff0c\u65e0\u6cd5\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillEditPlugin_14", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        this.openDealPage("sou_rcvdeposit", RECDEPOSITACTIONID);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs != null && rowIndexs.length > 0 && "materialentry".equals(entryName)) {
            IDataModel model = this.getModel();
            BigDecimal deleteAllAmount = BigDecimal.ZERO;
            for (int rownIndex : rowIndexs) {
                deleteAllAmount = deleteAllAmount.add((BigDecimal)model.getValue("taxamount", rownIndex));
            }
            BigDecimal totalAllAmount = (BigDecimal)model.getValue("sumtaxamount");
            totalAllAmount = totalAllAmount.subtract(deleteAllAmount);
            model.setValue("sumtaxamount", (Object)totalAllAmount);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        String codeChangeTaxType = this.getPageCache().get("codeChangeTaxType");
        for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = dataModel.getEntryCurrentRowIndex("materialentry");
            if (rowIndex >= 0 && currentRowIndex != rowIndex && "materialentry".equals(changeData.getDataEntity().getDataEntityType().getName())) {
                EntryGrid grid = (EntryGrid)this.getControl("materialentry");
                grid.selectRows(rowIndex, true);
            }
            Object value = dataModel.getValue(propertyName, rowIndex);
            cal.proChanged(dataModel, "materialentry", propertyName);
            block12 : switch (propertyName) {
                case "supcontacter": {
                    if (!(value instanceof DynamicObject)) break;
                    SouContactChangeUtil.ContactChange((IDataModel)dataModel, (DynamicObject)((DynamicObject)value));
                    break;
                }
                case "biztype": {
                    if (value == null || !"1".equals(value.toString())) break;
                    dataModel.deleteEntryData("supquoentry");
                    break;
                }
                case "unit": {
                    if (!(value instanceof DynamicObject)) break;
                    DynamicObject dyn = (DynamicObject)value;
                    if (changeData.getNewValue() == null) break;
                    int scale = dyn.getInt("precision");
                    BigDecimal qty = (BigDecimal)dataModel.getValue("qty");
                    qty = qty.setScale(scale, 4);
                    dataModel.setValue("qty", (Object)qty, rowIndex);
                    this.processBaseQty(dyn.getLong("id"), qty, rowIndex);
                    break;
                }
                case "qty": {
                    value = changeData.getNewValue();
                    Long unitId = (Long)dataModel.getValue("unit_id", rowIndex);
                    this.processBaseQty(unitId, (BigDecimal)value, rowIndex);
                    break;
                }
                case "taxtype": {
                    if ("1".equals(codeChangeTaxType)) {
                        this.getPageCache().put("codeChangeTaxType", "0");
                        break;
                    }
                    String oldValue = String.valueOf(changeData.getOldValue());
                    String newValue = String.valueOf(changeData.getNewValue());
                    this.getPageCache().put("taxTypeOldValue", oldValue);
                    if (StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue)) {
                        return;
                    }
                    DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("materialentry");
                    if (null == entryDyoCol || entryDyoCol.size() <= 0) break;
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_CHANGETAXTAPE, (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u8ba1\u7a0e\u7c7b\u578b\u4f1a\u6e05\u7a7a\u5f53\u524d\u5206\u5f55\u4ef7\u683c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouBidBillEditPlugin_15", (String)"scm-sou-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                case "material": {
                    if (!(value instanceof DynamicObject)) break;
                    MaterialUtil.materialChanged((IDataModel)dataModel, (String)propertyName, (DynamicObject)((DynamicObject)value), (String)"materialentry", (int)rowIndex);
                    BigDecimal qty = (BigDecimal)dataModel.getValue("qty");
                    Long unitId = (Long)dataModel.getValue("unit_id", rowIndex);
                    if (qty == null || unitId == 0L) break;
                    this.processBaseQty(unitId, qty, rowIndex);
                    break;
                }
                case "person": {
                    if (value instanceof DynamicObject) {
                        String number = ((DynamicObject)value).get("number").toString();
                        DynamicObject[] dynamicObjects = this.getPersonInfo(number);
                        dataModel.setValue("phone", dynamicObjects[0].get("user.phone"));
                    }
                    if (value != null) break;
                    dataModel.setValue("phone", null);
                    break;
                }
                case "reducepct": 
                case "reducetype": {
                    Object reducetype = dataModel.getValue("reducetype");
                    Object reducepct = dataModel.getValue("reducepct");
                    if (!"A".equals(reducetype)) break;
                    BigDecimal reducepct1 = (BigDecimal)reducepct;
                    BigDecimal b1 = BigDecimal.valueOf(100L);
                    if (reducepct1.compareTo(b1) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u964d\u4ef7\u65b9\u5f0f\u4e3a\u6309\u6bd4\u4f8b\u65f6\uff0c\u964d\u4ef7\u5e45\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"SouBidBillEditPlugin_16", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        dataModel.setValue("reducepct", (Object)BigDecimal.ZERO);
                        break;
                    }
                    if (reducepct1.compareTo(b1) != 0) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u964d\u4ef7\u65b9\u5f0f\u4e3a\u6309\u6bd4\u4f8b\u65f6\uff0c\u964d\u4ef7\u5e45\u5ea6\u4e0d\u80fd\u7b49\u4e8e100\u3002", (String)"SouBidBillEditPlugin_17", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    dataModel.setValue("reducepct", (Object)BigDecimal.ZERO);
                    break;
                }
                case "entrysupplier": {
                    DynamicObject newObject = this.getModel().getDataEntity(true);
                    DynamicObjectCollection col = newObject.getDynamicObjectCollection("supquoentry");
                    DynamicObject newObj = (DynamicObject)changeData.getNewValue();
                    if (null == newObj) {
                        return;
                    }
                    DynamicObject oldObj = null;
                    int count = 0;
                    if (col == null || col.size() <= 0) break;
                    for (DynamicObject supplier : col) {
                        oldObj = supplier.getDynamicObject("entrysupplier");
                        if (oldObj == null || !oldObj.getPkValue().equals(newObj.getPkValue()) || ++count != 2) continue;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6709\u76f8\u540c\u7684\u4f9b\u5e94\u5546\u5f55\u5165\u3002", (String)"SouBidBillEditPlugin_18", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                        this.getModel().setValue("entrysupplier", null, rowIndex);
                        this.getModel().beginInit();
                        this.getModel().endInit();
                        break block12;
                    }
                    break;
                }
            }
            dataModel.setValue("maxamount", dataModel.getValue("sumtaxamount"));
        }
    }

    private void processBaseQty(Long srcUnitId, BigDecimal qty, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("materialentry");
        DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"basicunit") && properties.containsKey((Object)"basicqty")) {
            Long materialId = (Long)model.getValue("material_id", rowIndex);
            Long baseId = (Long)model.getValue("basicunit_id", rowIndex);
            BigDecimal desmuCount = BaseDataServiceHelper.getDesmuCount((Long)materialId, (Long)srcUnitId, (BigDecimal)qty, (Long)baseId);
            this.getModel().setValue("basicqty", (Object)desmuCount, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)KEY_CHANGETAXTAPE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.clearEntryPrice();
            } else {
                this.getPageCache().put("codeChangeTaxType", "1");
                IDataModel model = this.getModel();
                model.setValue("taxtype", (Object)this.getPageCache().get("taxTypeOldValue"));
                this.getView().updateView("taxtype");
            }
        }
        if (StringUtils.equals((CharSequence)QUALIFYACTIONID, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.getView().updateView();
        }
    }

    private void clearEntryPrice() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set("sumtaxamount", (Object)BigDecimal.ZERO);
        DynamicObjectCollection dyoCol = (DynamicObjectCollection)dataEntity.get("materialentry");
        dyoCol.forEach(dyo -> {
            dyo.set("price", (Object)BigDecimal.ZERO);
            dyo.set("taxprice", (Object)BigDecimal.ZERO);
            dyo.set("amount", (Object)BigDecimal.ZERO);
            dyo.set("dctamount", (Object)BigDecimal.ZERO);
            dyo.set("tax", (Object)BigDecimal.ZERO);
            dyo.set("taxamount", (Object)BigDecimal.ZERO);
        });
        this.getView().updateView();
    }

    private DynamicObject[] getPersonInfo(String number) {
        String selectFields = "user.phone";
        HashMap paramMap = new HashMap(1);
        HashMap<String, String> poBillIdMap = new HashMap<String, String>(1);
        poBillIdMap.put("in", number);
        paramMap.put("number", poBillIdMap);
        return ORMUtil.load((String)"pur_bizperson", (String)selectFields, paramMap);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IFormView view = this.getView();
        String actionId = closedCallBackEvent.getActionId();
        BillModel model = (BillModel)this.getModel();
        model.load(model.getPKValue());
        switch (actionId) {
            case "bidHallActionId": {
                view.updateView("bidstatus");
                view.updateView("bidamount");
                view.updateView("bidnum");
                view.updateView("bidprofit");
                view.updateView("supplier");
                view.updateView("pausetime");
                view.updateView("bidrestoftime");
                view.updateView("pausestarttime");
                view.updateView("pauseamt");
                view.updateView("audit");
                view.updateView("terminate");
                break;
            }
            case "recdepositActionId": {
                view.updateView("supquoentry");
                break;
            }
            case "qualifyActionId": {
                view.updateView("supquoentry");
                view.updateView("bidstatus");
                BillFormUtil.activeTab((IFormView)view, (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
                break;
            }
        }
        this.getView().invokeOperation("refresh");
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
        model.setDataChanged(false);
    }

    private void resetStatus() {
        DynamicObject tempObj = this.getModel().getDataEntity();
        if (tempObj == null) {
            return;
        }
        String bidStatus = tempObj.getString("bidstatus");
        if (bidStatus == null) {
            BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)"tab");
            return;
        }
        if (bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
            this.getView().getControl("status_tabap").getView().setVisible(Boolean.FALSE, new String[]{"gtab"});
            this.getView().getControl("status_tabap").getView().setVisible(Boolean.FALSE, new String[]{"htab"});
        }
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(bidStatus.toLowerCase() + "tab"));
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        Tab statusTab = (Tab)this.getView().getControl("status_tabap");
        if (statusTab != null) {
            statusTab.activeTab("null");
        }
        this.initializeData();
    }

    private void trackDown() {
        DynamicObject query;
        long pkId = (Long)this.getModel().getValue("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbill", (String)"sou_bidbillcfm")) {
            noPermBill.add("sou_bidbillcfm");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u7ade\u4ef7\u5b9a\u6807\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillEditPlugin_20", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbill", (String)"sou_notice")) {
            noPermBill.add("sou_notice");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u516c\u544a\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillEditPlugin_19", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if ((query = QueryServiceHelper.queryOne((String)"sou_bidbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)})) != null && !BillStatusEnum.AUDIT.getVal().equals(query.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ade\u4ef7\u9879\u76ee\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u4e0b\u6e38\u73af\u8282\u3002", (String)"SouBidBillEditPlugin_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        Map<String, HashSet<Long>> result = this.getTrackDownBill(pkValue);
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackDownBill(long pk) {
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>();
        HashSet<Long> bidBillCfmSet = new HashSet<Long>();
        bidBillCfmSet.add(pk);
        resultMap.put("sou_bidbillcfm", bidBillCfmSet);
        Map noticeResult = BFTrackerServiceHelper.findTargetBills((String)"sou_bidbill", (Long[])new Long[]{pk});
        if (noticeResult != null && !noticeResult.isEmpty()) {
            resultMap.put("sou_notice", (HashSet<Long>)noticeResult.get("sou_notice"));
        }
        return resultMap;
    }

    private void refreshModelAndView() {
        BillModel model = (BillModel)this.getModel();
        IFormView view = this.getView();
        model.load(model.getPKValue());
        view.updateView("bidstatus");
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"materialentry")) {
            CalImportImpl calImport = new CalImportImpl();
            DynamicObjectCollection billentrys = (DynamicObjectCollection)this.getModel().getValue("materialentry");
            for (int i = 0; i < billentrys.size(); ++i) {
                DynamicObject unitDyn = ((DynamicObject)billentrys.get(i)).getDynamicObject("unit");
                if (unitDyn == null && null != this.getModel().getDataEntity().getDynamicObject("org") && null != ((DynamicObject)billentrys.get(i)).getDynamicObject("material")) {
                    MaterialUtil.materialChanged((IDataModel)this.getModel(), (String)"unit", (DynamicObject)((DynamicObject)billentrys.get(i)).getDynamicObject("material"), (String)"unit", (int)i);
                }
                this.getModel().setEntryCurrentRowIndex("materialentry", i);
                calImport.calByEntryQtyChange(this.getModel(), "materialentry");
                if ("2".equals(this.getModel().getValue("taxtype"))) {
                    calImport.calByEntryPriceChange(this.getModel(), "materialentry");
                    continue;
                }
                calImport.calByEntryTaxPriceChange(this.getModel(), "materialentry");
            }
            calImport.calSumAtLast(this.getModel(), "materialentry");
        }
    }
}

