/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.PriceProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExchangeCurrUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.sou.common.SouCommonUtil;
import kd.scm.sou.common.SouCompareBillUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.formplugin.SouCompareAssistantBatchPlugin;
import kd.scm.sou.formplugin.edit.SouCoreBillEditPlugin;
import kd.scm.sou.formplugin.ext.AdoptionHelper;
import kd.scm.sou.formplugin.ext.AdoptionModel;
import kd.scm.sou.formplugin.ext.imp.DefaultSouComparePushNoticeVerify;
import kd.sdk.scm.sou.extpoint.ISouComparePushNoticeVerify;

public class SouCompareBillEdit
extends SouCoreBillEditPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(SouCompareBillEdit.class);
    private static final String CONFIRMCALLBACK = "CONFIRMCALLBACK";
    private static final String ACTION_BOTPLIST = "botpList";

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("taxamount".equals(fieldKey)) {
            this.setQuoEntry();
        }
        if ("supplier".equals(fieldKey)) {
            MultCurrencyCalImpl currCal = new MultCurrencyCalImpl();
            ChangeData[] changedData = e.getChangeSet();
            int rowIndex = changedData[0].getRowIndex();
            DynamicObject newValue = (DynamicObject)changedData[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)changedData[0].getOldValue();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("materialentry");
            if (rowIndex >= 0 && currentRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl("materialentry");
                grid.selectRows(rowIndex, true);
            }
            if (!(newValue == null || oldValue != null && StringUtils.equals((CharSequence)oldValue.getPkValue().toString(), (CharSequence)newValue.getPkValue().toString()))) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("materialentry", rowIndex);
                DynamicObject material = rowEntity.getDynamicObject("material");
                String srcentry = rowEntity.getString("srcentryid");
                Long srcentryId = null;
                try {
                    srcentryId = Long.valueOf(srcentry);
                }
                catch (NumberFormatException e1) {
                    log.error("SouCompareBillEdit NumberFormatException : " + e1);
                }
                String quoBillNo = this.getPageCache().get(newValue.getString("id"));
                Long org = this.getModel().getDataEntity().getLong("org_id");
                if (material != null && StringUtils.isNotBlank((CharSequence)quoBillNo) && srcentryId != null) {
                    DynamicObjectCollection result;
                    DynamicObject quoRow = QueryServiceHelper.queryOne((String)"sou_quote", (String)"id,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "=", (Object)srcentryId)});
                    String quoSrcEntryId = "";
                    if (quoRow != null) {
                        quoSrcEntryId = quoRow.getString("materialentry.srcentryid");
                    }
                    if (null != (result = this.getQuoInfoCol(quoBillNo, newValue.getString("id"), material.getString("id"), quoSrcEntryId)) && !result.isEmpty()) {
                        this.getModel().setValue("quotecurr", ((DynamicObject)result.get(0)).get("materialentry.quotecurr.id"), rowIndex);
                        this.getModel().beginInit();
                        this.getModel().setValue("srcbillid", ((DynamicObject)result.get(0)).get("id"), rowIndex);
                        this.getModel().setValue("srcentryid", ((DynamicObject)result.get(0)).get("materialentry.id"), rowIndex);
                        this.getModel().setValue("entrydelidat", ((DynamicObject)result.get(0)).get("materialentry.delidate"), rowIndex);
                        this.getModel().setValue("entrydeliaddr", ((DynamicObject)result.get(0)).get("materialentry.deliaddr"), rowIndex);
                        this.changeEntryQuoteInfo(currCal, result, rowIndex);
                        this.setQuoEntry();
                        this.getModel().endInit();
                    }
                    this.changeLastPriceInfo(rowIndex, newValue.getLong("id"), rowEntity, material, org);
                    this.getView().updateView("materialentry", rowIndex);
                }
            }
        } else if ("qty".equals(fieldKey)) {
            ChangeData[] changedData = e.getChangeSet();
            int rowIndex = changedData[0].getRowIndex();
            Object value = changedData[0].getNewValue();
            Long unitId = (Long)this.getModel().getValue("unit_id", rowIndex);
            this.processBaseQty(unitId, (BigDecimal)value, rowIndex);
        }
    }

    private void changeLastPriceInfo(int rowIndex, Long newValue, DynamicObject rowEntity, DynamicObject material, Long org) {
        long materialId = material.getLong("id");
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and(new QFilter("materialentry.material", "=", (Object)materialId));
        filter.and(new QFilter("materialentry.supplier", "=", (Object)newValue));
        filter.and("materialentry.exrate", ">", (Object)0);
        filter.and("billstatus", "=", (Object)"C");
        Date date = TimeServiceHelper.now();
        filter.and("billdate", "<=", (Object)date);
        filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)24));
        DynamicObjectCollection comparebills = QueryServiceHelper.query((String)"sou_compare", (String)"id,org,billdate, materialentry.taxprice taxprice, materialentry.supplier supplier, materialentry.quotecurr quotecurr, materialentry.material material", (QFilter[])filter.toArray(), (String)"billdate desc, materialentry.taxprice");
        if (comparebills != null && comparebills.size() > 0) {
            HashMap cacheRateMap = new HashMap();
            long quotecurr = rowEntity.getLong("quotecurr_id");
            DynamicObject comparebill = (DynamicObject)comparebills.get(0);
            long lastcurr = comparebill.getLong("quotecurr");
            BigDecimal lastPrice = comparebill.getBigDecimal("taxprice");
            lastPrice = ExchangeCurrUtil.exchangeTaxprice((long)lastcurr, (long)quotecurr, (long)this.getModel().getDataEntity().getLong("exchtype_id"), (BigDecimal)lastPrice, cacheRateMap);
            this.getModel().setValue("lastwinprice", (Object)lastPrice, rowIndex);
            this.getModel().setValue("lastwinbillid", (Object)comparebill.getString("id"), rowIndex);
        }
    }

    private void processBaseQty(Long srcUnitId, BigDecimal qty, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("materialentry");
        DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"basicunit") && properties.containsKey((Object)"basicqty")) {
            Long materialId = (Long)model.getValue("material_id", rowIndex);
            Long baseId = (Long)model.getValue("basicunit_id", rowIndex);
            BigDecimal desmuCount = BaseDataServiceHelper.getDesmuCount((Long)materialId, (Long)srcUnitId, (BigDecimal)qty, (Long)baseId);
            this.getModel().setValue("basicqty", (Object)desmuCount, rowIndex);
        }
    }

    protected void changeEntryQuoteInfo(MultCurrencyCalImpl currCal, DynamicObjectCollection result, int rowIndex) {
        if (result != null && result.size() > 0) {
            Object price = ((DynamicObject)result.get(0)).get("materialentry.price");
            Object taxprice = ((DynamicObject)result.get(0)).get("materialentry.taxprice");
            Object exRate = ((DynamicObject)result.get(0)).get("materialentry.exrate");
            Object entryquotation = ((DynamicObject)result.get(0)).get("materialentry.entryquotation");
            this.getModel().setValue("exrate", exRate, rowIndex);
            this.getModel().setValue("taxrateid", ((DynamicObject)result.get(0)).get("materialentry.taxrateid.id"), rowIndex);
            this.getModel().setValue("taxrate", ((DynamicObject)result.get(0)).get("materialentry.taxrate"), rowIndex);
            this.getModel().setValue("price", price, rowIndex);
            this.getModel().setValue("taxprice", taxprice, rowIndex);
            Object currObj = this.getModel().getValue("curr");
            String taxtype = (String)this.getModel().getValue("taxtype");
            if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxtype) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxtype)) {
                currCal.proChanged(this.getModel(), "materialentry", "taxprice");
            } else {
                currCal.proChanged(this.getModel(), "materialentry", "price");
            }
            if (null != currObj && price != null && taxprice != null) {
                DynamicObject curr = (DynamicObject)currObj;
                BigDecimal exRate1 = exRate == null ? BigDecimal.ZERO : (BigDecimal)exRate;
                int scaleNumCurr = curr.getInt("priceprecision");
                if (entryquotation != null && entryquotation.equals("1")) {
                    this.getModel().setValue("excludeunittax", (Object)((BigDecimal)price).divide(exRate1, scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
                    this.getModel().setValue("includeunittax", (Object)((BigDecimal)taxprice).divide(exRate1, scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
                } else {
                    this.getModel().setValue("excludeunittax", (Object)((BigDecimal)price).multiply(exRate1).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
                    this.getModel().setValue("includeunittax", (Object)((BigDecimal)taxprice).multiply(exRate1).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
                }
            }
        }
    }

    private DynamicObjectCollection getQuoInfoCol(String billNo, String supplierId, String materialId, String srcEntryId) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo).and("supplier", "=", (Object)Long.valueOf(supplierId)).and("materialentry.material", "=", (Object)Long.valueOf(materialId)).and(new QFilter("materialentry.entrystatus", "=", (Object)BillEntryStatusEnum.COMMON.getVal()));
        if (StringUtils.isNotBlank((CharSequence)srcEntryId)) {
            filter.and("materialentry.srcentryid", "=", (Object)srcEntryId);
        }
        return QueryServiceHelper.query((String)"quo_quote", (String)"id,materialentry.id,materialentry.quotecurr.id,materialentry.price,materialentry.taxprice,materialentry.amount,materialentry.taxrateid.id,materialentry.exrate,materialentry.tax,materialentry.taxamount,materialentry.taxrate,materialentry.delidate,materialentry.deliaddr,materialentry.entryquotation", (QFilter[])new QFilter[]{filter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "comparetool": {
                this.billToComapreTool();
                break;
            }
            case "push1": {
                IDataModel model = this.getModel();
                Object inquiryNo = model.getValue("inquiryno");
                String billno = inquiryNo.toString();
                DefaultSouComparePushNoticeVerify plugin = new DefaultSouComparePushNoticeVerify();
                PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouComparePushNoticeVerify.class, (String)"SCM_SOU_COMPARE_PUSHNOTICE", null);
                List messages = pluginProxy.callReplaceIfPresent(p -> p.validatePushNotice(billno));
                String message = messages.size() >= 1 ? (String)messages.get(messages.size() - 1) : "";
                if (message.isEmpty()) {
                    return;
                }
                this.getView().showMessage(message);
                e.setCancel(true);
                break;
            }
            case "toeasorder": 
            case "tocontract": 
            case "updateappr": 
            case "updateSupp": {
                if (!this.isInquiryEnd(String.valueOf(this.getModel().getValue("inquiryno")))) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u7ecf\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"SouCompareBillEdit_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        List<Integer> indexOfQzgys;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (this.itemKeySetForQZGYS().contains(itemKey) && !(indexOfQzgys = this.indexOfQzgys()).isEmpty()) {
            this.getView().showErrorNotification(this.getModel().getValue("billno") + ":" + MessageFormat.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u5f55\u7b2c{0}\u884c\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u8ba4\u8bc1\u4e3a\u6b63\u5f0f\u4f9b\u5e94\u5546\u624d\u80fd\u5173\u8054\u4e0b\u6e38\u5355\u636e\u3002", (String)"SouCompareBillEdit_2", (String)"scm-sou-formplugin", (Object[])new Object[0]), CommonUtil.integerList2str(indexOfQzgys)));
            evt.setCancel(true);
            return;
        }
        if ("bar_submit".equals(itemKey) && "submit".equals(evt.getOperationKey()) && !(indexOfQzgys = this.indexOfQzgys()).isEmpty()) {
            this.getView().showConfirm(this.getModel().getValue("billno") + ":" + MessageFormat.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u5f55\u7b2c{0}\u884c\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u4e0d\u662f\u6b63\u5f0f\u4f9b\u5e94\u5546\uff0c\u540e\u7eed\u65e0\u6cd5\u4e0b\u63a8\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"SouCompareBillEdit_3", (String)"scm-sou-formplugin", (Object[])new Object[0]), CommonUtil.integerList2str(indexOfQzgys)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK));
            evt.setCancel(true);
            return;
        }
    }

    public Set<String> itemKeySetForQZGYS() {
        HashSet<String> itemKeySet = new HashSet<String>();
        itemKeySet.add("bar_pusheas");
        itemKeySet.add("baritemap");
        itemKeySet.add("toorder");
        itemKeySet.add("tocontract");
        itemKeySet.add("updateappr");
        itemKeySet.add("updatesupp");
        return itemKeySet;
    }

    public boolean hasQZGYS() {
        DynamicObjectCollection materialentryCol = this.getModel().getEntryEntity("quoentry");
        for (DynamicObject materialDyn : materialentryCol) {
            if (!materialDyn.getBoolean("isadopt") || !"QZGYS".equals(materialDyn.getString("entrysupplier.supplier_status.number"))) continue;
            return true;
        }
        return false;
    }

    private List<Integer> indexOfQzgys() {
        DynamicObjectCollection materialentryCol = this.getModel().getEntryEntity("materialentry");
        ArrayList<Integer> indexs = new ArrayList<Integer>(materialentryCol.size());
        for (DynamicObject row : materialentryCol) {
            if (!"QZGYS".equals(row.getString("supplier.supplier_status.number"))) continue;
            indexs.add(row.getInt("seq"));
        }
        return indexs;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operate = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operate) {
                case "mytrackup": {
                    this.trackUp();
                    break;
                }
                case "toeasorder": {
                    this.toOrder(operate);
                    break;
                }
                case "traceorder": {
                    Object pkId = this.getModel().getValue("id");
                    Object[] objects = new Object[]{pkId};
                    SouCommonUtil.traceDowOrder((Object[])objects, (IFormView)this.getView());
                    break;
                }
                case "adopttaxprice": 
                case "adoptprice": 
                case "adoptamount": 
                case "adopttaxamount": {
                    Map<String, Map<String, Object>> quoParams = AdoptionHelper.getQuoteDefaultParam((String)this.getModel().getValue("inquiryno"));
                    String orderBys = "materialentry.srcentryid asc";
                    AdoptionModel adoptionModel = new AdoptionModel("sou_comparetool");
                    SouCompareAssistantBatchPlugin instance = (SouCompareAssistantBatchPlugin)((Object)TypesContainer.createInstance(SouCompareAssistantBatchPlugin.class));
                    instance.setAdoptionModel(adoptionModel);
                    adoptionModel.initDataSource("sou_quote", quoParams, orderBys, instance.getQuoteInfoBlackMap(), operate);
                    DynamicObject inquiry = AdoptionHelper.getInquiryObjByBillNo((String)this.getModel().getValue("inquiryno"), null, null, instance, "");
                    adoptionModel.adoptByRule(inquiry, adoptionModel.getRule().getRule(operate), null);
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    dataEntity.getDynamicObjectCollection("quoentry").clear();
                    dataEntity.getDynamicObjectCollection("materialentry").clear();
                    Object[] objs = adoptionModel.toTargetBill((String)this.getModel().getValue("inquiryno"), this.getModel().getDataEntity(true), instance);
                    if (objs.length <= 0) break;
                    BusinessDataServiceHelper.loadRefence((Object[])objs, (IDataEntityType)this.getModel().getDataEntity(true).getDynamicObjectType());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                    this.getView().updateView();
                    break;
                }
                case "quotedetail": {
                    FormShowParameter formParamter = this.getView().getFormShowParameter();
                    Map customerParam = formParamter.getCustomParams();
                    String inquiryno = this.getModel().getDataEntity(true).getString("inquiryno");
                    long id = this.getModel().getDataEntity(true).getLong("id");
                    customerParam.put("billId", id);
                    customerParam.put("inquiryno", inquiryno);
                    FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"sou_quoteinfo_detail", (Map)customerParam, null, (ShowType)ShowType.Modal);
                    this.getView().showForm(param);
                    break;
                }
            }
        }
        if (operate.equals("mytrackup") || operate.equals("toeasorder") || operate.equals("traceorder") || operate.equals("adopttaxprice") || operate.equals("adoptprice") || operate.equals("adoptamount") || operate.equals("adopttaxamount") || operate.equals("quotedetail") || operate.equals("trackup") || operate.equals("trackdown") || operate.equals("audit") || operate.equals("unaudit") || operate.equals("unsubmit") || operate.equals("audit") || operate.equals("submit") || operate.equals("save")) {
            this.getView().updateView();
        }
    }

    private void trackUp() {
        long pkId = (Long)this.getModel().getValue("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_compare", (String)"sou_quote")) {
            noPermBill.add("sou_quote");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u62a5\u4ef7\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouCompareBillEdit_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_compare", (String)"sou_inquiry")) {
            noPermBill.add("sou_inquiry");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8be2\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouCompareBillEdit_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Map<String, HashSet<Long>> result = this.getTrackUpBill();
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackUpBill() {
        DynamicObjectCollection inqueryDyoCol;
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>();
        String inqueryBillNo = (String)this.getModel().getValue("inquiryno");
        DynamicObjectCollection quoteDyoCol = QueryServiceHelper.query((String)"sou_quote", (String)"id,inquiryno", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)inqueryBillNo)});
        if (null != quoteDyoCol && quoteDyoCol.size() > 0) {
            List inqueryIdList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)quoteDyoCol, (String)"id");
            resultMap.put("sou_quote", new HashSet(inqueryIdList));
        }
        if (null != (inqueryDyoCol = QueryServiceHelper.query((String)"sou_inquiry", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inqueryBillNo)})) && inqueryDyoCol.size() > 0) {
            List compareIdList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)inqueryDyoCol, (String)"id");
            resultMap.put("sou_inquiry", new HashSet(compareIdList));
        }
        return resultMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid headGrid = (EntryGrid)this.getView().getControl("quoentry");
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid materialentry = (EntryGrid)this.getControl("materialentry");
        materialentry.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        EntryGrid grid = (EntryGrid)e.getSource();
        String gridKey = grid.getKey();
        Object val = null;
        int index = e.getRowIndex();
        String entityKey = null;
        String property = e.getFieldName();
        if ("quoentry".equals(gridKey)) {
            val = grid.getModel().getValue(property);
            Long idValue = (Long)grid.getModel().getValue("quotebillid");
            if ("quobillno".equals(property)) {
                entityKey = "sou_quote";
            }
            if (idValue != null && idValue.compareTo(0L) > 0) {
                SouCompareBillUtil.showBillForm((Object)val, (String)entityKey, (Object)idValue, (IFormView)this.getView());
            } else {
                this.showBillForm(val, entityKey);
            }
        }
        if ("materialentry".equals(gridKey)) {
            String lastwinbillid;
            if ("lastcompareprice".equals(property)) {
                String lastCompareId = (String)this.getModel().getValue("lastcompareid", index);
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"sou_compare", (Object)lastCompareId, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
            } else if ("lastwinprice".equals(property) && (lastwinbillid = (String)this.getModel().getValue("lastwinbillid", index)) != null && !StringUtils.isEmpty((CharSequence)lastwinbillid)) {
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"sou_compare", (Object)lastwinbillid, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
            }
        }
    }

    public void showBillForm(Object val, String entityKey) {
        SouCompareBillUtil.showBillForm((Object)val, (String)entityKey, null, (IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "supplier": {
                int row = e.getRow();
                Object srcentryid = this.getModel().getValue("srcentryid", row);
                IDataModel model = this.getModel();
                List suplist = null;
                try {
                    String result = this.getPageCache().get(String.valueOf(srcentryid));
                    suplist = StringUtils.isNotBlank((CharSequence)result) ? (List)JacksonJsonUtil.fromJSON((String)result, List.class) : this.queryQuoteSupInfos(srcentryid);
                }
                catch (IOException ex) {
                    log.error("JacksonJson Exception!", (Throwable)ex);
                }
                DynamicObjectCollection quoentrs = model.getEntryEntity("quoentry");
                if (quoentrs == null || suplist == null || suplist.size() <= 0) break;
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)suplist));
                break;
            }
        }
    }

    protected List<Object> queryQuoteSupInfos(Object srcentryId) {
        ArrayList<Object> supplierIds = new ArrayList<Object>(8);
        if (srcentryId != null && !StringUtils.isEmpty((CharSequence)srcentryId.toString()) && !"0".equals(srcentryId)) {
            DynamicObject info = QueryServiceHelper.queryOne((String)"sou_quote", (String)"id,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "=", (Object)Long.parseLong(srcentryId.toString()))});
            if (info != null) {
                DynamicObjectCollection infos = QueryServiceHelper.query((String)"sou_quote", (String)"id,supplier.id", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "=", (Object)info.getString("materialentry.srcentryid")).and("materialentry.entrystatus", "=", (Object)"A").and("materialentry.taxprice", ">", (Object)0)});
                for (DynamicObject obj : infos) {
                    supplierIds.add(obj.getLong("supplier.id"));
                }
            }
            this.getPageCache().put(String.valueOf(srcentryId), JacksonJsonUtil.toJSON(supplierIds));
        }
        return supplierIds;
    }

    private void billToComapreTool() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object value = this.getModel().getValue("id");
        paramMap.put("bidBillId", value);
        FormShowParameter formShowParameter = BillFormUtil.assembleShowDynamicFormParam((String)"sou_comparetool", paramMap, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    private void toOrder(String itemKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Map resultMap = SouCompareBillUtil.verifyEASOrder((DynamicObject[])new DynamicObject[]{dataEntity});
        if ("true".equals(resultMap.get("succed"))) {
            if ("".equals(resultMap.get("botp"))) {
                IFormView view = this.getView();
                BillModel model = (BillModel)this.getModel();
                DynamicObject obj = model.getDataEntity(true);
                Map resultMsgMap = SouCompareBillUtil.toMultOrder((DynamicObject[])new DynamicObject[]{obj}, null);
                if (null != resultMsgMap.get("title") && null != resultMsgMap.get("message")) {
                    view.showMessage(resultMsgMap.get("title").toString(), resultMsgMap.get("message").toString(), MessageTypes.Default);
                } else {
                    view.showMessage(ResManager.loadKDString((String)"\u5355\u636e\u751f\u6210\u5931\u8d25", (String)"SouCompareBillEdit_8", (String)"scm-sou-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u6570\u636e", (String)"SouCompareBillEdit_9", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                }
                model.load(model.getPKValue());
                view.updateView("materialentry");
            } else {
                this.openBotpListPage(CommonUtil.objs2str((Object[])new Object[]{dataEntity.getPkValue()}), (List)resultMap.get("botp"), "order");
            }
        }
        if ("false".equals(resultMap.get("succed"))) {
            this.getView().showMessage(resultMap.get("title").toString(), resultMap.get("message").toString(), MessageTypes.Default);
            return;
        }
    }

    protected boolean isInquiryEnd(String inquiryNo) {
        if (StringUtils.isNotBlank((CharSequence)inquiryNo)) {
            QFilter qFilter = new QFilter("billno", "=", (Object)inquiryNo);
            qFilter.and("bizstatus", "=", (Object)BizStatusEnum.END.getVal());
            DynamicObject obj = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{qFilter});
            return obj != null;
        }
        return false;
    }

    private void openBotpListPage(String pkStr, List<Object> ruleList, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleList);
        param.put("tobilltype", toBillType);
        param.put("pkstr", pkStr);
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
        this.getView().showForm(formParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "botpList": {
                Object botpList_condition = closedCallBackEvent.getReturnData();
                if (botpList_condition == null) {
                    return;
                }
                IFormView view = this.getView();
                BillModel model = (BillModel)this.getModel();
                DynamicObject obj = model.getDataEntity(true);
                Map result = (Map)botpList_condition;
                Object ruleNumber = result.get("rule");
                if (ruleNumber == null) {
                    return;
                }
                Map resultMap = SouCompareBillUtil.toMultOrder((DynamicObject[])new DynamicObject[]{obj}, (String)String.valueOf(ruleNumber));
                view.showMessage(resultMap.get("title").toString(), resultMap.get("message").toString(), MessageTypes.Default);
                model.load(model.getPKValue());
                view.updateView("materialentry");
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        this.getModel().setDataChanged(false);
    }

    private Map<Object, Object> getSrcEntryidMap(DynamicObjectCollection entrs, DynamicObjectCollection quocols) {
        HashMap<Object, Object> srcentryidmap = new HashMap<Object, Object>();
        for (DynamicObject obj : entrs) {
            String comsrcid = obj.getString("srcentryid");
            for (DynamicObject quoobj : quocols) {
                if (!quoobj.get("entryid").toString().equals(comsrcid)) continue;
                srcentryidmap.put(comsrcid, quoobj.get("materialentry.srcentryid"));
            }
        }
        return srcentryidmap;
    }

    private Map<Object, Object> getSupMap(DynamicObjectCollection quocols) {
        HashMap<Object, Object> supmap = new HashMap<Object, Object>();
        HashMap<Object, Object> billnomap = new HashMap<Object, Object>();
        HashSet<Object> quosupidset = new HashSet<Object>();
        EntryGrid inquiryGrid = (EntryGrid)this.getView().getControl("materialentry");
        List<String> supQuoNumColumn = this.getSupQuoNumColumn();
        int index = 0;
        String simpleName = "";
        String supPrice = null;
        ArrayList<String> colums = new ArrayList<String>(8);
        for (DynamicObject supobj : quocols) {
            Object supid = supobj.get("supplier.id");
            String billno = supobj.getString("billno");
            if (supid == null || !quosupidset.add(supid)) continue;
            if (index < supQuoNumColumn.size()) {
                supPrice = supQuoNumColumn.get(index);
                FieldEdit fieldEditControl = (FieldEdit)this.getControl(supPrice);
                if (null == fieldEditControl) continue;
                simpleName = supobj.getString("supplier.name");
                fieldEditControl.setCaption(new LocaleString(simpleName));
                supmap.put(supid, supPrice);
                billnomap.put(supid, billno);
                if (simpleName != null && !simpleName.trim().isEmpty()) {
                    fieldEditControl.setCaption(new LocaleString(simpleName));
                    inquiryGrid.setColumnProperty(supPrice, "text-align", (Object)"left");
                    this.getView().setVisible(Boolean.TRUE, new String[]{supPrice});
                    colums.add(supPrice);
                }
            }
            ++index;
        }
        this.fixQuoBillno(billnomap);
        if (colums.size() < supQuoNumColumn.size()) {
            supQuoNumColumn.removeAll(colums);
            for (String s : supQuoNumColumn) {
                this.getView().setVisible(Boolean.FALSE, new String[]{s});
            }
        }
        return supmap;
    }

    private void setEntrySupName() {
        IDataModel model = this.getModel();
        Object inquiryNo = model.getValue("inquiryno");
        DynamicObjectCollection entrs = model.getEntryEntity("materialentry");
        DynamicObjectCollection quoteCollections = QueryServiceHelper.query((String)"quo_quote", (String)"id,materialentry.id entryid,materialentry.srcentryid,billno,supplier.id,materialentry.inquiryqty,supplier.name,materialentry.taxprice,materialentry.material,materialentry.quotecurr.priceprecision,materialentry.exrate,materialentry.entryquotation", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", inquiryNo).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("materialentry.entrystatus", "=", (Object)"A"))});
        Map<Object, Object> supmap = this.getSupMap(quoteCollections);
        Map<Object, Object> srcidmap = this.getSrcEntryidMap(entrs, quoteCollections);
        int i = 0;
        Object supPriceSb = null;
        if (entrs.size() > 0) {
            for (DynamicObject obj : entrs) {
                Object comsrcentryid = obj.get("srcentryid");
                Object quosrcid = srcidmap.get(comsrcentryid);
                ArrayList<Object> supIds = new ArrayList<Object>();
                if (quoteCollections.size() > 0) {
                    for (DynamicObject quoobj : quoteCollections) {
                        Object supid = quoobj.get("supplier.id");
                        Object srcentryid = quoobj.get("materialentry.srcentryid");
                        int scale = quoobj.getInt("materialentry.quotecurr.priceprecision");
                        BigDecimal taxprice = quoobj.getBigDecimal("materialentry.taxprice");
                        String entryquotation = quoobj.getString("materialentry.entryquotation");
                        if (srcentryid == null || !srcentryid.equals(quosrcid)) continue;
                        supPriceSb = supmap.get(supid);
                        if (supPriceSb != null) {
                            if (entryquotation != null && entryquotation.equals("1")) {
                                this.getModel().setValue(String.valueOf(supPriceSb), (Object)(taxprice == null ? BigDecimal.ZERO : taxprice.divide(quoobj.getBigDecimal("materialentry.exrate"), scale, RoundingMode.HALF_UP)), i);
                            } else {
                                this.getModel().setValue(String.valueOf(supPriceSb), (Object)(taxprice == null ? BigDecimal.ZERO : taxprice.setScale(scale, 4).multiply(quoobj.getBigDecimal("materialentry.exrate"))), i);
                            }
                        }
                        if (taxprice == null || taxprice.compareTo(BigDecimal.ZERO) <= 0) continue;
                        supIds.add(supid);
                    }
                    this.getPageCache().put(String.valueOf(comsrcentryid), JacksonJsonUtil.toJSON(supIds));
                }
                ++i;
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void setQuoEntry() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrs = model.getEntryEntity("materialentry");
        DynamicObjectCollection quoentrs = model.getEntryEntity("quoentry");
        SouCompareBillUtil.setAdoptInfo((DynamicObjectCollection)entrs, (DynamicObjectCollection)quoentrs);
        if (quoentrs != null) {
            this.getView().updateView("quoentry");
            this.getModel().setDataChanged(false);
        }
    }

    private void fixQuoBillno(Map<Object, Object> billnomap) {
        DynamicObjectCollection entrs = this.getModel().getEntryEntity("quoentry");
        if (entrs.size() > 0) {
            if (((DynamicObject)entrs.get(0)).get("entrysupplier") != null && (((DynamicObject)entrs.get(0)).get("quobillno") == null || ((DynamicObject)entrs.get(0)).get("quobillno").toString().trim().equals(""))) {
                for (DynamicObject obj : entrs) {
                    Object supid = obj.getDynamicObject("entrysupplier").getPkValue();
                    if (billnomap.get(supid) == null) continue;
                    obj.set("quobillno", billnomap.get(supid));
                }
            } else {
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        if (!"1".equals(model.getValue("pushresult"))) {
            model.setValue("pushresult", (Object)"0");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject inquiryObj;
        String inquiryno;
        super.afterBindData(e);
        if (ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_pusheas"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_pusheas"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap"});
        }
        if (ApiConfigUtil.hasCQScmConfig() || ApiConfigUtil.hasXKScmConfig()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pcbillno"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tocontract"});
        }
        if (ApiConfigUtil.hasCQScmConfig()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pobillno"});
        }
        if (!StringUtils.isEmpty((CharSequence)(inquiryno = String.valueOf(this.getModel().getValue("inquiryno")))) && (inquiryObj = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"id,totalinquiry", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inquiryno)})) != null) {
            boolean totalinquiry = inquiryObj.getBoolean("totalinquiry");
            this.getView().setVisible(Boolean.valueOf(totalinquiry), new String[]{"adoptamount1"});
            this.getView().setVisible(Boolean.valueOf(totalinquiry), new String[]{"adopttaxamount"});
            List atts = AttachmentServiceHelper.getAttachments((String)"sou_inquiry", (Object)inquiryObj.getLong("id"), (String)"attachmentpanel");
            AttachmentPanel panel = (AttachmentPanel)this.getControl("inquiryattachpanel");
            panel.bindData(atts);
        }
        DynamicObjectCollection entrs = this.getModel().getEntryEntity("materialentry");
        boolean isPushEasOrder = false;
        for (DynamicObject entry : entrs) {
            String poBillno = entry.getString("pobillno");
            if (poBillno == null || poBillno.trim().length() <= 0) continue;
            isPushEasOrder = true;
        }
        if (isPushEasOrder) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unaudit"});
        }
        this.cacheQuoBillNo();
        this.setEntrySupName();
    }

    private void cacheQuoBillNo() {
        IPageCache cache = this.getPageCache();
        DynamicObjectCollection dyoCol = this.getModel().getEntryEntity("quoentry");
        if (dyoCol != null && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                DynamicObject supplier = dyo.getDynamicObject("entrysupplier");
                if (null == supplier) continue;
                cache.put(supplier.getPkValue().toString(), dyo.getString("quobillno"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (CONFIRMCALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().invokeOperation("submit");
        }
    }

    protected List<String> getSupQuoNumColumn() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sou_compare");
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get("materialentry");
        DataEntityPropertyCollection properties = entityType.getProperties();
        ArrayList<String> result = new ArrayList<String>(8);
        for (IDataEntityProperty property : properties) {
            if (!property.getName().matches("\\w{0,}quote\\d+") || !(property instanceof PriceProp)) continue;
            result.add(property.getName());
        }
        return result;
    }
}

