/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.PersonChangeUtil;
import kd.scm.common.util.cal.CalImpl;
import kd.scm.common.util.cal.ICal;

public class SouCoreBillEditPlugin
extends AbstractBillPlugIn {
    private static ICal cal = new CalImpl();

    public void afterCreateNewData(EventObject eventobject) {
        Long currOrg;
        IDataModel model = this.getModel();
        String entityId = this.getView().getEntityId();
        List permissionOrgs = OrgUtil.getAllPurPermssionOrgs((String)entityId);
        if (permissionOrgs.contains(currOrg = Long.valueOf(RequestContext.get().getOrgId()))) {
            model.setValue("org", (Object)currOrg);
        } else if (permissionOrgs.size() > 0) {
            model.setValue("org", permissionOrgs.get(0));
        } else {
            model.setValue("org", (Object)0);
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
        this.getModel().setDataChanged(false);
    }

    protected String getStatusTabVal() {
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "audit": {
                BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
                break;
            }
            case "unaudit": {
                BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabVal() + "tab"));
                break;
            }
            case "deleteentry": {
                if (!"sou_inquiry".equals(this.getView().getEntityId())) break;
                cal.calSumQty(this.getModel(), "materialentry");
                break;
            }
        }
    }

    public void initEntryDefaultData(DynamicObject entry) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        block14: for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = model.getEntryCurrentRowIndex("materialentry");
            if (rowIndex >= 0 && currentRowIndex != rowIndex && "materialentry".equals(changeData.getDataEntity().getDataEntityType().getName())) {
                EntryGrid grid = (EntryGrid)this.getControl("materialentry");
                grid.selectRows(rowIndex, true);
            }
            Object modelValue = null;
            cal.proChanged(model, "materialentry", propertyName);
            switch (propertyName) {
                case "material": {
                    DynamicObject dataEntity;
                    DynamicObjectCollection entry;
                    DataEntityPropertyCollection properties;
                    modelValue = model.getValue(propertyName, rowIndex);
                    if (!(modelValue instanceof DynamicObject)) continue block14;
                    MaterialUtil.materialChanged((IDataModel)model, (String)propertyName, (DynamicObject)((DynamicObject)modelValue), (String)"materialentry", (int)rowIndex);
                    BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
                    DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
                    Long unitId = 0L;
                    if (unit != null) {
                        unitId = unit.getLong("id");
                    }
                    if (!(properties = (entry = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObjectCollection("materialentry")).getDynamicObjectType().getProperties()).containsKey((Object)"qty") || !properties.containsKey((Object)"unit")) continue block14;
                    this.processBaseQty(unitId, qty, rowIndex);
                    continue block14;
                }
                case "person": {
                    modelValue = model.getValue(propertyName, rowIndex);
                    PersonChangeUtil.personChange((IDataModel)model, (DynamicObject)((DynamicObject)modelValue));
                    continue block14;
                }
                case "qty": {
                    modelValue = changeData.getNewValue();
                    if (modelValue == null) {
                        modelValue = BigDecimal.ZERO;
                    }
                    Long unitId = (Long)model.getValue("unit_id", rowIndex);
                    this.processBaseQty(unitId, (BigDecimal)modelValue, rowIndex);
                    continue block14;
                }
                case "unit": {
                    if (changeData.getNewValue() == null) continue block14;
                    BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
                    this.processBaseQty(((DynamicObject)changeData.getNewValue()).getLong("id"), qty, rowIndex);
                    continue block14;
                }
                case "": {
                    continue block14;
                }
            }
        }
    }

    private void processBaseQty(Long srcUnitId, BigDecimal qty, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("materialentry");
        DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"basicunit") && properties.containsKey((Object)"basicqty")) {
            Long materialId = (Long)model.getValue("material_id", rowIndex);
            Long baseId = (Long)model.getValue("basicunit_id", rowIndex);
            BigDecimal desmuCount = BaseDataServiceHelper.getDesmuCount((Long)materialId, (Long)srcUnitId, (BigDecimal)qty, (Long)baseId);
            this.getModel().setValue("basicqty", (Object)desmuCount, rowIndex);
        }
    }

    protected ICal getCal() {
        return cal;
    }

    protected void setCal(ICal cal) {
        SouCoreBillEditPlugin.cal = cal;
    }
}

