/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SouOpenTypeEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BOTPUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ExchrateUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.InquiryUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.sou.common.SouContactChangeUtil;
import kd.scm.sou.common.SouInquiryUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.formplugin.edit.SouCoreBillEditPlugin;

public class SouInquiryEdit
extends SouCoreBillEditPlugin
implements BeforeF7SelectListener {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final String CONFIRMCOMPARE_ACTIONID = "confirmCompareActionId";

    protected String getMaxTurns() {
        return "20";
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "supplier": {
                GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
                DynamicObject newObject = this.getModel().getDataEntity(true);
                DynamicObjectCollection col = newObject.getDynamicObjectCollection("entryentity");
                ArrayList<Long> have = new ArrayList<Long>();
                for (DynamicObject row : col) {
                    DynamicObject supplier = row.getDynamicObject("supplier");
                    if (supplier == null) continue;
                    have.add(supplier.getLong("id"));
                }
                if (have.isEmpty()) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", have));
                break;
            }
            case "org": {
                List permissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)this.getModel().getDataEntityType().getName());
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)permissionOrgs));
                break;
            }
            case "material": {
                GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"sou");
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.initCurrency(org.getLong("id"));
            this.setExChangeRate();
            this.setBizPerson();
        }
    }

    private void setBizPerson() {
        QFilter statusFilter;
        QFilter enableFilter;
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("user", "=", (Object)currUserId);
        DynamicObjectCollection personDyns = QueryServiceHelper.query((String)"pur_bizperson", (String)"id,user,group,phone", (QFilter[])new QFilter[]{userFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")}, (String)"id");
        if (personDyns != null && !personDyns.isEmpty()) {
            this.getModel().setValue("person", (Object)((DynamicObject)personDyns.get(0)).getLong("id"));
            this.getModel().setValue("phone", ((DynamicObject)personDyns.get(0)).get("phone"));
        }
    }

    public void initCurrency(Long bizOrg) {
        if (bizOrg != 0L) {
            IDataModel model = this.getModel();
            DynamicObject locCurrency = (DynamicObject)model.getValue("loccurr");
            DynamicObject exchtype = (DynamicObject)model.getValue("exchtype");
            if (null == locCurrency || null == exchtype) {
                Map map = ExchrateUtil.getCurrencyAndExRateTable((Long)bizOrg);
                this.log.info("@@\u9ed8\u8ba4\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868map\uff1a" + map);
                if (map == null) {
                    return;
                }
                if (null == locCurrency) {
                    model.setValue("loccurr", map.get("baseCurrencyID"));
                }
                if (null == exchtype) {
                    model.setValue("exchtype", map.get("exchangeRateTableID"));
                }
            }
        }
    }

    public void setExChangeRate() {
        Date createTime = (Date)this.getModel().getValue("createtime");
        if (createTime == null) {
            createTime = TimeServiceHelper.now();
        }
        this.getModel().setValue("ratedate", (Object)createTime);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetTaxType();
        this.setEnable();
        this.setVisible();
    }

    public void afterLoadData(EventObject e) {
        DynamicObject org;
        IDataModel model = this.getModel();
        Object billStatus = model.getValue("billstatus");
        if ("ADDNEW".equals(this.getView().getFormShowParameter().getStatus().name()) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            this.initCurrency(org.getLong("id"));
        }
        if ("A".equals(billStatus) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            this.initCurrency(org.getLong("id"));
            this.setExChangeRate();
        }
    }

    public void afterCopyData(EventObject e) {
        this.clearData();
    }

    private void setVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date enddate = dataEntity.getDate("enddate");
        String bizstatus = dataEntity.getString("bizstatus");
        String scope = dataEntity.getString("supscope");
        String turns = dataEntity.getString("turns");
        if (enddate != null && TimeServiceHelper.now().before(enddate) && "A".equals(bizstatus) && ("2".equals(scope) || "1".equals(scope) && !turns.equals("1"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"replenishsupplier"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"replenishsupplier"});
        }
    }

    protected void setEnable() {
        DynamicObjectCollection materialentry = this.getModel().getDataEntity().getDynamicObjectCollection("materialentry");
        if (materialentry.size() > 0) {
            DynamicObject row = (DynamicObject)materialentry.get(0);
            String prbillid = row.getString("prbillid");
            if (StringUtils.isNotBlank((CharSequence)prbillid)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"org", "taxtype", "unit"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"org", "taxtype", "unit"});
            }
        }
    }

    private void resetTaxType() {
        ComboEdit taxtypeControl = (ComboEdit)this.getView().getControl("taxtype");
        List<ComboItem> comboItems = this.getTaxTypeComboItems();
        taxtypeControl.setComboItems(comboItems);
    }

    private List<ComboItem> getTaxTypeComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem taxsExpriceIntax = this.createComboItem(TaxTypeEnum.TAXSEXPRICE_INTAX);
        ComboItem taxsExpriceExtax = this.createComboItem(TaxTypeEnum.TAXSEXPRICE_EXTAX);
        comboItems.add(taxsExpriceIntax);
        comboItems.add(taxsExpriceExtax);
        if (ApiConfigUtil.hasEASConfig()) {
            ComboItem taxsInpriceIntax = this.createComboItem(TaxTypeEnum.TAXSINPRICE_INTAX);
            comboItems.add(taxsInpriceIntax);
        }
        return comboItems;
    }

    private ComboItem createComboItem(TaxTypeEnum commondimension) {
        return new ComboItem(new LocaleString(commondimension.getName()), commondimension.getVal());
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        String bizStatus = inquiryObject.getString("bizstatus");
        return bizStatus == null ? "" : bizStatus.toLowerCase();
    }

    private void trackDown() {
        long pkId = (Long)this.getModel().getValue("id");
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (!"C".equals(billstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"SouInquiryEdit_30", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_quote")) {
            noPermBill.add("sou_quote");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u62a5\u4ef7\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryEdit_21", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_notice")) {
            noPermBill.add("sou_notice");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u516c\u544a\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryEdit_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_compare")) {
            noPermBill.add("sou_compare");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6bd4\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryEdit_23", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Object inquiryPKObj = this.getModel().getDataEntity().getPkValue();
        Map<String, HashSet<Long>> result = this.getTrackDownBill(inquiryPKObj);
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        String openType = (String)this.getModel().getValue("opentype");
        String status = (String)this.getModel().getValue("bizstatus");
        if ((SouOpenTypeEnum.INVISIBLE_AUTOOPEN.getVal().equals(openType) || SouOpenTypeEnum.INVISIBLE_MANUALOPEN.getVal().equals(openType)) && "A".equals(status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5f00\u6807\uff0c\u4e0d\u80fd\u4e0b\u67e5\u5355\u636e\u3002", (String)"SouInquiryEdit_19", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        if (result.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"SouInquiryEdit_16", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackDownBill(Object object) {
        HashMap<String, String> entityOfPro = new HashMap<String, String>();
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        QFilter originFilter = new QFilter("origin", "=", (Object)"1");
        QFilter supFilter = filter.and(originFilter);
        QFilter purOriginfilter = new QFilter("origin", "=", (Object)"2");
        entityOfPro.put("sou_quote", "inquiryno");
        Map resultMap = BOTPUtil.getTrackDownBillByFilter((Object[])new Object[]{object}, (String)"sou_inquiry", entityOfPro, (QFilter)supFilter.or(purOriginfilter));
        entityOfPro.clear();
        entityOfPro.put("sou_compare", "inquiryno");
        Map compareResultMap = BOTPUtil.getTrackDownBillByFilter((Object[])new Object[]{object}, (String)"sou_inquiry", entityOfPro, null);
        if (null != compareResultMap) {
            resultMap.put("sou_compare", compareResultMap.get("sou_compare"));
        } else {
            resultMap.put("sou_compare", new HashSet());
        }
        Map noticeResult = BFTrackerServiceHelper.findTargetBills((String)"sou_inquiry", (Long[])new Long[]{(Long)object});
        if (noticeResult != null && !noticeResult.isEmpty() && null != noticeResult.get("sou_notice")) {
            resultMap.put("sou_notice", noticeResult.get("sou_notice"));
        }
        Iterator it = resultMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (null != entry.getValue() && !((HashSet)entry.getValue()).isEmpty()) continue;
            it.remove();
        }
        return resultMap;
    }

    private void alertDate() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject inquiryObj = model.getDataEntity();
        Object bizStatus = (inquiryObj = BusinessDataServiceHelper.loadSingle((String)"sou_inquiry", (String)"id,bizstatus,opentype,supquonum,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", inquiryObj.getPkValue())})).get("bizstatus");
        if (null != bizStatus && BizStatusEnum.OPENEDTHEBID.getVal().equals(bizStatus.toString())) {
            view.showMessage(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u5df2\u5f00\u6807\uff0c\u4e0d\u80fd\u53d8\u66f4\u65f6\u95f4\u3002", (String)"SouInquiryEdit_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String openTypeObj = inquiryObj.getString("opentype");
        int supQuoNumObj = inquiryObj.getInt("supquonum");
        if (supQuoNumObj > 0 && (SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal().equals(openTypeObj) || SouOpenTypeEnum.INVISIBLE_AUTOOPEN.getVal().equals(openTypeObj)) && inquiryObj.getDate("enddate").getTime() <= TimeServiceHelper.now().getTime()) {
            view.showMessage(ResManager.loadKDString((String)"\u7cfb\u7edf\u6b63\u5728\u6267\u884c\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u3002", (String)"SouInquiryEdit_20", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        paramMap.put("billid", inquiryObj.getPkValue());
        paramMap.put("enddate", inquiryObj.getDate("enddate"));
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_alertdate", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "alertDateAction"), (ShowType)ShowType.Modal));
    }

    private void turnsQuote() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject inquiryObj = model.getDataEntity();
        Object bizStatus = inquiryObj.get("bizstatus");
        if (null != bizStatus && !BizStatusEnum.OPENEDTHEBID.getVal().equals(bizStatus.toString())) {
            view.showMessage(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u9879\u76ee\u72b6\u6001\u4e3a\u5df2\u5f00\u6807\u7684\u624d\u80fd\u591a\u8f6e\u62a5\u4ef7\u3002", (String)"SouInquiryEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String turns = inquiryObj.getString("turns");
        if (turns != null && turns.equals(this.getMaxTurns())) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u7684\u62a5\u4ef7\u8f6e\u6b21\u662f\u7b2c%s\u8f6e\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u591a\u8f6e\u62a5\u4ef7\u3002", (String)"SouInquiryEdit_2", (String)"scm-sou-formplugin", (Object[])new Object[0]), this.getMaxTurns()));
            return;
        }
        String billNo = inquiryObj.getString("billno");
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"sou_compare", (String)"billno", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)billNo)});
        if (dyoCol != null && dyoCol.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u751f\u6210\u6bd4\u4ef7\u5355\u3002", (String)"SouInquiryEdit_17", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            for (DynamicObject dyo : dyoCol) {
                sb.append(dyo.getString("billno")).append(',');
            }
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u6bd4\u4ef7\u5355\u518d\u8fdb\u884c\u591a\u8f6e\u62a5\u4ef7\u3002", (String)"SouInquiryEdit_18", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            view.showMessage(sb.toString());
            return;
        }
        paramMap.put("org", inquiryObj.getLong("org.id"));
        paramMap.put("billid", inquiryObj.getPkValue());
        paramMap.put("billno", inquiryObj.getString("billno"));
        paramMap.put("enddate", inquiryObj.getDate("enddate"));
        paramMap.put("inquirytitle", inquiryObj.getString("inquirytitle"));
        paramMap.put("curr", SrmCommonUtil.getPkValue((DynamicObject)inquiryObj.getDynamicObject("curr")));
        turns = turns == null || turns.equals("") ? "2" : String.valueOf(Integer.parseInt(turns) + 1);
        paramMap.put("turns", turns);
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_inquiryturns", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "turnsQuoteAction"), (ShowType)ShowType.Modal));
    }

    private void clearData() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        dataModel.deleteEntryData("entrylog");
        dataModel.setValue("quotenum", null);
        dataModel.setValue("minsumamount", null);
        dataModel.setValue("minsupplier", null);
        dataModel.setValue("maxsumamount", null);
        dataModel.setValue("maxsupplier", null);
        dataModel.setValue("avgsumamount", null);
        dataModel.setValue("audit", null);
        dataModel.setValue("terminate", null);
        dataModel.setValue("pushnotice", (Object)0);
        BillFormUtil.clearSrcPro((IDataModel)dataModel, (String)"materialentry");
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        if (properties.containsKey((Object)"businesstype")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"businesstype"});
        }
    }

    private void compareTool() {
        IDataModel model = this.getModel();
        String billno = String.valueOf(model.getValue("billno"));
        DynamicObject info = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        String billSatus = info.getString("billstatus");
        String bizstatus = info.getString("bizstatus");
        String opentype = model.getValue("opentype").toString();
        Date enddate = (Date)model.getValue("enddate");
        if (BillStatusEnum.AUDIT.getVal().equals(billSatus) && ("B".equals(bizstatus) || SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal().equals(opentype) && enddate.before(new Date()))) {
            DynamicObject[] savedCompareData = SouInquiryUtil.getSavedCompareData((String)billno);
            if (savedCompareData.length != 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMCOMPARE_ACTIONID, (IFormPlugin)this);
                String confirmTip = MessageFormat.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355{0}\u5df2\u751f\u6210\u4fdd\u5b58\u7684\u6bd4\u4ef7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouInquiryEdit_27", (String)"scm-sou-formplugin", (Object[])new Object[0]), billno);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
            this.openDealPage("sou_comparetool", "compareToolAtionId", ShowType.MainNewTabPage);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
    }

    private void terminate() {
        Object bizstatus = this.getModel().getValue("bizstatus");
        if (bizstatus.equals("D")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u6267\u884c\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouInquiryEdit_7", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        if (bizstatus.equals("E")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"SouInquiryEdit_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String billno = (String)this.getModel().getValue("billno");
        QFilter qFilter = new QFilter("inquiryno", "=", (Object)billno);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        DynamicObject souCompareDyn = QueryServiceHelper.queryOne((String)"sou_compare", (String)"id,inquiryno", (QFilter[])new QFilter[]{qFilter});
        if (souCompareDyn != null) {
            QFilter qFilter2 = new QFilter("billentry.srcbillid", "=", (Object)souCompareDyn.getLong("id"));
            DynamicObject pmOrderDyn = QueryServiceHelper.queryOne((String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter2});
            if (pmOrderDyn != null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouInquiryEdit_32", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject conmContractDyn = QueryServiceHelper.queryOne((String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{qFilter2});
            if (conmContractDyn != null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouInquiryEdit_32", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.openDealPage("sou_inquiryend", "inquiryTerminateAtionId", ShowType.Modal);
    }

    private void compareResult() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.getModel().getDataEntity();
        if (inquiryBill == null) {
            return;
        }
        Map compareResult = SouInquiryUtil.verifyCompareResult((DynamicObject)inquiryBill);
        if ("false".equals(compareResult.get("succed"))) {
            view.showMessage(compareResult.get("message").toString());
            return;
        }
        if ("true".equals(compareResult.get("succed"))) {
            Long[] pkId = new Long[1];
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SouInquiryList", (String)"sou_compare", (String)"id", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)inquiryBill.getString("billno")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal())}, (String)"id");){
                dataSet.forEach(row -> {
                    pkId[0] = row.getLong("id");
                });
            }
            if (pkId[0] == null) {
                view.showMessage(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u8be2\u4ef7\u5355\u7684\u6bd4\u4ef7\u5355\u3002", (String)"SouInquiryEdit_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            } else {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)"sou_compare", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)pkId[0], null, null);
                view.showForm((FormShowParameter)showParam);
            }
        }
    }

    private void openDealPage(String pageKey, String actionId, ShowType showType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("inquiryBillId", this.getModel().getDataEntity().getPkValue());
        paramMap.put("inquiryno", this.getModel().getValue("billno"));
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)showType));
    }

    private boolean validateCompare() {
        IDataModel model = this.getModel();
        long pkId = (Long)model.getValue("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_inquiry")) {
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8be2\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryEdit_26", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_quote")) {
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u62a5\u4ef7\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryEdit_21", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_comparetool")) {
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6bd4\u4ef7\u52a9\u624b\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryEdit_25", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!errMsgList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)"\uff0c", errMsgList));
            return true;
        }
        DynamicObject info = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"enddate,opentype,billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
        if (info == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u8be2\u4ef7\u5355\u7684\u6bd4\u4ef7\u5355\u3002", (String)"SouInquiryEdit_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject dataEntity = model.getDataEntity();
        ArrayList<String> billnos = new ArrayList<String>();
        billnos.add(dataEntity.getString("billno"));
        String billStatus = info.getString("billstatus");
        String bizStatus = info.getString("bizstatus");
        Object openType = info.get("opentype");
        Date enddate = info.getDate("enddate");
        String billno = String.valueOf(model.getValue("billno"));
        if (!"C".equals(billStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u8fdb\u884c\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_11", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        switch (bizStatus) {
            case "E": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_14", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return true;
            }
            case "C": 
            case "D": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_13", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return true;
            }
            case "A": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5f00\u6807\uff0c\u4e0d\u80fd\u8fdb\u884c\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_12", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        DynamicObject[] compareCol = SouInquiryUtil.getCompareData((String)billno);
        if (compareCol != null && compareCol.length >= 1) {
            String compareBillStatus;
            switch (compareBillStatus = compareCol[0].getString("billstatus")) {
                case "B": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_28", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "C": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_29", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                }
            }
            return true;
        }
        if (InquiryUtil.getQuoteBillByInquiryBillNo(billnos).length == 0 && SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal().equals(openType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f9b\u5e94\u5546\u62a5\u4ef7\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_10", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (enddate != null && enddate.after(new Date())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryEdit_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operate) && null == this.getModel().getValue("creator")) {
            this.getModel().setValue("createtime", (Object)new Date());
            this.getModel().setValue("creator_id", (Object)RequestContext.get().getUserId());
        }
        if ("quote".equals(operate)) {
            ((AbstractOperate)args.getSource()).getOption().setVariableValue("quote_source", "sou");
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"verifyQuote", (Object[])new Object[]{this.getModel().getValue("id"), null});
            if ("false".equals(result.get("succed"))) {
                this.getView().showTipNotification(result.get("message").toString());
                args.setCancel(true);
                return;
            }
        } else if ("replenishsupplier".equals(operate)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String bizStatus = dataEntity.getString("bizstatus");
            String errorInfo = null;
            if (!"A".equals(bizStatus)) {
                errorInfo = ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e0d\u662f\u5f85\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u8865\u5145\u4f9b\u5e94\u5546", (String)"QuoInquiryUtil_3", (String)"scm-quo-common", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorInfo);
                args.setCancel(true);
                return;
            }
        }
    }

    private void reloadAndUpdate() {
        BillModel model = (BillModel)this.getModel();
        model.load(model.getPKValue());
        this.getView().updateView();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operate = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("copy".equals(operate)) {
            this.clearData();
        }
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (operate) {
                case "alertdate": {
                    this.alertDate();
                    this.reloadAndUpdate();
                    break;
                }
                case "compare": {
                    if (this.validateCompare()) {
                        return;
                    }
                    this.compareTool();
                    break;
                }
                case "compareresult": {
                    this.compareResult();
                    break;
                }
                case "turns": {
                    this.reloadAndUpdate();
                    this.turnsQuote();
                    break;
                }
                case "terminate": {
                    this.terminate();
                    break;
                }
                case "mytrackdown": {
                    this.trackDown();
                    break;
                }
                case "save": {
                    this.getModel().updateCache();
                    this.getView().updateView("pl_otherinfo");
                    break;
                }
                case "audit": {
                    DynamicObjectCollection supplierEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    if (supplierEntrys != null) {
                        supplierEntrys.forEach(row -> InquirySupParticipateUtils.setSupProStatus((DynamicObject)row, (Date)row.getDate("deadline"), (String)"supplierbizstatus", (String)row.getString("supplierbizstatus")));
                    }
                    this.getView().updateView();
                    break;
                }
                case "replenishsupplier": {
                    DynamicObject inquiryObj = this.getModel().getDataEntity(true);
                    DynamicObjectCollection entryentity = inquiryObj.getDynamicObjectCollection("entryentity");
                    HashSet<Long> supplierIds = new HashSet<Long>(entryentity.size());
                    HashSet<Long> bizpartnerIds = new HashSet<Long>(entryentity.size());
                    for (DynamicObject row2 : entryentity) {
                        if (!StringUtils.equals((CharSequence)row2.getString("entryturns"), (CharSequence)inquiryObj.getString("turns"))) continue;
                        supplierIds.add(row2.getLong("supplier_id"));
                        bizpartnerIds.add(row2.getLong("supplier.bizpartner.id"));
                    }
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("supplierIds", supplierIds);
                    paramMap.put("bizpartnerIds", bizpartnerIds);
                    paramMap.put("org", inquiryObj.getLong("org.id"));
                    paramMap.put("billid", inquiryObj.getPkValue());
                    this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_inquirysupplier", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "replenishAction"), (ShowType)ShowType.Modal));
                    break;
                }
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String opKey;
        super.itemClick(evt);
        switch (opKey = evt.getOperationKey()) {
            case "openbid": {
                this.getView().invokeOperation("refresh");
            }
            case "submit": {
                this.getModel().updateCache();
                this.getView().updateView("pl_otherinfo");
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        Object value = dataModel.getValue(name);
        switch (name) {
            case "supcontacter": {
                if (!(value instanceof DynamicObject)) break;
                SouContactChangeUtil.ContactChange((IDataModel)dataModel, (DynamicObject)((DynamicObject)value));
                break;
            }
            case "supscope": {
                if (value == null || !"1".equals(value.toString())) break;
                dataModel.deleteEntryData("entryentity");
                break;
            }
            case "person": {
                if (value instanceof DynamicObject) {
                    String number = ((DynamicObject)value).get("number").toString();
                    DynamicObject[] dynamicObjects = this.getPersonInfo(number);
                    dataModel.setValue("phone", dynamicObjects[0].get("user.phone"));
                }
                if (value != null) break;
                dataModel.setValue("phone", null);
                break;
            }
            case "curr": 
            case "exchtype": {
                this.setExChangeRate();
                break;
            }
            case "totalinquiry": {
                ChangeData[] changeSet;
                for (ChangeData data : changeSet = e.getChangeSet()) {
                    if (data.getNewValue() == null) continue;
                    this.setAdoptRuleItem((Boolean)data.getNewValue());
                    if (((Boolean)data.getNewValue()).booleanValue() || !"3".equals(this.getModel().getValue("adoptrule")) && !"4".equals(this.getModel().getValue("adoptrule"))) continue;
                    this.getModel().setValue("adoptrule", (Object)"1");
                }
                break;
            }
        }
    }

    private void setAdoptRuleItem(boolean totalinquiry) {
        Object adoptrule = this.getModel().getDataEntity(true).getDataEntityType().getProperties().get((Object)"adoptrule");
        List comboItems = ((ComboProp)adoptrule).getComboItems();
        ComboEdit adoptrule1 = (ComboEdit)this.getView().getControl("adoptrule");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        for (ValueMapItem comboItem : comboItems) {
            ComboItem item = new ComboItem();
            item.setCaption(comboItem.getName());
            if (!totalinquiry && ("3".equals(comboItem.getValue()) || "4".equals(comboItem.getValue()))) continue;
            item.setId(comboItem.getValue());
            item.setValue(comboItem.getValue());
            items.add(item);
        }
        adoptrule1.setComboItems(items);
    }

    private DynamicObject[] getPersonInfo(String number) {
        String selectFields = "user.phone";
        HashMap paramMap = new HashMap(1);
        HashMap<String, String> poBillIdMap = new HashMap<String, String>(1);
        poBillIdMap.put("in", number);
        paramMap.put("number", poBillIdMap);
        return ORMUtil.load((String)"pur_bizperson", (String)selectFields, paramMap);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "inquiryTerminateAtionId": 
            case "compareToolAtionId": 
            case "alertDateAction": 
            case "turnsQuoteAction": 
            case "replenishAction": {
                model.load(model.getPKValue());
                view.updateView();
                break;
            }
        }
        model.setDataChanged(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CONFIRMCOMPARE_ACTIONID, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.openDealPage("sou_comparetool", "compareToolAtionId", ShowType.MainNewTabPage);
        }
    }

    protected void setSupplier(Object[] supplierIdS) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        IDataEntityProperty dataEntityProperty = this.getModel().getProperty("entryentity");
        int rowIndex = currentRowIndex;
        for (Object supplierId : supplierIdS) {
            int insertIndex = this.getModel().insertEntryRow(dataEntityProperty.getName(), rowIndex);
            this.getModel().setValue("supplier", supplierId, insertIndex);
            ++rowIndex;
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection supplierEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (supplierEntrys != null) {
            supplierEntrys.sort((a, b) -> {
                try {
                    String aturns = a.getString("entryturns");
                    String bturns = b.getString("entryturns");
                    if (StringUtils.isNotBlank((CharSequence)aturns) && StringUtils.isNotBlank((CharSequence)bturns)) {
                        Integer turns2;
                        Integer turns1 = Integer.valueOf(aturns);
                        int result = turns1.compareTo(turns2 = Integer.valueOf(bturns));
                        if (result > 0) {
                            return 1;
                        }
                        if (result < 0) {
                            return -1;
                        }
                        return 0;
                    }
                    if (StringUtils.isBlank((CharSequence)aturns) && StringUtils.isNotBlank((CharSequence)bturns)) {
                        return 1;
                    }
                    return -1;
                }
                catch (NumberFormatException ex) {
                    this.log.error("entryturns NumberFormatException:", (Throwable)ex);
                    return 0;
                }
            });
            supplierEntrys.forEach(row -> InquirySupParticipateUtils.setSupProStatus((DynamicObject)row, (Date)row.getDate("deadline"), (String)"supplierbizstatus", (String)row.getString("supplierbizstatus")));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"materialentry")) {
            DynamicObjectCollection billentrys = (DynamicObjectCollection)this.getModel().getValue("materialentry");
            for (int i = 0; i < billentrys.size(); ++i) {
                DynamicObject unitDyn = ((DynamicObject)billentrys.get(i)).getDynamicObject("unit");
                if (unitDyn != null || null == this.getModel().getDataEntity().getDynamicObject("org") || null == ((DynamicObject)billentrys.get(i)).getDynamicObject("material")) continue;
                MaterialUtil.materialChanged((IDataModel)this.getModel(), (String)"unit", (DynamicObject)((DynamicObject)billentrys.get(i)).getDynamicObject("material"), (String)"unit", (int)i);
            }
        }
        this.dealExrate(dataEntity, this.getModel());
    }

    private void dealExrate(DynamicObject dataEntity, IDataModel model) {
        String quotation;
        Date exrateDate;
        Long locCurr = dataEntity.getLong("loccurr.id");
        Long curr = dataEntity.getLong("curr.id");
        long rateTableId = dataEntity.getLong("exchtype.id");
        if (rateTableId == 0L) {
            rateTableId = this.getRateTableIdByOrg(dataEntity.getLong("org.id"));
            model.setValue("exchtype_id", (Object)rateTableId);
        }
        if (Objects.isNull(exrateDate = dataEntity.getDate("ratedate"))) {
            model.setValue("ratedate", (Object)TimeServiceHelper.now());
        }
        BigDecimal exchrate = dataEntity.getBigDecimal("exchrate");
        if (locCurr == 0L || curr == 0L || locCurr.equals(curr) || exchrate.compareTo(BigDecimal.ZERO) <= 0) {
            exchrate = BigDecimal.ONE;
            quotation = "0";
        } else {
            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)locCurr, (Long)curr, (Long)rateTableId, (Date)exrateDate);
            exchrate = (BigDecimal)exchangeRateMap.get("exchangeRate");
            quotation = (Boolean)exchangeRateMap.get("quoteType") != false ? "1" : "0";
        }
        this.getModel().setValue("exchrate", (Object)exchrate);
        this.getModel().setValue("quotation", (Object)quotation);
    }

    private Long getRateTableIdByOrg(long orgId) {
        long exchangeTableId = 0L;
        Map companyMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (companyMap == null || companyMap.size() == 0) {
            return exchangeTableId;
        }
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)companyMap.get("id")));
        if (baseAccountingInfo == null || baseAccountingInfo.size() == 0) {
            return exchangeTableId;
        }
        exchangeTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
        return exchangeTableId;
    }
}

