/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.BizTypeHelper;
import kd.scm.common.util.cal.CalImpl;
import org.apache.commons.lang.StringUtils;

public class SouLineTypeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CACHE_KEY_BIZTYPEID = "cache_key_biztype_id";
    private static final String CACHE_KEY_DEF_LINETYPEID = "cache_key_def_linetype_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        BasedataEdit businesstype = (BasedataEdit)this.getControl("businesstype");
        BasedataEdit linetype = (BasedataEdit)this.getControl("linetype");
        if (material != null) {
            material.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (businesstype != null) {
            businesstype.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (linetype != null) {
            linetype.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("businesstype");
        switch (name) {
            case "material": {
                List qf;
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", e.getRow());
                if (lineType == null || billType == null || lineType == null || (qf = BizTypeHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)false)) == null || qf.size() <= 0) break;
                QFilter qFilter = (QFilter)qf.get(0);
                QFilter serviceAttrFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + qFilter.getValue() + " ) "));
                showParameter.getListFilterParameter().getQFilters().add(serviceAttrFilter);
                break;
            }
            case "businesstype": {
                if (billType == null) break;
                List bizTypes = BizTypeHelper.getAllBizTypes((String)this.getView().getEntityId(), (Long)((Long)billType.getPkValue()));
                if (bizTypes != null && !bizTypes.isEmpty()) {
                    QFilter qFilter = new QFilter("id", "in", (Object)bizTypes);
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                QFilter qFilter = new QFilter("id", "=", (Object)0);
                List<QFilter> qfList = Collections.singletonList(qFilter);
                showParameter.getListFilterParameter().setQFilters(qfList);
                break;
            }
            case "linetype": {
                DynamicObject biztype = (DynamicObject)this.getModel().getValue("businesstype");
                if (null == bizType) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"SouLineTypeEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List qFilters = BizTypeHelper.getAllLineTypes((Long)(biztype != null ? (Long)biztype.getPkValue() : 0L));
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject oldValue = null;
        block10: for (ChangeData changeData : changeSet) {
            switch (name) {
                case "material": {
                    DynamicObject material = (DynamicObject)changeData.getNewValue();
                    if (material != null) {
                        this.getModel().setValue("materialnametext", (Object)material.getString("name"), changeData.getRowIndex());
                        continue block10;
                    }
                    this.getModel().setValue("materialnametext", null, changeData.getRowIndex());
                    continue block10;
                }
                case "businesstype": {
                    oldValue = (DynamicObject)changeData.getOldValue();
                    if (Objects.equals(changeData.getNewValue(), oldValue)) continue block10;
                    this.getPageCache().put(CACHE_KEY_BIZTYPEID, String.valueOf(oldValue == null ? Long.valueOf(0L) : oldValue.getPkValue()));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"SouLineTypeEdit_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(name, (IFormPlugin)this));
                    continue block10;
                }
                case "linetype": {
                    oldValue = (DynamicObject)changeData.getOldValue();
                    if (Objects.equals(changeData.getNewValue(), oldValue)) continue block10;
                    this.getModel().setValue("material", null, changeData.getRowIndex());
                    continue block10;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("businesstype".equals(event.getCallBackId())) {
            String biztypeId;
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("materialentry");
                if ("materialentry".equals(this.getView().getEntityId())) {
                    this.getModel().deleteEntryData("materialentry");
                }
                this.getModel().createNewEntryRow("materialentry");
                IDataModel model = this.getModel();
                DynamicObject bizType = (DynamicObject)model.getValue("businesstype");
                this.initNewDataEntry(0, this.getDefLineTypeFromPageCache(bizType));
                CalImpl cal = new CalImpl();
                cal.calSumQty(this.getModel(), "materialentry");
            } else if (event.getResult() == MessageBoxResult.Cancel && kd.bos.util.StringUtils.isNotEmpty((String)(biztypeId = this.getPageCache().get(CACHE_KEY_BIZTYPEID)))) {
                this.getModel().beginInit();
                if ("0".equals(biztypeId)) {
                    this.getModel().setValue("businesstype", null);
                } else {
                    this.getModel().setValue("businesstype", (Object)Long.parseLong(biztypeId));
                }
                this.getModel().endInit();
                this.getView().updateView("businesstype");
            }
            this.getPageCache().remove(CACHE_KEY_BIZTYPEID);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("materialentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            IDataModel model = this.getModel();
            DynamicObject bizType = (DynamicObject)model.getValue("businesstype");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initNewDataEntry(rowIndex, this.getDefLineTypeFromPageCache(bizType));
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        }
    }

    public void afterCreateNewData(EventObject eventobject) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        this.changeBillType(billType);
        int entryRowCount = this.getModel().getEntryRowCount("materialentry");
        IDataModel model = this.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("businesstype");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initNewDataEntry(i, this.getDefLineTypeFromPageCache(bizType));
        }
        this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
    }

    private Long getDefLineTypeFromPageCache(DynamicObject biztype) {
        if (biztype == null || Objects.equals(0L, biztype.getPkValue())) {
            return null;
        }
        String lineTypeIDCache = this.getPageCache().get(CACHE_KEY_DEF_LINETYPEID);
        if (StringUtils.isNotEmpty((String)lineTypeIDCache)) {
            return Long.valueOf(lineTypeIDCache);
        }
        Long lineTypeID = BizTypeHelper.getDefaultLineType((Long)((Long)biztype.getPkValue()));
        if (lineTypeID != null && !Objects.equals(0L, lineTypeID)) {
            this.getPageCache().put(CACHE_KEY_DEF_LINETYPEID, String.valueOf(lineTypeID));
            return lineTypeID;
        }
        return null;
    }

    private void initNewDataEntry(int rowIndex, Long bizType) {
        this.getModel().setValue("linetype", (Object)bizType, rowIndex);
    }

    private void changeBillType(DynamicObject billType) {
        if (billType == null) {
            this.getModel().setValue("billtype", null);
        } else {
            BillEntityType entityType = (BillEntityType)this.getModel().getDataEntityType();
            if (entityType == null) {
                return;
            }
            String formid = this.getView().getEntityId();
            Long biztype = BizTypeHelper.getDefaultBizType((String)formid, (Long)((Long)billType.getPkValue()));
            this.getModel().setValue("businesstype", (Object)biztype);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection billentrys;
        DataEntityPropertyCollection properties1;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"materialentry") && (properties1 = (billentrys = (DynamicObjectCollection)this.getModel().getValue("materialentry")).getDynamicObjectType().getProperties()).containsKey((Object)"materialnametext") && properties1.containsKey((Object)"material")) {
            for (DynamicObject billentry : billentrys) {
                DynamicObject material = billentry.getDynamicObject("material");
                if (material == null) continue;
                if (material.getBoolean("isdisposable")) {
                    if (!StringUtils.isBlank((String)billentry.getString("materialnametext"))) continue;
                    billentry.set("materialnametext", (Object)material.getLocaleString("name").getLocaleValue());
                    continue;
                }
                billentry.set("materialnametext", (Object)material.getLocaleString("name").getLocaleValue());
            }
        }
    }
}

