/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class SouLookUpTrackerEdit
extends AbstractFormPlugin {
    public static final String EntityNumber_LookUpTracker = "sou_lookuptracker";
    private static final String Key_TabBills = "tabbills";
    private Map<String, String> childPageIds = new HashMap<String, String>();
    private static final String CacheKey_PageIds = "pageids";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAllList();
    }

    private void showAllList() {
        Map showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Map result = (Map)showParameterMap.get("param");
        Object permMsg = showParameterMap.get("permMsg");
        if (permMsg != null) {
            this.getView().showTipNotification(String.valueOf(permMsg));
        }
        if (result != null) {
            this.childPageIds.clear();
            if (!result.isEmpty()) {
                for (Map.Entry entry : result.entrySet()) {
                    List billIds = (List)entry.getValue();
                    if (billIds == null || billIds.size() == 0) continue;
                    this.showList(billIds, (String)entry.getKey());
                }
            }
            this.putPageIds(this.childPageIds);
        }
    }

    private void showList(List<Long> billIds, String key) {
        if (billIds.size() == 1) {
            BillShowParameter showParameter = this.createBillShowParameter(key, billIds.get(0));
            if (showParameter != null) {
                this.getView().showForm((FormShowParameter)showParameter);
                this.childPageIds.put(key, showParameter.getPageId());
            }
        } else {
            ListShowParameter showParameter = this.createShowParameter(key, billIds);
            if (showParameter != null) {
                this.getView().showForm((FormShowParameter)showParameter);
                this.childPageIds.put(key, showParameter.getPageId());
            }
        }
    }

    protected BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(Key_TabBills);
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setHasRight(true);
        return showParameter;
    }

    protected ListShowParameter createShowParameter(String entityNumber, List<Long> billIds) {
        QFilter qFilter = null;
        qFilter = billIds.size() == 1 ? new QFilter("id", "=", (Object)billIds.get(0)) : new QFilter("id", "in", (Object)billIds.toArray(new Long[0]));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        showParameter.setIsolationOrg(false);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(Key_TabBills);
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setHasRight(true);
        return showParameter;
    }

    private void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put(CacheKey_PageIds, SerializationUtils.toJsonString(childPageIds));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            this.closePage(entityNumber);
        }
    }

    private String getPageId(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(entityNumber);
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get(CacheKey_PageIds);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return new HashMap<String, String>();
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    private void closePage(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        if (pageIds.containsKey(entityNumber)) {
            pageIds.remove(entityNumber);
        }
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }
}

