/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.pds.common.noticetpl.IPdsNoticeInterface;
import kd.scm.pds.common.noticetpl.PdsNoticeTplContext;
import kd.scm.pds.common.noticetpl.PdsNoticeTplFactory;
import kd.scm.sou.formplugin.edit.SouCoreBillEditPlugin;
import org.apache.commons.lang.StringUtils;

public class SouNoticeEdit
extends SouCoreBillEditPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        BasedataEdit noticetpl = (BasedataEdit)this.getControl("noticetpl");
        supplier.addBeforeF7SelectListener(this::beforeF7Select);
        supplier.addAfterF7SelectListener(this::afterF7Select);
        if (noticetpl != null) {
            noticetpl.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String supscope = this.getModel().getValue("supscope").toString();
        this.SupScopeChanged(supscope);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        richTextEditor.setText(" ");
        this.getModel().setValue("content", (Object)"");
        this.getModel().setValue("duedate", null);
    }

    @Override
    public void afterBindData(EventObject e) {
        Boolean iscopy;
        String appId;
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        if (dataModel.getValue("content") != null) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(dataModel.getValue("content").toString());
        }
        if ("srm".equals(appId = this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"noticetpl"});
        }
        if ("src".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new"});
        }
        if (null != (iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")) && iscopy.booleanValue()) {
            this.getModel().deleteEntryData("replyentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel Model = this.getModel();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                String text = richTextEditor.getText();
                Model.setValue("content", (Object)text);
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "preview": {
                Long id = (Long)this.getModel().getValue("id");
                this.showDetailPage(id);
                break;
            }
        }
    }

    private void showDetailPage(Long id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("quo_notice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u516c\u544a\u9884\u89c8", (String)"SouNoticeEdit_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        showParameter.setPkId((Object)id);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IDataModel model = this.getModel();
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (!operateKey.equals("newentry") && !operateKey.equals("deleteentry")) {
            String text = (String)model.getValue("content");
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            if (null != text) {
                richTextEditor.setText(text);
            }
        }
        if ("copy".equals(operateKey)) {
            this.getModel().setValue("duedate", null);
            model.setDataChanged(false);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!("supscope".equals(name) || "noticetpl".equals(name) || "biztype".equals(name))) {
            return;
        }
        Object value = dataEntity.get(name);
        switch (name) {
            case "supscope": {
                this.SupScopeChanged(value.toString());
                break;
            }
            case "noticetpl": {
                this.noticeTplChanged(value);
                break;
            }
            case "biztype": {
                this.getModel().setValue("noticetpl", null);
                break;
            }
        }
    }

    public void noticeTplChanged(Object noticeTpl) {
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        String content = "";
        if (null != noticeTpl && noticeTpl instanceof DynamicObject) {
            DynamicObject noticeTplObj = (DynamicObject)noticeTpl;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String srcBillId = dataEntity.getString("srcbillid");
            String srcBillType = dataEntity.getString("srcbilltype");
            if (StringUtils.isEmpty((String)srcBillId) || StringUtils.isEmpty((String)srcBillType)) {
                QFilter contentFilter = new QFilter("id", "=", noticeTplObj.getPkValue());
                DynamicObject noticeQOBj = QueryServiceHelper.queryOne((String)"pds_noticetpl", (String)"id,content,content_tag", (QFilter[])contentFilter.toArray());
                richTextEditor.setText(noticeQOBj.getString("content_tag"));
                return;
            }
            DynamicObject srcBillObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(srcBillId), (String)srcBillType);
            PdsNoticeTplContext noticeContext = (PdsNoticeTplContext)TypesContainer.createInstance(PdsNoticeTplContext.class);
            noticeContext.setNoticeTpl(noticeTplObj).setBillObj(srcBillObj);
            IPdsNoticeInterface pdsNoticePlugin = PdsNoticeTplFactory.getPdsNoticePluginInstance((PdsNoticeTplContext)noticeContext);
            content = pdsNoticePlugin.decorateContent(noticeContext);
        }
        richTextEditor.setText(content);
    }

    public void SupScopeChanged(String str) {
        switch (str) {
            case "3": 
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pl_supinfo"});
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"pl_supinfo"});
                break;
            }
        }
        this.getView().updateView("pl_supinfo");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("supplier".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
            DynamicObject newObject = this.getModel().getDataEntity(true);
            DynamicObjectCollection col = newObject.getDynamicObjectCollection("entryentity");
            ArrayList<Long> selectedList = new ArrayList<Long>();
            for (DynamicObject row : col) {
                DynamicObject supplier = row.getDynamicObject("supplier");
                if (supplier == null) continue;
                selectedList.add(supplier.getLong("id"));
            }
            if (!selectedList.isEmpty()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", selectedList));
            }
        } else if ("noticetpl".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String billtype = (String)this.getModel().getValue("srcbilltype");
            if (StringUtils.isNotBlank((String)billtype)) {
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                QFilter qFilter = new QFilter("bizobject", "=", (Object)billtype);
                qFilters.add(qFilter);
            } else {
                showParameter.setCustomParam("filterAppNumber", (Object)((BillEntityType)this.getModel().getDataEntity().getDataEntityType()).getAppId());
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String fieldKey = source.getFieldKey();
        if ("supplier".equals(fieldKey)) {
            IDataModel dataModel = this.getModel();
            int currentRowIndex = afterF7SelectEvent.getCurrentRowIndex();
            List inputTexts = afterF7SelectEvent.getInputTexts();
            if (inputTexts != null && inputTexts.size() > 0) {
                HashMap<Object, Map<String, String>> dataMap = this.queryLinkMans(inputTexts, "number");
                this.setLinkManValues(inputTexts, dataMap, currentRowIndex);
                return;
            }
            ListSelectedRowCollection rows = afterF7SelectEvent.getListSelectedRowCollection();
            ArrayList supplierPks = new ArrayList();
            if (rows != null && rows.size() > 0) {
                rows.forEach(row -> supplierPks.add(row.getPrimaryKeyValue()));
                HashMap<Object, Map<String, String>> dataMap = this.queryLinkMans(supplierPks, "id");
                this.setLinkManValues((List)rows, dataMap, currentRowIndex);
                return;
            }
            ArrayList inputValues = (ArrayList)afterF7SelectEvent.getInputValues();
            if (inputValues != null && inputValues.size() > 0) {
                HashMap<Object, Map<String, String>> dataMap = this.queryLinkMans(CommonUtil.stringObjList2longObjList((Collection)inputValues), "id");
                int rowIndex = dataModel.getEntryCurrentRowIndex("entryentity");
                this.setLinkManValues(inputValues, dataMap, rowIndex);
            }
        }
    }

    private void setLinkManValues(List inputList, Map<Object, Map<String, String>> dataMap, int rowIndex) {
        IDataModel dataModel = this.getModel();
        for (Object input : inputList) {
            Map<String, String> linkMan = dataMap.get(input.toString());
            if (linkMan != null && linkMan.size() > 0) {
                dataModel.setValue("supcontacter", (Object)linkMan.get("contactperson"), rowIndex);
                dataModel.setValue("supemail", (Object)linkMan.get("email"), rowIndex);
                dataModel.setValue("supphone", (Object)linkMan.get("phone"), rowIndex);
            } else {
                dataModel.setValue("supcontacter", null, rowIndex);
                dataModel.setValue("supemail", null, rowIndex);
                dataModel.setValue("supphone", null, rowIndex);
            }
            ++rowIndex;
        }
    }

    private HashMap<Object, Map<String, String>> queryLinkMans(Object pks, String paramType) {
        QFilter qFilter1;
        HashMap supMap = new HashMap(20);
        if ("id".equals(paramType)) {
            qFilter1 = new QFilter("supplierid", "in", pks);
        } else {
            String supNo = pks.toString().replace("[", "").replace("]", "");
            DynamicObjectCollection sups = QueryServiceHelper.query((String)"bd_supplier", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)supNo)});
            sups.forEach(sup -> supMap.put(sup.get("id"), sup.getString("number")));
            qFilter1 = new QFilter("supplierid", "in", supMap.keySet());
        }
        DynamicObjectCollection linkedMans = QueryServiceHelper.query((String)"bd_supplierlinkman", (String)"supplierid, contactperson, phone, email,isdefault_linkman", (QFilter[])new QFilter[]{qFilter1.and("isdefault_linkman", "=", (Object)"1")});
        HashMap<Object, Map<String, String>> dataMap = new HashMap<Object, Map<String, String>>();
        for (DynamicObject dyn : linkedMans) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("contactperson", (String)dyn.get("contactperson"));
            info.put("phone", (String)dyn.get("phone"));
            info.put("email", (String)dyn.get("email"));
            dataMap.put(paramType.equals("id") ? dyn.get("supplierid").toString() : supMap.get(dyn.get("supplierid")), info);
        }
        return dataMap;
    }
}

