/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.parent.AbstractMultCurrencyPlugin;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.cal.Cal4MultCurrencyObj;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.sdk.scm.quo.extpoint.IQuoInquiryVerify;

public class SouQuoteEdit
extends AbstractMultCurrencyPlugin {
    private static final int ARRAY_LENGTH = 3;
    private MultCurrencyCalImpl currCal = new MultCurrencyCalImpl();
    private Cal4MultCurrencyObj obj = new Cal4MultCurrencyObj();

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData supplierData = null;
        block8: for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = model.getEntryCurrentRowIndex(this.getEntryEntity());
            if (rowIndex >= 0 && currentRowIndex != rowIndex && this.getEntryEntity().equals(changeData.getDataEntity().getDataEntityType().getName())) {
                EntryGrid grid = (EntryGrid)this.getControl(this.getEntryEntity());
                grid.selectRows(rowIndex, true);
            }
            if (this.currCal.isNeedChange()) {
                this.currCal.needChange(false);
                this.currCal.proChanged(this.getModel(), this.getEntryEntity(), e.getProperty().getName());
                this.currCal.needChange(true);
            }
            switch (propertyName) {
                case "quotecurr": {
                    this.changeQuoteCurr(e);
                    continue block8;
                }
                case "supplier": {
                    supplierData = changeData;
                    continue block8;
                }
            }
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"supplier") && supplierData != null) {
            this.changeSupplier(supplierData);
            this.getView().updateView();
        }
    }

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    private void changeSupplier(ChangeData changeData) {
        List bills = new ArrayList<DynamicObject>(1);
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (newValue != null) {
            ArrayList<Long> supIdList = new ArrayList<Long>();
            supIdList.add(newValue.getLong("id"));
            this.getModel().getDataEntity().set("bizpartner", (Object)newValue.getDynamicObject("bizpartner"));
            QFilter qFilter = new QFilter("billno", "=", this.getModel().getValue("inquiryno"));
            DynamicObject[] inquiries = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)"billno,isautofillprice,turns,materialentry.newestturns", (QFilter[])new QFilter[]{qFilter});
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            bills.add(dataEntity);
            BillPushAssistUtil.processTurnsCountInfo((String)"sou_inquiry", (DynamicObject[])new DynamicObject[]{dataEntity}, (String)dataEntity.getString("inquiryno"), supIdList);
            Map autoBillNoMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoteAutoFillService", (String)"getAutoFillNoMap", (Object[])new Object[]{Arrays.asList(inquiries)});
            bills = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoteAutoFillService", (String)"autoFillLastPriceMap", (Object[])new Object[]{bills, autoBillNoMap, newValue.getLong("id")});
            BusinessDataServiceHelper.loadRefence((Object[])bills.toArray(), (IDataEntityType)dataEntity.getDynamicObjectType());
        }
    }

    private void changeQuoteCurr(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObject bill = this.getModel().getDataEntity(true);
        BigDecimal[] sum = this.obj.calAndGetSum(bill, this.getEntryEntity(), "exrate", "entryquotation");
        if (sum != null && sum.length == 3) {
            this.getModel().setValue("sumtax", (Object)sum[0]);
            this.getModel().setValue("sumamount", (Object)sum[1]);
            this.getModel().setValue("sumtaxamount", (Object)sum[sum.length - 1]);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contacter = (BasedataEdit)this.getControl("contacter");
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        if (contacter != null) {
            contacter.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (supplier != null) {
            supplier.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "contacter": {
                this.contacterF7Select(e);
                break;
            }
            case "supplier": {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
                this.supplierF7Select(e);
                break;
            }
        }
    }

    private void supplierF7Select(BeforeF7SelectEvent e) {
        List<Long> supplierIds;
        QFilter qFilter = new QFilter("billno", "=", this.getModel().getValue("inquiryno"));
        DynamicObject[] inquiries = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)"billno,isautofillprice,turns,supscope,entryentity.supplier,entryentity.supentrystatus,entryentity.supplierbizstatus,entryentity.canshow,entryentity.entryturns,entryentity.deadline", (QFilter[])new QFilter[]{qFilter});
        if (inquiries.length > 0 && (supplierIds = this.getAbleSupplierIds(inquiries[0])).size() > 0) {
            e.getCustomQFilters().add(new QFilter("id", "in", supplierIds));
        }
    }

    private void contacterF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplier = this.getModel().getDataEntity().getDynamicObject("supplier");
        if (supplier == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SouQuoteEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List customQFilters = e.getCustomQFilters();
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setCustomParam("isPurchaser", (Object)"true");
        long bizpartner = supplier.getLong("bizpartner_id");
        QFilter qFilter = new QFilter("bizpartner", "=", (Object)(bizpartner != 0L ? bizpartner : -1L));
        customQFilters.add(qFilter);
    }

    private List<Long> getAbleSupplierIds(DynamicObject bill) {
        if (bill == null) {
            return Collections.emptyList();
        }
        String turns = bill.getString("turns");
        String supscope = bill.getString("supscope");
        if ("1".equals(supscope) && "1".equals(turns)) {
            return Collections.emptyList();
        }
        IQuoInquiryVerify iQuoInquiryVerify = new IQuoInquiryVerify(){};
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        HashSet set = new HashSet();
        entryentity.stream().forEach(row -> set.add(row.getLong("supplier_id")));
        HashMap entryTrunsMap = new HashMap();
        iQuoInquiryVerify.getQuoMaxEntry(bill, Arrays.asList(set.toArray(new Long[0])), entryTrunsMap);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            boolean flag;
            Long aLong = (Long)iterator.next();
            DynamicObject entry = (DynamicObject)entryTrunsMap.get(String.valueOf(aLong));
            if (entry == null || !(flag = this.isRemove(entry))) continue;
            iterator.remove();
        }
        return Arrays.asList(set.toArray(new Long[0]));
    }

    private boolean isRemove(DynamicObject entry) {
        if (SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal().equals(entry.getString("supentrystatus"))) {
            return true;
        }
        Object enddate = entry.get("deadline");
        return enddate == null || TimeServiceHelper.now().after((Date)enddate);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisable();
    }

    private void setVisable() {
        DynamicObject row;
        String entrystatus;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String origin = dataEntity.getString("origin");
        String billstatus = dataEntity.getString("billstatus");
        DynamicObjectCollection materialentry = dataEntity.getDynamicObjectCollection("materialentry");
        if (materialentry.size() > 0 && "A".equals(entrystatus = (row = (DynamicObject)materialentry.get(0)).getString("entrystatus")) && "2".equals(origin) && "C".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"quoteunaudit"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operate = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("audit".equals(operate)) {
            this.setVisable();
        }
    }

    protected String getPreTag() {
        return "";
    }

    protected String getEntryEntity() {
        return "materialentry";
    }

    protected long getTargetCurr() {
        return this.getModel().getDataEntity().getLong("curr_id");
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        DynamicObject entity = this.getModel().getDataEntity();
        String turns = entity.getString("turns");
        e.setPredicate(e.getPredicate().and(rowItem -> {
            int row = rowItem.getRow();
            DynamicObject materialentry = this.getModel().getEntryRowEntity("materialentry", row);
            String newestturns = materialentry.getString("newestturns");
            return "".equals(newestturns) || StringUtils.equals((CharSequence)turns, (CharSequence)newestturns);
        }));
    }
}

