/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.datahandle.AbstractBillImportEdit;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.common.util.excel.ExcelDataEntity;

public class SouQuoteImportEdit
extends AbstractBillImportEdit {
    private static final Log log = LogFactory.getLog(SouQuoteImportEdit.class);
    private Map<String, String> mustInputProMap = null;
    private MultCurrencyCalImpl cal = new MultCurrencyCalImpl();
    public Map<String, DynamicObject> notNewPurListIdColMap = new HashMap<String, DynamicObject>(8);
    public Map<String, Integer> proScaleMap = new HashMap<String, Integer>(8);

    public String getEntryKey() {
        return "materialentry";
    }

    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        String newStr;
        String str;
        List<String> proList = this.getIsImportPros();
        IDataModel model = this.getModel();
        String taxType = model.getDataEntity().getString("taxtype");
        if ("2".equals(taxType)) {
            proList.remove("taxprice");
        } else {
            proList.remove("price");
        }
        String supCurrType = model.getDataEntity().getString("supcurrtype");
        if ("1".equals(supCurrType)) {
            proList.remove("quotecurr");
        }
        if (!proList.contains(column)) {
            return null;
        }
        boolean isBd = false;
        Object returnVal = val;
        IDataEntityProperty pro = this.findPro(column);
        if (pro instanceof BasedataProp) {
            isBd = true;
            if (pro instanceof AssistantProp) {
                Map assistantMap = (Map)this.assistantProMap.get(column);
                if (null == assistantMap) {
                    return null;
                }
                if (StringUtils.isEmpty((String)String.valueOf(val))) {
                    returnVal = null;
                } else {
                    String assistantType = (String)assistantMap.get("assistant_type");
                    String assistantKey = (String)assistantMap.get("assistant_key");
                    returnVal = this.getAssistantBdVal(column, assistantKey, Long.parseLong(assistantType), val);
                }
            } else {
                String bdKey = (String)this.bdProMap.get(column);
                if (null == bdKey) {
                    return null;
                }
                returnVal = StringUtils.isEmpty((String)String.valueOf(val)) ? null : this.getBdVal(column, bdKey, val);
            }
            if ("0".equals(String.valueOf(returnVal))) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u7cfb\u7edf\u4e2d\u6ca1\u6709\u503c\u4e3a'%2$s'\u7684\u57fa\u7840\u8d44\u6599", (String)"SouQuoteImportEdit_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName(), val));
                msg.append('\n');
            }
        } else if (pro instanceof BooleanProp) {
            if (ResManager.loadKDString((String)"\u662f", (String)"SouQuoteImportEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0]).equals(String.valueOf(val))) {
                returnVal = Boolean.TRUE;
            } else if (ResManager.loadKDString((String)"\u5426", (String)"SouQuoteImportEdit_2", (String)"scm-sou-formplugin", (Object[])new Object[0]).equals(String.valueOf(val))) {
                returnVal = Boolean.FALSE;
            } else {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u662f\u5e03\u5c14\u7c7b\u578b\uff0c\u53ea\u80fd\u8f93\u5165\u662f\u6216\u8005\u5426", (String)"SouQuoteImportEdit_3", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                msg.append('\n');
            }
        } else if (pro instanceof DecimalProp) {
            String decimalValStr = val != null && String.valueOf(val).trim().length() > 0 ? String.valueOf(val) : "0";
            try {
                BigDecimal decimalVal = new BigDecimal(decimalValStr);
                if (pro instanceof PriceProp) {
                    if (decimalVal.compareTo(BigDecimal.ZERO) < 0) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"SouQuoteImportEdit_4", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                        msg.append('\n');
                    } else {
                        BigDecimal decimal;
                        int priceprecision = this.getScale(null, column, index);
                        String[] split = decimalValStr.split("\\.");
                        if (split.length == 2 && (decimal = new BigDecimal(split[1])).compareTo(BigDecimal.ZERO) > 0 && split[1].length() > priceprecision) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u4e0d\u80fd\u8d85\u8fc7%2$s\u4f4d\u5c0f\u6570", (String)"SouQuoteImportEdit_5", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName(), priceprecision));
                            msg.append('\n');
                        }
                    }
                } else if (pro instanceof AmountProp) {
                    // empty if block
                }
                returnVal = decimalVal;
            }
            catch (NumberFormatException e) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u5c0f\u6570\u683c\u5f0f", (String)"SouQuoteImportEdit_6", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                msg.append('\n');
                log.error("\u5bfc\u5165\u5931\u8d25\uff1a\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u5c0f\u6570\u683c\u5f0f", (Throwable)e);
            }
        } else if (pro instanceof DateProp) {
            if (val != null && String.valueOf(val).trim().length() > 0) {
                str = String.valueOf(val).trim();
                newStr = str.replace('.', '-').replace('|', '-').replace('/', '-');
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                df.setLenient(false);
                try {
                    returnVal = df.parse(newStr);
                }
                catch (ParseException e) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u662f\u5408\u6cd5\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u683c\u5f0f\u5982\u4e0b\uff1ayyyy-MM-dd", (String)"SouQuoteImportEdit_7", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                    msg.append('\n');
                    returnVal = null;
                    log.error("\u5bfc\u5165\u5931\u8d25\uff1a\u5c5e\u6027{}\u6570\u636e\u683c\u5f0f\u4e0d\u662f\u5408\u6cd5\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u683c\u5f0f\u5982\u4e0b\uff1ayyyy-MM-dd", (Object)pro.getDisplayName(), (Object)e);
                }
            } else {
                returnVal = null;
            }
        } else if (pro instanceof DateTimeProp) {
            if (val != null && String.valueOf(val).trim().length() > 0) {
                str = String.valueOf(val).trim();
                newStr = str.replace('.', '-').replace('|', '-').replace('/', '-');
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                df.setLenient(false);
                try {
                    returnVal = df.parse(newStr);
                }
                catch (ParseException e) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u662f\u5408\u6cd5\u7684\u957f\u65e5\u671f\u683c\u5f0f\uff0c\u683c\u5f0f\u5982\u4e0b\uff1ayyyy-MM-dd HH:mm:ss", (String)"SouQuoteImportEdit_8", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                    msg.append('\n');
                    returnVal = null;
                    log.error("\u5bfc\u5165\u5931\u8d25\uff1a\u5c5e\u6027{}\u6570\u636e\u683c\u5f0f\u4e0d\u662f\u5408\u6cd5\u7684\u957f\u65e5\u671f\u683c\u5f0f\uff0c\u683c\u5f0f\u5982\u4e0b\uff1ayyyy-MM-dd HH:mm:ss", (Object)pro.getDisplayName(), (Object)e);
                }
            } else {
                returnVal = null;
            }
        }
        if (null == returnVal) {
            Map<String, String> mustInputProMap = this.getMustInputProMap();
            if (null != mustInputProMap.get(column) && msg.length() == 0) {
                IDataEntityProperty prop = this.getModel().getDataEntityType().findProperty(column);
                if (null != prop) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (String)"SouQuoteImportEdit_9", (String)"scm-sou-formplugin", (Object[])new Object[0]), pro.getDisplayName())).append('\n');
                }
            } else if (isBd) {
                returnVal = 0L;
            }
        }
        return returnVal;
    }

    protected void addComment(Map<String, String> commentMap) {
        super.addComment(commentMap);
        commentMap.put("taxrateid", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7a0e\u7387\u503c\uff0c\u793a\u4f8b\uff1a \u7a0e\u738713%\uff0c\u586b\u519913", (String)"SouQuoteImportEdit_10", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        commentMap.put("quotecurr", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e01\u522b\u7f16\u7801\uff0c\u793a\u4f8b\uff1aCNY/USD/HKD", (String)"SouQuoteImportEdit_11", (String)"scm-sou-formplugin", (Object[])new Object[0]));
    }

    public Map<String, String> getMustInputProMap() {
        if (null == this.mustInputProMap) {
            this.mustInputProMap = new HashMap<String, String>(1);
            this.mustInputProMap = this.getMustInputValByTemplate();
            StringBuilder proKey = new StringBuilder();
            proKey.append(this.getEntryKey());
            proKey.append('.');
            proKey.append(this.getUnEditablePriceProByTaxType());
            this.mustInputProMap.remove(proKey.toString());
        }
        return this.mustInputProMap;
    }

    private Map<String, String> getMustInputValByTemplate() {
        HashMap<String, String> mustInputValMap = new HashMap<String, String>(8);
        QFilter filter = new QFilter("templatetype", "=", (Object)"IMPT_ENTRY");
        filter.and("bizobject", "=", (Object)"sou_quote");
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bos_importentry_template", (String)"id,treeentryentity.entitynumber entitynumber,treeentryentity.ismustinput ismustinput", (QFilter[])filter.toArray());
        if (templates.isEmpty()) {
            return mustInputValMap;
        }
        for (DynamicObject template : templates) {
            if (!template.getBoolean("ismustinput")) continue;
            String entityNumber = template.getString("entitynumber");
            IDataModel model = this.getModel();
            String entityName = ((IDataEntityProperty)((DynamicObject)model.getEntryEntity("materialentry").get(0)).getDataEntityType().getProperties().get((Object)entityNumber)).getDisplayName().getLocaleValue_zh_CN();
            mustInputValMap.put(entityNumber, entityName);
        }
        return mustInputValMap;
    }

    private String getUnEditablePriceProByTaxType() {
        String taxType = this.getModel().getDataEntity().getString("taxtype");
        StringBuilder proKey = new StringBuilder();
        if ("2".equals(taxType)) {
            proKey.append("taxprice");
        } else {
            proKey.append("price");
        }
        return proKey.toString();
    }

    protected boolean isAddNew() {
        return false;
    }

    private List<String> getIsImportPros() {
        ArrayList<String> proList = new ArrayList<String>();
        QFilter filter = new QFilter("templatetype", "=", (Object)"IMPT_ENTRY");
        filter.and("bizobject", "=", (Object)"sou_quote");
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bos_importentry_template", (String)"id,treeentryentity.entitynumber entitynumber,treeentryentity.isimport isimport", (QFilter[])filter.toArray());
        if (templates.isEmpty()) {
            return proList;
        }
        for (DynamicObject template : templates) {
            if (!template.getBoolean("isimport")) continue;
            proList.add(template.getString("entitynumber"));
        }
        return proList;
    }

    protected void afterImport() {
        super.afterImport();
        EntryGrid grid = (EntryGrid)this.getControl(this.getEntryKey());
        try {
            IDataModel model = this.getModel();
            String calPro = this.getCalPro();
            int rowCount = model.getEntryRowCount(this.getEntryKey());
            for (int i = 0; i < rowCount; ++i) {
                grid.selectRows(i, true);
                this.cal.proChanged(this.getModel(), this.getEntryKey(), calPro);
            }
        }
        catch (Exception e) {
            BizLog.log((String)("after import error:" + e.getMessage()));
        }
        this.notNewPurListIdColMap.clear();
    }

    protected String getGroupVal(DynamicObject col, String pro) {
        if ("entryid".equals(pro)) {
            return String.valueOf(col.get("id"));
        }
        return super.getGroupVal(col, pro);
    }

    private String getCalPro() {
        IDataModel model = this.getModel();
        String taxType = model.getDataEntity().getString("taxtype");
        String calPro = "";
        calPro = "2".equals(taxType) ? "price" : "taxprice";
        return calPro;
    }

    protected void addUniqueColumn(List<String> uniqueColumnList) {
        super.addUniqueColumn(uniqueColumnList);
        uniqueColumnList.add("entryid");
    }

    protected Object getBdVal(String column, String bdKey, Object val) {
        if (column.equals("taxrateid")) {
            return this.getTaxItem(val, bdKey);
        }
        if (column.equals("quotecurr")) {
            return this.getCurrItem(val, bdKey);
        }
        return super.getBdVal(column, bdKey, val);
    }

    private Object getCurrItem(Object val, String bdKey) {
        Object currItemId = 0L;
        QFilter filter = new QFilter("number", "=", val);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject obj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null != obj) {
            currItemId = obj.get("id");
        }
        return currItemId;
    }

    private Object getTaxItem(Object val, String bdKey) {
        Object taxItemId = 0L;
        try {
            val = new BigDecimal(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            log.error("\u83b7\u53d6\u7a0e\u7387\u5f02\u5e38", (Throwable)e);
            return taxItemId;
        }
        IDataModel model = this.getModel();
        Date billDate = (Date)model.getValue("billdate");
        QFilter activeQfilter = new QFilter("activedate", "<=", (Object)billDate);
        QFilter expQfilter = new QFilter("expdate", ">", (Object)billDate);
        expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
        QFilter dataQFilter = expQfilter.and(activeQfilter);
        QFilter filter = new QFilter("taxrate", "=", val);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(dataQFilter);
        DynamicObject obj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null != obj) {
            taxItemId = obj.get("id");
        }
        return taxItemId;
    }

    protected void setColumn(ExcelDataEntity excelData) {
        super.setColumn(excelData);
        ArrayList<String> isExportProList = new ArrayList<String>(excelData.getColumnKeyList());
        isExportProList.add("entryid");
        isExportProList.add("materialmodel");
        excelData.setColumnKeyList(isExportProList);
        this.removeUnValidColumnKey(excelData);
    }

    public Object getRowVal(DynamicObject col, String column, int index) {
        Object val = "";
        Object columnVal = null;
        if ("entryid".equals(column)) {
            val = col.getLong("id");
        } else if ("materialmodel".equals(column)) {
            DynamicObject material = col.getDynamicObject("material");
            if (null == material) {
                return "";
            }
            val = material.get("modelnum");
        } else {
            try {
                columnVal = col.get(column);
            }
            catch (Exception e) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u503c\u5931\u8d25\uff1a%1$s", (String)"SouQuoteImportEdit_12", (String)"scm-sou-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (columnVal == null) {
                val = "";
            } else if (null != columnVal && columnVal instanceof DynamicObject) {
                if (column.equals("taxrateid")) {
                    val = ((DynamicObject)columnVal).getBigDecimal("taxrate");
                    val = ((BigDecimal)val).stripTrailingZeros().toPlainString();
                } else {
                    val = ((DynamicObject)columnVal).get(this.getBdPro(column));
                }
            } else {
                IDataEntityProperty pro;
                val = columnVal instanceof BigDecimal ? (((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : ((BigDecimal)columnVal).setScale(this.getScale(col, column, index), RoundingMode.HALF_UP)) : (columnVal instanceof Boolean ? (((Boolean)columnVal).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"SouQuoteImportEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SouQuoteImportEdit_2", (String)"scm-sou-formplugin", (Object[])new Object[0])) : (columnVal instanceof Date ? ((pro = this.findPro(column)) instanceof DateTimeProp ? ((DateTimeProp)pro).getDateFormat().format(columnVal) : DateUtil.date2str((Date)((Date)columnVal), (String)"yyyy-MM-dd")) : columnVal));
            }
        }
        return val;
    }

    public int getScale(DynamicObject col, String column, int rowIndex) {
        DynamicObject currency;
        Integer cacheScale = this.proScaleMap.get(column);
        if (null != cacheScale) {
            return cacheScale;
        }
        int scale = 6;
        IDataEntityProperty pro = this.findPro(column);
        if (pro instanceof PriceProp) {
            DynamicObject currency2 = this.getCurrency(rowIndex);
            if (Objects.nonNull(currency2)) {
                scale = currency2.getInt("priceprecision");
            }
        } else if (pro instanceof AmountProp && Objects.nonNull(currency = this.getCurrency(rowIndex))) {
            scale = currency.getInt("amtprecision");
        }
        this.proScaleMap.put(column, scale);
        return scale;
    }

    protected void removeUnValidColumnKey(ExcelDataEntity excelData) {
        IDataModel model = this.getModel();
        ArrayList<String> needRemoveColumn = new ArrayList<String>(32);
        for (int i = 0; i < excelData.getColumnKeyList().size(); ++i) {
            DynamicProperty pro;
            String column = (String)excelData.getColumnKeyList().get(i);
            if ("entryid".equals(column) || "materialmodel".equals(column) || null != (pro = (DynamicProperty)model.getDataEntityType().findProperty(column))) continue;
            needRemoveColumn.add(column);
        }
        needRemoveColumn.add("entryquotation");
        needRemoveColumn.add("amount");
        needRemoveColumn.add("taxrate");
        needRemoveColumn.add("tax");
        needRemoveColumn.add("taxamount");
        needRemoveColumn.add("result");
        needRemoveColumn.add("cfmqty");
        needRemoveColumn.add("cfmtaxrate");
        needRemoveColumn.add("cfmprice");
        needRemoveColumn.add("cfmtaxprice");
        needRemoveColumn.add("cfmtaxrateid");
        needRemoveColumn.add("cfmnote");
        needRemoveColumn.add("entrystatus");
        needRemoveColumn.add("entryreqorg");
        needRemoveColumn.add("exrate");
        needRemoveColumn.add("entrydelidate");
        needRemoveColumn.add("newestturns");
        needRemoveColumn.add("sumcompareqty");
        if (needRemoveColumn.size() == 0) {
            return;
        }
        List<Object> newColumnKeyList = new ArrayList(excelData.getColumnKeyList());
        newColumnKeyList.removeAll(needRemoveColumn);
        newColumnKeyList = newColumnKeyList.stream().distinct().collect(Collectors.toList());
        excelData.setColumnKeyList(newColumnKeyList);
    }

    protected void groupEntryData(Map<String, DynamicObject> uniqueColumnColMap, Map<String, Integer> columnIndexMap) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(this.getEntryKey());
        ArrayList<Integer> turnsrList = new ArrayList<Integer>();
        for (DynamicObject row : rows) {
            turnsrList.add(Integer.valueOf(row.getString("newestturns")));
        }
        Integer maxTurns = (Integer)Collections.max(turnsrList);
        List uniqueColumnList = this.getUniqueColumnList();
        int rowIndex = 0;
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
        for (DynamicObject col : cols) {
            Integer newestturns = Integer.valueOf(col.getString("newestturns"));
            if (newestturns.equals(maxTurns)) {
                String valStr = this.getGroupVal(col, uniqueColumnList);
                uniqueColumnColMap.put(valStr, col);
                columnIndexMap.put(valStr, rowIndex);
            }
            ++rowIndex;
        }
    }

    protected void setExcelHeader(ExcelDataEntity excelDataEntity, IDataModel model) throws IOException {
        ArrayList<String> columnTitleList = new ArrayList<String>();
        Integer rowCount = 0;
        ArrayList<Integer> mustInputIndexList = new ArrayList<Integer>();
        for (int i = 0; i < excelDataEntity.getColumnKeyList().size(); ++i) {
            Integer n;
            Integer n2;
            String column = (String)excelDataEntity.getColumnKeyList().get(i);
            DynamicProperty pro = (DynamicProperty)model.getDataEntityType().findProperty(column);
            StringBuilder headTitileSb = new StringBuilder();
            if (null != pro) {
                String taxType = model.getDataEntity().getString("taxtype");
                if (("1".equals(taxType) || "3".equals(taxType)) && "taxprice".equals(column)) {
                    headTitileSb.append('*');
                    mustInputIndexList.add(rowCount);
                }
                if ("2".equals(taxType) && "price".equals(column)) {
                    headTitileSb.append('*');
                    mustInputIndexList.add(rowCount);
                }
                if ("taxrateid".equals(column)) {
                    mustInputIndexList.add(rowCount);
                }
                headTitileSb.append(pro.getDisplayName());
                if (excelDataEntity.isAddColumnKeyToHeader()) {
                    headTitileSb.append("${").append(column).append('}');
                }
                columnTitleList.add(headTitileSb.toString());
                n2 = rowCount;
                Integer n3 = rowCount = Integer.valueOf(rowCount + 1);
                continue;
            }
            if (column.equals("entryid")) {
                headTitileSb.append(ResManager.loadKDString((String)"*(\u52ff\u6539\u52ff\u5220)", (String)"SouQuoteImportEdit_13", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                mustInputIndexList.add(rowCount);
                headTitileSb.append(ResManager.loadKDString((String)"\u62a5\u4ef7\u5355\u5206\u5f55ID", (String)"SouQuoteImportEdit_14", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                if (excelDataEntity.isAddColumnKeyToHeader()) {
                    headTitileSb.append("${").append(column).append('}');
                }
                columnTitleList.add(headTitileSb.toString());
                n = rowCount;
                n2 = rowCount = Integer.valueOf(rowCount + 1);
                continue;
            }
            if (!column.equals("materialmodel")) continue;
            headTitileSb.append(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"SouQuoteImportEdit_15", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            if (excelDataEntity.isAddColumnKeyToHeader()) {
                headTitileSb.append("${").append(column).append('}');
            }
            columnTitleList.add(headTitileSb.toString());
            n = rowCount;
            n2 = rowCount = Integer.valueOf(rowCount + 1);
        }
        excelDataEntity.setExcelHeader(columnTitleList);
        this.setColumnTitleColor(excelDataEntity, mustInputIndexList);
    }
}

