/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.HtmlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.pds.common.util.PdsNoticeTplUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class SouQuoteInfoDetailPlugin
extends AbstractFormPlugin {
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String DOLLAR = "$";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object billId = formShowParameter.getCustomParams().get("billId");
        String inquiryno = (String)formShowParameter.getCustomParams().get("inquiryno");
        String content = this.decorateContent(billId, inquiryno);
        this.getPageCache().put("billId", billId.toString());
        this.getPageCache().put("inquiryno", inquiryno);
        RichTextEditor richText = (RichTextEditor)this.getControl("richtexteditorap");
        richText.setText(content);
        this.getView().updateView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("displaymode".equals(fieldKey)) {
            String billId = this.getPageCache().get("billId");
            String inquiryno = this.getPageCache().get("inquiryno");
            String content = this.decorateContent(Long.parseLong(billId), inquiryno);
            RichTextEditor richText = (RichTextEditor)this.getControl("richtexteditorap");
            richText.setText(content);
            this.getView().updateView();
        }
    }

    private String decorateContent(Object billId, String inquiryNo) {
        String template = this.getTemplate();
        if (StringUtils.isNotBlank((CharSequence)template)) {
            Set entityKeys = PdsNoticeTplUtil.getEntityKeySetByTpl((String)template);
            Map<String, Set<String>> entityPropertyMap = this.getEntityPropertyMap(template, entityKeys, false);
            if (billId != null && inquiryNo != null) {
                Set<String> comparePropertys = entityPropertyMap.get("sou_compare");
                if (comparePropertys == null) {
                    return template;
                }
                comparePropertys.add("inquiryno");
                comparePropertys.add("curr");
                comparePropertys.add("org");
                comparePropertys.add("materialentry.srcentryid");
                comparePropertys.add("materialentry.material.id");
                comparePropertys.add("curr.priceprecision");
                comparePropertys.add("materialentry.hisminprice");
                comparePropertys.add("materialentry.dctrate");
                comparePropertys.add("materialentry.taxrate");
                comparePropertys.add("materialentry.material");
                comparePropertys.add("materialentry.exrate");
                comparePropertys.add("materialentry.entryquotation");
                DynamicObjectCollection souCompareBill = QueryServiceHelper.query((String)"sou_compare", (String)StringUtils.join((Object[])comparePropertys.toArray(), (String)","), (QFilter[])new QFilter[]{new QFilter("id", "=", billId)});
                if (souCompareBill == null || souCompareBill.isEmpty()) {
                    return template;
                }
                HashMap<String, String> inquryMap = new HashMap<String, String>();
                HashMap<String, Map<Long, List<DynamicObject>>> entryQuoteInfoMap = new HashMap<String, Map<Long, List<DynamicObject>>>();
                Document document = Jsoup.parse((String)template);
                HashMap<String, DynamicObject> lowestQuoteMap = new HashMap<String, DynamicObject>();
                Map<String, String> valuePprecisionMap = this.prevParseTemplate(document, inquiryNo, entityPropertyMap, entryQuoteInfoMap, inquryMap, lowestQuoteMap, souCompareBill);
                List<Map<String, Object>> resultList = this.combineInfo(souCompareBill, entryQuoteInfoMap, inquryMap, entityPropertyMap, lowestQuoteMap);
                if (document != null) {
                    int i = 0;
                    Elements table = document.select("table");
                    for (Element element : table) {
                        Object value1;
                        Elements tr = element.select("tr");
                        Element forthRow = element.getElementById("valuerow");
                        if (tr != null && tr.size() > 0 && forthRow != null) {
                            for (Map<String, Object> map : resultList) {
                                if (map.containsKey("issummap")) continue;
                                Element clone = forthRow.clone();
                                if (i % 2 == 0) {
                                    String style = clone.attr("style");
                                    style = style + "background-color:#F5F5F5;";
                                    clone.attr("style", style);
                                }
                                ++i;
                                String rex = clone.outerHtml();
                                Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
                                String replace = rex;
                                while (iterator.hasNext()) {
                                    Map.Entry<String, Object> next = iterator.next();
                                    if (!replace.contains(next.getKey())) continue;
                                    String value = valuePprecisionMap.get(next.getKey());
                                    value1 = next.getValue();
                                    if (StringUtils.isNotBlank((CharSequence)value)) {
                                        Object precisition = map.get(value);
                                        if (value1 instanceof BigDecimal && precisition instanceof Integer) {
                                            value1 = ((BigDecimal)value1).setScale((int)((Integer)precisition), RoundingMode.HALF_UP);
                                        }
                                    }
                                    replace = replace.replace(next.getKey(), next.getValue() == null ? "" : StringEscapeUtils.escapeHtml((String)String.valueOf(value1)));
                                }
                                forthRow.after(replace);
                            }
                            forthRow.remove();
                        }
                        Element sumrow = element.getElementById("sumrow");
                        if (tr == null || tr.size() <= 0 || sumrow == null) continue;
                        for (Map<String, Object> map : resultList) {
                            if (!map.containsKey("issummap")) continue;
                            Element clone = sumrow.clone();
                            String rex = clone.outerHtml();
                            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
                            String replace = rex;
                            while (iterator.hasNext()) {
                                Map.Entry<String, Object> next = iterator.next();
                                if (!replace.contains(next.getKey())) continue;
                                value1 = next.getValue();
                                if (value1 instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value1) == 0) {
                                    value1 = "";
                                }
                                replace = replace.replace(next.getKey(), next.getValue() == null ? "" : StringEscapeUtils.escapeHtml((String)String.valueOf(value1)));
                            }
                            sumrow.after(replace);
                        }
                        sumrow.remove();
                    }
                    return document.outerHtml();
                }
            }
        }
        return "";
    }

    private Map<String, String> prevParseTemplate(Document document, String inquiryNo, Map<String, Set<String>> entityPropertyMap, Map<String, Map<Long, List<DynamicObject>>> entryQuoteInfoMap, Map<String, String> inquryMap, Map<String, DynamicObject> lowestQuoteMap, DynamicObjectCollection compareBill) {
        Set<String> quotePropertys = entityPropertyMap.get("sou_quote");
        quotePropertys.add("supplier.id");
        quotePropertys.add("supplier.name");
        quotePropertys.add("materialentry.quoturns");
        quotePropertys.add("materialentry.amount");
        quotePropertys.add("materialentry.price");
        quotePropertys.add("materialentry.id");
        quotePropertys.add("materialentry.srcentryid");
        quotePropertys.add("materialentry.material.id");
        quotePropertys.add("materialentry.exrate");
        quotePropertys.add("materialentry.entryquotation");
        quotePropertys.add("materialentry.entrystatus");
        quotePropertys.add("materialentry.quotecurr.priceprecision");
        quotePropertys.add("materialentry.quotecurr.amtprecision");
        quotePropertys.add("turns");
        HashMap<String, String> valuePrecisionMap = new HashMap<String, String>(1);
        QFilter qFilter = new QFilter("inquiryno", "=", (Object)inquiryNo);
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection quoteInfos = QueryServiceHelper.query((String)"sou_quote", (String)StringUtils.join((Object[])quotePropertys.toArray(), (String)","), (QFilter[])new QFilter[]{qFilter}, (String)"supplier.id desc,turns asc,auditdate desc");
        HashMap<Long, String> supplierNameMap = new HashMap<Long, String>();
        HashMap<Long, Set<String>> supplierCount = new HashMap<Long, Set<String>>();
        HashMap<Long, Set<String>> dumpQuote = new HashMap<Long, Set<String>>();
        int colSpan = 0;
        int currprecision = this.getCurrprecision(compareBill);
        for (DynamicObject quoteInfo : quoteInfos) {
            BigDecimal price;
            String quotation;
            long supplierId = quoteInfo.getLong("supplier.id");
            supplierNameMap.put(supplierId, quoteInfo.getString("supplier.name"));
            String srcEntryId = quoteInfo.getString("materialentry.srcentryid");
            Set quoteTurns = this.getOrCreateSet(supplierCount, supplierId);
            Set quoEntryIdSet = this.getOrCreateSet(dumpQuote, supplierId);
            String dumpKey = srcEntryId + "-" + quoteInfo.getString("turns");
            if (quoEntryIdSet.contains(dumpKey)) continue;
            quoEntryIdSet.add(dumpKey);
            if (!quoteTurns.contains(quoteInfo.getString("turns"))) {
                ++colSpan;
            }
            quoteTurns.add(quoteInfo.getString("turns"));
            inquryMap.put(quoteInfo.getString("materialentry.id"), srcEntryId);
            this.groupQuoteInfo(srcEntryId, supplierId, entryQuoteInfoMap, quoteInfo);
            if (!"A".equals(quoteInfo.getString("materialentry.entrystatus"))) continue;
            BigDecimal exrate = quoteInfo.getBigDecimal("materialentry.exrate");
            if (null == exrate || exrate.compareTo(BigDecimal.ZERO) == 0) {
                exrate = BigDecimal.ONE;
            }
            if ((quotation = quoteInfo.getString("materialentry.entryquotation")) == null || quotation.isEmpty()) {
                quotation = "0";
            }
            int pricescale = quoteInfo.getInt("materialentry.quotecurr.priceprecision");
            if (this.isshowInTax()) {
                price = MultCurrencyCalImpl.convertByExrate((BigDecimal)quoteInfo.getBigDecimal("materialentry.taxprice"), (BigDecimal)exrate, (int)currprecision, (String)quotation);
                quoteInfo.set("materialentry.taxprice", (Object)price);
            } else {
                price = MultCurrencyCalImpl.convertByExrate((BigDecimal)quoteInfo.getBigDecimal("materialentry.price"), (BigDecimal)exrate, (int)currprecision, (String)quotation);
                quoteInfo.set("materialentry.price", (Object)price);
            }
            String materialId = quoteInfo.getString("materialentry.material.id");
            DynamicObject quoteData = lowestQuoteMap.get(materialId);
            if (quoteData == null) {
                lowestQuoteMap.put(materialId, quoteInfo);
                continue;
            }
            BigDecimal oldtaxprice = this.isshowInTax() ? quoteData.getBigDecimal("materialentry.taxprice") : quoteData.getBigDecimal("materialentry.price");
            if (price.compareTo(oldtaxprice) >= 0) continue;
            lowestQuoteMap.put(materialId, quoteInfo);
        }
        Elements table = document.select("table");
        HashSet<String> priceInfoSet = new HashSet<String>(1024);
        HashSet quoteValueInfos = null;
        for (Element element : table) {
            Elements tr = element.select("tr");
            Element supplierlist = element.getElementById("supplierlist");
            Element forthRow = element.getElementById("valuerow");
            if (tr == null || tr.size() <= 0 || supplierlist == null) continue;
            this.dealColSpan(supplierlist, colSpan);
            priceInfoSet.add("sou_quote");
            priceInfoSet.add("sou_compare");
            Map<String, Set<String>> quoteInfoTdId = this.getEntityPropertyMap(forthRow.outerHtml(), priceInfoSet, true);
            quoteValueInfos = new HashSet();
            Iterator<Map.Entry<String, Set<String>>> iterator1 = quoteInfoTdId.entrySet().iterator();
            Set<String> quotePropertySets = quoteInfoTdId.get("sou_quote");
            while (iterator1.hasNext()) {
                Map.Entry<String, Set<String>> next = iterator1.next();
                quoteValueInfos.addAll(next.getValue());
            }
            ArrayList<Element> quoteTds = new ArrayList<Element>(1);
            if (quoteValueInfos != null) {
                for (String quoteValueInfo : quoteValueInfos) {
                    Element elementById = element.getElementById(quoteValueInfo);
                    if (elementById == null) continue;
                    quoteTds.add(elementById);
                }
            }
            Element suppliername = element.getElementById("suppliername");
            Element quoteprice = element.getElementById("quoteprice");
            Element quotetaxprice = element.getElementById("quotetaxprice");
            Element emptyvalue = element.getElementById("emptyvalue");
            Element sumquote = element.getElementById("sumquote");
            Element quotenum = element.getElementById("quotenum");
            if (suppliername == null) continue;
            Iterator iterator = supplierCount.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Element supplierName = suppliername.clone();
                supplierName.removeAttr("id");
                this.dealColSpan(supplierName, ((Set)next.getValue()).size());
                String supplierValue = (String)supplierNameMap.get(next.getKey());
                supplierName = this.replaceSpanText(supplierName, "{supplier}", supplierValue);
                suppliername.parent().appendChild((Node)supplierName);
                Set value = (Set)next.getValue();
                String[] objects = value.toArray(new String[0]);
                if (quoteTds == null || quoteTds.size() <= 0) continue;
                for (String quoteNumValue : objects) {
                    ++count;
                    Element quotenumClon = quotenum.clone();
                    quotenumClon.removeAttr("id");
                    quotenumClon = this.replaceSpanText(quotenumClon, "{turns}", quoteNumValue);
                    quotenum.parent().appendChild((Node)quotenumClon);
                    Iterator iterator2 = quoteTds.iterator();
                    if (count > 1) {
                        // empty if block
                    }
                    Element quotepriceclone = quoteprice.clone();
                    Element quotetaxpriceclone = quotetaxprice.clone();
                    Element emptyvalueclone = emptyvalue.clone();
                    Element sumquoteclone = sumquote.clone();
                    sumquoteclone = this.replaceSpanText(sumquoteclone, LEFT_BRACE, LEFT_BRACE + next.getKey());
                    sumquoteclone = this.replaceSpanText(sumquoteclone, RIGHT_BRACE, quoteNumValue + RIGHT_BRACE);
                    quoteprice.parent().appendChild((Node)quotepriceclone);
                    quotepriceclone.parent().appendChild((Node)quotetaxpriceclone);
                    emptyvalue.parent().appendChild((Node)emptyvalueclone);
                    sumquote.parent().appendChild((Node)sumquoteclone);
                    while (iterator2.hasNext()) {
                        String replace;
                        String[] classInfos;
                        String[] entrys;
                        Element quoteTd = (Element)iterator2.next();
                        if (quoteTd == null) continue;
                        Element priceClone = quoteTd.clone();
                        String property = priceClone.attr("id");
                        priceClone.removeAttr("id");
                        if (!StringUtils.isNotBlank((CharSequence)property) || (entrys = property.split("\\$")).length <= 1) continue;
                        String aClass = priceClone.attr("class");
                        if (StringUtils.isNotBlank((CharSequence)aClass) && (classInfos = (replace = aClass.replace(LEFT_BRACE, "").replace(RIGHT_BRACE, "")).split("\\$")).length > 1) {
                            if (!quotePropertySets.contains(replace)) {
                                valuePrecisionMap.put(LEFT_BRACE + property + RIGHT_BRACE, priceClone.attr("class"));
                                quoteTd.removeAttr("id");
                                iterator2.remove();
                                continue;
                            }
                            priceClone.attr("class", LEFT_BRACE + next.getKey() + classInfos[1] + quoteNumValue + RIGHT_BRACE);
                            valuePrecisionMap.put(LEFT_BRACE + next.getKey() + entrys[1] + quoteNumValue + RIGHT_BRACE, priceClone.attr("class"));
                        }
                        priceClone = this.replaceSpanText(priceClone, LEFT_BRACE + entrys[0] + DOLLAR, LEFT_BRACE + next.getKey());
                        priceClone = this.replaceSpanText(priceClone, RIGHT_BRACE, quoteNumValue + RIGHT_BRACE);
                        quoteTd.parent().appendChild((Node)priceClone);
                    }
                }
            }
            quoteprice.remove();
            quotetaxprice.remove();
            emptyvalue.remove();
            sumquote.remove();
            suppliername.remove();
            quotenum.remove();
            for (Element quoteTd : quoteTds) {
                if (quoteTd == null) continue;
                quoteTd.remove();
            }
        }
        return valuePrecisionMap;
    }

    private int getCurrprecision(DynamicObjectCollection compareBill) {
        int precision = 6;
        DynamicObject compare = (DynamicObject)compareBill.get(0);
        if (compare == null) {
            return precision;
        }
        return compare.getInt("curr.priceprecision");
    }

    private Element replaceSpanText(Element element, String oldValue, String value) {
        Elements spans = element.select("span");
        ArrayList<Element> elements = new ArrayList<Element>(1);
        value = value == null ? "" : value;
        String string = oldValue = oldValue == null ? "" : oldValue;
        if (spans == null) {
            elements.add(element);
            return element;
        }
        elements.addAll((Collection<Element>)spans);
        for (Element el : elements) {
            if (el == null || el.text() == null) continue;
            String replace = el.text().replace(oldValue, value);
            el.text(replace);
        }
        return element;
    }

    private void groupQuoteInfo(String srcEntryId, long supplierId, Map<String, Map<Long, List<DynamicObject>>> entryQuoteInfoMap, DynamicObject quoteInfo) {
        List<DynamicObject> dynamicObjects;
        Map<Long, List<DynamicObject>> supplierQuoteInfoMap = entryQuoteInfoMap.get(srcEntryId);
        if (supplierQuoteInfoMap == null) {
            supplierQuoteInfoMap = new HashMap<Long, List<DynamicObject>>(1);
            entryQuoteInfoMap.put(srcEntryId, supplierQuoteInfoMap);
        }
        if ((dynamicObjects = supplierQuoteInfoMap.get(supplierId)) == null) {
            dynamicObjects = new ArrayList<DynamicObject>(1);
            supplierQuoteInfoMap.put(supplierId, dynamicObjects);
        }
        dynamicObjects.add(quoteInfo);
    }

    private void dealColSpan(Element el, int num) {
        String colspan = el.attr("colspan");
        Integer col = 1;
        if (StringUtils.isNotBlank((CharSequence)colspan)) {
            col = Integer.valueOf(colspan);
        }
        el.attr("colspan", String.valueOf(num * col));
    }

    private Set getOrCreateSet(Map<Long, Set<String>> storeMap, Long infoKey) {
        Set<String> setInfo = storeMap.get(infoKey);
        if (setInfo == null) {
            setInfo = new LinkedHashSet<String>();
            storeMap.put(infoKey, setInfo);
        }
        return setInfo;
    }

    private Map<String, Set<String>> getEntityPropertyMap(String template, Set<String> entityKeys, boolean isFullText) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(16);
        if (template != null && !"".equals(template)) {
            String regex = "\\{[^}]*\\}";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(template);
            while (m.find()) {
                String g = m.group();
                String fieldContext = g.substring(1, g.length() - 1);
                String[] proTexts = fieldContext.split("\\$");
                if (entityKeys == null || !entityKeys.contains(proTexts[0])) continue;
                LinkedHashSet<String> propertySets = (LinkedHashSet<String>)resultMap.get(proTexts[0]);
                if (propertySets == null) {
                    propertySets = new LinkedHashSet<String>();
                    resultMap.put(proTexts[0], propertySets);
                }
                if (proTexts.length > 1 && !isFullText) {
                    propertySets.add(proTexts[1]);
                    continue;
                }
                if (!isFullText) continue;
                propertySets.add(fieldContext);
            }
        }
        return resultMap;
    }

    private String getTemplate() {
        FormMetadata quoteMetaData = MetaDataUtil.getFormMetaData((String)"sou_quoteinfo_detail");
        List items = quoteMetaData.getItems();
        String displaymode = (String)this.getModel().getValue("displaymode");
        String template = "";
        for (ControlAp item : items) {
            if ("htmlap".equals(item.getKey()) && "1".equals(displaymode)) {
                template = ((HtmlAp)item).getHtmlContent();
                break;
            }
            if (!"htmlap1".equals(item.getKey()) || !"2".equals(displaymode)) continue;
            template = ((HtmlAp)item).getHtmlContent();
            break;
        }
        return template;
    }

    private List<Map<String, Object>> combineInfo(DynamicObjectCollection souCompareBill, Map<String, Map<Long, List<DynamicObject>>> entryQuoteInfoMap, Map<String, String> inquryMap, Map<String, Set<String>> entityPropertyMap, Map<String, DynamicObject> lowestQuoteMap) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(souCompareBill.size());
        Set<String> propertys = entityPropertyMap.get("sou_compare");
        Set<String> quotePropertys = entityPropertyMap.get("sou_quote");
        DataEntityPropertyCollection properties = souCompareBill.getDynamicObjectType().getProperties();
        HashMap<String, Object> summap = new HashMap<String, Object>();
        summap.put("issummap", true);
        if (propertys == null || propertys.size() < 1) {
            return list;
        }
        Map<String, Map<String, Object>> hisLowestInfo = this.getHisLowestInfo(souCompareBill);
        for (int i = souCompareBill.size() - 1; i >= 0; --i) {
            String srcentryid;
            String inquiryEntryId;
            Map<Long, List<DynamicObject>> quoteInfoMap;
            DynamicObject row = (DynamicObject)souCompareBill.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            for (IDataEntityProperty property : properties) {
                boolean isSumProperty;
                if (propertys.contains(property.getName())) {
                    map.put("{sou_compare$" + property.getName() + RIGHT_BRACE, row.get(property.getName()));
                }
                Object propertyValue = row.get(property.getName());
                boolean bl = isSumProperty = "materialentry.taxamount".equals(property.getName()) || "materialentry.amount".equals(property.getName());
                if (!(propertyValue instanceof BigDecimal) || !isSumProperty) continue;
                BigDecimal bigdecimalProp = (BigDecimal)propertyValue;
                bigdecimalProp = bigdecimalProp.setScale(row.getInt("materialentry.quotecurr.amtprecision"), RoundingMode.HALF_UP);
                String key = "sou_compare_" + property.getName() + "_sum";
                if (summap.get(key) == null) {
                    summap.put(key, bigdecimalProp);
                    continue;
                }
                BigDecimal sumvalue = bigdecimalProp.add((BigDecimal)summap.get(key));
                summap.put(key, sumvalue);
            }
            list.add(map);
            String materialId = row.getString("materialentry.material.id");
            DynamicObject quoteinfo = lowestQuoteMap.get(materialId);
            Map<String, Object> hisInfoMap = hisLowestInfo.get(materialId);
            if (hisInfoMap != null) {
                BigDecimal hislowesttaxamount = (BigDecimal)hisInfoMap.get("hislowesttaxamount");
                this.dealSum(summap, hislowesttaxamount, "sumhislowesttaxamount");
            }
            if ((quoteInfoMap = entryQuoteInfoMap.get(inquiryEntryId = inquryMap.get(srcentryid = row.getString("materialentry.srcentryid")))) == null) continue;
            Iterator<Map.Entry<Long, List<DynamicObject>>> iterator = quoteInfoMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<Long, List<DynamicObject>> next = iterator.next();
                if (next == null) continue;
                for (DynamicObject value : next.getValue()) {
                    ++count;
                    String turns = value.getString("turns");
                    DataEntityPropertyCollection pro1 = value.getDataEntityType().getProperties();
                    for (String property : quotePropertys) {
                        if (!pro1.containsKey((Object)property)) continue;
                        Object o = value.get(property);
                        map.put(LEFT_BRACE + next.getKey() + property + turns + RIGHT_BRACE, o);
                        if (o instanceof BigDecimal) {
                            BigDecimal sumvalue = (BigDecimal)summap.get(LEFT_BRACE + next.getKey() + property + turns + RIGHT_BRACE);
                            BigDecimal taxamountValue = (BigDecimal)o;
                            taxamountValue = taxamountValue.setScale(value.getInt("materialentry.quotecurr.amtprecision"), RoundingMode.HALF_UP);
                            if (sumvalue == null) {
                                summap.put(LEFT_BRACE + next.getKey() + property + turns + RIGHT_BRACE, taxamountValue);
                            } else {
                                summap.put(LEFT_BRACE + next.getKey() + property + turns + RIGHT_BRACE, taxamountValue.add(sumvalue));
                            }
                        }
                        int priceScale = row.getInt("curr.priceprecision");
                        int amtScale = row.getInt("curr.amtprecision");
                        if (!"materialentry.material.id".equals(property)) continue;
                        if (quoteinfo != null) {
                            map.put("lowestpricesup", quoteinfo.getString("supplier.name"));
                            if (this.isshowInTax()) {
                                BigDecimal taxpriceValue = quoteinfo.getBigDecimal("materialentry.taxprice").setScale(priceScale, RoundingMode.HALF_UP);
                                BigDecimal taxamountValue = taxpriceValue.multiply(row.getBigDecimal("materialentry.qty")).setScale(amtScale, RoundingMode.HALF_UP);
                                map.put("lowestprice", taxpriceValue);
                                map.put("lowesttaxamount", taxamountValue);
                                if (count == 1) {
                                    this.dealSum(summap, taxamountValue, "sumlowesttaxamount");
                                }
                            } else {
                                BigDecimal priceValue = quoteinfo.getBigDecimal("materialentry.price").setScale(priceScale, RoundingMode.HALF_UP);
                                BigDecimal amountValue = priceValue.multiply(row.getBigDecimal("materialentry.qty")).setScale(amtScale, RoundingMode.HALF_UP);
                                map.put("lowestprice", priceValue);
                                map.put("lowesttaxamount", amountValue);
                                if (count == 1) {
                                    this.dealSum(summap, amountValue, "sumlowesttaxamount");
                                }
                            }
                        }
                        if (hisInfoMap != null) {
                            if (BigDecimal.ZERO.compareTo((BigDecimal)hisInfoMap.get("hisminprice")) == 0) {
                                map.put("hisminprice", "");
                                map.put("hislowesttaxamount", "");
                                map.put("hisinfosign", "");
                                continue;
                            }
                            BigDecimal hisminprice = (BigDecimal)hisInfoMap.get("hisminprice");
                            map.put("hisminprice", hisminprice.stripTrailingZeros().toPlainString());
                            map.put("hislowesttaxamount", hisInfoMap.get("hislowesttaxamount"));
                            map.put("hisinfosign", hisInfoMap.get("hisinfosign"));
                            continue;
                        }
                        map.put("hisminprice", "");
                        map.put("hislowesttaxamount", "");
                        map.put("hisinfosign", "");
                    }
                }
            }
        }
        list.add(summap);
        return list;
    }

    private boolean isshowInTax() {
        Object displaymode = this.getModel().getValue("displaymode");
        return "1".equals(displaymode);
    }

    private void dealSum(Map<String, Object> summap, BigDecimal taxprice, String key) {
        Object lowestprice_sum = summap.get(key);
        if (lowestprice_sum == null) {
            summap.put(key, taxprice);
        } else {
            summap.put(key, taxprice.add((BigDecimal)lowestprice_sum));
        }
    }

    private Map<String, Map<String, Object>> getHisLowestInfo(DynamicObjectCollection souCompareBill) {
        if (souCompareBill == null || souCompareBill.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Object>> mat_priceMap = new HashMap<String, Map<String, Object>>();
        Object settCurr = ((DynamicObject)souCompareBill.get(0)).get("curr");
        Long priceprecision = ((DynamicObject)souCompareBill.get(0)).getLong("curr.priceprecision");
        Long amtprecision = ((DynamicObject)souCompareBill.get(0)).getLong("curr.amtprecision");
        for (DynamicObject soucompare : souCompareBill) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            BigDecimal hisminprice = soucompare.getBigDecimal("materialentry.hisminprice");
            if (BigDecimal.ZERO.compareTo(hisminprice) == 0) {
                valueMap.put("hisminprice", hisminprice);
                valueMap.put("hislowesttaxamount", BigDecimal.ZERO);
                mat_priceMap.put(soucompare.getString("materialentry.material"), valueMap);
                continue;
            }
            BigDecimal dctrate = soucompare.getBigDecimal("materialentry.dctrate");
            BigDecimal qty = soucompare.getBigDecimal("materialentry.qty");
            int pricescale = settCurr == null ? 6 : priceprecision.intValue();
            int amtscale = settCurr == null ? 6 : amtprecision.intValue();
            BigDecimal taxamount = CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)hisminprice, (BigDecimal)dctrate, (int)amtscale);
            BigDecimal percentTaxrate = soucompare.getBigDecimal("materialentry.taxrate").divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
            if (!this.isshowInTax()) {
                hisminprice = hisminprice.divide(BigDecimal.ONE.add(percentTaxrate), pricescale, RoundingMode.HALF_UP);
            }
            BigDecimal amount = taxamount.multiply(BigDecimal.ONE.subtract(percentTaxrate)).setScale(amtscale, RoundingMode.HALF_UP);
            valueMap.put("hisinfosign", soucompare.get("curr.sign"));
            if (this.isshowInTax()) {
                valueMap.put("hisminprice", hisminprice);
                valueMap.put("hislowesttaxamount", taxamount);
            } else {
                valueMap.put("hisminprice", hisminprice);
                valueMap.put("hislowesttaxamount", amount);
            }
            mat_priceMap.put(soucompare.getString("materialentry.material"), valueMap);
        }
        return mat_priceMap;
    }
}

