/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.sou.service.ISouToEasService;
import kd.scm.sou.service.SouToEasServiceImp;
import org.apache.commons.lang.StringUtils;

public class SouToEasContractEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String ACTION_BOTPLIST = "botpList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        ISouToEasService service = this.getToEasService();
        switch (key) {
            case "tocontract": {
                Map resultMap = service.verifyEASBill(new DynamicObject[]{this.getModel().getDataEntity()}, this.getModel().getDataEntityType().getName(), this.getBillEntryName(), "contract", ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"SouToEasContractEdit_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                ArrayList<Object> array = new ArrayList<Object>();
                array.add(this.getModel().getDataEntity().getPkValue());
                Object result = service.toContractInfo(this.flowServiceCode(), resultMap, new Object[]{array});
                if (result instanceof Map) {
                    FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", (Map)((Map)result), (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
                    this.getView().showForm(formParam);
                } else if (result instanceof Long) {
                    this.dispatch((Long)result);
                    this.getView().updateView();
                } else if (result instanceof String) {
                    this.getView().showMessage("", (String)result, MessageTypes.Default);
                }
                if (!"false".equals(resultMap.get("succed"))) break;
                this.getView().showMessage(resultMap.get("title").toString(), resultMap.get("message").toString(), MessageTypes.Default);
            }
        }
    }

    protected ISouToEasService getToEasService() {
        return new SouToEasServiceImp();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (StringUtils.equals((String)e.getActionId(), (String)"taskcloseback")) {
            String result = this.getToEasService().taskCallBack(e.getReturnData());
            this.getView().invokeOperation("refresh");
            if (StringUtils.isNotBlank((String)result)) {
                this.getView().showMessage(result);
            }
        }
        switch (e.getActionId()) {
            case "botpList": {
                Object botpList_condition = e.getReturnData();
                if (botpList_condition == null) {
                    return;
                }
                Map result = (Map)botpList_condition;
                Object ruleNumber = result.get("rule");
                Object tobilltype = result.get("tobilltype");
                if (ruleNumber == null) {
                    return;
                }
                if (!tobilltype.equals("contract")) break;
                try {
                    ArrayList<Object> inputs = new ArrayList<Object>(1);
                    inputs.add(this.getModel().getDataEntity().getPkValue());
                    inputs.add(ruleNumber);
                    Long instanceId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{this.flowServiceCode(), inputs});
                    this.dispatch(instanceId);
                    this.getView().updateView();
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
                break;
            }
        }
    }

    private void dispatch(Long instanceId) {
        JobInfo jobInfo = new JobInfo();
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        jobInfo.setAppId(routeAppId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(MessageFormat.format(ResManager.loadKDString((String)"\u6267\u884c\u6bd4\u4ef7\u5355:\u201c{0}\u201d\u751f\u6210\u5408\u540c\u3002", (String)"SouToEasContractEdit_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), (String)this.getModel().getValue("billno")));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.scm.sou.formplugin.task.SouTask");
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("time", 20);
        params.put("instanceId", instanceId);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setClickClassName("kd.scm.sou.formplugin.task.SouTaskClick");
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
    }

    private String flowServiceCode() {
        String name;
        switch (name = this.getModel().getDataEntityType().getName()) {
            case "sou_compare": {
                return "KD_SRM_SOU_COMPARE_CONTACT_ADD";
            }
            case "sou_bidbillcfm": {
                return "KD_SRM_SOU_BIDBILLCFM_CONTACT_ADD";
            }
        }
        return "";
    }

    protected String getBillEntryName() {
        String name;
        switch (name = this.getModel().getDataEntityType().getName()) {
            case "sou_compare": {
                return "materialentry";
            }
            case "sou_bidbillcfm": {
                return "entryentity";
            }
        }
        return "";
    }
}

