/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.ext;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.PriceProp;
import kd.bos.form.container.Container;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.sou.common.SouCompareToolUtil;
import kd.scm.sou.formplugin.AbstractSouCompareBatchPlugin;
import org.apache.poi.util.StringUtil;

public class AdoptionHelper {
    private static final String INQUIRY_ENTRYTITY = "inquiry_entry";

    public static List<String> getSupQuoNumColumn() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sou_comparetool");
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(INQUIRY_ENTRYTITY);
        DataEntityPropertyCollection properties = entityType.getProperties();
        ArrayList<String> result = new ArrayList<String>(8);
        for (IDataEntityProperty property : properties) {
            if (!property.getName().matches("\\w{0,}supprice\\d+") || !(property instanceof PriceProp)) continue;
            result.add(property.getName());
        }
        return result;
    }

    public static Map<String, String> dealCompareProMap(DataEntityPropertyCollection inquiryProperties, Map<String, Character> compareInquiryEntryPro, DataEntityPropertyCollection properties, Map<String, String> compareEntryWhiteProMap, String prex) {
        HashMap<String, String> inquiryPropMap = new HashMap<String, String>();
        for (IDataEntityProperty inquiryProperty : inquiryProperties) {
            if (compareInquiryEntryPro.containsKey(inquiryProperty.getName())) continue;
            String key = compareEntryWhiteProMap.get(inquiryProperty.getName());
            IDataEntityProperty property = null;
            if (StringUtils.isNotEmpty((String)key)) {
                property = (IDataEntityProperty)properties.get((Object)key);
            } else {
                boolean endPrex;
                String propertyName = inquiryProperty.getName();
                if (StringUtils.isNotEmpty((String)prex) && (endPrex = propertyName.endsWith(prex))) {
                    propertyName = propertyName.substring(0, propertyName.lastIndexOf(prex));
                }
                property = (IDataEntityProperty)properties.get((Object)propertyName);
            }
            if (property == null) continue;
            inquiryPropMap.put(inquiryProperty.getName(), property.getName());
        }
        return inquiryPropMap;
    }

    public static Map<String, Map<String, Object>> getQuoteDefaultParam(String billno) {
        HashMap<String, Map<String, Object>> quoParams = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> inquiryNoMap = new HashMap<String, String>(1);
        inquiryNoMap.put("=", billno);
        quoParams.put("inquiryno", inquiryNoMap);
        HashMap<String, String> entryStatusMap = new HashMap<String, String>(1);
        entryStatusMap.put("=", "A");
        quoParams.put("materialentry.entrystatus", entryStatusMap);
        HashMap<String, BigDecimal> priceStatusMap = new HashMap<String, BigDecimal>(1);
        priceStatusMap.put(">", BigDecimal.ZERO);
        quoParams.put("materialentry.price", priceStatusMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", "C");
        quoParams.put("billstatus", statusMap);
        return quoParams;
    }

    public static DynamicObject getInquiryObjByBillNo(String billNo, Container inquiryquopanel, Container inquirybasepanel, AbstractSouCompareBatchPlugin plugin, String inquiryTitle) {
        String selects;
        DynamicObjectCollection objs;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sou_inquiry");
        HashSet<String> selectsList = new HashSet<String>(64);
        if (plugin != null) {
            plugin.wrapSelectsByContainer(inquiryquopanel, selectsList, type.getProperties());
            plugin.wrapSelectsByContainer(inquirybasepanel, selectsList, type.getProperties());
        }
        selectsList.add("org.id purorg");
        selectsList.add("billno inquiryno");
        selectsList.add("adoptrule");
        HashMap paramMap = new HashMap(1);
        HashMap<String, String> billNoMap = new HashMap<String, String>(1);
        billNoMap.put("=", billNo);
        paramMap.put("billno", billNoMap);
        if (StringUtils.isNotEmpty((String)inquiryTitle)) {
            HashMap<String, String> billTitle = new HashMap<String, String>();
            billTitle.put("=", inquiryTitle);
            paramMap.put("inquirytitle", billTitle);
        }
        return (objs = ORMUtil.queryDynamicObjectCollection((String)"sou_inquiry", (String)(selects = StringUtil.join((Object[])selectsList.toArray(), (String)",")), paramMap)).size() > 0 ? (DynamicObject)objs.get(0) : null;
    }

    public static DynamicObjectCollection getInquiryData(String inquiryNo) {
        HashMap paramMap = new HashMap(1);
        HashMap<String, String> inquiryNoMap = new HashMap<String, String>(1);
        inquiryNoMap.put("=", inquiryNo);
        paramMap.put("billno", inquiryNoMap);
        return SouCompareToolUtil.getInquiryData((String)"sou_inquiry", paramMap, (String)"");
    }
}

