/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.ext;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.common.util.cal.Cal4MultCurrencyObj;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.sou.formplugin.AbstractSouCompareBatchPlugin;
import kd.scm.sou.formplugin.ext.AdoptionHelper;
import kd.scm.sou.formplugin.ext.imp.DefaultSouCompareAssistantDataSource;
import kd.sdk.scm.sou.entity.AdoptionRule;
import kd.sdk.scm.sou.entity.SouCompareAssistantDoingArgs;
import kd.sdk.scm.sou.extpoint.ISouCompareAssistantDataSource;
import kd.sdk.scm.sou.extpoint.ISouCompareToolAdopt;

public final class AdoptionModel {
    private String dataModelKey;
    private Map<String, BigDecimal[]> adoptQuoteInfoMap = new HashMap<String, BigDecimal[]>();
    private DynamicObject dataModel;
    private boolean hasLoadData = false;
    private AdoptionRule rule;
    private Map<String, Object> data;
    private static final String INQUIRY_ENTRYTITY_SUFFIX = "1";
    private static final String QUOTE_ENTRYTITY_SUFFIX = "2";
    private static final String INQUIRY_ENTRYTITY = "inquiry_entry";
    private static final String QUOTE_ENTRYTITY = "quote_entry";
    private static final String RESULT = "result";
    private static final String CFMTAXRATE = "cfmtaxrate";
    private static final String CFMTAXRATEID = "cfmtaxrateid";
    private static final String CFMTAXPRICE = "cfmtaxprice";
    private static final String CFMPRICE = "cfmprice";
    private static final String CFMQTY = "cfmqty";
    private static final String CFMAMOUNT = "cfmamount";
    private static final String CFMTAXAMOUNT = "cfmtaxamount";
    private static final String CFMBASEQTY = "cfmbaseqty";
    private List<Long> quoEntryIdList = new ArrayList<Long>();
    private Map<String, BigDecimal> quoEntryId_CompareQty = new HashMap<String, BigDecimal>();

    public AdoptionModel(String dataModelKey) {
        this.dataModelKey = dataModelKey;
        this.dataModel = BusinessDataServiceHelper.newDynamicObject((String)this.dataModelKey);
    }

    public AdoptionModel(String dataModelKey, DynamicObject dataModel) {
        this.dataModelKey = dataModelKey;
        this.dataModel = dataModel;
    }

    public Map<String, Object> initDataSource(String entityName, Map<String, Map<String, Object>> params, String orderBys, Map<String, Character> blackListMap, String adoptType) {
        LinkedHashSet<String> selects = new LinkedHashSet<String>();
        this.dealSelectList(selects, blackListMap);
        SouCompareAssistantDoingArgs args = new SouCompareAssistantDoingArgs(entityName, params, orderBys, blackListMap, selects);
        args.setQuoteOrderBy(this.getRule().getOrderByRule(adoptType));
        DefaultSouCompareAssistantDataSource plugin = new DefaultSouCompareAssistantDataSource();
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouCompareAssistantDataSource.class, (String)"SCM_SOU_COMPARETOOL_DATASOURCE", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.doGetData(args);
            return null;
        });
        this.data = args.getResult();
        this.hasLoadData = true;
        return this.data;
    }

    private void dealSelectList(Set<String> selects, Map<String, Character> blackListMap) {
        if (selects == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sou_comparetool");
        EntityType inquiryEntity = (EntityType)dataEntityType.getAllEntities().get(INQUIRY_ENTRYTITY);
        EntityType quoteEntity = (EntityType)dataEntityType.getAllEntities().get(QUOTE_ENTRYTITY);
        EntityType quoheadEntity = (EntityType)dataEntityType.getAllEntities().get("quohead_entry");
        HashMap<String, String> exMap = new HashMap<String, String>(64);
        exMap.put("billid", "id");
        MainEntityType souQuoteEntity = EntityMetadataCache.getDataEntityType((String)"sou_quote");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)inquiryEntity.getProperties(), selects, exMap, blackListMap, (DataEntityPropertyCollection)souQuoteEntity.getProperties(), (String)INQUIRY_ENTRYTITY_SUFFIX);
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)inquiryEntity.getProperties(), selects, exMap, blackListMap, (DataEntityPropertyCollection)((EntityType)souQuoteEntity.getAllEntities().get("materialentry")).getProperties(), (String)INQUIRY_ENTRYTITY_SUFFIX);
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)quoteEntity.getProperties(), selects, exMap, blackListMap, (DataEntityPropertyCollection)souQuoteEntity.getProperties(), (String)QUOTE_ENTRYTITY_SUFFIX);
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)quoteEntity.getProperties(), selects, exMap, blackListMap, (DataEntityPropertyCollection)((EntityType)souQuoteEntity.getAllEntities().get("materialentry")).getProperties(), (String)QUOTE_ENTRYTITY_SUFFIX);
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)quoheadEntity.getProperties(), selects, exMap, blackListMap, (DataEntityPropertyCollection)souQuoteEntity.getProperties(), (String)"4");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)quoheadEntity.getProperties(), selects, exMap, blackListMap, (DataEntityPropertyCollection)((EntityType)souQuoteEntity.getAllEntities().get("materialentry")).getProperties(), (String)"4");
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
        this.hasLoadData = true;
    }

    public DynamicObjectCollection adoptByRule(DynamicObject inquiryObj, String adoptType, Function<Map<String, Object>, Object> fill) {
        this.adoptQuoteInfoMap.clear();
        if (!this.hasLoadData || this.data == null || this.dataModel == null) {
            return null;
        }
        DynamicObjectCollection quoteCollections = new DynamicObjectCollection();
        if (null != this.data.get("quote")) {
            quoteCollections = (DynamicObjectCollection)this.data.get("quote");
        }
        if (inquiryObj != null) {
            HashMap inquiryInfo = new HashMap(quoteCollections.size());
            ArrayList<String> entryids = new ArrayList<String>(quoteCollections.size());
            for (DynamicObject bill : quoteCollections) {
                String entryId = bill.getString("srcentryid");
                if (!inquiryInfo.containsKey(entryId)) {
                    inquiryInfo.put(entryId, new ArrayList(36));
                    entryids.add(entryId);
                }
                List entryList = (List)inquiryInfo.get(entryId);
                entryList.add(bill);
            }
            DynamicObjectCollection inquiryEntry = this.dataModel.getDynamicObjectCollection(INQUIRY_ENTRYTITY);
            if (inquiryEntry.size() > 0) {
                inquiryEntry.clear();
            }
            DataEntityPropertyCollection inquiryEntryProp = inquiryEntry.getDynamicObjectType().getProperties();
            HashSet allBaseFields = new HashSet(16);
            allBaseFields.addAll(inquiryEntryProp.getComplexProperties(false).stream().map(IMetadata::getName).collect(Collectors.toList()));
            DataEntityPropertyCollection quoteEntryProp = null;
            HashSet allQuoteBaseFields = new HashSet(16);
            for (String billEntryId : entryids) {
                List billEntrys = (List)inquiryInfo.get(billEntryId);
                if (billEntrys == null) continue;
                DynamicObject addInquiry = inquiryEntry.addNew();
                DynamicObjectCollection quoteEntry = addInquiry.getDynamicObjectCollection(QUOTE_ENTRYTITY);
                quoteEntry.clear();
                if (quoteEntryProp == null) {
                    quoteEntryProp = quoteEntry.getDynamicObjectType().getProperties();
                    allQuoteBaseFields.addAll(quoteEntryProp.getComplexProperties(false).stream().map(IMetadata::getName).collect(Collectors.toList()));
                }
                Boolean addInquiryAtFirstTime = Boolean.FALSE;
                BigDecimal minPrice = new BigDecimal(Integer.MAX_VALUE);
                BigDecimal newPrice = BigDecimal.ZERO;
                BigDecimal sumPrice = BigDecimal.ZERO;
                BigDecimal maxPrice = BigDecimal.ZERO;
                Date recentDate = DateUtil.string2date((String)"1990-12-12 00:00:00", null);
                HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>(4);
                int seq = 0;
                int validnum = 0;
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("addInquiry", addInquiry);
                param.put("priceMap", priceMap);
                HashMap<String, DynamicObject> quoteInfoMap = new HashMap<String, DynamicObject>(1024);
                AdoptionRule rule = this.getRule();
                rule.initRule(quoteEntry, quoteInfoMap);
                rule.addCompareInfo(adoptType, null);
                for (DynamicObject setEntry : billEntrys) {
                    BigDecimal realTaxPrice;
                    if (setEntry == null) continue;
                    quoteInfoMap.put(setEntry.getString("entryid"), setEntry);
                    Map objectMap = DynamicObjectUtil.plainObject2Map((DynamicObject)setEntry);
                    BigDecimal settleTaxPrice = realTaxPrice = CommonUtil.getBigDecimalPro((Object)setEntry.get("taxprice"));
                    BigDecimal realPrice = CommonUtil.getBigDecimalPro((Object)setEntry.get("price"));
                    Date auditDate = setEntry.getDate("auditdate");
                    int pricePrecision = setEntry.getInt("settlepriceprecision");
                    BigDecimal exrate = setEntry.getBigDecimal("exrate");
                    String entryquotation = setEntry.getString("entryquotation");
                    settleTaxPrice = MultCurrencyCalImpl.convertByExrate((BigDecimal)settleTaxPrice, (BigDecimal)exrate, (int)pricePrecision, (String)entryquotation);
                    realPrice = MultCurrencyCalImpl.convertByExrate((BigDecimal)realPrice, (BigDecimal)exrate, (int)pricePrecision, (String)entryquotation);
                    if (realPrice != null && realPrice.compareTo(BigDecimal.ZERO) > 0) {
                        ++validnum;
                    }
                    DynamicObject addQuoteEntry = quoteEntry.addNew();
                    addQuoteEntry.set("seq", (Object)(++seq));
                    sumPrice = sumPrice.add(settleTaxPrice);
                    if (minPrice.compareTo(settleTaxPrice) > 0) {
                        minPrice = settleTaxPrice;
                    }
                    if (maxPrice.compareTo(settleTaxPrice) < 0) {
                        maxPrice = settleTaxPrice;
                    }
                    if (null != auditDate && auditDate.after(recentDate)) {
                        newPrice = settleTaxPrice;
                        recentDate = auditDate;
                    }
                    String supplierPk = setEntry.getString("supplier");
                    priceMap.put(supplierPk, settleTaxPrice);
                    boolean isdisposable = setEntry.getBoolean("isdisposable");
                    for (Map.Entry entry : objectMap.entrySet()) {
                        String quoteKey;
                        String inquiryKey;
                        if (addInquiryAtFirstTime.equals(Boolean.FALSE) && inquiryEntryProp.containsKey((Object)(inquiryKey = (String)entry.getKey() + INQUIRY_ENTRYTITY_SUFFIX))) {
                            addInquiry.set(inquiryKey + (allBaseFields.contains(inquiryKey) ? "_id" : ""), entry.getValue());
                        }
                        if (!quoteEntryProp.containsKey((Object)(quoteKey = (String)entry.getKey() + QUOTE_ENTRYTITY_SUFFIX))) continue;
                        if (((String)entry.getKey()).contains("price")) {
                            BigDecimal newPriceField = new BigDecimal(entry.getValue().toString());
                            if ("price".equals(entry.getKey())) {
                                addQuoteEntry.set("excludeunittax2", (Object)realPrice);
                            } else if ("taxprice".equals(entry.getKey())) {
                                addQuoteEntry.set("includeunittax2", (Object)settleTaxPrice);
                            }
                            addQuoteEntry.set(quoteKey, (Object)newPriceField);
                            continue;
                        }
                        addQuoteEntry.set(quoteKey + (allQuoteBaseFields.contains(quoteKey) ? "_id" : ""), entry.getValue());
                    }
                    if (isdisposable && StringUtils.isEmpty((String)setEntry.getString("materialnametext")) || !isdisposable) {
                        addInquiry.set("materialnametext1", (Object)setEntry.getString("materialname"));
                        addQuoteEntry.set("materialnametext2", (Object)setEntry.getString("materialname"));
                    }
                    if (quoteEntry != null && quoteEntry.size() >= 1) {
                        rule.adopt();
                    }
                    addInquiryAtFirstTime = Boolean.TRUE;
                }
                addInquiry.set("validnum1", (Object)validnum);
                addInquiry.set("minprice1", (Object)minPrice);
                addInquiry.set("maxprice1", (Object)maxPrice);
                addInquiry.set("newprice1", (Object)newPrice);
                addInquiry.set("avgprice1", (Object)sumPrice.divide(new BigDecimal(quoteEntry.size()), sumPrice.scale(), RoundingMode.HALF_UP));
                if (fill != null) {
                    fill.apply(param);
                }
                for (Integer index : rule.getAdoptSet()) {
                    if (index <= 0 || index > addInquiry.getDynamicObjectCollection(QUOTE_ENTRYTITY).size()) continue;
                    DynamicObject addQuoteEntry = (DynamicObject)addInquiry.getDynamicObjectCollection(QUOTE_ENTRYTITY).get(index - 1);
                    DynamicObject setEntry = (DynamicObject)quoteInfoMap.get(addQuoteEntry.getString("entryid2"));
                    int settleamtprecision = setEntry.getInt("settleamtprecision");
                    BigDecimal exrate = setEntry.getBigDecimal("exrate");
                    String entryquotation = setEntry.getString("entryquotation");
                    BigDecimal realTaxPrice = CommonUtil.getBigDecimalPro((Object)setEntry.get("taxprice"));
                    this.setAdoptQuoteInfo(setEntry, addQuoteEntry, exrate, settleamtprecision, realTaxPrice, entryquotation);
                }
            }
            return quoteCollections;
        }
        return null;
    }

    private void setAdoptQuoteInfo(DynamicObject setEntry, DynamicObject addQuoteEntry, BigDecimal exrate, int settleamtprecision, BigDecimal realTaxPrice, String entryquotation) {
        BigDecimal price = CommonUtil.getBigDecimalPro((Object)setEntry.get("price"));
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)setEntry.get("qty"));
        BigDecimal baseqty = CommonUtil.getBigDecimalPro((Object)setEntry.get("basicqty"));
        BigDecimal taxRate = CommonUtil.getBigDecimalPro((Object)setEntry.get("taxrate"));
        Long taxRateId = setEntry.getLong("taxrateid");
        addQuoteEntry.set("result2", (Object)INQUIRY_ENTRYTITY_SUFFIX);
        addQuoteEntry.set("cfmprice2", (Object)price);
        addQuoteEntry.set("cfmtaxprice2", (Object)realTaxPrice);
        addQuoteEntry.set("cfmtaxrate2", (Object)taxRate);
        addQuoteEntry.set("cfmtaxrateid2_id", (Object)taxRateId);
        addQuoteEntry.set("cfmqty2", (Object)qty);
        addQuoteEntry.set("cfmbaseqty2", (Object)baseqty);
        BigDecimal cfmAmount = CommonUtil.getBigDecimalPro((Object)setEntry.get("amount"));
        BigDecimal cfmTaxAmount = CommonUtil.getBigDecimalPro((Object)setEntry.get("taxamount"));
        addQuoteEntry.set("cfmamount2", (Object)cfmAmount);
        addQuoteEntry.set("cfmtaxamount2", (Object)cfmTaxAmount);
        BigDecimal[] infos = this.adoptQuoteInfoMap.get(setEntry.getString("billno"));
        cfmAmount = MultCurrencyCalImpl.convertByExrate((BigDecimal)cfmAmount, (BigDecimal)exrate, (int)settleamtprecision, (String)entryquotation);
        cfmTaxAmount = MultCurrencyCalImpl.convertByExrate((BigDecimal)cfmTaxAmount, (BigDecimal)exrate, (int)settleamtprecision, (String)entryquotation);
        if (infos != null) {
            infos[0] = infos[0].add(cfmAmount);
            infos[1] = infos[1].add(cfmTaxAmount);
        } else {
            if (cfmAmount == null) {
                cfmAmount = BigDecimal.ZERO;
            }
            if (cfmTaxAmount == null) {
                cfmTaxAmount = BigDecimal.ZERO;
            }
            infos = new BigDecimal[]{cfmAmount, cfmTaxAmount};
            this.adoptQuoteInfoMap.put(setEntry.getString("billno"), infos);
        }
    }

    public DynamicObject getDataModel() {
        return this.dataModel;
    }

    public Object[] toTargetBill(String inquiryNo, DynamicObject bill, AbstractSouCompareBatchPlugin plugin) {
        Object[] objs = null;
        DynamicObjectCollection inquiryCol = AdoptionHelper.getInquiryData(inquiryNo);
        if (inquiryCol.size() > 0 && plugin != null) {
            DynamicObject billObj;
            int source = 0;
            if (bill != null) {
                billObj = bill;
            } else {
                source = 1;
                billObj = plugin.createCompareBillHead((DynamicObject)inquiryCol.get(0), null);
            }
            if (billObj != null) {
                if (source == 0) {
                    plugin.createCompareQuoEntry(billObj, "quoentry", inquiryNo, source);
                    plugin.createCompareBillEntry(billObj, "materialentry", source);
                } else {
                    plugin.createCompareQuoEntry(billObj, "quoentry");
                    plugin.createCompareBillEntry(billObj, "materialentry");
                }
                Cal4MultCurrencyObj obj = new Cal4MultCurrencyObj();
                obj.calByQty(billObj, "materialentry");
                plugin.setQuoEntry(billObj, source);
                if (source == 0) {
                    return new Object[]{billObj};
                }
                objs = SaveServiceHelper.save((IDataEntityType)billObj.getDataEntityType(), (Object[])new Object[]{billObj});
            }
        }
        return objs != null ? objs : new Object[]{};
    }

    private List<String> rebuildBillPkIds(Object[] pkIds) {
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkIds == null) {
            return pkList;
        }
        for (Object pk : pkIds) {
            if (pk == null) continue;
            pkList.add(String.valueOf(pk));
        }
        return pkList;
    }

    public void createCompareBillEntry(DynamicObject billObj, String entryKey, AbstractSouCompareBatchPlugin plugin, int source) {
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection(entryKey);
        DynamicObjectCollection inquiryCols = this.dataModel.getDynamicObjectCollection(INQUIRY_ENTRYTITY);
        DataEntityPropertyCollection inquiryProperties = ((EntityType)((MainEntityType)this.dataModel.getDynamicObjectType()).getAllEntities().get(INQUIRY_ENTRYTITY)).getProperties();
        DataEntityPropertyCollection quoteProperties = ((EntityType)((MainEntityType)this.dataModel.getDynamicObjectType()).getAllEntities().get(QUOTE_ENTRYTITY)).getProperties();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sou_compare");
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get("materialentry");
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map<String, String> inquiryPropMap = AdoptionHelper.dealCompareProMap(inquiryProperties, plugin.getInquiryEntryBlackMap(), properties, plugin.getInquiryEntryWhiteMap(), INQUIRY_ENTRYTITY_SUFFIX);
        Map<String, String> quotePropMap = AdoptionHelper.dealCompareProMap(quoteProperties, plugin.getCompareQuoteBlackMap(), properties, plugin.getCompareQuoteWhiteMap(), QUOTE_ENTRYTITY_SUFFIX);
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        int index = 1;
        IDataEntityProperty seqPro = (IDataEntityProperty)properties.get((Object)"seq");
        int size = source == 0 ? inquiryCols.size() : inquiryCols.size() - 1;
        for (int i = 0; i < size; ++i) {
            DynamicObject inquiryCol = (DynamicObject)inquiryCols.get(i);
            DynamicObjectCollection quoteCols = inquiryCol.getDynamicObjectCollection(QUOTE_ENTRYTITY);
            for (DynamicObject quoteCol : quoteCols) {
                String result = quoteCol.getString("result2");
                if (!INQUIRY_ENTRYTITY_SUFFIX.equals(result)) continue;
                String quoEntryId = quoteCol.getString("entryid2");
                if (!quoEntryId.isEmpty()) {
                    this.quoEntryIdList.add(Long.valueOf(quoEntryId));
                    BigDecimal cfmqty = quoteCol.getBigDecimal("cfmqty2");
                    this.quoEntryId_CompareQty.put(quoEntryId, cfmqty);
                }
                DynamicObject entry = ORMUtil.newDynamicObject((String)"sou_compare.materialentry");
                this.setCompareEntry(inquiryPropMap, entry, inquiryCol);
                this.setCompareEntry(quotePropMap, entry, quoteCol);
                seqPro.setValueFast((Object)entry, (Object)index);
                entry.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                entryList.add(entry);
                ++index;
            }
        }
        if (entryList.size() > 0) {
            entrys.addAll(entryList);
        }
    }

    private void setCompareEntry(Map<String, String> propMap, DynamicObject entry, DynamicObject quoteCol) {
        for (Map.Entry<String, String> next : propMap.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)quoteCol.getDataEntityType().getProperties().get((Object)next.getKey());
            Object value = quoteCol.get(next.getKey());
            if (property instanceof BasedataProp || property instanceof CurrencyProp || property instanceof OrgProp) {
                value = quoteCol.get(next.getKey() + "_id");
                entry.set(next.getValue() + "_id", value == null ? Long.valueOf(0L) : value);
                continue;
            }
            if (property instanceof BigDecimal) {
                entry.set(next.getValue(), (Object)CommonUtil.getBigDecimalPro((Object)value));
                continue;
            }
            entry.set(next.getValue(), value);
        }
    }

    public AdoptionRule getRule() {
        if (this.rule == null) {
            ISouCompareToolAdopt plugin = new ISouCompareToolAdopt(){

                public AdoptionRule wrapAdoptRule() {
                    return new AdoptionRule();
                }
            };
            PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouCompareToolAdopt.class, (String)"SCM_SOU_COMPARETOOL_ADOPT", null);
            List rules = pluginProxy.callReplace(p -> p.wrapAdoptRule());
            this.rule = rules.size() >= 1 ? (AdoptionRule)rules.get(rules.size() - 1) : new AdoptionRule();
        }
        return this.rule;
    }

    public Map<String, BigDecimal[]> getAdoptQuoteInfoMap() {
        return this.adoptQuoteInfoMap;
    }

    public List<Long> getQuoEntryIdList() {
        return this.quoEntryIdList;
    }

    public Map<String, BigDecimal> getQuoEntryId_CompareQty() {
        return this.quoEntryId_CompareQty;
    }
}

