/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.ext.imp;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.InquiryUtil;
import kd.sdk.scm.sou.entity.SouCompareAssiRecentPriceArgs;
import kd.sdk.scm.sou.extpoint.ISouCompareAssistantRecentPriceSource;
import org.apache.poi.util.StringUtil;

public class DefaultSouCompareAssistantRecentPriceSource
implements ISouCompareAssistantRecentPriceSource {
    private static final int TOP = 10;

    public void doGetData(SouCompareAssiRecentPriceArgs args) {
        String entityName = "pur_order";
        String entryEntityName = "materialentry";
        String orderBys = "billdate desc,billno";
        QFilter qfilter = new QFilter("1", "=", (Object)1);
        qfilter.and("materialentry.material.id", "in", (Object)args.getMaterialPkIds());
        Date date = new Date();
        String monthnumStr = args.getMonthnumStr();
        if (null != monthnumStr && monthnumStr.trim().length() > 0) {
            int monthnum = Integer.parseInt(monthnumStr);
            qfilter.and("billdate", "<=", (Object)DateUtil.getFormatDateEndMaxDate((Date)date));
            qfilter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)(monthnum > 0 ? monthnum - 1 : monthnum)));
        } else {
            qfilter.and("billdate", "<=", (Object)DateUtil.getFormatDateEndMaxDate((Date)date));
            qfilter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)24));
        }
        qfilter.and("materialentry.material.isdisposable", "=", (Object)Boolean.FALSE);
        Set<String> selectList = this.getSelectLists(args.getSelects(), args.getBlackListMap(), entityName, entryEntityName);
        String selects = StringUtil.join((Object[])selectList.toArray(), (String)",");
        QFilter[] qfArray = new QFilter[]{qfilter};
        DynamicObjectCollection querydycols = QueryServiceHelper.query((String)entityName, (String)selects, (QFilter[])qfArray, (String)orderBys, (int)10);
        args.setResult(querydycols);
    }

    private Set<String> getSelectLists(Set<String> selectList, Map<String, Character> blackListMap, String entityName, String entryEntityName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sou_comparetool");
        EntityType recentpriceEntry = (EntityType)dataEntityType.getAllEntities().get("recentprice_entry");
        MainEntityType orderType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityType materialentry = (EntityType)orderType.getAllEntities().get(entryEntityName);
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)recentpriceEntry.getProperties(), selectList, null, blackListMap, (DataEntityPropertyCollection)orderType.getProperties(), (String)"3");
        if (materialentry != null) {
            InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)recentpriceEntry.getProperties(), selectList, null, blackListMap, (DataEntityPropertyCollection)materialentry.getProperties(), (String)"3");
        }
        return selectList;
    }
}

