/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExchangeHelper;
import kd.scm.common.util.OrgUtil;
import kd.scm.sou.formplugin.service.ISouCompareAssistantBatchService;

public class DefaultSouCompareAssistantBatchService
implements ISouCompareAssistantBatchService {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    public static final String PARTITION = "_";

    @Override
    public Map<String, BigDecimal> getMinPrice(IDataModel model, int monthnum) {
        DynamicObjectCollection inquiryEntryCols = model.getEntryEntity("inquiry_entry");
        List materialIdList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)inquiryEntryCols, (String)"material1");
        String selectFields = "org,materialentry.quotecurr curr,materialentry.material material,materialentry.taxprice*materialentry.exrate settletaxprice,materialentry.taxprice taxprice";
        HashMap<String, BigDecimal> mat_priceMap = new HashMap<String, BigDecimal>();
        try (DataSet compareDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sou_compare", (String)selectFields, (QFilter[])new QFilter[]{this.buildMinFilter(materialIdList, monthnum)}, (String)"billdate");){
            GroupbyDataSet groupDataSet = compareDataSet.groupBy(new String[]{"material", "curr"});
            DynamicObjectCollection compareCols = ORM.create().toPlainDynamicObjectCollection(groupDataSet.min("settletaxprice").min("taxprice").finish());
            Object settCurr = model.getValue("curr");
            Object purOrg = model.getValue("purorg");
            if (null == purOrg || null == settCurr) {
                HashMap<String, BigDecimal> hashMap = mat_priceMap;
                return hashMap;
            }
            DynamicObject purOrgObj = (DynamicObject)purOrg;
            DynamicObject settCurrObj = (DynamicObject)settCurr;
            for (DynamicObject compareCol : compareCols) {
                Object material = compareCol.get("material");
                Object curr = compareCol.get("curr");
                if (null == material || null == curr) continue;
                BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)compareCol.get("taxprice"));
                if (settCurrObj.getPkValue().toString().equals(curr.toString())) {
                    BigDecimal price = (BigDecimal)mat_priceMap.get(material.toString());
                    if (null != price && taxPrice.compareTo(price) >= 0) continue;
                    mat_priceMap.put(material.toString(), taxPrice);
                    continue;
                }
                List companyids = OrgUtil.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)((Long)purOrgObj.getPkValue()));
                BigDecimal exchange = ExchangeHelper.getExChangeRateByOrg((Long)Long.valueOf(settCurrObj.getPkValue().toString()), (Long)((Long)curr), (Long)(!companyids.isEmpty() ? (Long)companyids.get(0) : Long.valueOf(0L)));
                if (exchange == null || exchange.compareTo(BigDecimal.ZERO) == 0) {
                    exchange = BigDecimal.ONE;
                }
                taxPrice = taxPrice.setScale(settCurr == null ? 6 : ((DynamicObject)settCurr).getInt("priceprecision"), 4).multiply(exchange);
                BigDecimal price = (BigDecimal)mat_priceMap.get(material.toString());
                if (null == price || taxPrice.compareTo(price) < 0) {
                    mat_priceMap.put(material.toString(), taxPrice);
                }
                compareCol.set("taxprice", (Object)taxPrice);
            }
        }
        return mat_priceMap;
    }

    public QFilter buildMinFilter(List<Long> materialIdList, int monthnum) {
        QFilter filter = new QFilter("materialentry.material", "in", materialIdList);
        filter.and("materialentry.taxprice", ">", (Object)0);
        filter.and("materialentry.exrate", ">", (Object)0);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        filter.and("org", "in", (Object)OrgUtil.getAllPurViewPermissionOrgs((String)"sou_compare"));
        Date date = new Date();
        if (monthnum > 0) {
            filter.and("billdate", "<=", (Object)DateUtil.getFormatDateEndMaxDate((Date)date));
            filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)(monthnum - 1)));
        } else {
            filter.and("billdate", "<=", (Object)DateUtil.getFormatDateEndMaxDate((Date)date));
            filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)24));
        }
        return filter;
    }

    @Override
    public Map<String, String> getLastComparePrice(IDataModel model, int monthnum) {
        long extableId;
        DynamicObject extable;
        LinkedHashMap<String, String> mat_priceMap = new LinkedHashMap<String, String>();
        DynamicObjectCollection inquiryEntryCols = model.getEntryEntity("inquiry_entry");
        ArrayList<Long> materialIdList = new ArrayList<Long>();
        inquiryEntryCols.forEach(inquiryEntry -> {
            long materialId = inquiryEntry.getLong("material1.id");
            materialIdList.add(materialId);
        });
        String selectFields = "id,billno,org,materialentry.quotecurr,materialentry.material.id,materialentry.taxprice,materialentry.entryrcvorg.id,materialentry.quotecurr.id,materialentry.quotecurr.name,materialentry.material.isdisposable";
        DynamicObject inquiryCurr = (DynamicObject)model.getValue("curr");
        long[] inquiryCurrId = new long[]{0L};
        String[] inquiryCurrName = new String[]{""};
        if (inquiryCurr != null) {
            inquiryCurrId[0] = inquiryCurr.getLong("id");
            inquiryCurrName[0] = inquiryCurr.getString("name");
        }
        if ((extable = (DynamicObject)model.getValue("exchtype")) == null) {
            this.log.info("\u83b7\u53d6\u4e0a\u4e00\u6b21\u6bd4\u4ef7\u5355\u8fc7\u7a0b\u4e2d\u83b7\u53d6\u6c47\u7387\u8868\u4e3a\u7a7a\u3002");
            extableId = 0L;
        } else {
            extableId = extable.getLong("id");
        }
        HashMap compareCurrMap = new HashMap();
        HashMap currNameMap = new HashMap();
        HashMap compareBillnoMap = new HashMap();
        try (DataSet compareDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sou_compare", (String)selectFields, (QFilter[])new QFilter[]{this.buildLastComparePriceFilter(materialIdList, monthnum, model)}, (String)"billdate,materialentry.seq desc");){
            compareDataSet.forEach(row -> {
                Long compareCurrId = row.getLong("materialentry.quotecurr.id");
                String materialId = row.getString("materialentry.material.id");
                String org = row.getString("org");
                String key = org + PARTITION + materialId;
                String entryKey = row.getString("id") + PARTITION + materialId;
                compareBillnoMap.put(row.getString("id"), row.getString("billno"));
                if (compareCurrId != null) {
                    compareCurrMap.put(entryKey, compareCurrId);
                    currNameMap.put(compareCurrId, row.getString("materialentry.quotecurr.name"));
                }
                BigDecimal taxprice = row.getBigDecimal("materialentry.taxprice");
                mat_priceMap.remove(key);
                mat_priceMap.put(key, entryKey + PARTITION + taxprice);
            });
        }
        HashMap<Long, BigDecimal> cacheRateMap = new HashMap<Long, BigDecimal>();
        String inquiryNo = (String)model.getValue("inquiryno");
        for (Map.Entry entry : mat_priceMap.entrySet()) {
            String com_price = (String)entry.getValue();
            String[] split = com_price.split(PARTITION);
            BigDecimal taxprice = new BigDecimal(split[2]);
            Long compareCurrId = (Long)compareCurrMap.get(split[0] + PARTITION + split[1]);
            if (compareCurrMap.size() > 0 && compareCurrId != null) {
                taxprice = this.exchangeTaxprice(compareCurrId, inquiryCurrId[0], extableId, taxprice, cacheRateMap);
                if (null == taxprice) {
                    String compareBillno = (String)compareBillnoMap.get(com_price.split(PARTITION)[0]);
                    String msg = String.format(ResManager.loadKDString((String)"\u6839\u636e\u6bd4\u4ef7\u5355\u201c%1$s\u201d\u7ed3\u7b97\u5e01\u201c%2$s\u201d\u548c\u8be2\u4ef7\u5355\u201c%3$s\u201d\u7ed3\u7b97\u5e01\u201c%4$s\u201d\u8f6c\u6362\u4e0a\u6b21\u6bd4\u4ef7\u5355\u4ef7\u683c\u9519\u8bef\uff0c\u8bf7\u5230\u6c47\u7387\u8868\u4e2d\u7ef4\u62a4\u76f8\u5173\u5e01\u79cd\u6362\u7b97\u5173\u7cfb", (String)"DefaultSouCompareAssistantBatchService_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), compareBillno, currNameMap.get(compareCurrId), inquiryNo, inquiryCurrName[0]);
                    throw new KDBizException(msg);
                }
                taxprice = taxprice.setScale(inquiryCurr == null ? 6 : inquiryCurr.getInt("priceprecision"), 4).multiply(BigDecimal.ONE);
            }
            entry.setValue(split[0] + PARTITION + taxprice);
        }
        return mat_priceMap;
    }

    public BigDecimal exchangeTaxprice(long compareCurrId, long inquiryCurrId, long extableId, BigDecimal taxprice, Map<Long, BigDecimal> cacheRateMap) {
        BigDecimal exchangeRate;
        if (inquiryCurrId == compareCurrId) {
            exchangeRate = BigDecimal.ONE;
        } else {
            exchangeRate = cacheRateMap.get(compareCurrId);
            if (exchangeRate == null && (exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)extableId, (Long)compareCurrId, (Long)inquiryCurrId, (Date)TimeServiceHelper.now())) != null) {
                cacheRateMap.put(compareCurrId, exchangeRate);
            }
        }
        if (exchangeRate == null || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
            return null;
        }
        taxprice = taxprice.multiply(exchangeRate);
        return taxprice;
    }

    public QFilter buildLastComparePriceFilter(List<Long> materialIdList, int monthnum, IDataModel model) {
        QFilter filter = new QFilter("materialentry.material.id", "in", materialIdList);
        filter.and("materialentry.exrate", ">", (Object)0);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("materialentry.material.isdisposable", "=", (Object)Boolean.FALSE);
        Date date = TimeServiceHelper.now();
        if (monthnum > 0) {
            filter.and("billdate", "<=", (Object)date);
            filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)(monthnum - 1)));
        } else {
            filter.and("billdate", "<=", (Object)date);
            filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)24));
        }
        DynamicObject purOrg = (DynamicObject)model.getValue("purorg");
        if (null == purOrg) {
            return null;
        }
        filter.and("org", "=", purOrg.getPkValue());
        return filter;
    }
}

