/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.task;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import kd.scm.sou.formplugin.task.SouBidBillAutoOpenTask;

public class SouBidBillAutoConfirmTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SouBidBillAutoOpenTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info(ResManager.loadKDString((String)"\u7ade\u4ef7\u81ea\u52a8\u5b9a\u6807", (String)"SouBidBillAutoConfirmTask_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)"supquoentry", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)"quoentry", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)"materialentry", (boolean)false);
        HashSet<String> set = new HashSet<String>();
        set.add("C");
        set.add("D");
        QFilter statusFilter = new QFilter("bidstatus", "in", set);
        boolean autoconfirm = false;
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sou_bidbill", (String)selectFields, (QFilter[])new QFilter[]{statusFilter});
        ArrayList<String> pmApplyPkIds = new ArrayList<String>();
        if (bills != null) {
            String cfmBillFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbillcfm", (boolean)false);
            cfmBillFields = DynamicObjectUtil.getEntrySelectfields((String)cfmBillFields, (String)"sou_bidbillcfm", (String)"entryentity1", (boolean)false);
            cfmBillFields = DynamicObjectUtil.getEntrySelectfields((String)cfmBillFields, (String)"sou_bidbillcfm", (String)"entryentity2", (boolean)false);
            cfmBillFields = DynamicObjectUtil.getEntrySelectfields((String)cfmBillFields, (String)"sou_bidbillcfm", (String)"entryentity", (boolean)false);
            Set bidBillIds = Arrays.stream(bills).mapToLong(bill -> bill.getLong("id")).boxed().collect(Collectors.toCollection(HashSet::new));
            QFilter idsFilter = new QFilter("id", "in", (Object)bidBillIds);
            DynamicObject[] cfmBills = BusinessDataServiceHelper.load((String)"sou_bidbillcfm", (String)cfmBillFields, (QFilter[])new QFilter[]{idsFilter});
            for (DynamicObject bill2 : bills) {
                String checktype;
                String bidstatus = bill2.getString("bidstatus");
                long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)bill2);
                if ("C".equals(bidstatus) && restOfTime <= 0L) {
                    bill2.set("bidstatus", (Object)BidStatusEnum.EVALUATING);
                    SouBidBillUtil.updateSupplierInfo((DynamicObject)bill2);
                }
                if ("2".equals(checktype = bill2.getString("checktype")) || !(autoconfirm = bill2.getBoolean("autoconfirm")) || restOfTime > 0L) continue;
                BigDecimal sumtaxamount = bill2.getBigDecimal("sumtaxamount");
                DynamicObjectCollection quoentry = bill2.getDynamicObjectCollection("quoentry");
                boolean flag = false;
                for (DynamicObject row : quoentry) {
                    BigDecimal quoteamount = row.getBigDecimal("quoteamount");
                    if (quoteamount.compareTo(BigDecimal.ZERO) <= 0 || sumtaxamount.compareTo(quoteamount) == 0) continue;
                    flag = true;
                }
                if (!flag) continue;
                SouBidBillUtil.setbidBill((DynamicObject)bill2);
                bill2.set("bidstatus", (Object)"E");
                bill2.set("decidedate", (Object)TimeServiceHelper.now());
                BigDecimal amount = bill2.getBigDecimal("bidamount");
                BigDecimal sumTaxAmount = bill2.getBigDecimal("sumtaxamount");
                DynamicObjectCollection materialEntrys = bill2.getDynamicObjectCollection("materialentry");
                Long supplierPk = bill2.getLong("supplier");
                BigDecimal curTaxAmount = null;
                for (DynamicObject[] materialEntry : materialEntrys) {
                    String srcBillId;
                    BigDecimal price = materialEntry.getBigDecimal("price");
                    BigDecimal taxPrice = materialEntry.getBigDecimal("taxprice");
                    materialEntry.set("winprice", (Object)price.multiply(amount).divide(sumTaxAmount, 10, RoundingMode.CEILING));
                    materialEntry.set("wintaxprice", (Object)taxPrice.multiply(amount).divide(sumTaxAmount, 10, RoundingMode.CEILING));
                    curTaxAmount = materialEntry.getBigDecimal("taxamount");
                    materialEntry.set("winamount", (Object)curTaxAmount.multiply(amount).divide(sumTaxAmount, 10, RoundingMode.CEILING));
                    materialEntry.set("winsupplier", (Object)supplierPk);
                    String srcType = materialEntry.getString("srcbilltype");
                    if (srcType.isEmpty() || !"pm_purapplybill".equals(srcType) || (srcBillId = materialEntry.getString("srcbillid")) == null || srcBillId.isEmpty() || pmApplyPkIds.contains(srcBillId)) continue;
                    pmApplyPkIds.add(srcBillId);
                }
                this.beforeSendMessage(bill2);
                DynamicObject cfmBillDyn = null;
                for (DynamicObject cfmBill : cfmBills) {
                    if (cfmBill.getLong("id") != bill2.getLong("id")) continue;
                    cfmBillDyn = cfmBill;
                }
                if (cfmBillDyn == null) continue;
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                OperationServiceHelper.executeOperate((String)"sendmsgtowin", (String)"sou_bidbillcfm", (DynamicObject[])new DynamicObject[]{cfmBillDyn}, (OperateOption)option);
                OperationServiceHelper.executeOperate((String)"sendmsgtofail", (String)"sou_bidbillcfm", (DynamicObject[])new DynamicObject[]{cfmBillDyn}, (OperateOption)option);
            }
        }
        if (bills != null && bills.length > 0) {
            SaveServiceHelper.save((DynamicObject[])bills);
            if (!ApiConfigUtil.hasEASConfig() && ApiConfigUtil.hasCQScmConfig() && !pmApplyPkIds.isEmpty()) {
                HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
                confirmMap.put("ids", pmApplyPkIds);
                confirmMap.put("status", "B");
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upApplyBidStatus", (Object[])new Object[]{confirmMap});
            }
            logger.info(ResManager.loadKDString((String)"\u7ade\u4ef7\u81ea\u52a8\u5b9a\u6807\u7ed3\u675f", (String)"SouBidBillAutoConfirmTask_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforeSendMessage(DynamicObject bill) {
        DynamicObjectCollection supQuoEntrys = bill.getDynamicObjectCollection("supquoentry");
        DynamicObject quoBidBillDO = QueryServiceHelper.queryOne((String)"quo_bidbill", (String)"id,billno,name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)bill.getString("billno"))});
        if (quoBidBillDO != null) {
            for (DynamicObject supQuoEntry : supQuoEntrys) {
                String adoptStr;
                if ("F".equals(supQuoEntry.getString("supentrystatus"))) {
                    adoptStr = ResManager.loadKDString((String)"\u5df2\u4e2d\u6807", (String)"SouBidBillAutoConfirmTask_6", (String)"scm-sou-formplugin", (Object[])new Object[0]);
                } else {
                    if (!"G".equals(supQuoEntry.getString("supentrystatus"))) continue;
                    adoptStr = ResManager.loadKDString((String)"\u672a\u4e2d\u6807", (String)"SouBidBillAutoConfirmTask_7", (String)"scm-sou-formplugin", (Object[])new Object[0]);
                }
                DynamicObject entrysupplier = supQuoEntry.getDynamicObject("entrysupplier");
                long bizPartnerPkId = entrysupplier.getLong("bizpartner_id");
                HashSet<Long> bizPartnerPkIds = new HashSet<Long>();
                bizPartnerPkIds.add(bizPartnerPkId);
                long supenroll = supQuoEntry.getLong("supenroll.id");
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(supenroll);
                String content = MessageFormat.format(ResManager.loadKDString((String)"\u7ade\u4ef7\u67e5\u8be2\u5355\uff08\u9879\u76ee\u540d\u79f0\uff1a{0}\uff0c\u9879\u76ee\u7f16\u53f7\uff1a{1}\uff09\u7684\u7ed3\u679c\u72b6\u6001\u4e3a{2}\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SouBidBillAutoConfirmTask_2", (String)"scm-sou-formplugin", (Object[])new Object[0]), quoBidBillDO.getString("name"), quoBidBillDO.getString("billno"), adoptStr);
                HashMap<String, String> msgParams = new HashMap<String, String>();
                DynamicObject person = bill.getDynamicObject("person");
                if (person != null) {
                    msgParams.put("senderId", String.valueOf(person.getPkValue()));
                    msgParams.put("senderName", person.getString("name"));
                } else {
                    DynamicObject creator = bill.getDynamicObject("creator");
                    msgParams.put("senderId", String.valueOf(creator.getPkValue()));
                    msgParams.put("senderName", creator.getString("name"));
                }
                msgParams.put("title", ResManager.loadKDString((String)"\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5", (String)"SouBidBillAutoConfirmTask_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                msgParams.put("content", content);
                msgParams.put("failMsgTitle", ResManager.loadKDString((String)"\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u901a\u77e5\u4e1a\u52a1\u90e8\u95e8\u8ddf\u8fdb\u3002", (String)"SouBidBillAutoConfirmTask_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                msgParams.put("failMsgContent", String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e3a\u53d1\u9001\u5931\u8d25\u4fe1\u606f\uff1a%1$s", (String)"SouBidBillAutoConfirmTask_5", (String)"scm-sou-formplugin", (Object[])new Object[0]), content));
                msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_bidbill" + "&pkId=" + quoBidBillDO.getLong("id"));
                msgParams.put("toMob", "false");
                msgParams.put("hasBizDataId", "false");
                SouSendMessageUtil.sendMessage(bizPartnerPkIds, ids, msgParams);
            }
        }
    }
}

