/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class SrcAddSupplierEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.setDefaultValue();
        this.setComboListValie();
        this.createEntryEntity();
    }

    public void setDefaultValue() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        this.getView().getModel().setValue("entityname", paramMap.get("entityname"));
        this.getView().getModel().setValue("project", paramMap.get("project"));
        this.getView().getModel().setValue("billid", paramMap.get("billid"));
        this.getView().getModel().setValue("turns", paramMap.get("turns"));
    }

    public void setComboListValie() {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(4);
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309 \u9879\u76ee \u8865\u5145\u4f9b\u5e94\u5546", (String)"SrcAddSupplierEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0])), "1"));
        boolean isByPackage = PdsCommonUtils.isByPackage((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project"));
        boolean isByBidPackage = false;
        if (isByPackage) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309 \u6807\u6bb5 \u8865\u5145\u4f9b\u5e94\u5546", (String)"SrcAddSupplierEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0])), "2"));
        } else {
            long projectId = PdsCommonUtils.object2Long((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"project"));
            QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(projectId));
            isByBidPackage = QueryServiceHelper.exists((String)"src_bidpackagef7", (QFilter[])qfilter.toArray());
            if (isByBidPackage) {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309 \u6807\u5305 \u8865\u5145\u4f9b\u5e94\u5546", (String)"SrcAddSupplierEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0])), "3"));
            }
        }
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309 \u6807\u7684 \u8865\u5145\u4f9b\u5e94\u5546", (String)"SrcAddSupplierEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0])), "4"));
        ComboEdit comboEdit = (ComboEdit)this.getControl("addsupplier");
        comboEdit.setComboItems(data);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "addsupplier": {
                this.createEntryEntity();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        switch (key = operate.getOperateKey()) {
            case "confirm": {
                if (!evt.getOperationResult().isSuccess()) break;
                PdsCommonUtils.refreshParentView((IFormView)this.getView());
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void createEntryEntity() {
        long projectId = PdsCommonUtils.object2Long((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"project"));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"projectid", "package", "packagename", "purlist"});
        String addSupplier = this.getModel().getDataEntity().getString("addsupplier");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        if (projectId == 0L) {
            return;
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        switch (addSupplier) {
            case "1": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"projectid"});
                this.createProjectEntry(projectId, ts);
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"package"});
                this.createPackageEntry(projectId, ts);
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"packagename"});
                this.createBidPackageEntry(projectId, ts);
                break;
            }
            case "4": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"purlist"});
                this.createPurlistEntry(projectId, ts);
                break;
            }
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void createProjectEntry(long projectId, TableValueSetter ts) {
        ts.set("projectid", (Object)projectId, 0);
    }

    private void createPackageEntry(long projectId, TableValueSetter ts) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"package.id", (QFilter[])qfilter.toArray());
        for (int i = 0; i < rows.size(); ++i) {
            ts.set("package", (Object)((DynamicObject)rows.get(i)).getLong("package.id"), i);
        }
    }

    private void createBidPackageEntry(long projectId, TableValueSetter ts) {
        QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(projectId));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidpackagef7", (String)"packagename", (QFilter[])qfilter.toArray());
        for (int i = 0; i < rows.size(); ++i) {
            ts.set("packagename", (Object)((DynamicObject)rows.get(i)).getString("packagename"), i);
        }
    }

    private void createPurlistEntry(long projectId, TableValueSetter ts) {
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        QFilter qfilter = new QFilter("project", "=", (Object)projectId).and("supplier", "=", (Object)0L);
        qfilter.and("purlist.id", "not in", (Object)purListEndIds);
        qfilter.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id", (QFilter[])qfilter.toArray());
        for (int i = 0; i < rows.size(); ++i) {
            ts.set("purlist", (Object)((DynamicObject)rows.get(i)).getLong("purlist.id"), i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (key) {
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("supplier");
        if (null != basedataEdit) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }
}

