/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.src.common.util.SrcComponentUtil;
import kd.scm.src.common.util.SrcPurListUtil;
import kd.scm.src.common.util.SrcQuickPurUtil;

public class SrcBidDocPackageEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.visiblePackageByManageType();
    }

    private void visiblePackageByManageType() {
        String manageType = SrcComponentUtil.getManagetype((IFormView)this.getView());
        if ("1".equals(manageType) || "3".equals(manageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"package"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchfillentry"});
            if ("src_supplier_select".equals(this.getView().getEntityId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"enrollpackage"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"package"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"batchfillentry"});
            if ("src_supplier_select".equals(this.getView().getEntityId())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"enrollpackage"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOPerationEvt) {
        String operateKey;
        super.beforeDoOperation(beforeDoOPerationEvt);
        switch (operateKey = ((AbstractOperate)beforeDoOPerationEvt.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.setPackageData();
                break;
            }
        }
    }

    protected void setPackageData() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject packageObj = this.getPackage();
        try {
            String entryKey = this.getEntryKey();
            DynamicObjectCollection cols = model.getEntryEntity(entryKey);
            int rowCount = cols.size();
            for (int i = 0; i < rowCount; ++i) {
                Object packageVal = model.getValue("package", i);
                if (null != packageVal || null == packageObj) continue;
                model.setValue("package", packageObj.getPkValue(), i);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    private DynamicObject getPackage() {
        IDataModel model = this.getModel();
        long parentIdVal = model.getDataEntity().getLong("parentid");
        QFilter projectFilter = new QFilter("project", "=", (Object)parentIdVal);
        projectFilter.and("packagename", "in", (Object)"ByItem");
        return BusinessDataServiceHelper.loadSingle((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{projectFilter});
    }

    protected String getEntryKey() {
        String entityKey = this.getView().getEntityId();
        if ("src_supplier_invite".equals(entityKey)) {
            return "entrysupplier";
        }
        return "entryentity";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname;
        super.propertyChanged(e);
        switch (propertyname = e.getProperty().getName()) {
            case "bidattach": {
                if (Objects.equals(this.getView().getEntityId(), "src_supplier_select")) {
                    return;
                }
                AttachmentUtils.setAttachFileName((IFormView)this.getView(), (int)this.getModel().getEntryCurrentRowIndex("entryentity"));
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (SrcQuickPurUtil.isQuickPurchase((IFormView)this.getView(), Collections.singletonList("src_decision"))) {
            BasedataEdit supplierEdit = (BasedataEdit)this.getControl("supplier");
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (SrcQuickPurUtil.isQuickPurchase((IFormView)this.getView(), Collections.singletonList("src_decision"))) {
            String keyName = beforeF7SelectEvent.getProperty().getName();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            switch (keyName) {
                case "supplier": {
                    IFormView parentView = this.getView().getParentView();
                    if (parentView == null) {
                        return;
                    }
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                    List supplierIds = SrcPurListUtil.getInviteSupplier((Object)String.valueOf(parentView.getModel().getDataEntity().getPkValue()));
                    QFilter qFilter = new QFilter("id", "in", (Object)supplierIds);
                    listShowParameter.getListFilterParameter().setFilter(qFilter);
                    break;
                }
            }
        }
    }
}

