/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.src.common.util.SrcAppCache;

public class SrcBidPackageEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)this.getView().getEntityId(), (Object)this.getView().getPageId(), (IFormView)parentView);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        switch (key = operate.getOperateKey()) {
            case "query": {
                this.purlistQuery();
                break;
            }
        }
    }

    public void purlistQuery() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        IDataModel model = this.getView().getModel();
        HashSet purlistSet = new HashSet();
        for (int index = 0; index < selectIndexs.length; ++index) {
            DynamicObject row = model.getEntryRowEntity("entryentity", selectIndexs[index]);
            purlistSet.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"purlist"));
        }
        if (purlistSet.size() > 0) {
            QFilter qfilter = new QFilter("purlist", "in", purlistSet);
            qfilter.and("billtype", "=", (Object)"1");
            OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_purlistquery", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilter, null);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u6807\u5305\u3002", (String)"SrcBidPackageEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit purlist = (BasedataEdit)this.getView().getControl("purlist");
        if (purlist != null) {
            purlist.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "purlist": {
                long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity());
                QFilter qfilter = new QFilter("project", "=", (Object)projectId);
                qfilter.and("billtype", "=", (Object)"1");
                Set<Long> excluPurlistIds = this.getExcluPurlistIds(evt);
                if (null != excluPurlistIds && excluPurlistIds.size() > 0) {
                    qfilter.and("purlist", "not in", excluPurlistIds);
                }
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
                showParameter.getListFilterParameter().setFilter(qfilter);
                break;
            }
        }
    }

    public Set<Long> getExcluPurlistIds(BeforeF7SelectEvent evt) {
        if (this.getModel().getDataEntity().getBoolean("isallowrepeat")) {
            return null;
        }
        HashSet<Long> excluPurlistIds = new HashSet<Long>();
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            excluPurlistIds.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getEntryRowEntity("entryentity", i), (String)"purlist"));
        }
        return excluPurlistIds;
    }
}

