/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcUsualUserUtils;

public class SrcEvaluateConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)this.getView().getEntityId(), (Object)this.getView().getPageId(), (IFormView)parentView);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows.size() == 0) {
            this.getModel().getEntryEntity("entryentity").addNew();
            this.getModel().setValue("entrystatus", (Object)"A", 0);
            this.getView().updateView("entryentity");
        }
        if (null == this.getModel().getValue("indextype")) {
            this.getModel().setValue("indextype", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS008"), 0);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        super.beforeDeleteRow(evt);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            for (int index : evt.getRowIndexs()) {
                String entrystatus = PdsCommonUtils.object2String((Object)this.getModel().getValue("entrystatus", index), (String)"");
                if ("A".equals(entrystatus)) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4e0b\u8fbe\u7684\u5206\u5f55\u624d\u80fd\u88ab\u5220\u9664\u3002", (String)"SrcEvaluateConfigEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit scorer;
        BasedataEdit scheme;
        super.registerListener(e);
        BasedataEdit indexType = (BasedataEdit)this.getView().getControl("indextype");
        if (indexType != null) {
            indexType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scheme = (BasedataEdit)this.getView().getControl("scheme")) != null) {
            scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scorer = (BasedataEdit)this.getView().getControl("scorer")) != null) {
            scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!PdsCommonUtils.isValidBillType((IFormView)this.getView().getParentView())) {
            return;
        }
        super.propertyChanged(e);
        block3 : switch (key = e.getProperty().getName()) {
            case "indextype": {
                String baseType;
                int index = e.getChangeSet()[0].getRowIndex();
                IDataModel model = this.getModel();
                DynamicObject row = model.getEntryRowEntity("entryentity", index);
                DynamicObject indexTypeObj = row.getDynamicObject("indextype");
                model.setValue("scheme", null, index);
                if (null == indexTypeObj) {
                    model.setValue("weight", null, index);
                    return;
                }
                String scoreType = this.getView().getParentView().getModel().getDataEntity().getString("scoretype");
                HashMap<String, String> paramMap = new HashMap<String, String>(2);
                paramMap.put("scoretype", scoreType);
                long schemeId = SchemeFilterUtils.getFirstSchemeId((DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)this.getView().getEntityId(), paramMap);
                if (schemeId == 0L) {
                    model.setValue("scheme", null, index);
                } else {
                    model.setValue("scheme", (Object)schemeId, index);
                }
                switch (baseType = indexTypeObj.getString("basetype")) {
                    case "8": {
                        this.getModel().setValue("weight", (Object)100, index);
                        break block3;
                    }
                }
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        if (!PdsCommonUtils.isValidBillType((IFormView)this.getView().getParentView())) {
            return;
        }
        switch (key = evt.getProperty().getName()) {
            case "indextype": {
                String sourceMethod = evt.getSourceMethod();
                if (Objects.equals(sourceMethod, "setItemByNumber")) {
                    return;
                }
                ArrayList<String> indexTypes = new ArrayList<String>(1);
                indexTypes.add("8");
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("basetype", "in", indexTypes));
                break;
            }
            case "scorer": {
                String expertType = ExpertFilterUtils.inviteExpertType();
                if (null == expertType) break;
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                paramMap.put("ismustinput", true);
                ExpertFilterUtils.setExpertF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)("src_expertevaluate_" + expertType + '_' + "filter"), paramMap);
                break;
            }
            case "scheme": {
                String scoreType = this.getView().getParentView().getModel().getDataEntity().getString("scoretype");
                HashMap<String, String> paramMap = new HashMap<String, String>(1);
                paramMap.put("scoretype", scoreType);
                paramMap.put("schemetype", "4");
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)this.getView().getEntityId(), paramMap);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.deleteInvalidRows(this.getModel().getDataEntity(true));
                break;
            }
            case "usualuser": {
                long billId = SrcUsualUserUtils.getBillId((String)this.getView().getEntityId());
                if (billId > 0L) {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_usualuser", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, null);
                }
                evt.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                this.createMyTaskByScorer();
                SrcUsualUserUtils.addToUsualScorer((IFormView)this.getView());
                break;
            }
        }
    }

    private void createMyTaskByScorer() {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setProjectId(PdsCommonUtils.object2Long((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue()));
        context.setCompkey("src_project_reference");
        SrcMyTaskFacade.createMyTaskByScorer((SrcMyTaskContext)context);
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("indextype") != null && obj.getLong("indextype.id") != 0L) continue;
            ite.remove();
        }
    }
}

