/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import com.alibaba.druid.util.StringUtils;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcIsNeedBiddocSetting
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsNeedBiddoc();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                if (!this.checkBidTndDoc(args)) break;
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean checkBidTndDoc(BeforeDoOperationEventArgs evt) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return false;
        }
        String parentkey = parentView.getEntityId();
        if (!StringUtils.equals((String)"tnd_tenderbill", (String)parentkey)) {
            return false;
        }
        DynamicObject billObj = parentView.getModel().getDataEntity();
        if (billObj == null) {
            return false;
        }
        Boolean isneedbiddoc = billObj.getBoolean("isneedbiddoc");
        if (isneedbiddoc.booleanValue()) {
            return false;
        }
        DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return false;
        }
        int index = 1;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : rows) {
            if (row.getBoolean("isneedbiddoc") && row.getString("packfilename").length() == 0) {
                String entryStatus = row.getString("entrystatus");
                if (Objects.equals(entryStatus, ProjectStatusEnums.INVALID.getValue())) {
                    ++index;
                    continue;
                }
                sb = sb.length() == 0 ? sb.append(index) : sb.append(',').append(index);
            }
            ++index;
        }
        if (sb.length() > 0) {
            evt.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9700\u8981\u4e0a\u4f20\u6807\u4e66\uff0c\u8bf7\u4e0a\u4f20\u540e\u64cd\u4f5c\u3002", (String)"SrcIsNeedBiddocSetting_1", (String)"scm-src-formplugin", (Object[])new Object[0]), sb));
            return true;
        }
        return false;
    }

    private void setIsNeedBiddoc() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if ("src_bidassess_doc".equals(this.getView().getEntityId())) {
            return;
        }
        String parentkey = parentView.getEntityId();
        DynamicObject billObj = parentView.getModel().getDataEntity();
        if (billObj == null) {
            return;
        }
        boolean isneedbiddoc = true;
        try {
            isneedbiddoc = PdsCommonUtils.getNotProjectBill().contains(parentkey) ? billObj.getBoolean("isneedbiddoc") : billObj.getBoolean("srctype.isneedbiddoc");
        }
        catch (Exception e) {
            isneedbiddoc = false;
        }
        if (isneedbiddoc) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isneedbiddoc"});
            this.getView().getModel().setValue("isneedbiddoc_p", (Object)Boolean.TRUE);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isneedbiddoc"});
            if (!(StringUtils.equals((String)"src_project", (String)parentkey) || StringUtils.equals((String)"src_biddoc", (String)parentkey) || StringUtils.equals((String)"src_bidpublish", (String)parentkey))) {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"isneedbiddoc"});
            }
            ComboEdit packfiletype = (ComboEdit)this.getControl("packfiletype");
            packfiletype.setMustInput(false);
            TextEdit packfilename = (TextEdit)this.getControl("packfilename");
            packfilename.setMustInput(false);
            AttachmentEdit bidattach = (AttachmentEdit)this.getControl("bidattach");
            bidattach.setMustInput(false);
        }
    }
}

