/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.supplierfilter.SupplierFilterUtils;
import kd.scm.pds.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.src.common.util.SrcPurListUtil;
import org.apache.commons.collections.CollectionUtils;

public class SrcItemSupplierEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ISBYCOLUMN = "isbycolumn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supControl = (BasedataEdit)this.getView().getControl("supplier");
        if (null != supControl) {
            supControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildData();
        this.setDefaultSupplier();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.buildData();
                this.setDefaultSupplier();
                break;
            }
        }
    }

    private void buildData() {
        String projectId = this.getProjectId();
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)Long.parseLong(projectId));
        QFilter filter = new QFilter("project", "=", (Object)Long.parseLong(projectId));
        filter.and("purlist.id", "not in", (Object)purListEndIds);
        filter.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist", (QFilter[])filter.toArray());
        List purListIds = cols.stream().map(col -> col.getLong("purlist")).distinct().collect(Collectors.toList());
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        List itemPurListIds = rows.stream().map(row -> row.getLong("purlist.id")).distinct().collect(Collectors.toList());
        HashSet<Integer> seqSet = new HashSet<Integer>();
        int i = 0;
        for (Long itemPurListId : itemPurListIds) {
            if (!purListIds.remove(itemPurListId)) {
                seqSet.add(i);
            }
            ++i;
        }
        if (CollectionUtils.isNotEmpty(seqSet)) {
            this.getModel().deleteEntryRows("entryentity", seqSet.stream().mapToInt(Integer::valueOf).toArray());
        }
        if (CollectionUtils.isNotEmpty(purListIds)) {
            DynamicObject[] purObjs;
            DynamicObjectCollection purRows = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject purObj : purObjs = BusinessDataServiceHelper.load((Object[])purListIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"src_purlistf7").getDynamicObjectType())) {
                DynamicObject col2 = purRows.addNew();
                col2.set("purlist", (Object)purObj);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
        this.showSupplierByColumn();
        this.setSupColumnVal();
        this.getView().updateView("entryentity");
    }

    private void setEnable() {
        boolean isSourceSupplier;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        boolean isEnable = true;
        String entityKey = parentView.getEntityId();
        if ("src_bidpublish".equals(entityKey) && (isSourceSupplier = parentView.getModel().getDataEntity().getBoolean("issourcesupplier"))) {
            isEnable = false;
        }
        if (!isEnable) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ISBYCOLUMN, "entryentity"});
        }
    }

    private void setDefaultSupplier() {
        int rowcount = this.getModel().getEntryRowCount("entryentity");
        long pkVal = this.getModel().getDataEntity().getLong("id");
        Set<Long> supIdSet = this.getSupIds();
        IDataModel model = this.getModel();
        for (int i = 0; i < rowcount; ++i) {
            Object supObj = model.getValue("supplier", i);
            if (pkVal != 0L && null != supObj && ((DynamicObjectCollection)supObj).size() > 0) continue;
            model.setValue("supplier", (Object)supIdSet.toArray(new Object[0]), i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String proName;
        switch (proName = evt.getProperty().getName()) {
            case "supplier": {
                DynamicObject obj;
                boolean isSourceSup;
                IFormView parentView = this.getView().getParentView();
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                String supplierType = SupplierFilterUtils.inviteSupplierType();
                if (null != supplierType) {
                    HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                    paramMap.put("ismustinput", true);
                    SupplierFilterUtils.setSupplierF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity().getDynamicObject("projectf7"), (String)("src_project_" + supplierType + '_' + "filter"), paramMap);
                }
                if (!"src_bidpublish".equals(parentView.getEntityId()) && !"src_project".equals(parentView.getEntityId()) || !(isSourceSup = (obj = parentView.getModel().getDataEntity()).getBoolean("issourcesupplier"))) break;
                int rowIndex = evt.getRow();
                Object purList = this.getModel().getValue("purlist", rowIndex);
                if (null == purList) {
                    return;
                }
                DynamicObject purListObj = (DynamicObject)purList;
                DynamicObject material = purListObj.getDynamicObject("material");
                HashSet<Long> matIdSet = new HashSet<Long>(2);
                matIdSet.add(material.getLong("id"));
                QFilter supFilter = new QFilter("id", "in", this.getSupIdsBySourceList(obj, matIdSet));
                evt.getCustomQFilters().add(supFilter);
                break;
            }
        }
    }

    private String getProjectId() {
        String projectId = this.getModel().getDataEntity().getString("parentid");
        if (null == projectId || projectId.trim().length() == 0) {
            IFormView parentView = this.getView().getParentView();
            projectId = null != parentView ? String.valueOf(parentView.getModel().getDataEntity().getPkValue()) : "0";
        }
        return projectId;
    }

    private Set<Long> getSupIds() {
        Set<Long> supIdsSet = new HashSet<Long>(1);
        DynamicObject[] supplierCompDatas = this.getSupplierCompDatas();
        if (supplierCompDatas != null) {
            Set<String> supEntityKeySet = this.getModelSupEntityKey();
            supIdsSet = supEntityKeySet.contains(this.getView().getParentView().getEntityId()) ? Arrays.stream(supplierCompDatas).filter(Objects::nonNull).map(col -> (Long)col.getPkValue()).collect(Collectors.toSet()) : Arrays.stream(supplierCompDatas).filter(col -> null != col.getDynamicObject("supplier")).map(col -> (Long)col.getDynamicObject("supplier").getPkValue()).collect(Collectors.toSet());
        }
        return supIdsSet;
    }

    private Set<Long> getSupIdsBySourceList(DynamicObject obj, Set<Long> matrialIdSet) {
        List dataList = SrcPurListUtil.getPmSourceListData((DynamicObject)obj, matrialIdSet);
        HashSet<Long> supIdSet = new HashSet<Long>(dataList.size());
        for (Map dataMap : dataList) {
            Object supplierId = dataMap.get("supplierId");
            if (!(supplierId instanceof Long)) continue;
            supIdSet.add((Long)supplierId);
        }
        return supIdSet;
    }

    private DynamicObject[] getSupplierCompDatas() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return null;
        }
        Set<String> supEntityKeySet = this.getModelSupEntityKey();
        if (supEntityKeySet.contains(parentView.getEntityId())) {
            DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (null == rows || rows.size() == 0) {
                return null;
            }
            HashSet supplierSet = new HashSet(16);
            for (DynamicObject row : rows) {
                supplierSet.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"supplier"));
            }
            return BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierSet)});
        }
        String projectID = this.getProjectId();
        String selectFiled = "suppliertype,supplier,isinvite";
        QFilter filter = new QFilter("entryparentid", "=", (Object)projectID);
        filter.or("billid", "=", (Object)Long.parseLong(projectID));
        filter.and("isconfirm", "=", (Object)Boolean.TRUE);
        DynamicObject[] supplierCompDatas = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFiled, (QFilter[])new QFilter[]{filter});
        return supplierCompDatas;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        switch (fieldName = e.getProperty().getName()) {
            case "supplier": {
                return;
            }
            case "isbycolumn": {
                this.showSupplierByColumn();
                this.setSupColumnVal();
                break;
            }
        }
        this.supColumnChange(e);
    }

    private void supColumnChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection supCols = (DynamicObjectCollection)model.getValue("supplier", rowIndex);
        ArrayList<Long> supIdList = DynamicObjectUtil.getMulId((DynamicObjectCollection)supCols);
        if (null == supIdList) {
            supIdList = new ArrayList<Long>(10);
        }
        IPageCache cache = this.getPageCache();
        String fieldName = e.getProperty().getName();
        int maxSupColumnSize = this.getMaxSupplierColumnSize();
        for (int size = 1; size <= maxSupColumnSize; ++size) {
            String supIdStr;
            String supColumnKey = "supplier" + size;
            if (!fieldName.equals(supColumnKey) || null == (supIdStr = cache.get(supColumnKey))) continue;
            Object newValue = changeData.getNewValue();
            long supId = Long.parseLong(supIdStr);
            if (((Boolean)newValue).booleanValue()) {
                supIdList.add(supId);
            } else {
                supIdList.remove(supId);
            }
            model.setValue("supplier", (Object)supIdList.toArray(new Object[0]), rowIndex);
            return;
        }
    }

    private void showSupplierByColumn() {
        boolean isByColumn = this.getModel().getDataEntity().getBoolean(ISBYCOLUMN);
        if (!isByColumn) {
            return;
        }
        DynamicObject[] supObjs = this.getSupplierCompDatas();
        int maxSupColumnSize = this.getMaxSupplierColumnSize();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        String supColumnKey = "";
        for (int i = 1; i <= maxSupColumnSize; ++i) {
            supColumnKey = "supplier" + i;
            view.setVisible(Boolean.FALSE, new String[]{supColumnKey});
            cache.remove(supColumnKey);
        }
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        boolean isSourceSupplier = parentView.getModel().getDataEntity().getBoolean("issourcesupplier");
        if (null != supObjs) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            if (null == entryGrid) {
                return;
            }
            Set<String> supEntityKeySet = this.getModelSupEntityKey();
            for (int i = 0; i < supObjs.length; ++i) {
                FieldEdit fieldEditControl;
                DynamicObject supObj = supObjs[i];
                DynamicObject supplier = null;
                supplier = supEntityKeySet.contains(parentView.getEntityId()) ? supObj : supObj.getDynamicObject("supplier");
                if (null == supplier || null == (fieldEditControl = (FieldEdit)this.getControl(supColumnKey = "supplier" + (i + 1)))) continue;
                String supName = supplier.getString("name");
                fieldEditControl.setCaption(new LocaleString(supName));
                view.setVisible(Boolean.TRUE, new String[]{supColumnKey});
                String supIdStr = String.valueOf(supplier.getPkValue());
                cache.put(supColumnKey, supIdStr);
                if (!isSourceSupplier) continue;
                List properties = kd.scm.common.util.DynamicObjectUtil.getContainerProperties((Container)entryGrid);
                for (String property : properties) {
                    if (Objects.equals(property, "supplier")) continue;
                    view.setEnable(Boolean.FALSE, i, new String[]{property});
                }
            }
        }
    }

    private void setSupColumnVal() {
        boolean isByColumn = this.getModel().getDataEntity().getBoolean(ISBYCOLUMN);
        if (!isByColumn) {
            return;
        }
        IPageCache cache = this.getPageCache();
        int maxSupColumnSize = this.getMaxSupplierColumnSize();
        DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryCols.size(); ++i) {
            DynamicObject col = (DynamicObject)entryCols.get(i);
            DynamicObjectCollection supCols = col.getDynamicObjectCollection("supplier");
            if (null == supCols) continue;
            HashMap<String, DynamicObject> supplierIDMap = new HashMap<String, DynamicObject>(16);
            for (int j = 0; j < supCols.size(); ++j) {
                DynamicObject supplier = (DynamicObject)supCols.get(j);
                DynamicObject obj = (DynamicObject)supplier.get(1);
                if (obj == null) continue;
                supplierIDMap.put(String.valueOf(obj.getPkValue()), supplier);
            }
            for (int size = 1; size <= maxSupColumnSize; ++size) {
                String supColumnKey = "supplier" + size;
                String supIdStr = cache.get(supColumnKey);
                if (null == supIdStr) continue;
                boolean isSelect = false;
                if (null != supplierIDMap.get(supIdStr)) {
                    isSelect = true;
                }
                this.getModel().setValue(supColumnKey, (Object)isSelect, i);
            }
        }
    }

    protected int getMaxSupplierColumnSize() {
        return 20;
    }

    public Set<String> getModelSupEntityKey() {
        HashSet<String> supEntityKey = new HashSet<String>();
        supEntityKey.add("src_project");
        supEntityKey.add("src_invitesupplier");
        supEntityKey.add("src_bidpublish");
        return supEntityKey;
    }
}

