/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;

public class SrcSelectExpertHelper
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "selectexpert": {
                this.selectExpert();
                break;
            }
            case "logquery": {
                QFilter qfilters = new QFilter("project", "=", (Object)this.getModel().getDataEntity().getLong("projectf7.id"));
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"pds_expselectlog", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilters, null);
                break;
            }
        }
    }

    private void selectExpert() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("project", projectId);
        if (this.getCurrentRowInfo(paramMap)) {
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_selectexpert", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "pds_selectexpert"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        Map paramMap = (Map)returnData;
        if (paramMap == null || paramMap.size() == 0) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "pds_selectexpert": {
                this.setScorerValue(paramMap);
                break;
            }
        }
    }

    private void setScorerValue(Map<String, Object> paramMap) {
        Object currentRow = paramMap.get("currentrow");
        if (StringUtils.isBlank((Object)currentRow)) {
            return;
        }
        int index = (Integer)currentRow;
        List newExpertIds = (List)paramMap.get("expertuser");
        if (newExpertIds == null || newExpertIds.size() == 0) {
            return;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("srctype"));
        boolean isOneRowPerExpert = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isOneRowPerExpert", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity())));
        IDataModel model = this.getModel();
        boolean isAdd = (Boolean)(paramMap.get("isadd") == null ? Boolean.valueOf(false) : paramMap.get("isadd"));
        if (isAdd && !isOneRowPerExpert) {
            Set expertIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)((DynamicObject)model.getEntryEntity("entryentity").get(index)), (String)"scorer");
            newExpertIds.addAll(expertIds);
        }
        this.setScorerValue(model, newExpertIds, paramMap, index, isOneRowPerExpert);
    }

    private void setScorerValue(IDataModel model, List<Long> newExpertIds, Map<String, Object> paramMap, int index, boolean isOneRowPerExpert) {
        if (!isOneRowPerExpert) {
            model.setValue("scorer", (Object)newExpertIds.toArray(new Object[0]), index);
            model.setValue("qfilter_tag", paramMap.get("condition"), index);
            return;
        }
        int rowCount = model.getEntryRowCount("entryentity");
        index = 999999;
        for (int i = 0; i < rowCount; ++i) {
            if (model.getEntryRowEntity("entryentity", i).getDynamicObjectCollection("scorer").size() != 0) continue;
            index = i;
            break;
        }
        index = index < rowCount ? index : rowCount;
        for (long newExpertId : newExpertIds) {
            Object[] scoreIds = new Object[]{newExpertId};
            if (index >= rowCount) {
                model.appendEntryRow("entryentity", index, 1);
            }
            model.setValue("scorer", (Object)scoreIds, index);
            model.setValue("qfilter_tag", paramMap.get("condition"), index);
            ++index;
        }
    }

    private boolean getCurrentRowInfo(Map<String, Object> paramMap) {
        DynamicObjectCollection entreObj = this.getModel().getEntryEntity("entryentity");
        if (null == entreObj || entreObj.size() == 0) {
            IDataModel model = this.getModel();
            model.createNewEntryRow("entryentity");
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowIndex);
        if (row == null) {
            return false;
        }
        paramMap.put("currentrow", currentRowIndex);
        paramMap.put("packageid", row.getLong("package.id"));
        paramMap.put("packagename", row.getString("package.packagename"));
        paramMap.put("indextypeid", row.getLong("indextype.id"));
        paramMap.put("datefrom", row.getDate("datefrom"));
        paramMap.put("dateto", row.getDate("dateto"));
        paramMap.put("select_ids", this.getSelectScorerIds(row));
        return true;
    }

    private Set<Long> getSelectScorerIds(DynamicObject currRow) {
        HashSet<Long> selectScorerIds = new HashSet<Long>();
        long packageId = currRow.getLong("package.id");
        long indexTypeId = currRow.getLong("indextype.id");
        long schemeId = currRow.getLong("scheme.id");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            if (packageId != row.getLong("package.id") || indexTypeId != row.getLong("indextype.id") || schemeId != row.getLong("scheme.id")) continue;
            selectScorerIds.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"scorer"));
        }
        return selectScorerIds;
    }
}

