/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.bizop.PdsBizOperateLogUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.common.recommend.ISrcRecommendSupplier;
import kd.scm.src.common.util.SrcAptitudeUtils;
import kd.scm.src.common.util.SrcSavePackageF7Util;
import kd.scm.src.formplugin.comp.SrcSupplierValidateModelData;
import kd.scm.src.formplugin.comp.SrcSupplierValidateTenderModelData;
import org.apache.commons.lang3.StringUtils;

public class SrcSupplierSelectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private boolean isSupplierChange = true;
    private boolean isPuragentChange = false;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (!SrcAptitudeUtils.isSupplierReplyAptitude((DynamicObject)parentView.getModel().getDataEntity())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ispuraptitude"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "recommend": {
                this.isSupplierChange = false;
                this.recommend();
                this.isSupplierChange = true;
                break;
            }
            case "unrecommend": {
                this.isSupplierChange = false;
                this.unrecommend();
                this.isSupplierChange = true;
                break;
            }
            case "submit": {
                this.deleteInvalidRows();
                Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entrysupplier"), (String)"package", (String)"supplier", null);
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    evt.setCancel(true);
                    evt.setCancelMessage(resultMap.get("message").toString());
                    break;
                }
                if (!this.validateModelData()) {
                    evt.setCancel(true);
                    evt.setCancelMessage(ResManager.loadKDString((String)"\u62a5\u540d\u4f9b\u5e94\u5546\u5206\u5f55\u6570\u636e\u6709\u66f4\u65b0,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"SrcSupplierSelectEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!Objects.equals("src_supplier_select2", this.getView().getEntityId())) break;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                break;
            }
            case "reenroll": {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                this.reEnroll(evt);
                break;
            }
            case "reenrollquery": {
                this.reEnrollQuery(evt);
                break;
            }
            case "save": {
                if (this.validateModelData()) break;
                evt.setCancel(true);
                evt.setCancelMessage(ResManager.loadKDString((String)"\u62a5\u540d\u4f9b\u5e94\u5546\u5206\u5f55\u6570\u636e\u6709\u66f4\u65b0,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"SrcSupplierSelectEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean validateModelData() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin((String)SrcSupplierValidateModelData.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcSupplierValidateModelData.class.getName());
        return context.isSucced();
    }

    private boolean validateTenderModelData() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin((String)SrcSupplierValidateTenderModelData.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcSupplierValidateTenderModelData.class.getName());
        return context.isSucced();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "deleteentry": {
                this.resetIsSelect();
                break;
            }
            case "autorecommend": {
                if (!evt.getOperationResult().isSuccess()) break;
                this.autoRecommend(operateKey);
                break;
            }
        }
    }

    private void autoRecommend(String operateKey) {
        ExtPluginContext context = ExtPluginFactory.createContext((IFormView)this.getView(), (String)operateKey, (boolean)true);
        ExtPluginFactory.executeExtplugin((String)ISrcRecommendSupplier.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        if (!context.isSucced()) {
            this.getView().showTipNotification(PdsCommonUtils.object2String((Object)context.getMessage(), (String)ResManager.loadKDString((String)"\u5904\u7406\u672a\u6210\u529f", (String)"SrcSupplierSelectEdit_8", (String)"scm-src-formplugin", (Object[])new Object[0])));
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String property = evt.getProperty().getName();
        int currIndex = evt.getChangeSet()[0].getRowIndex();
        switch (property) {
            case "supplier": {
                this.resetPurAgentValues(currIndex, "ispuragent", "isfeeagent", "ispuraptitude");
            }
            case "package": {
                DynamicObject noPackage;
                Object newValue = evt.getChangeSet()[0].getNewValue();
                Object packageObj = this.getModel().getValue("package", currIndex);
                if (packageObj == null && Objects.nonNull(noPackage = SrcSavePackageF7Util.getNoPackageNameObj((IDataModel)this.getModel()))) {
                    this.getModel().setValue("package", noPackage.getPkValue(), currIndex);
                }
                this.resetIsSelect();
                if (!this.isSupplierChange || !StringUtils.equals((CharSequence)property, (CharSequence)"supplier")) break;
                this.setSupplierInfo(newValue, currIndex);
                break;
            }
            case "ispuragent": {
                this.resetPurAgentValues(currIndex, "ispuragent", null, null);
                break;
            }
            case "isfeeagent": {
                this.resetPurAgentValues(currIndex, null, "isfeeagent", null);
                break;
            }
            case "ispuraptitude": {
                this.resetPurAgentValues(currIndex, null, null, "ispuraptitude");
                break;
            }
        }
    }

    protected void recommend() {
        if (!this.validateTenderModelData()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9080\u8bf7\u4f9b\u5e94\u5546\u5206\u5f55\u6570\u636e\u6709\u66f4\u65b0,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"SrcSupplierSelectEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> rows = this.getSelectRows("entryenroll");
        if (rows != null) {
            this.addToSelectSupplier(rows);
        }
    }

    protected void reEnroll(BeforeDoOperationEventArgs evt) {
        List<DynamicObject> rows = this.getReEnrollRows("entryenroll");
        if (CollectionUtils.isEmpty(rows)) {
            evt.setCancel(true);
            return;
        }
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid"));
        Set suppliers = rows.stream().map(e -> e.getLong("enrollsupplier.id")).collect(Collectors.toSet());
        String opType = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u65b0\u62a5\u540d", (String)"SrcSupplierSelectEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]);
        String description = ResManager.loadKDString((String)"\u5c06\u5220\u9664\u8fd9\u4e9b\u4f9b\u5e94\u5546\u7684\u62a5\u540d\u8bb0\u5f55\u53ca\u76f8\u5173\u9644\u4ef6\uff0c\u4f9b\u5e94\u5546\u53ef\u4ee5\u91cd\u65b0\u62a5\u540d\u3002", (String)"SrcSupplierSelectEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]);
        PdsBizOperateLogUtils.openOperateLog((IFormView)this.getView(), (String)this.getPluginName(), (String)opType, (String)description, (long)projectId, (long)projectId, (String)this.getView().getEntityId(), (String)((AbstractOperate)evt.getSource()).getOperateKey(), suppliers, null);
    }

    protected void reEnrollQuery(BeforeDoOperationEventArgs evt) {
        long billId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid"));
        PdsBizOperateLogUtils.logQurry((IFormView)this.getView(), (long)billId, (long)0L, null, (String)"reenroll", null, null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals("bizoperatelog") && "succed".equals(PdsCommonUtils.object2String((Object)evt.getReturnData(), (String)""))) {
            List<DynamicObject> rows = this.getReEnrollRows("entryenroll");
            Set supplierIds = rows.stream().map(e -> e.getLong("enrollsupplier.id")).collect(Collectors.toSet());
            QFilter qfilter = new QFilter("billid", "=", (Object)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid")));
            qfilter.and("supplier", "in", supplierIds);
            DeleteServiceHelper.delete((String)"src_enrollsupplier", (QFilter[])qfilter.toArray());
            this.getView().invokeOperation("refresh");
            DynamicObject[] applyObjs = BusinessDataServiceHelper.load((String)"tnd_apply", (String)"id", (QFilter[])new QFilter("id", "=", (Object)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid"))).toArray());
            OperateOption option = OperateOption.create();
            option.setVariableValue("supplierIds", String.valueOf(supplierIds));
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationServiceHelper.executeOperate((String)"reenroll", (String)"tnd_apply", (DynamicObject[])new DynamicObject[]{applyObjs[0]}, (OperateOption)option);
        }
    }

    protected void unrecommend() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entrysupplier");
        int[] indexs = grid.getSelectRows();
        if (indexs == null || indexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u63a8\u8350\u7684\u4f9b\u5e94\u5546\u548c\u6807\u6bb5\u3002", (String)"SrcSupplierSelectEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Integer> selectList = new ArrayList<Integer>(8);
        ArrayList<DynamicObject> selectedRowDatas = new ArrayList<DynamicObject>();
        IDataModel model = this.getModel();
        for (int i = 0; i < indexs.length; ++i) {
            DynamicObject row = model.getEntryRowEntity("entrysupplier", indexs[i]);
            String publishStatus = row.getString("publishstatus");
            if (null != publishStatus && "B".equals(publishStatus)) continue;
            selectList.add(indexs[i]);
            selectedRowDatas.add(row);
        }
        if (selectedRowDatas.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u7684\u6570\u636e\u90fd\u5df2\u53d1\u6807\uff0c\u4e0d\u80fd\u53d6\u6d88\u63a8\u8350\u3002", (String)"SrcSupplierSelectEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] selectIndexArrs = new int[selectList.size()];
        for (int i = 0; i < selectList.size(); ++i) {
            selectIndexArrs[i] = (Integer)selectList.get(i);
        }
        this.getModel().deleteEntryRows("entrysupplier", selectIndexArrs);
        this.resetIsSelect();
    }

    protected Set<String> getSelectedSuppliers() {
        HashSet<String> selectedSet = new HashSet<String>();
        DynamicObjectCollection selectedObjs = this.getModel().getDataEntity(true).getDynamicObjectCollection("entrysupplier");
        for (DynamicObject selectedObj : selectedObjs) {
            selectedSet.add(this.getKey(selectedObj, ""));
        }
        return selectedSet;
    }

    protected boolean isSelected(DynamicObject obj, String prefix, Set<String> selectedSuppliers) {
        return selectedSuppliers.contains(this.getKey(obj, prefix));
    }

    protected String getKey(DynamicObject obj, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject(prefix + "supplier"))));
        sb.append(String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject(prefix + "package"))));
        return sb.toString();
    }

    protected void addToSelectSupplier(List<DynamicObject> rows) {
        if (null == rows || rows.size() == 0) {
            return;
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        DynamicObjectCollection supRows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entrysupplier");
        if (null != supRows && supRows.size() > 0) {
            for (DynamicObject row : supRows) {
                if (null == row.getDynamicObject("supplier") || row.getLong("supplier.id") <= 0L) continue;
                this.setRowValue(ts, row, index, "");
                ++index;
            }
        }
        for (DynamicObject row : rows) {
            this.setRowValue(ts, row, index, "enroll");
            ++index;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entrysupplier");
        model.batchCreateNewEntryRow("entrysupplier", ts);
    }

    protected void resetIsSelect() {
        DynamicObjectCollection enrollObjs = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryenroll");
        if (enrollObjs == null || enrollObjs.size() == 0) {
            return;
        }
        Set<String> selectedSuppliers = this.getSelectedSuppliers();
        for (int i = 0; i < this.getModel().getEntryEntity("entryenroll").size(); ++i) {
            DynamicObject enrollObj = this.getModel().getEntryRowEntity("entryenroll", i);
            if (this.isSelected(enrollObj, "enroll", selectedSuppliers)) {
                this.getModel().setValue("isselect", (Object)Boolean.TRUE, i);
                continue;
            }
            this.getModel().setValue("isselect", (Object)Boolean.FALSE, i);
        }
    }

    protected void setRowValue(TableValueSetter ts, DynamicObject row, int index, String prifix) {
        ts.set("suppliertype", (Object)row.getString(prifix + "suppliertype"), index);
        ts.set("supplier", (Object)SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(prifix + "supplier")), index);
        ts.set("supplier_id", (Object)SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(prifix + "supplier")), index);
        DynamicObject loadSup = BusinessDataServiceHelper.loadSingle((Object)row.getDynamicObject(prifix + "supplier").getPkValue(), (String)row.getDynamicObject(prifix + "supplier").getDynamicObjectType().getName());
        ts.set("supname", (Object)loadSup.getString("name"), index);
        ts.set("package", (Object)SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(prifix + "package")), index);
        ts.set("package_id", (Object)SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(prifix + "package")), index);
        ts.set("publishstatus", (Object)"A", index);
        ts.set("linkman", (Object)row.getString(prifix + "linkman"), index);
        ts.set("duty", (Object)row.getString(prifix + "duty"), index);
        ts.set("email", (Object)row.getString(prifix + "email"), index);
        ts.set("phone", (Object)row.getString(prifix + "phone"), index);
        ts.set("address", (Object)row.getString(prifix + "address"), index);
        ts.set("note", (Object)row.getString(prifix + "note"), index);
        ts.set("risknum", (Object)row.getString(prifix + "risknum"), index);
        ts.set("riskremark", (Object)row.getString(prifix + "riskremark"), index);
        ts.set("isdownload", (Object)row.getString(prifix + "isdownload"), index);
        ts.set("supplierip", (Object)row.getString(prifix + "supplierip"), index);
        ts.set("entrysupplierip", (Object)row.getString(prifix + "supplierip"), index);
        ts.set("isaptitude", (Object)row.getString(prifix + "isaptitude"), index);
        ts.set("aptitudenote", (Object)row.getString(prifix + "aptitudenote"), index);
        ts.set("isexemptapt", (Object)row.getString(prifix + "isexemptapt"), index);
        ts.set("societycreditcode", (Object)row.getString(prifix + "societycreditcode"), index);
        String entryKey = row.getDynamicObjectType().getName();
        if ("entrysupplier".equals(entryKey)) {
            ts.set("publishstatus", (Object)row.getString(prifix + "publishstatus"), index);
            ts.set("publishdate", (Object)row.getString(prifix + "publishdate"), index);
            DynamicObject pulisher = row.getDynamicObject(prifix + "publisher");
            ts.set("publisher", null == pulisher ? Long.valueOf(0L) : pulisher.getPkValue(), index);
        }
        if ("src_supplier_select2".equals(this.getView().getEntityId())) {
            long packageId;
            ts.set("istender", (Object)row.getString(prifix + "istender"), index);
            ts.set("isquote", (Object)row.getString(prifix + "isquote"), index);
            ts.set("supplierip", (Object)row.getString(prifix + "supplierip"), index);
            ts.set("ispuragent", (Object)row.getString(prifix + "ispuragent"), index);
            ts.set("isfeeagent", (Object)row.getString(prifix + "isfeeagent"), index);
            if (!"2".equals(this.getView().getParentView().getModel().getDataEntity().getString("managetype")) && (packageId = PdsCommonUtils.object2Long((Object)ts.get("package_id", index))) == 0L) {
                DynamicObject noPackage = PdsCommonUtils.getNoPackageNameObj((long)SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity()));
                ts.set("package_id", noPackage.getPkValue(), index);
            }
        }
    }

    protected List<DynamicObject> getSelectRows(String entryName) {
        long projectId;
        QFilter qfilter;
        DynamicObjectCollection rows;
        ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>();
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryName);
        int[] indexs = grid.getSelectRows();
        if (indexs == null || indexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u5206\u5f55\u884c\u3002", (String)"SrcSupplierSelectEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return null;
        }
        String entityName = "src_enrollsupplier";
        if (this.getView().getEntityId().equals("src_supplier_select2")) {
            entityName = "src_supplierinvite";
        }
        if ((rows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])(qfilter = new QFilter("billid", "=", (Object)(projectId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid"))))).toArray())).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u63a8\u8350\u7684\u4f9b\u5e94\u5546\uff0c\u53ef\u80fd\u5df2\u7ecf\u63a8\u8350\u4e86\u3002", (String)"SrcSupplierSelectEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return selectedRows;
        }
        Set idSet = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        for (int i = 0; i < indexs.length; ++i) {
            DynamicObject row = this.getView().getModel().getEntryRowEntity(entryName, indexs[i]);
            if (!this.isRecommend(row) || !idSet.contains(row.getLong("id"))) continue;
            selectedRows.add(row);
            this.getModel().setValue("isselect", (Object)Boolean.TRUE, indexs[i]);
        }
        if (null == selectedRows || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u63a8\u8350\u7684\u4f9b\u5e94\u5546\uff0c\u53ef\u80fd\u5df2\u7ecf\u63a8\u8350\u6216\u672a\u6295\u6807\uff0c\u6216\u4f9b\u5e94\u5546\u88ab\u7981\u7528\u4e86\u3002", (String)"SrcSupplierSelectEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        return selectedRows;
    }

    private boolean isRecommend(DynamicObject row) {
        if (row.getBoolean("isselect")) {
            return false;
        }
        if (!row.getBoolean("enrollsupplier.enable")) {
            return false;
        }
        return !this.getView().getEntityId().equals("src_supplier_select2") || row.getBoolean("enrollistender");
    }

    protected List<DynamicObject> getReEnrollRows(String entryName) {
        ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>();
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryName);
        int[] indexs = grid.getSelectRows();
        if (indexs == null || indexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u5206\u5f55\u884c\u3002", (String)"SrcSupplierSelectEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection supEntrys = this.getModel().getEntryEntity("entrysupplier");
        Set supEntryIds = supEntrys.stream().map(supEntry -> supEntry.getLong("supplier.id")).collect(Collectors.toSet());
        for (int index : indexs) {
            DynamicObject row = this.getView().getModel().getEntryRowEntity(entryName, index);
            if (row.getBoolean("isselect") || supEntryIds.contains(row.getLong("enrollsupplier.id"))) continue;
            selectedRows.add(row);
        }
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u63a8\u8350\u5165\u56f4\u7684\u4f9b\u5e94\u5546\u4e0d\u5141\u8bb8\u9000\u56de\uff0c\u8bf7\u53d6\u6d88\u63a8\u8350\u540e\u518d\u9000\u56de\u3002", (String)"SrcSupplierSelectEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        return selectedRows;
    }

    private int deleteInvalidRows() {
        int index = 0;
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getDataEntity(true).getDynamicObjectCollection("entrysupplier");
        if (rows == null || rows.size() == 0) {
            return index;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("supplier") == null || obj.getLong("supplier.id") == 0L) {
                ite.remove();
                continue;
            }
            ++index;
        }
        this.getView().updateView();
        return index;
    }

    private void setSupplierInfo(Object newValue, int rowIndex) {
        if (!(newValue instanceof DynamicObject)) {
            return;
        }
        DynamicObject supobj = (DynamicObject)newValue;
        HashMap lingkerMap = new HashMap(8);
        Object supplierType = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
        lingkerMap = supplierType == null || "".equals(supplierType) || "bd_supplier".equals(supplierType.toString()) ? PdsLinkManFacade.getSupplierLinkMan((Object)SrmCommonUtil.getPkValue((DynamicObject)supobj)) : PdsLinkManFacade.getRegSupplierLinkMan((Object)SrmCommonUtil.getPkValue((DynamicObject)supobj));
        this.getModel().setValue("linkman", lingkerMap.get("linkman"), rowIndex);
        this.getModel().setValue("duty", lingkerMap.get("duty"), rowIndex);
        this.getModel().setValue("phone", lingkerMap.get("phone"), rowIndex);
        this.getModel().setValue("email", lingkerMap.get("email"), rowIndex);
        this.getModel().setValue("address", lingkerMap.get("address"), rowIndex);
        DynamicObject loadSup = BusinessDataServiceHelper.loadSingle((Object)supobj.getPkValue(), (String)supobj.getDynamicObjectType().getName());
        this.getModel().setValue("supname", (Object)loadSup.getString("name"), rowIndex);
    }

    public void registerListener(EventObject e) {
        BasedataEdit supplierUserEdit;
        BasedataEdit supplierBsEdit;
        super.registerListener(e);
        BasedataEdit packageFieldEdit = (BasedataEdit)this.getView().getControl("package");
        if (null != packageFieldEdit) {
            packageFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierBsEdit = (BasedataEdit)this.getView().getControl("supplier"))) {
            supplierBsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierUserEdit = (BasedataEdit)this.getView().getControl("supplieruser"))) {
            supplierUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String pro = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = null;
        switch (pro) {
            case "package": {
                long parentId = parentView.getModel().getDataEntity().getLong("id");
                qFilter = new QFilter("project.id", "=", (Object)parentId);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                DynamicObjectCollection entrySupCols = this.getModel().getEntryEntity("entrysupplier");
                Set supIdSet = entrySupCols.stream().filter(col -> null != col.getDynamicObject("supplier")).map(col -> col.getDynamicObject("supplier").getLong("id")).collect(Collectors.toSet());
                Object currSupObj = this.getModel().getValue("supplier", evt.getRow());
                if (null != currSupObj) {
                    supIdSet.remove(((DynamicObject)currSupObj).getLong("id"));
                }
                if (supIdSet.size() == 0) {
                    return;
                }
                qFilter = new QFilter("id", "not in", supIdSet);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "supplieruser": {
                Object currSupObj = this.getModel().getValue("supplier", evt.getRow());
                if (null == currSupObj) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcSupplierSelectEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)((DynamicObject)currSupObj).getLong("id"));
                qFilter = new QFilter("bizpartner", "=", (Object)bizPartnerId);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private void resetPurAgentValues(int currIndex, String isPurAgentField, String isFeeAgentField, String isPurAptitudeField) {
        if (!this.isPuragentChange) {
            this.isPuragentChange = true;
            SupplierUtil.isPuragentChangedHandle((IFormView)this.getView(), (int)currIndex, (String)isPurAgentField, (String)isFeeAgentField, (String)isPurAptitudeField);
            this.isPuragentChange = false;
        }
    }
}

