/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcSupplierValidateTenderModelData
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        IFormView parentView = context.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        if (!Objects.equals(parentView.getEntityId(), "src_selectsupplier2")) {
            return;
        }
        context.setBillObj(parentView.getModel().getDataEntity());
        context.setProjectObj(parentView.getModel().getDataEntity());
        if (!ExtFilterUtils.isMatchSourceTypeAndSourceFlow((Object)context, (String)this.getClass().getName(), (String)context.getPluginNumber())) {
            return;
        }
        this.validateTenderModelData(context);
    }

    public void validateTenderModelData(ExtPluginContext context) {
        QFilter filter = new QFilter("billid", "=", context.getView().getModel().getDataEntity().getPkValue());
        filter.and("istender", "=", (Object)"1");
        DynamicObjectCollection isTenders = QueryServiceHelper.query((String)"src_supplierinvite", (String)"id", (QFilter[])filter.toArray());
        DynamicObjectCollection rows = context.getView().getModel().getEntryEntity("entryenroll");
        List enrollSuppliers = rows.stream().filter(e -> e.getBoolean("enrollistender")).collect(Collectors.toList());
        if (isTenders.size() != enrollSuppliers.size()) {
            context.setSucced(false);
        }
    }
}

