/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;

public class SrcQuoteBillAttachHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.loadQuoteBillAttach(context);
    }

    private void loadQuoteBillAttach(ExtPluginContext context) {
        String openstatus = context.getView().getModel().getDataEntity().getString("projectf7.openstatus");
        if (StringUtils.isBlank((CharSequence)openstatus)) {
            return;
        }
        if (openstatus.equals(BidOpenStatusEnums.NOOPEN.getValue()) || openstatus.equals(BidOpenStatusEnums.NEGOTIATE.getValue())) {
            return;
        }
        long projectId = context.getView().getModel().getDataEntity().getLong("projectf7.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        String selectFields = "project,suppliertype,supplier,billdate,billno,turns,supplierip";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"tnd_quotebill", (String)selectFields, (QFilter[])qfilter.toArray(), (String)"supplier,billdate");
        if (rows == null || rows.length == 0) {
            return;
        }
        DynamicObjectCollection docRows = context.getView().getModel().getEntryEntity("entryentity");
        Map<String, List<Map<String, Object>>> attachmentsMap = this.getBillAttachMap(rows);
        Map<String, DynamicObject> attachObjMap = this.getAttachMap(attachmentsMap);
        context.getView().getModel().beginInit();
        for (DynamicObject row : rows) {
            long billId = row.getLong("id");
            List<Map<String, Object>> attachments = attachmentsMap.get(String.valueOf(billId));
            if (null == attachments || attachments.size() == 0) continue;
            DynamicObject docRow = docRows.addNew();
            docRow.set("suppliertype", (Object)"bd_supplier");
            docRow.set("supplier", row.get("supplier"));
            docRow.set("package", null);
            docRow.set("packfiletype", (Object)"8");
            docRow.set("billdate", row.get("billdate"));
            docRow.set("turns", row.get("turns"));
            docRow.set("supplierip", row.get("supplierip"));
            DynamicObjectCollection attachRows = docRow.getDynamicObjectCollection("bidattach");
            HashSet<Long> basedataidSet = new HashSet<Long>(attachments.size());
            for (Map<String, Object> attachment : attachments) {
                DynamicObject attObj = attachObjMap.get((String)attachment.get("uid"));
                if (null == attObj || !basedataidSet.add(attObj.getLong("id"))) continue;
                DynamicObject attachRow = attachRows.addNew();
                attachRow.set("fbasedataid", (Object)attObj);
            }
            docRow.set("bidattach", (Object)attachRows);
            String fileName = String.format(ResManager.loadKDString((String)"\u5355\u636e\u9644\u4ef6:%1$s", (String)"SrcQuoteBillAttachHandler_1", (String)"scm-src-formplugin", (Object[])new Object[0]), AttachmentUtils.getAttachFileName((DynamicObjectCollection)attachRows));
            docRow.set("packfilename", (Object)fileName);
        }
        context.getView().getModel().endInit();
        context.getView().updateView("entryentity");
    }

    private Map<String, List<Map<String, Object>>> getBillAttachMap(DynamicObject[] rows) {
        ArrayList<Long> billIdList = new ArrayList<Long>(rows.length);
        for (DynamicObject row : rows) {
            billIdList.add(row.getLong("id"));
        }
        Map attachmentsMap = AttachmentServiceHelper.getAttachments((String)"tnd_quotebill", (Object[])billIdList.toArray(new Object[0]), (String)"attachmentpanel", (boolean)false);
        return attachmentsMap;
    }

    private Map<String, DynamicObject> getAttachMap(Map<String, List<Map<String, Object>>> attachmentsMap) {
        Map attachMap;
        HashMap<String, DynamicObject> attachObjMap = new HashMap<String, DynamicObject>();
        if (null == attachmentsMap || attachmentsMap.size() == 0) {
            return attachObjMap;
        }
        HashSet<DynamicObject[]> uidSet = new HashSet<DynamicObject[]>();
        HashMap<String, Map<String, Object>> uidAttachMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, List<Map<String, Object>>> attachmentEntry : attachmentsMap.entrySet()) {
            for (Map<String, Object> attachment : attachmentEntry.getValue()) {
                DynamicObject[] uid = (DynamicObject[])attachment.get("uid");
                uidSet.add(uid);
                uidAttachMap.put((String)uid, attachment);
            }
        }
        this.addCreateId(uidAttachMap);
        QFilter[] filters = new QFilter[]{new QFilter("uid", "in", uidSet)};
        String selectFields = DynamicObjectUtil.getSelectfields((String)"bd_attachment", (boolean)false);
        DynamicObject[] attCols = BusinessDataServiceHelper.load((String)"bd_attachment", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> bdAttachMap = new HashMap<String, DynamicObject>(attCols.length);
        for (DynamicObject attchObj : attCols) {
            bdAttachMap.put(attchObj.getString("uid"), attchObj);
        }
        ArrayList newAttchMapList = new ArrayList();
        ArrayList<DynamicObject> needUpdateObj = new ArrayList<DynamicObject>();
        HashSet<String> updateUidSet = new HashSet<String>();
        for (Map.Entry entry : uidAttachMap.entrySet()) {
            String uid = (String)entry.getKey();
            DynamicObject bdAttach = (DynamicObject)bdAttachMap.get(uid);
            if (null == bdAttach) {
                updateUidSet.add(uid);
                newAttchMapList.add(entry.getValue());
                continue;
            }
            attachMap = (Map)entry.getValue();
            Long creatorId = bdAttach.getLong("creator.id");
            Object createUserId = attachMap.get("createUserId");
            if (null != createUserId && createUserId instanceof Long && ((Long)createUserId).compareTo(creatorId) != 0) {
                updateUidSet.add(uid);
                bdAttach.set("creator", createUserId);
                bdAttach.set("createtime", attachMap.get("createdate"));
                needUpdateObj.add(bdAttach);
                continue;
            }
            if (null == createUserId && creatorId != 0L) {
                updateUidSet.add(uid);
                bdAttach.set("creator", (Object)0L);
                bdAttach.set("createtime", attachMap.get("createdate"));
                needUpdateObj.add(bdAttach);
                continue;
            }
            attachObjMap.put(uid, bdAttach);
        }
        if (newAttchMapList.size() > 0) {
            List attObjs = AttachmentFieldServiceHelper.saveAttachments((String)"", (String)"", newAttchMapList);
            for (DynamicObject attObj : attObjs) {
                String uid = attObj.getString("uid");
                attachMap = (Map)uidAttachMap.get(uid);
                if (null == attachMap) continue;
                Object createUserId = attachMap.get("createUserId");
                if (null != createUserId && createUserId instanceof Long) {
                    attObj.set("creator", createUserId);
                } else {
                    attObj.set("creator", (Object)0L);
                }
                attObj.set("createtime", attachMap.get("createdate"));
                needUpdateObj.add(attObj);
            }
        }
        if (needUpdateObj.size() > 0) {
            DynamicObject[] updateAttCols;
            SaveServiceHelper.save((DynamicObject[])needUpdateObj.toArray(new DynamicObject[0]));
            filters = new QFilter[]{new QFilter("uid", "in", updateUidSet)};
            for (DynamicObject updateAttObj : updateAttCols = BusinessDataServiceHelper.load((String)"bd_attachment", (String)selectFields, (QFilter[])filters)) {
                String uid = updateAttObj.getString("uid");
                attachObjMap.put(uid, updateAttObj);
            }
        }
        return attachObjMap;
    }

    private void addCreateId(Map<String, Map<String, Object>> attachmentsMap) {
        if (null == attachmentsMap) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> uidAttachMapEntry : attachmentsMap.entrySet()) {
            Map<String, Object> attachMap = uidAttachMapEntry.getValue();
            Object createUserId = attachMap.get("createUserId");
            if (null == createUserId) continue;
            return;
        }
        QFilter filter = new QFilter("FNUMBER", "in", attachmentsMap.keySet());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_attachment", (String)"id,FNUMBER,FCREATEMEN", (QFilter[])filter.toArray());
        for (DynamicObject col : cols) {
            String number = col.getString("FNUMBER");
            Map<String, Object> attachMap = attachmentsMap.get(number);
            if (null == attachMap) continue;
            Long createMenId = col.getLong("FCREATEMEN");
            attachMap.put("createUserId", createMenId);
        }
    }
}

