/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.BidDocTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsOrderByUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcComponentUtil;
import kd.scm.src.formplugin.compext.SrcSupplierBidDocFilterHandler;

public class SrcSupplierBidDocAttachHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.loadBidDocAttach(context);
    }

    private void loadBidDocAttach(ExtPluginContext context) {
        QFilter bidDocFilter = null;
        if (null != context.getCompKeys() && context.getCompKeys().size() > 0) {
            bidDocFilter = new QFilter("project", "=", (Object)context.getProjectId());
            bidDocFilter.and("supplier", ">", (Object)0L);
            if (null != context.getExtFilterObj()) {
                String status = context.getExtFilterObj().getString("isopencontrol");
                if ("1".equals(status)) {
                    bidDocFilter.and("entrystatus", "=", (Object)"C");
                } else if ("0".equals(status)) {
                    bidDocFilter.and("entrystatus", "=", (Object)"B");
                }
            }
            bidDocFilter.and("packfiletype", "in", (Object)context.getCompKeys());
        } else {
            bidDocFilter = this.getBidDocFilter(context);
        }
        bidDocFilter.and("bidattach.fbasedataid", ">", (Object)0L);
        String orderBy = PdsOrderByUtils.getOrderByString((String)"orderby003");
        TemplateUtil.loadCompEntryData((IFormView)context.getView(), (String)"src_biddoctplf7", (QFilter)bidDocFilter, (Set)context.getExcludedFields(), (String)"entryentity", (String)orderBy, (boolean)false);
    }

    private QFilter getBidDocFilter(ExtPluginContext context) {
        QFilter bidDocFilter = this.getBaseBidDocFilter(context);
        Object baseTypeObj = PdsCommonUtils.getCustomParamValue((IFormView)context.getView().getParentView(), (String)"basetype");
        if ("src_aptitudeaudit".equals(context.getEntityId()) || PdsCommonUtils.isEqualOrContain((Object)baseTypeObj, (String)"4")) {
            QFilter typeFilter = new QFilter("packfiletype", "=", (Object)BidDocTypeEnums.APT_DOC.getValue());
            typeFilter.or("packfiletype", "=", (Object)BidDocTypeEnums.ENROLL_DOC.getValue());
            bidDocFilter.and(typeFilter);
        } else if (StringUtils.equals((CharSequence)context.getEntityId(), (CharSequence)"src_scorertask") && "2".equals(SrcComponentUtil.getManagetype((IFormView)context.getView()))) {
            bidDocFilter = bidDocFilter.and("package.id", "in", this.getPackageSet());
        }
        DynamicObject billObj = context.getView().getParentView().getModel().getDataEntity();
        if ("src_scoreassist".equals(context.getView().getParentView().getEntityId())) {
            String entityName = "src_bidassess";
            if (PdsCommonUtils.isEqualOrContain((Object)baseTypeObj, (String)"2")) {
                entityName = "src_compare";
            }
            long projectId = PdsCommonUtils.object2Long((Object)PdsCommonUtils.getCustomParamValue((IFormView)context.getView(), (String)"project"));
            billObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"opentype,projectf7", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        }
        if (SrcBidAssessUtils.isParallelOpenTec((DynamicObject)billObj)) {
            bidDocFilter.and("packfiletype", "!=", (Object)BidDocTypeEnums.BIZ_DOC.getValue());
        } else if (SrcBidAssessUtils.isParallelOpenBiz((DynamicObject)billObj)) {
            bidDocFilter.and("packfiletype", "=", (Object)BidDocTypeEnums.BIZ_DOC.getValue());
        } else if (SrcBidAssessUtils.isNeedIndexTypeControl((DynamicObject)billObj)) {
            if ("src_bidassess".equals(billObj.getDataEntityType().getName())) {
                bidDocFilter.and("packfiletype", "!=", (Object)BidDocTypeEnums.BIZ_DOC.getValue());
            } else if ("src_compare".equals(billObj.getDataEntityType().getName())) {
                bidDocFilter.and("packfiletype", "=", (Object)BidDocTypeEnums.BIZ_DOC.getValue());
            }
        }
        return bidDocFilter;
    }

    private Set<Long> getPackageSet() {
        QFilter qFilter = new QFilter("scorer", "=", (Object)RequestContext.get().getCurrUserId()).or("billid.creator", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and("billid.bizstatus", "!=", (Object)"E");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_scoretask_scorerf7", (String)"package.id", (QFilter[])new QFilter[]{qFilter});
        return rows.stream().map(row -> row.getLong("package.id")).collect(Collectors.toSet());
    }

    private QFilter getBaseBidDocFilter(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcSupplierBidDocFilterHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
        if (null != context.getQfilters()) {
            return context.getQfilters();
        }
        QFilter bidDocFilter = new QFilter("project", "=", (Object)context.getProjectId());
        bidDocFilter.and("entrystatus", "=", (Object)"C");
        return bidDocFilter;
    }
}

