/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcTenderSupplierSaveEntryData
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.saveEntryData(context);
    }

    protected void saveEntryData(ExtPluginContext context) {
        DynamicObject[] targetRows = this.getTenderSupplierRows(context.getView());
        if (targetRows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> sourceRowsMap = this.getSourceRowsMap(context.getView());
        if (sourceRowsMap.size() == 0) {
            return;
        }
        List properties = null;
        for (DynamicObject targetRow : targetRows) {
            DynamicObject sourceRow;
            if (null == properties) {
                properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)targetRow);
                properties.removeAll(this.getExcludedFields());
            }
            if (null == (sourceRow = sourceRowsMap.get(targetRow.getLong("id")))) continue;
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)sourceRow, (DynamicObject)targetRow, (List)properties, new HashSet(), (int)-1);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])targetRows);
    }

    private Map<Long, DynamicObject> getSourceRowsMap(IFormView view) {
        DynamicObjectCollection rows = view.getModel().getEntryEntity("entryentity");
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private DynamicObject[] getTenderSupplierRows(IFormView view) {
        QFilter qfilters = this.getProjectFilter(view);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private QFilter getProjectFilter(IFormView view) {
        return new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
    }

    private Set<String> getExcludedFields() {
        HashSet<String> excludedFields = new HashSet<String>(96);
        excludedFields.add("currentrank");
        excludedFields.add("sumscore");
        excludedFields.add("bizamount");
        excludedFields.add("package");
        excludedFields.add("isaptpush");
        excludedFields.add("isaptpush2");
        excludedFields.add("isbidpush");
        excludedFields.add("suppliertype");
        excludedFields.add("supplier");
        excludedFields.add("bidder");
        excludedFields.add("suppliercode");
        excludedFields.add("isinvite");
        excludedFields.add("feeamount");
        excludedFields.add("isdownload");
        excludedFields.add("ispayfee");
        excludedFields.add("ispaydocfee");
        excludedFields.add("isconfirm");
        excludedFields.add("isabandon");
        excludedFields.add("istender");
        excludedFields.add("count");
        excludedFields.add("count2");
        excludedFields.add("isquote");
        excludedFields.add("isnegotiate");
        excludedFields.add("isdiscard");
        excludedFields.add("reason");
        excludedFields.add("entrystatus");
        excludedFields.add("abandonreason");
        excludedFields.add("isaptitude");
        excludedFields.add("aptitudenote");
        excludedFields.add("risknum");
        excludedFields.add("riskremark");
        excludedFields.add("source");
        excludedFields.add("supplierip");
        excludedFields.add("istecopen");
        excludedFields.add("isbizopen");
        excludedFields.add("isaptopen");
        excludedFields.add("billid");
        excludedFields.add("entryparentid");
        excludedFields.add("isexempt");
        excludedFields.add("supplieruser");
        excludedFields.add("docamount");
        excludedFields.add("isupload");
        excludedFields.add("ispuragent");
        excludedFields.add("isfeeagent");
        excludedFields.add("ispuraptitude");
        excludedFields.add("isexemptapt");
        excludedFields.add("rank");
        excludedFields.add("tecopenuser");
        excludedFields.add("tecopendate");
        excludedFields.add("bizopenuser");
        excludedFields.add("bizopendate");
        excludedFields.add("aptopendate");
        excludedFields.add("aptopenuser");
        excludedFields.add("isbidpublish");
        excludedFields.add("isviepublish");
        excludedFields.add("fseq");
        excludedFields.add("isaptitudereply");
        return excludedFields;
    }
}

