/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.question.PdsQuestionFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcComponentUtil;

public class SrcBidAssesEdit
extends PdsBillCompTplEdit {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        switch (key) {
            case "notify": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u901a\u77e5\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5229\u76ca\u5173\u7cfb\u6f84\u6e05\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SrcBidAssesEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("notify"));
                evt.setCancel(true);
                break;
            }
            case "todotask": {
                QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_memberclarify", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
            case "bar_allopen": 
            case "bar_tecopen": {
                IFormView compView = SrcComponentUtil.getComponentView((IFormView)this.getView(), (String)"src_bidopen_open");
                if (!Objects.nonNull(compView)) break;
                compView.invokeOperation("save");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "purlist": {
                QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                qFilter.and("supplier", ">", (Object)0);
                qFilter.and("entrystatus", ">", (Object)ProjectStatusEnums.TOQUOTE.getValue());
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_supplierpurlist", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
            case "bidresult": {
                SrcBidAssessUtils.openBidAssessResult((IFormView)this.getView());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "notify": {
                if (evt.getResult() != MessageBoxResult.Yes) {
                    return;
                }
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                if (projectId == 0L) {
                    return;
                }
                Map notifyMap = SrcClarifyUtils.notifyAllMember((IFormView)this.getView(), (long)projectId, (String)"src_project_man");
                if (((Boolean)notifyMap.get("succed")).booleanValue()) {
                    this.getView().showSuccessNotification(notifyMap.get("message").toString());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().showTipNotification(notifyMap.get("message").toString());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        HashMap<String, Long> paramMap = new HashMap<String, Long>(4);
        switch (opKey = args.getOperateKey()) {
            case "aptitude": {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_aptitudeaudit", (Object)this.getModel().getDataEntity().getPkValue(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "answer": {
                PdsQuestionFacade.openQuestionList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"src_question", (boolean)true);
                break;
            }
            case "scorehelper": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    paramMap.put("project", projectId);
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_scoreassist", (ShowType)ShowType.MainNewTabPage, paramMap, null);
                break;
            }
        }
    }
}

