/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsReportUtils;
import kd.scm.pds.common.util.SrcGetDataByUserUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.formplugin.bidchange.SrcBidChangePlugin;
import kd.scm.src.formplugin.edit.SrcBidChangeCreateCompPdfAttach;

public class SrcBidChangeEdit
extends SrcBidChangePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit template = (BasedataEdit)this.getControl("template");
        if (Objects.nonNull(template)) {
            template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject obj = this.getModel().getDataEntity();
        String changeSource = PdsCommonUtils.object2String((Object)this.getModel().getValue("changesource"), (String)"3");
        DynamicObject changeObj = SrcBidChangeUtil.getBidChangeObject((IDataModel)this.getModel());
        if (Objects.nonNull(changeObj)) {
            Object currentNode;
            Object bizType = obj.get("biztype");
            if (Objects.isNull(bizType) && null != (bizType = changeObj.get("biztype"))) {
                this.getModel().setValue("biztype", Optional.ofNullable(changeObj.getDynamicObject("biztype")).map(DataEntityBase::getPkValue).orElse(null));
            }
            if (Objects.isNull(currentNode = obj.get("currentnode"))) {
                if ("1".equals(changeSource)) {
                    this.getModel().setValue("currentnode", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"pds_biznode", (String)PdsBizNodeEnums.SRCAPPLY.getValue()));
                } else if ("2".equals(changeSource)) {
                    this.getModel().setValue("currentnode", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"pds_biznode", (String)PdsBizNodeEnums.DEMAND.getValue()));
                } else {
                    this.getModel().setValue("currentnode", Optional.ofNullable(changeObj.getDynamicObject("currentnode")).map(DataEntityBase::getPkValue).orElse(null));
                }
            }
        }
        this.setChangeSourceVisible(changeSource);
        this.lockPreviousBill();
        this.getModel().setDataChanged(false);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        switch (key) {
            case "template": {
                QFilter qfilters = null;
                switch (this.getView().getEntityId()) {
                    case "src_bidchange": {
                        String changeSource = this.getModel().getDataEntity().getString("changesource");
                        if (changeSource.equals("1")) {
                            qfilters = new QFilter("biznode.number", "=", (Object)PdsBizNodeEnums.SRCAPPLY.getValue());
                            break;
                        }
                        if (changeSource.equals("2")) {
                            qfilters = new QFilter("biznode.number", "=", (Object)PdsBizNodeEnums.DEMAND.getValue());
                            break;
                        }
                        qfilters = new QFilter("biznode.number", "=", (Object)PdsBizNodeEnums.BIDCHANGE.getValue());
                        qfilters.and("issupplier", "=", (Object)"0");
                        break;
                    }
                    case "src_batchdecision": {
                        qfilters = new QFilter("biznode.number", "=", (Object)PdsBizNodeEnums.BATCHDECISION.getValue());
                        break;
                    }
                    default: {
                        qfilters = new QFilter("biznode.number", "=", (Object)PdsBizNodeEnums.BIDCHANGE.getValue());
                        qfilters.and("issupplier", "=", (Object)"1");
                        String manageType = this.getModel().getDataEntity().getString("project.managetype");
                        if ("3".equals(manageType)) {
                            qfilters.and("number", "!=", (Object)"SYS076");
                        }
                        String sourceType = this.getModel().getDataEntity().getString("project.sourcetype.number");
                        if (!SourceTypeEnums.VIE.getValue().equals(sourceType) && !SourceTypeEnums.ELECTRONIC_AUCTION.getValue().equals(sourceType)) break;
                        qfilters.and("number", "!=", (Object)"SYS075");
                    }
                }
                QFilter extFilter = this.getExtQFilter();
                if (null != extFilter) {
                    qfilters.and(extFilter);
                }
                showParameter.getListFilterParameter().setFilter(qfilters);
                break;
            }
            case "apply": 
            case "demand": 
            case "project": {
                this.getModel().setValue("template", null);
            }
        }
    }

    public QFilter getExtQFilter() {
        String changeSource = PdsCommonUtils.object2String((Object)this.getModel().getValue("changesource"), (String)"3");
        if (!"3".equals(changeSource)) {
            return null;
        }
        ExtFilterContext context = new ExtFilterContext();
        context.setBillObj(this.getModel().getDataEntity(true));
        context.setProjectObj(this.getModel().getDataEntity().getDynamicObject("project"));
        context.setNumber("pds_bidchangetpl_filter");
        List ids = SchemeFilterUtils.getAllSchemeIds((ExtFilterContext)context);
        if (null != ids && ids.size() > 0) {
            return new QFilter("id", "in", (Object)ids);
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void initParam() {
        DynamicObject billObj;
        Object tenderId;
        if (null != this.getModel().getValue("apply") || null != this.getModel().getValue("demand") || null != this.getModel().getValue("project")) {
            return;
        }
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object changeObjId = paraMap.get("project");
        if (null != changeObjId) {
            String entityName = (String)paraMap.get("entityname");
            if ("src_apply".equals(entityName)) {
                this.getModel().setValue("changesource", (Object)"1");
                this.getModel().setValue("apply", changeObjId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"apply", "changesource"});
            } else if ("src_demand".equals(entityName)) {
                this.getModel().setValue("changesource", (Object)"2");
                this.getModel().setValue("demand", changeObjId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"demand", "changesource"});
            } else {
                this.getModel().setValue("changesource", (Object)"3");
                this.getModel().setValue("project", changeObjId);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"project", "changesource"});
            }
            Object orgId = paraMap.get("org");
            if (orgId != null) {
                this.getModel().setValue("org", orgId);
            } else {
                DynamicObject project = QueryServiceHelper.queryOne((String)"src_projectf7", (String)"id,org.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(changeObjId.toString()))});
                if (null != project) {
                    this.getModel().setValue("org", (Object)project.getLong("org.id"));
                }
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changesource"});
        }
        if (null != (tenderId = this.getView().getFormShowParameter().getCustomParam("tenderid")) && null != (billObj = BusinessDataServiceHelper.loadSingle((Object)PdsCommonUtils.object2Long((Object)tenderId), (String)this.getView().getFormShowParameter().getCustomParam("entityname").toString()))) {
            this.getModel().setValue("supplier", billObj.get("supplier"));
            this.getModel().setValue("suppliertype", billObj.get("suppliertype"));
            this.getModel().setValue("supplieruser", billObj.get("supplieruser"));
        }
    }

    public void beforeBindData(EventObject e) {
        Object templateId;
        super.beforeBindData(e);
        long userId = RequestContext.get().getCurrUserId();
        List purdeptIds = SrcGetDataByUserUtil.getPurdeptSetByUserIdAndBillType((long)userId, (String)"src_bidchange");
        this.getModel().setValue("purdept", purdeptIds.size() == 0 ? null : purdeptIds.get(0));
        List purGroupIds = SrcGetDataByUserUtil.getPurGroupSetByUserIdAndBillType((long)userId, (String)"src_bidchange");
        this.getModel().setValue("purgroup", purGroupIds.size() == 0 ? null : purGroupIds.get(0));
        if (null == this.getModel().getValue("template") && null != (templateId = this.getView().getFormShowParameter().getCustomParam("template"))) {
            this.getModel().setValue("template", templateId);
        }
        this.initParam();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "apply": 
            case "demand": 
            case "project": {
                if ("src_batchdecision".equals(this.getView().getEntityId())) {
                    DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("biznodenumber", PdsBizNodeEnums.BATCHDECISION.getValue());
                    if (null != projectObj) {
                        paramMap.put("sourcetype", SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("sourcetype")));
                    }
                    SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)projectObj, (String)"pds_tplconfig_filter", (String)"template", paramMap);
                    break;
                }
                this.getModel().setValue("template", null);
                break;
            }
            case "template": {
                this.getModel().setValue("remark", null);
                break;
            }
            case "changesource": {
                this.getModel().setValue("apply", null);
                this.getModel().setValue("demand", null);
                this.getModel().setValue("project", null);
                this.getModel().setValue("template", null);
                this.setChangeSourceVisible(e.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    private void setChangeSourceVisible(Object changeSourceObj) {
        String changeSource = PdsCommonUtils.object2String((Object)changeSourceObj, (String)"3");
        BasedataEdit applyEdit = (BasedataEdit)this.getView().getControl("apply");
        BasedataEdit demandEdit = (BasedataEdit)this.getView().getControl("demand");
        BasedataEdit projectEdit = (BasedataEdit)this.getView().getControl("project");
        switch (changeSource) {
            case "1": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"apply"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"demand", "project", "bidname"});
                applyEdit.setMustInput(true);
                demandEdit.setMustInput(false);
                projectEdit.setMustInput(false);
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"demand"});
                demandEdit.setMustInput(true);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"apply", "project", "bidname"});
                applyEdit.setMustInput(false);
                projectEdit.setMustInput(false);
                break;
            }
            default: {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"project", "bidname"});
                projectEdit.setMustInput(true);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"apply", "demand"});
                applyEdit.setMustInput(false);
                demandEdit.setMustInput(false);
            }
        }
    }

    private void lockPreviousBill() {
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object changeObjId = paraMap.get("project");
        if (null != changeObjId) {
            String entityName = (String)paraMap.get("entityname");
            if ("src_apply".equals(entityName)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"apply", "changesource"});
            } else if ("src_demand".equals(entityName)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"demand", "changesource"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"project", "changesource"});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changesource"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "createpdf": {
                PdsReportUtils.openCreatePdf((IFormView)this.getView(), (boolean)false, null);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        OperationResult result = evt.getOperationResult();
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": {
                if (null == result || !result.isSuccess()) break;
                PdsReportUtils.createCompPdfAttach((IFormView)this.getView(), (String)"attachmentpanel", (String)SrcBidChangeCreateCompPdfAttach.class.getSimpleName());
                break;
            }
            case "audit": {
                if (null == result || !result.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                PdsCommonUtils.refreshParentView((IFormView)this.getView());
                break;
            }
        }
    }
}

