/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsReportUtils;

public class SrcBidDocTplEdit
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String operationKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        switch (operationKey) {
            case "batch": {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batch");
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_biddoc_batch", (ShowType)ShowType.Modal, this.getParamMap(), (CloseCallBack)closeCallBack);
                break;
            }
            case "submit": {
                String entityId = parentView.getEntityId();
                if (!Objects.equals(entityId, "src_project") && !Objects.equals(entityId, "src_biddoc")) break;
                this.setEntryData();
                break;
            }
            case "biddoc": {
                Map<String, Object> paramMap = this.getParamMap();
                if (!this.getCurrentRowInfo(paramMap)) break;
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"pds_biddoctool", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "biddoc"));
                break;
            }
            case "createpdf": {
                PdsReportUtils.openCreatePdf((IFormView)this.getView(), (boolean)true, (String)"entryentity");
                break;
            }
        }
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        IFormView parentView = this.getView().getParentView();
        DynamicObject billObj = parentView.getModel().getDataEntity();
        if (billObj != null) {
            if (PdsCommonUtils.isNotProjectBill((String)parentView.getEntityId())) {
                paramMap.put("project", SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("project")));
            } else {
                paramMap.put("project", billObj.getPkValue());
            }
            paramMap.put("billid", billObj.getPkValue());
            paramMap.put("entityname", parentView.getEntityId());
        }
        return paramMap;
    }

    protected void setEntryData() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        Object projectId = parentView.getModel().getDataEntity().getPkValue();
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < cols.size(); ++i) {
            this.getModel().setValue("project", projectId, i);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getActionId().equals("batch")) {
            DynamicObjectCollection bidDocRows = (DynamicObjectCollection)evt.getReturnData();
            if (bidDocRows == null || bidDocRows.size() == 0) {
                return;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            TableValueSetter ts = new TableValueSetter(new String[0]);
            int index = 0;
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            long projectId = PdsCommonUtils.object2Long((Object)parentView.getModel().getDataEntity().getPkValue());
            model.beginInit();
            for (DynamicObject bidDocRow : bidDocRows) {
                List bidDocList = bidDocRow.getDynamicObjectCollection("package").stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
                for (int i = 0; i < bidDocList.size(); ++i) {
                    ts.set("package", bidDocList.get(i), index);
                    ts.set("packfiletype", (Object)bidDocRow.getString("packfiletype"), index);
                    ts.set("fileclassid", (Object)bidDocRow.getLong("fileclassid.id"), index);
                    ts.set("fileclass", (Object)bidDocRow.getString("fileclass"), index);
                    ts.set("packfilename", (Object)bidDocRow.getString("packfilename"), index);
                    ts.set("packnote", (Object)bidDocRow.getString("packnote"), index);
                    ts.set("bidattach", (Object)bidDocRow.getDynamicObjectCollection("bidattach"), index);
                    ts.set("entrystatus", (Object)"A", index);
                    ts.set("srcbillid", (Object)"", index);
                    ts.set("compkey", (Object)this.getView().getEntityId(), index);
                    ts.set("entryparentid", (Object)projectId, index);
                    ts.set("billtype", (Object)"1", index);
                    ts.set("seq", (Object)(index + 1), index);
                    ts.set("supplier", (Object)0L, index);
                    ts.set("project", (Object)projectId, index);
                    ++index;
                }
            }
            model.batchCreateNewEntryRow("entryentity", ts);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private boolean getCurrentRowInfo(Map<String, Object> paramMap) {
        DynamicObjectCollection entreObj = this.getModel().getEntryEntity("entryentity");
        if (null == entreObj || entreObj.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u6570\u636e\u8fdb\u884c\u6807\u4e66\u7f16\u5236\u3002", (String)"SrcBidDocTplEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return false;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowIndex);
        if (row == null) {
            return false;
        }
        paramMap.put("currentrow", currentRowIndex);
        return true;
    }
}

