/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.carryvalue.PdsCarryValueFacade;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcUsualUserUtils;
import kd.scm.src.common.util.SrcWinruleUtils;
import kd.scm.src.formplugin.edit.SrcProjectSchemeHandler;

public class SrcBidopenConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (Objects.equals(entityId, "src_bidassess")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usualuser", "queryriskinfo"});
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        if (PdsCompConfigUtil.parentIsProject((IFormView)this.getView()) && PdsCompConfigUtil.isTemplateChanged((IFormView)this.getView())) {
            ArrayList<String> defaultCompKeyList = new ArrayList<String>(1);
            defaultCompKeyList.add(this.getView().getEntityId());
            PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView().getParentView(), (String)"srctype", defaultCompKeyList);
        }
        if (PdsCompConfigUtil.parentIsProject((IFormView)this.getView())) {
            Object manageType = parentView.getModel().getValue("managetype");
            if (Objects.equals("2", String.valueOf(manageType))) {
                this.getModel().setValue("ismultipackage", (Object)true);
            } else {
                this.getModel().setValue("ismultipackage", (Object)false);
            }
        }
        if (PdsCommonUtils.isOpenBySupplier((DynamicObject)parentView.getModel().getDataEntity())) {
            this.getModel().setValue("ishidesupplier", (Object)false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"ishidesupplier"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ishidesupplier"});
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit agent;
        BasedataEdit scorer;
        BasedataEdit pack;
        BasedataEdit scheme;
        super.registerListener(e);
        BasedataEdit indexType = (BasedataEdit)this.getView().getControl("indextype");
        if (indexType != null) {
            indexType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scheme = (BasedataEdit)this.getView().getControl("scheme")) != null) {
            scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pack = (BasedataEdit)this.getView().getControl("package")) != null) {
            pack.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((scorer = (BasedataEdit)this.getView().getControl("scorer")) != null) {
            scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((agent = (BasedataEdit)this.getView().getControl("agent")) != null) {
            agent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        block9 : switch (key) {
            case "indextype": {
                String baseType;
                int index = e.getChangeSet()[0].getRowIndex();
                DynamicObject row = model.getEntryRowEntity("entryentity", index);
                DynamicObject indexTypeObj = row.getDynamicObject("indextype");
                model.setValue("scheme", null, index);
                if (null == indexTypeObj) {
                    model.setValue("weight", null, index);
                    return;
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)indexTypeObj));
                paramMap.put("scoretype", model.getDataEntity().getString("scoretype"));
                paramMap.put("scoremethod", model.getDataEntity().getString("scoremethod"));
                SchemeFilterUtils.autoSetScheme((IFormView)this.getView(), (int)index, paramMap, (IDataModel)model);
                switch (baseType = indexTypeObj.getString("basetype")) {
                    case "1": {
                        model.setValue("weight", model.getValue("ratio_tec"), index);
                        break block9;
                    }
                    case "2": {
                        model.setValue("weight", model.getValue("ratio_biz"), index);
                        break block9;
                    }
                    case "3": {
                        model.setValue("weight", model.getValue("ratio_oth"), index);
                        break block9;
                    }
                    case "6": {
                        model.setValue("weight", model.getValue("ratio_syn"), index);
                        break block9;
                    }
                }
                break;
            }
            case "scoretype": {
                String scoreType = PdsCommonUtils.object2String((Object)e.getChangeSet()[0].getNewValue(), (String)"1");
                HashMap<String, Object> paramMap2 = new HashMap<String, Object>(2);
                paramMap2.put("scoretype", scoreType);
                DynamicObjectCollection rows = model.getEntryEntity("entryentity");
                for (int i = 0; i < rows.size(); ++i) {
                    paramMap2.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)rows.get(i)).getDynamicObject("indextype")));
                    long schemeId2 = SchemeFilterUtils.getFirstSchemeId((DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)this.getView().getEntityId(), paramMap2);
                    if (schemeId2 == 0L) {
                        model.setValue("scheme", null, i);
                        continue;
                    }
                    model.setValue("scheme", (Object)schemeId2, i);
                }
                break;
            }
            case "bidattach": {
                ChangeData[] changeSet = e.getChangeSet();
                int rowIndex = changeSet[0].getRowIndex();
                Object newValue = changeSet[0].getNewValue();
                if (rowIndex < 0) {
                    return;
                }
                if (newValue == null) {
                    return;
                }
                DynamicObjectCollection bidattachs = (DynamicObjectCollection)newValue;
                StringBuffer strbuf = new StringBuffer();
                for (DynamicObject bidattach : bidattachs) {
                    String attachName = bidattach.getString("fbasedataid.name");
                    int lastIndexOf = attachName.lastIndexOf(46);
                    strbuf.append(attachName, 0, lastIndexOf);
                }
                model.setValue("bidname", (Object)strbuf, rowIndex);
                break;
            }
            case "isbyproject": 
            case "scoremethod": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "ratio_biz": {
                this.calcBaseScore_MinScore((BigDecimal)e.getChangeSet()[0].getNewValue(), true);
                break;
            }
            case "scheme": {
                SrcBidOpenUtils.setProjectSchemeValue((IFormView)this.getView(), (PropertyChangedArgs)e);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        IDataModel model = this.getModel();
        switch (key = evt.getProperty().getName()) {
            case "indextype": {
                String sourceMethod = evt.getSourceMethod();
                if (Objects.equals(sourceMethod, "setItemByNumber")) {
                    return;
                }
                ArrayList<String> indexTypes = new ArrayList<String>(3);
                if (SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel()) || model.getDataEntity().getBigDecimal("ratio_tec").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("1");
                }
                if (SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel()) || model.getDataEntity().getBigDecimal("ratio_biz").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("2");
                }
                if (SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel()) || model.getDataEntity().getBigDecimal("ratio_oth").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("3");
                }
                if (model.getDataEntity().getBigDecimal("ratio_syn").compareTo(BigDecimal.ZERO) > 0) {
                    indexTypes.add("6");
                }
                if (indexTypes.size() == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6280\u672f\u6807\u5360\u6bd4/\u5546\u52a1\u6807\u5360\u6bd4/\u5546\u52a1\u7efc\u5408/\u8bc4\u6807\u7efc\u5408\u5360\u6bd4\uff0c\u518d\u9009\u62e9\u6307\u6807\u7c7b\u578b\u3002", (String)"SrcBidopenConfigEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("basetype", "in", indexTypes));
                break;
            }
            case "package": {
                DynamicObject data = model.getDataEntity(true);
                QFilter filter = new QFilter("project", "=", data.getPkValue());
                ListShowParameter packageShowParameter = (ListShowParameter)evt.getFormShowParameter();
                packageShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "scorer": 
            case "agent": {
                String expertType = ExpertFilterUtils.inviteExpertType();
                if (null == expertType) break;
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                paramMap.put("ismustinput", true);
                ExpertFilterUtils.setExpertF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity().getDynamicObject("projectf7"), (String)("src_scorertask_" + expertType + '_' + "filter"), paramMap);
                break;
            }
            case "scheme": {
                DynamicObject row = model.getEntryRowEntity("entryentity", evt.getRow());
                HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
                paramMap.put("indextypeid", SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("indextype")));
                paramMap.put("scoretype", model.getDataEntity().getString("scoretype"));
                paramMap.put("scoremethod", model.getDataEntity().getString("scoremethod"));
                paramMap.put("schemetype", "1");
                paramMap.put("ismustinput", true);
                IFormView parentView = this.getView().getParentView();
                if (null == parentView) break;
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)parentView.getModel().getDataEntity(), (String)this.getView().getEntityId(), paramMap);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String operateKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        switch (operateKey) {
            case "save": {
                this.calcBaseScore_MinScore(this.getModel().getDataEntity().getBigDecimal("ratio_biz"), false);
            }
            case "submit": {
                this.deleteInvalidRows(this.getModel().getDataEntity(true));
                this.setPackageVal();
                this.setRatioValue();
                this.resetBizScore(evt);
                break;
            }
            case "batch": {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                if (null == parentView) {
                    return;
                }
                DynamicObject billObj = parentView.getModel().getDataEntity();
                if (billObj != null) {
                    paramMap.put("project", billObj.getPkValue());
                    paramMap.put("scoretype", this.getModel().getDataEntity().getString("scoretype"));
                    paramMap.put("ratio_tec", this.getModel().getDataEntity().getBigDecimal("ratio_tec"));
                    paramMap.put("ratio_biz", this.getModel().getDataEntity().getBigDecimal("ratio_biz"));
                    paramMap.put("ratio_oth", this.getModel().getDataEntity().getBigDecimal("ratio_oth"));
                    paramMap.put("ratio_syn", this.getModel().getDataEntity().getBigDecimal("ratio_syn"));
                    paramMap.put("scoremethod", this.getModel().getDataEntity().getString("scoremethod"));
                    paramMap.put("isbyproject", this.getModel().getDataEntity().getBoolean("isbyproject"));
                }
                paramMap.put("schemetype", "1");
                paramMap.put("entityname", this.getView().getEntityId());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batch");
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_assesscfg_batch", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)closeCallBack);
                break;
            }
            case "usualuser": {
                long billId = SrcUsualUserUtils.getBillId((String)this.getView().getEntityId());
                if (billId > 0L) {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_usualuser", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, null);
                }
                evt.setCancel(true);
                break;
            }
            case "projectscorer": {
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_projectscorer", (ShowType)ShowType.Modal, null, null);
                break;
            }
        }
    }

    private void setRatioValue() {
        if (!SrcBidAssessUtils.isFinalValue((IDataModel)this.getModel())) {
            return;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        String packageName = null;
        for (DynamicObject row : rows) {
            String key;
            if (row.getDynamicObject("indextype") == null) continue;
            String baseType = row.getDynamicObject("indextype").getString("basetype");
            weightMap.put(key, weightMap.get(key = row.getString("package.packagename") + "|" + baseType) == null ? row.getBigDecimal("weight") : row.getBigDecimal("weight").add((BigDecimal)weightMap.get(key)));
            if (null != packageName) continue;
            packageName = row.getString("package.packagename") + "|";
        }
        this.getModel().setValue("ratio_tec", weightMap.get(packageName + "1"));
        this.getModel().setValue("ratio_biz", weightMap.get(packageName + "2"));
        this.getModel().setValue("ratio_oth", weightMap.get(packageName + "3"));
    }

    private void setPackageVal() {
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity("entryentity");
        if (null == cols || cols.size() == 0) {
            return;
        }
        boolean isMultiPackage = model.getDataEntity().getBoolean("ismultipackage");
        if (isMultiPackage) {
            return;
        }
        ArrayList<Integer> noPackageIndexList = new ArrayList<Integer>();
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject packageObj = ((DynamicObject)cols.get(i)).getDynamicObject("package");
            if (null != packageObj && packageObj.getLong("id") != 0L) continue;
            noPackageIndexList.add(i);
        }
        if (noPackageIndexList.size() > 0) {
            DynamicObject packageObj = this.getPackageObj();
            this.setEntryPackageVal(noPackageIndexList, packageObj);
        }
    }

    private DynamicObject getPackageObj() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return null;
        }
        QFilter packageFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity()));
        packageFilter.and("packagename", "=", (Object)"ByItem");
        DynamicObject packageObj = QueryServiceHelper.queryOne((String)"src_packagef7", (String)"package", (QFilter[])new QFilter[]{packageFilter});
        return packageObj;
    }

    private void setEntryPackageVal(List<Integer> noPackageIndexList, DynamicObject packageObj) {
        if (null == packageObj) {
            return;
        }
        Object packObj = packageObj.get("package");
        for (int index : noPackageIndexList) {
            this.getModel().setValue("package", packObj, index);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"batch")) {
            DynamicObjectCollection configRows = (DynamicObjectCollection)evt.getReturnData();
            if (configRows == null || configRows.size() == 0) {
                return;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            int index = model.getEntryRowCount("entryentity");
            for (DynamicObject configRow : configRows) {
                List configList = configRow.getDynamicObjectCollection("package").stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
                for (int i = 0; i < configList.size(); ++i) {
                    model.createNewEntryRow("entryentity");
                    model.setValue("package", configList.get(i), index);
                    model.setValue("indextype", (Object)configRow.getLong("indextype.id"), index);
                    model.setValue("scheme", (Object)configRow.getLong("scheme.id"), index);
                    BigDecimal weight = configRow.getBigDecimal("weight");
                    if (weight.compareTo(BigDecimal.ZERO) > 0) {
                        model.setValue("weight", (Object)weight, index);
                    }
                    AttachmentUtils.setMultiBasedataForModel((IDataModel)model, (DynamicObjectCollection)configRow.getDynamicObjectCollection("bidattach"), (String)"bidattach", (int)index);
                    model.setValue("bidname", (Object)configRow.getString("packfilename"), index);
                    model.setValue("scorer", (Object)configRow.getDynamicObjectCollection("scorer"), index);
                    model.setValue("note", (Object)configRow.getString("note"), index);
                    ++index;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": {
                this.createMyTaskByScorer();
                SrcUsualUserUtils.addToUsualScorer((IFormView)this.getView());
                break;
            }
            case "openscheme": {
                this.setProjectScheme();
                break;
            }
        }
    }

    private void createMyTaskByScorer() {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setProjectId(PdsCommonUtils.object2Long((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue()));
        context.setCompkey("src_project_reference");
        SrcMyTaskFacade.createMyTaskByScorer((SrcMyTaskContext)context);
    }

    private void setProjectScheme() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin((String)SrcProjectSchemeHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("indextype") != null && obj.getLong("indextype.id") != 0L) continue;
            ite.remove();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        super.beforeDeleteRow(evt);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)evt.getEntryProp().getName())) {
            for (int index : evt.getRowIndexs()) {
                String entrystatus = PdsCommonUtils.object2String((Object)this.getModel().getValue("entrystatus", index), (String)"");
                if ("A".equals(entrystatus)) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4e0b\u8fbe\u7684\u5206\u5f55\u624d\u80fd\u88ab\u5220\u9664\u3002", (String)"SrcBidopenConfigEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void calcBaseScore_MinScore(Object newValue, boolean isNeedChanged) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (!(isNeedChanged || this.getModel().getDataEntity().getBigDecimal("basescore").compareTo(BigDecimal.ZERO) <= 0 && this.getModel().getDataEntity().getBigDecimal("minscore").compareTo(BigDecimal.ZERO) <= 0)) {
            return;
        }
        if (null == newValue) {
            return;
        }
        BigDecimal ratio_biz = (BigDecimal)newValue;
        DynamicObject schemeObj = SrcWinruleUtils.getWinruleSchemeObj((IFormView)this.getView());
        if (null != schemeObj) {
            String rankType;
            switch (rankType = schemeObj.getString("ranktype")) {
                case "1": 
                case "2": 
                case "3": 
                case "4": 
                case "5": 
                case "6": {
                    if (schemeObj.getBigDecimal("basescoreratio").compareTo(BigDecimal.ZERO) <= 0) {
                        this.getModel().setValue("basescore", (Object)ratio_biz);
                    } else {
                        this.getModel().setValue("basescore", (Object)ratio_biz.multiply(schemeObj.getBigDecimal("basescoreratio").divide(BigDecimal.TEN).divide(BigDecimal.TEN)));
                    }
                    this.getModel().setValue("minscore", (Object)ratio_biz.multiply(schemeObj.getBigDecimal("minscoreratio").divide(BigDecimal.TEN).divide(BigDecimal.TEN)));
                    break;
                }
            }
        }
    }

    protected void resetBizScore(BeforeDoOperationEventArgs evt) {
        DynamicObject cfgObj = this.getModel().getDataEntity(true);
        if (cfgObj.getBoolean("isbyproject")) {
            DynamicObjectCollection rows = cfgObj.getDynamicObjectCollection("entryentity");
            int isScoreTaskCount = 0;
            for (DynamicObject row : rows) {
                DynamicObject schemeObj = row.get("proscheme") != null ? row.getDynamicObject("proscheme") : row.getDynamicObject("scheme");
                if (!schemeObj.getBoolean("isbizscore")) continue;
                ++isScoreTaskCount;
            }
            if (isScoreTaskCount == 0) {
                this.getModel().setValue("isbizscore", (Object)"0");
            } else if (isScoreTaskCount == rows.size()) {
                this.getModel().setValue("isbizscore", (Object)"1");
            } else {
                evt.setCancelMessage(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u591a\u4e2a\u7efc\u5408\u8bc4\u6807\u65b9\u6848\u7684\u5546\u52a1\u6307\u6807\uff0c\u8981\u4e48\u90fd\u4e0b\u8fbe\u8bc4\u6807\u4efb\u52a1\uff0c\u8981\u4e48\u90fd\u4e0d\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u90e8\u5206\u4e0b\u8fbe\uff0c\u90e8\u5206\u4e0d\u4e0b\u8fbe\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"SrcBidopenConfigEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

