/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.src.common.contract.SrcContractUtils;
import kd.scm.src.common.contract.SrcCreateContractItemHandler;
import kd.scm.src.common.contract.SrcDeleteContractItemHandler;
import kd.scm.src.common.hyperlink.SrcPurListHyperlinkHandler;

public class SrcContractEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "push": {
                SrcContractUtils.isExistsMaterialPurchaseInfoByEdit((IDataModel)this.getModel(), (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
                break;
            }
            case "bizitem": {
                this.resetContractItem();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTieredVisibleAndEditable();
        SrcContractUtils.setGenerateVisible((IFormView)this.getView());
        if (!ApiConfigUtil.hasCQScmConfig()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewbillrelation"});
        }
        this.setCostDetailVisible();
        if (this.getModel().getEntryRowCount("bizitementity") <= 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabbizitem"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabbizitem"});
        }
    }

    private void setCostDetailVisible() {
        long sourceFlowId = this.getView().getModel().getDataEntity().getLong("srctype.id");
        Object isEnableObj = ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isEnableCostDetail", (Object)false, (long)this.getView().getModel().getDataEntity().getLong("id"));
        boolean isEnableCostDetail = ExtParameterUtils.convertToBoolen((Object)isEnableObj);
        if (!isEnableCostDetail) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costdetail"});
        }
    }

    private void setTieredVisibleAndEditable() {
        String tieredType = this.getModel().getDataEntity().getString("tieredtype");
        if (StringUtils.isBlank((CharSequence)tieredType) || "1".equals(tieredType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subentryentity", "qtyfrom", "qtyto"});
            return;
        }
        if ("2".equals(tieredType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subentryentity"});
            return;
        }
        if ("3".equals(tieredType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"qtyfrom", "qtyto"});
            return;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setHyperLinkClickEvent(evt);
        ExtPluginFactory.executeExtplugin((String)SrcPurListHyperlinkHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    public void resetContractItem() {
        DynamicObject billObj = this.getModel().getDataEntity();
        QFilter qfilter = new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if (!QueryServiceHelper.exists((String)"src_decision", (QFilter[])qfilter.toArray())) {
            return;
        }
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(billObj);
        SrcDeleteContractItemHandler deleteHandler = new SrcDeleteContractItemHandler();
        deleteHandler.process(context);
        SrcCreateContractItemHandler createHandler = new SrcCreateContractItemHandler();
        createHandler.process(context);
        this.getView().invokeOperation("refresh");
    }
}

