/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.src.common.enums.SrcSupplierTypeEnum;
import kd.scm.src.formplugin.edit.SrcPurListImportEdit;
import org.apache.poi.ss.usermodel.CellStyle;

public class SrcDireAndComImportEdit
extends SrcPurListImportEdit {
    @Override
    protected void setColumn(ExcelDataEntity excelData) {
        super.setColumn(excelData);
        ArrayList newColumnKeyList = new ArrayList(excelData.getColumnKeyList());
        newColumnKeyList.remove("purlist");
        excelData.setColumnKeyList(newColumnKeyList);
    }

    protected void setColumnTitleColor(ExcelDataEntity excelDataEntity, List<Integer> mustInputIndexList) {
        CellStyle style = this.getCellStyle(excelDataEntity);
        for (int colIndex : mustInputIndexList) {
            try {
                excelDataEntity.setStyle(0, 0, colIndex, style, 4000);
            }
            catch (IOException e) {
                BizLog.log((String)e.getMessage());
            }
        }
    }

    @Override
    protected void addCellRangeList(Map<String, List<String>> cellRangeListMap) {
        super.addCellRangeList(cellRangeListMap);
        ArrayList<String> supTypeList = new ArrayList<String>();
        supTypeList.add(SrcSupplierTypeEnum.SRC_SUPPLIER.getName());
        supTypeList.add(SrcSupplierTypeEnum.SRC_SUPPLIER_TMP.getName());
        supTypeList.add(SrcSupplierTypeEnum.BOS_USER.getName());
        supTypeList.add(SrcSupplierTypeEnum.BD_SUPPLIER.getName());
        cellRangeListMap.put("suppliertype", supTypeList);
    }

    @Override
    public Object getRowVal(DynamicObject col, String column, int index) {
        Object val = "";
        Object columnVal = null;
        try {
            columnVal = col.get(column);
        }
        catch (Exception e) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u503c\u5931\u8d25\uff1a%1$s\u3002", (String)"SrcDireAndComImportEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        if (columnVal instanceof Date) {
            val = DateUtil.date2str((Date)((Date)columnVal), (String)"yyyy-MM-dd");
        } else if ("suppliertype".equals(column)) {
            val = this.getSupTypeVal(String.valueOf(columnVal));
        } else if (column.equals("bidmaterial")) {
            if (columnVal == null) {
                val = "";
                return val;
            }
            val = ((DynamicObject)columnVal).get("id");
        } else {
            val = super.getRowVal(col, column, index);
        }
        return val;
    }

    private Object getSupTypeVal(String val) {
        String supTypeVal = SrcSupplierTypeEnum.getNameByValue((String)val);
        return supTypeVal;
    }

    @Override
    protected void addUniqueColumn(List<String> uniqueColumnList) {
        uniqueColumnList.add("materialnane");
        uniqueColumnList.add("supplier");
        uniqueColumnList.add("suppliername");
    }

    @Override
    protected String getGroupVal(DynamicObject col, String pro) {
        DynamicObject proVal;
        if ("bidmaterial".equals(pro) && null != (proVal = col.getDynamicObject(pro))) {
            return String.valueOf(proVal.get("id"));
        }
        return super.getGroupVal(col, pro);
    }

    @Override
    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        List uniqueColumnList = this.getUniqueColumnList();
        if (uniqueColumnList.contains(column)) {
            return null;
        }
        return super.getVal(column, index, val, msg);
    }

    @Override
    protected List<String> unVirtual() {
        List<String> unVirtual = super.unVirtual();
        unVirtual.add("bidmaterial");
        unVirtual.add("supplier");
        return unVirtual;
    }
}

